/*
 * Decompiled with CFR 0.152.
 */
package hectare;

import hectare.Debug;
import hectare.SoundSystem;
import hectare.model.GameState;
import hectare.view.Layer;
import hectare.view.MainWindow;
import hectare.view.SlideShow;
import hectare.view.layers.GameLayer;
import hectare.view.layers.LoadGameLayer;
import hectare.view.layers.NewLoadLayer;
import hectare.view.layers.SavingLayer;
import hectare.view.layers.SingleWidgetLayer;
import hectare.view.layers.TutorialLayer;
import hectare.view.layers.TutorialLoadLayer;
import hectare.view.utilities.DialogUtilities;
import hectare.view.widgets.LoseGameMenu;
import hectare.view.widgets.MainMenu;
import hectare.view.widgets.PauseMenu;
import hectare.view.widgets.SlideShower;
import hectare.view.widgets.WaitingScreen;
import hectare.view.widgets.WinGameMenu;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Stack;

public abstract class Hectare {
    private static final int VIEW_WIDTH = 1024;
    private static final int VIEW_HEIGHT = 768;
    private static final boolean MUSIC_ON = true;
    private static final String INITIAL_MAP = "/maps/world.txt";
    private static final String TUTORIAL_MAP = "/maps/tutorialworld.txt";
    private static final int TIME_PER_LOOP = 30;
    private static final int MIN_SLEEP_TIME = 10;
    private static final Stack<Layer> layers = new Stack();
    private static MainWindow window;
    private static long lastTime;
    private static GameLayer gameLayer;
    private static TutorialLayer tutorialLayer;

    public static void pushLayer(Layer l) {
        if (layers.size() > 0) {
            layers.peek().setEnabled(false);
        }
        layers.push(l);
        window.add((Component)l, 0);
    }

    public static void popLayer() {
        Hectare.removeLayer(Hectare.peekLayer());
    }

    public static void removeLayer(Layer l) {
        layers.remove(l);
        window.remove(l);
        if (layers.size() > 0) {
            layers.peek().setEnabled(true);
        }
    }

    public static Layer peekLayer() {
        return layers.peek();
    }

    public static void main(String[] args) {
        Debug.setEnabled(true);
        Hectare.initializeView();
        Hectare.startMainLoop();
    }

    public static void startGame() {
        GameState state = new GameState(INITIAL_MAP, window);
        Hectare.pushLayer(new NewLoadLayer(1024, 768, state));
    }

    public static void startGame(GameState state) {
        gameLayer = new GameLayer(1024, 768, state);
        Hectare.pushLayer(gameLayer);
    }

    public static void startTutorial() {
        GameState state = new GameState(TUTORIAL_MAP, window);
        Hectare.pushLayer(new TutorialLoadLayer(1024, 768, state));
    }

    public static void startTutorial(GameState state) {
        tutorialLayer = new TutorialLayer(1024, 768, state);
        Hectare.pushLayer(tutorialLayer);
    }

    public static void winGame() {
        WinGameMenu w = new WinGameMenu(512, 384);
        Hectare.pushLayer(new SingleWidgetLayer<WinGameMenu>(1024, 768, w));
    }

    public static void loseGame() {
        LoseGameMenu l = new LoseGameMenu(1024, 768);
        Hectare.pushLayer(new SingleWidgetLayer<LoseGameMenu>(1024, 768, l));
    }

    public static void showPauseMenu() {
        PauseMenu m = new PauseMenu(256, 537);
        Hectare.pushLayer(new SingleWidgetLayer<PauseMenu>(1024, 768, m));
    }

    public static void showInstructions() {
        SlideShow instructions = new SlideShow("instructions.txt");
        SlideShower shower = new SlideShower(1024, 768, instructions);
        Hectare.pushLayer(new SingleWidgetLayer<SlideShower>(1024, 768, shower));
    }

    public static void save(File toSave) {
        Hectare.pushLayer(new SavingLayer(1024, 768, toSave));
    }

    public static void load(File toLoad) {
        Hectare.pushLayer(new LoadGameLayer(1024, 768, toLoad));
    }

    public static void backToMainMenu() {
        int y = layers.size();
        int x = 0;
        while (x < y - 1) {
            Hectare.popLayer();
            ++x;
        }
    }

    private static void initializeView() {
        window = new MainWindow();
        MainMenu m = new MainMenu(1024, 768);
        Hectare.pushLayer(new SingleWidgetLayer<MainMenu>(1024, 768, m));
        window.pack();
        window.setLocationRelativeTo(null);
        window.setVisible(true);
    }

    private static void startMainLoop() {
        Debug.write(Hectare.class, "Running main loop");
        SoundSystem.getInstance().startMusic();
        lastTime = System.currentTimeMillis();
        while (true) {
            long now = System.currentTimeMillis();
            long loopTime = now - lastTime;
            lastTime = now;
            Layer topLayer = layers.peek();
            topLayer.tick(loopTime);
            int key = window.getLastKeyPressed();
            if (topLayer instanceof GameLayer && key >= 48 && key <= 56) {
                ((GameLayer)topLayer).getToolbar().changeTool(key - 49);
            }
            topLayer.repaint();
            loopTime = System.currentTimeMillis() - now;
            try {
                Thread.sleep(Math.max(30L - loopTime, 10L));
                continue;
            }
            catch (InterruptedException e) {
                Debug.write(Hectare.class, e.getMessage());
                e.printStackTrace();
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static void saveGame(File toSave) {
        try {
            ObjectOutputStream writer = new ObjectOutputStream(new FileOutputStream(toSave));
            GameState state = gameLayer.getState();
            writer.writeObject(state);
            writer.close();
            Debug.write(Hectare.class, "Game saved to " + toSave.getAbsolutePath());
            DialogUtilities.showNativeNotification(window, "Game Saved", "Your game has been saved as " + toSave.getName() + "!");
        }
        catch (NotSerializableException e) {
            Debug.write(Hectare.class, "Unserializable thing!");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            Debug.write(Hectare.class, "Could not open " + toSave.getAbsolutePath());
            e.printStackTrace();
        }
        catch (IOException e) {
            Debug.write(Hectare.class, "Error writing to " + toSave.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public static void loadGame(File toLoad) {
        try {
            ObjectInputStream reader = new ObjectInputStream(new FileInputStream(toLoad));
            GameState state = (GameState)reader.readObject();
            Hectare.startGame(state);
            reader.close();
            Debug.write(Hectare.class, "Game loaded from " + toLoad.getAbsolutePath());
        }
        catch (InvalidClassException e) {
            Debug.write(Hectare.class, "Savegame too old!");
            e.printStackTrace();
            DialogUtilities.showNativeNotification(gameLayer, "Error", "This saved game is from a different version of Hectare. It does not work in this version.");
            Hectare.popLayer();
        }
        catch (FileNotFoundException e) {
            Debug.write(Hectare.class, "Could not open " + toLoad.getAbsolutePath());
            e.printStackTrace();
            DialogUtilities.showNativeNotification(gameLayer, "Error", "Hectare could not open that file!");
            Hectare.popLayer();
        }
        catch (IOException e) {
            Debug.write(Hectare.class, "Error reading " + toLoad.getAbsolutePath());
            e.printStackTrace();
            DialogUtilities.showNativeNotification(gameLayer, "Error", "Hectare could not read that file!");
            Hectare.popLayer();
        }
        catch (ClassNotFoundException e) {
            Debug.write(Hectare.class, "Nonexistent class in " + toLoad.getAbsolutePath());
            e.printStackTrace();
            DialogUtilities.showNativeNotification(gameLayer, "Error", "This saved game is from a different version of Hectare. It does not work in this version.");
            Hectare.popLayer();
        }
        catch (Exception e) {
            Debug.write(Hectare.class, "Unknown exception while loading " + toLoad.getAbsolutePath());
            e.printStackTrace();
            DialogUtilities.showNativeNotification(gameLayer, "Error", "Hectare could not open that file!");
            Hectare.popLayer();
        }
    }

    public static Layer pauseEverything() {
        SingleWidgetLayer<WaitingScreen> l = new SingleWidgetLayer<WaitingScreen>(1024, 768, new WaitingScreen(1024, 768, "Hectare is paused!"));
        Hectare.pushLayer(l);
        return l;
    }
}

