/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Controller;
import hectare.model.Cloud;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.Vector;
import hectare.model.World;
import java.util.Iterator;
import java.util.List;

public class CloudController
implements Controller {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void step(GameState state) {
        List<Cloud> clouds;
        World theWorld = state.getWorld();
        List<Cloud> list = clouds = theWorld.getClouds();
        synchronized (list) {
            for (Cloud c : clouds) {
                c.snapToDestination();
            }
            Iterator i = clouds.iterator();
            while (i.hasNext()) {
                Cloud thisCloud = (Cloud)i.next();
                Cloud actuallyThere = theWorld.getCloud(thisCloud.getPosition());
                if (actuallyThere == thisCloud) continue;
                actuallyThere.eat(thisCloud);
                i.remove();
            }
            i = clouds.iterator();
            while (i.hasNext()) {
                Cloud c = (Cloud)i.next();
                Coordinates position = c.getPosition();
                Tile ground = theWorld.getTile(position);
                Vector wind = ground.getWind();
                Coordinates destination = new Coordinates(position.getX() + wind.getXOffset(), position.getY() + wind.getYOffset());
                c.setDestination(destination);
                c.updateRaining();
                if (!c.isRaining()) continue;
                double rain = c.rainfall();
                ground.setGroundwater(ground.getGroundwater() + rain);
                if (!c.isEmpty()) continue;
                i.remove();
            }
        }
    }
}

