/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Tool;
import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.model.GameState;
import hectare.model.MountainEntity;
import hectare.model.Tile;
import hectare.model.TownEntity;
import hectare.model.World;
import java.io.Serializable;

public class MountainTool
extends Tool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double REQUIRED_PROSPERITY = 18.0;
    private boolean hasUsed = false;

    @Override
    public boolean canApply(Coordinates location, World world) {
        Tile target = world.getTile(location);
        Entity entity = target.getEntity();
        return entity == null || entity instanceof MountainEntity;
    }

    @Override
    public boolean apply(Coordinates location, World world) {
        Tile target;
        if (!this.hasUsed) {
            this.hasUsed = true;
        }
        if ((target = world.getTile(location)).getEntity() == null) {
            target.setEntity(new MountainEntity());
            return true;
        }
        if (target.getEntity() instanceof MountainEntity) {
            target.setEntity(null);
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return "Mountain";
    }

    @Override
    public boolean isUsed() {
        return this.hasUsed;
    }

    @Override
    public String getSuccessSound() {
        return "clunk.wav";
    }

    @Override
    public String getIcon() {
        return "tool_mountain.png";
    }

    @Override
    public String getMouseOverText() {
        if (this.isEnabled()) {
            return "Create and destroys mountains, which can block clouds.";
        }
        return "Unlocked at population " + Integer.toString(TownEntity.toPopulation(18.0));
    }

    @Override
    public void tryUnlock(GameState state) {
        this.unlockByProsperity(18.0, state);
    }

    @Override
    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }
}

