/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Controller;
import hectare.model.Coordinates;
import hectare.model.ForestEntity;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.World;

public class NutrientController
implements Controller {
    private static final double DECREASE_RATE = 5.0E-4;
    private static final int[][] DIRECTION_VH;
    private static final int[][] DIRECTION_DI;
    private static final double DIFFUSION_WEIGHT_VH = 2.0;
    private static final double DIFFUSION_WEIGHT_DI = 1.0;
    private static final double NUTRIENT_DIFFUSION_RATE = 0.2;
    private static final double FOREST_NUTRIENT_INCREASE_RATE = 0.02;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        DIRECTION_VH = nArrayArray;
        DIRECTION_DI = new int[][]{{1, 1}, {-1, 1}, {-1, -1}, {1, -1}};
    }

    @Override
    public void step(GameState state) {
        World theWorld = state.getWorld();
        int i = 0;
        while (i < theWorld.getWidth()) {
            int j = 0;
            while (j < theWorld.getHeight()) {
                Coordinates here = new Coordinates(i, j);
                Tile target = theWorld.getTile(here);
                this.diffuse(theWorld, here);
                double newNutrient = target.getNutrient();
                newNutrient -= 5.0E-4;
                if (target.getEntity() != null && target.getEntity() instanceof ForestEntity) {
                    newNutrient += 0.02;
                }
                if (newNutrient < 0.0) {
                    newNutrient = 0.0;
                }
                if (newNutrient > 1.0) {
                    newNutrient = 1.0;
                }
                target.setNutrient(newNutrient);
                ++j;
            }
            ++i;
        }
    }

    private void diffuse(World world, Coordinates here) {
        Coordinates nearbyCoordinate;
        int x = here.getX();
        int y = here.getY();
        Tile target = world.getTile(here);
        double nearbyNutrient = 0.0;
        int dir = 0;
        while (dir < 4) {
            nearbyCoordinate = new Coordinates(x + DIRECTION_VH[dir][0], y + DIRECTION_VH[dir][1]);
            nearbyNutrient += 2.0 * world.getTile(nearbyCoordinate).getNutrient();
            ++dir;
        }
        dir = 0;
        while (dir < 4) {
            nearbyCoordinate = new Coordinates(x + DIRECTION_DI[dir][0], y + DIRECTION_DI[dir][1]);
            nearbyNutrient += 1.0 * world.getTile(nearbyCoordinate).getNutrient();
            ++dir;
        }
        double newNutrient = 0.8 * target.getNutrient() + 0.2 * (nearbyNutrient /= 12.0);
        target.setNutrient(newNutrient);
    }
}

