/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Tool;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.World;
import java.io.Serializable;

public class QueryTool
extends Tool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean hasUsed = false;

    @Override
    public boolean apply(Coordinates location, World world) {
        if (!this.hasUsed) {
            this.hasUsed = true;
        }
        if (location.equals(world.getQueryLocation())) {
            world.setQueryLocation(null);
        } else {
            world.setQueryLocation(location);
        }
        return true;
    }

    @Override
    public void deselect(World world) {
        world.setQueryLocation(null);
    }

    @Override
    public String getDisplayName() {
        return "Query";
    }

    @Override
    public boolean isUsed() {
        return this.hasUsed;
    }

    @Override
    public String getSuccessSound() {
        return "click.wav";
    }

    @Override
    public String getIcon() {
        return "tool_query.png";
    }

    @Override
    public String getMouseOverText() {
        return "Click on a square to learn about it.";
    }

    @Override
    public void tryUnlock(GameState state) {
        this.unlockByDefault();
    }

    @Override
    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }
}

