/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Tool;
import hectare.model.Cloud;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.World;
import java.io.Serializable;

public class RainTool
extends Tool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean hasUsed = false;

    @Override
    public boolean canApply(Coordinates location, World world) {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                Coordinates check = new Coordinates(location.getX() + i, location.getY() + j);
                if (world.getCloud(check) != null) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean apply(Coordinates location, World world) {
        boolean worked = false;
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                Coordinates check = new Coordinates(location.getX() + i, location.getY() + j);
                Cloud target = world.getCloud(check);
                if (target != null) {
                    target.setRaining(true);
                    worked = true;
                    if (!this.hasUsed) {
                        this.hasUsed = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return worked;
    }

    @Override
    public String getDisplayName() {
        return "Rain";
    }

    @Override
    public boolean isUsed() {
        return this.hasUsed;
    }

    @Override
    public String getSuccessSound() {
        return "rain_start.wav";
    }

    @Override
    public String getIcon() {
        return "tool_rain.png";
    }

    @Override
    public String getMouseOverText() {
        return "Turn clouds into rain clouds.";
    }

    @Override
    public void tryUnlock(GameState state) {
        this.unlockByDefault();
    }

    @Override
    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }
}

