/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.controller.Tool;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.TownEntity;
import hectare.model.World;
import java.io.Serializable;

public class SunTool
extends Tool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double REQUIRED_PROSPERITY = 9.0;
    private static final double SUN_TOOL_INCREASE = 0.4;
    private static final int SUN_TOOL_RADIUS = 3;
    private static final double SUN_BY_TOOL_LIMIT = 3.0;
    private boolean hasUsed = false;

    @Override
    public boolean apply(Coordinates location, World world) {
        if (!this.hasUsed) {
            this.hasUsed = true;
        }
        int i = -3;
        while (i <= 3) {
            int j = -3;
            while (j <= 3) {
                double distance = Math.sqrt(i * i + j * j);
                if (!(distance > 3.0)) {
                    Coordinates here = new Coordinates(location.getX() + i, location.getY() + j);
                    double increment = 0.13333333333333333 * (3.0 - distance);
                    Tile tile = world.getTile(here);
                    double newSunByTool = tile.getSunByTool() + increment;
                    if (newSunByTool > 3.0) {
                        newSunByTool = 3.0;
                    }
                    tile.setSunByTool(newSunByTool);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Sun";
    }

    @Override
    public boolean isUsed() {
        return this.hasUsed;
    }

    @Override
    public String getSuccessSound() {
        return "sunshine.wav";
    }

    @Override
    public String getIcon() {
        return "tool_sun.png";
    }

    @Override
    public String getMouseOverText() {
        if (this.isEnabled()) {
            return "Increase the sunniness on a tile to raise the temperature.";
        }
        return "Unlocked at population " + Integer.toString(TownEntity.toPopulation(9.0));
    }

    @Override
    public void tryUnlock(GameState state) {
        this.unlockByProsperity(9.0, state);
    }

    @Override
    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }
}

