/*
 * Decompiled with CFR 0.152.
 */
package hectare.controller;

import hectare.SoundSystem;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.World;
import hectare.view.Notification;
import hectare.view.NotificationSystem;
import hectare.view.ScreenPoint;
import java.io.Serializable;

public abstract class Tool
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_SUCCESS_SOUND = "applause.wav";
    protected static final String DEFAULT_FAILURE_SOUND = "failure.wav";
    protected static final String DEFAULT_UNLOCK_SOUND = "newtool.wav";
    private boolean enabled;
    private boolean hasUsed;
    private ScreenPoint toolPos;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isUsed() {
        return this.hasUsed;
    }

    public void setUsed(boolean setter) {
        this.hasUsed = setter;
    }

    public boolean canApply(Coordinates location, World world) {
        return true;
    }

    public abstract boolean apply(Coordinates var1, World var2);

    public void deselect(World world) {
    }

    public abstract String getDisplayName();

    public String getSuccessSound() {
        return DEFAULT_SUCCESS_SOUND;
    }

    public String getFailureSound() {
        return DEFAULT_FAILURE_SOUND;
    }

    public abstract String getIcon();

    public void setPosition(ScreenPoint toolPos) {
        this.toolPos = toolPos;
    }

    public abstract String getMouseOverText();

    public abstract void tryUnlock(GameState var1);

    protected void unlockByDefault() {
        this.setEnabled(true);
    }

    protected void unlockByProsperity(double requiredProsperity, GameState state) {
        if (!this.isEnabled() && requiredProsperity - state.getWorld().getTotalProsperity() < 1.0E-4) {
            this.setEnabled(true);
            SoundSystem.getInstance().playSound(DEFAULT_UNLOCK_SOUND);
            if (this.toolPos != null) {
                Notification n = new Notification("New tool unlocked!", new Coordinates(-1, -1), 10.0);
                n.setPointTo(this.toolPos);
                NotificationSystem.getInstance().postNotification(n, "TOOLBAR");
            }
        }
    }

    protected void unlockByTutorial(GameState state) {
        if (!this.isEnabled()) {
            this.setEnabled(true);
            SoundSystem.getInstance().playSound(DEFAULT_UNLOCK_SOUND);
            if (this.toolPos != null) {
                Notification n = new Notification("New tool unlocked!", new Coordinates(-1, -1), 10.0);
                n.setPointTo(this.toolPos);
                NotificationSystem.getInstance().postNotification(n, "TOOLBAR");
            }
        }
    }
}

