/*
 * Decompiled with CFR 0.152.
 */
package hectare.model;

import hectare.Debug;
import hectare.Hectare;
import hectare.controller.CloudController;
import hectare.controller.CloudTool;
import hectare.controller.Controller;
import hectare.controller.ForestTool;
import hectare.controller.GroundwaterController;
import hectare.controller.HumidityController;
import hectare.controller.MountainTool;
import hectare.controller.NutrientController;
import hectare.controller.NutrientTool;
import hectare.controller.QueryTool;
import hectare.controller.RainTool;
import hectare.controller.SunTool;
import hectare.controller.TemperatureController;
import hectare.controller.Tool;
import hectare.controller.TownController;
import hectare.controller.WindController;
import hectare.controller.WindTool;
import hectare.model.Coordinates;
import hectare.model.TownEntity;
import hectare.model.World;
import hectare.view.MainWindow;
import hectare.view.layers.SingleWidgetLayer;
import hectare.view.widgets.IsoView;
import hectare.view.widgets.TutorialMenu;
import hectare.view.widgets.TutorialWinMenu;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class GameState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double POP_WIN_GOAL = 20.0;
    private static final long UPDATE_INTERVAL = 1000L;
    private static final double EPSILON = 1.0E-4;
    private static final int VIEW_WIDTH = 1024;
    private static final int VIEW_HEIGHT = 768;
    private World world;
    private ArrayList<Tool> tools;
    private Tool currentTool;
    private transient ArrayList<Controller> controllers;
    private boolean initialized;
    private boolean wonGame;
    private long lastUpdate;
    private int currentGoal;
    private boolean start;

    public GameState(String mapFile, MainWindow window) {
        this.world = new World(mapFile, window);
        this.controllers = new ArrayList();
        this.tools = new ArrayList();
        this.currentGoal = 0;
        this.start = true;
        this.addInitialControllers();
        this.initialized = false;
        this.wonGame = false;
    }

    public void initialize() {
        this.addStoryControllers();
        QueryTool queryTool = new QueryTool();
        this.tools.add(queryTool);
        this.tools.add(new RainTool());
        this.tools.add(new WindTool());
        this.tools.add(new NutrientTool());
        this.tools.add(new SunTool());
        this.tools.add(new CloudTool());
        this.tools.add(new ForestTool());
        this.tools.add(new MountainTool());
        this.currentTool = queryTool;
        this.initialized = true;
        this.lastUpdate = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step() {
        GameState gameState = this;
        synchronized (gameState) {
            for (Controller c : this.controllers) {
                c.step(this);
            }
            this.lastUpdate = System.currentTimeMillis();
        }
        for (Tool t : this.tools) {
            t.tryUnlock(this);
        }
        if (!this.wonGame && this.getWorld().getTotalProsperity() >= 20.0) {
            this.wonGame = true;
            Hectare.winGame();
        } else if (this.initialized && this.getWorld().getTotalProsperity() < 1.0E-4 && !this.wonGame) {
            Hectare.loseGame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tStep(IsoView view) {
        boolean bl;
        GameState gameState = this;
        synchronized (gameState) {
            for (Controller controller : this.controllers) {
                controller.step(this);
            }
            this.lastUpdate = System.currentTimeMillis();
        }
        for (Tool t : this.tools) {
            t.tryUnlock(this);
        }
        if (this.start) {
            this.pushTutorial(0);
            this.start = false;
        }
        int usingtool = this.tools.indexOf(this.getCurrentTool());
        boolean bl2 = false;
        if (usingtool == this.currentGoal && this.getCurrentTool().isUsed()) {
            if (this.correctOverlay(usingtool, view)) {
                bl = true;
                if (this.currentGoal == this.tools.size() - 1) {
                    TutorialWinMenu m = new TutorialWinMenu(512, 384);
                    Hectare.pushLayer(new SingleWidgetLayer<TutorialWinMenu>(1024, 768, m));
                    return bl;
                }
                ++this.currentGoal;
                this.pushTutorial(this.currentGoal);
                this.setTool(this.tools.get(this.currentGoal), view);
                if (this.currentGoal != 0) {
                    this.unlockNextTool();
                }
            } else {
                this.getCurrentTool().setUsed(false);
            }
        }
        return bl;
    }

    private void pushTutorial(int message) {
        TutorialMenu m = new TutorialMenu(512, 384, message);
        Hectare.pushLayer(new SingleWidgetLayer<TutorialMenu>(1024, 768, m));
    }

    private boolean correctOverlay(int utool, IsoView view) {
        if (utool == 0 || utool == 1 || utool == 5 || utool == 6 || utool == 7) {
            return true;
        }
        if (view.getCurrentOverlay() == null) {
            return false;
        }
        if (utool == 2 && view.getCurrentOverlay().currentName() == "Wind") {
            return true;
        }
        if (utool == 3 && view.getCurrentOverlay().currentName() == "Nutrient") {
            return true;
        }
        return utool == 4 && view.getCurrentOverlay().currentName() == "Temperature";
    }

    public void setTool(Tool t) {
        if (this.currentTool != null) {
            this.currentTool.deselect(this.world);
        }
        this.currentTool = t;
    }

    public void setTool(Tool t, IsoView view) {
        if (this.currentTool != null) {
            this.currentTool.deselect(this.world);
        }
        this.currentTool = t;
        int newtoolint = this.tools.indexOf(t);
        if (newtoolint == 2) {
            view.setCurrentOverlay(IsoView.WIND_OVERLAY);
        } else if (newtoolint == 3) {
            view.setCurrentOverlay(IsoView.NUTRIENT_OVERLAY);
        } else if (newtoolint == 4) {
            view.setCurrentOverlay(IsoView.TEMP_OVERLAY);
        }
    }

    public Tool getCurrentTool() {
        return this.currentTool;
    }

    public ArrayList<Tool> getTools() {
        return this.tools;
    }

    public ArrayList<Controller> getControllers() {
        return this.controllers;
    }

    public World getWorld() {
        return this.world;
    }

    public int getCurrentGoal() {
        return this.currentGoal;
    }

    public long getLastUpdateTime() {
        return this.lastUpdate;
    }

    public boolean applyTool(Coordinates location) {
        Debug.write(this, "Applying  " + this.currentTool.getDisplayName() + " tool");
        return this.currentTool.apply(location, this.world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStepInterpolation() {
        GameState gameState = this;
        synchronized (gameState) {
            long time = System.currentTimeMillis();
            return Math.min((double)(time - this.lastUpdate) / 1000.0, 1.0);
        }
    }

    public boolean unlockNextTool() {
        int i = 0;
        while (i < this.tools.size()) {
            if (!this.tools.get(i).isEnabled()) {
                this.tools.get(i).setEnabled(true);
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getPopulationGoal() {
        return TownEntity.toPopulation(20.0);
    }

    public boolean isWon() {
        return this.wonGame;
    }

    private void addInitialControllers() {
        this.controllers.add(new GroundwaterController());
        this.controllers.add(new HumidityController());
        this.controllers.add(new TemperatureController());
        this.controllers.add(new WindController());
        this.controllers.add(new CloudController());
        this.controllers.add(new NutrientController());
    }

    private void addStoryControllers() {
        this.controllers.add(new TownController());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.controllers = new ArrayList();
        this.addInitialControllers();
        this.addStoryControllers();
    }
}

