/*
 * Decompiled with CFR 0.152.
 */
package hectare.model;

import hectare.model.Entity;
import hectare.model.Vector;
import java.io.Serializable;

public class Tile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double SUN_MIN_PRODUCTIVE = 0.8;
    private static final double SUN_MAX_PRODUCTIVE = 1.5;
    private static final double SUN_MAX_USEFUL = 1.7;
    private static final double WATER_MIN_PRODUCTIVE = 0.1;
    private static final double WATER_MAX_PRODUCTIVE = 0.7;
    private static final double WATER_MAX_USEFUL = 0.8;
    private static final double MIN_NUTRIENT_PRODUCTIVITY_FACTOR = 0.7;
    private static final double MIN_TILE_GROUNDWATER = 0.0;
    private static final double MAX_TILE_GROUNDWATER = 1.0;
    private static final double MIN_TILE_SUN = 0.0;
    private static final double MAX_TILE_SUN = 4.0;
    private static final double MIN_TILE_NUTRIENT = 0.0;
    private static final double MAX_TILE_NUTRIENT = 1.0;
    private double groundwater = 0.3;
    private double humidity = 0.1;
    private double sun = 1.0;
    private double sunByTool;
    private double temperature = 1.0;
    private double nutrient = 0.7;
    private Vector wind = new Vector(0.0, 0.0);
    private Vector incomingWind = new Vector(0.0, 0.0);
    private Vector windByTool = new Vector(0.0, 0.0);
    private Entity entity;

    public static double getMinSun() {
        return 0.0;
    }

    public static double getMinGoodSun() {
        return 0.8;
    }

    public static double getMaxGoodSun() {
        return 1.5;
    }

    public static double getMaxSun() {
        return 4.0;
    }

    public static double getMinWater() {
        return 0.0;
    }

    public static double getMinGoodWater() {
        return 0.1;
    }

    public static double getMaxGoodWater() {
        return 0.7;
    }

    public static double getMaxWater() {
        return 1.0;
    }

    public static double getMinNutrient() {
        return 0.0;
    }

    public static double getMaxNutrient() {
        return 1.0;
    }

    public void setHumidity(double newHumidity) {
        this.humidity = newHumidity;
    }

    public double getHumidity() {
        return this.humidity;
    }

    public void setGroundwater(double newGroundwater) {
        this.groundwater = Math.min(newGroundwater, 1.0);
    }

    public double getGroundwater() {
        return this.groundwater;
    }

    public void setSun(double newSun) {
        this.sun = Math.min(newSun, 4.0);
    }

    public double getSun() {
        return this.sun;
    }

    public void setSunByTool(double newSunByTool) {
        this.sunByTool = newSunByTool;
    }

    public double getSunByTool() {
        return this.sunByTool;
    }

    public void setWind(Vector newWind) {
        this.wind = newWind;
    }

    public Vector getWind() {
        return this.wind;
    }

    public void addWind(Vector newWind) {
        this.incomingWind = this.incomingWind.add(newWind);
    }

    public void setWindByTool(Vector newWindByTool) {
        this.windByTool = newWindByTool;
    }

    public Vector getWindByTool() {
        return this.windByTool;
    }

    public void addWindByTool(Vector newWind) {
        this.windByTool = this.windByTool.add(newWind);
    }

    public void updateWind() {
        if (this.incomingWind.getLength() > 1.0) {
            this.incomingWind = this.incomingWind.normalize();
        }
        this.wind = this.incomingWind;
    }

    public void setEntity(Entity newEntity) {
        this.entity = newEntity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public void setTemperature(double newTemperature) {
        this.temperature = newTemperature;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setNutrient(double newNutrient) {
        this.nutrient = Math.min(newNutrient, 1.0);
    }

    public double getNutrient() {
        return this.nutrient;
    }

    private double getSunQuality() {
        double sunQuality = this.sun < 0.8 ? this.sun / 0.8 : (this.sun < 1.5 ? 1.0 : (this.sun < 1.7 ? (1.7 - this.sun) / 0.19999999999999996 : 0.0));
        return sunQuality;
    }

    private double getWaterQuality() {
        double waterQuality = this.groundwater < 0.1 ? this.groundwater / 0.1 : (this.groundwater < 0.7 ? 1.0 : (this.groundwater < 0.8 ? (0.8 - this.groundwater) / 0.10000000000000009 : 0.0));
        return waterQuality;
    }

    private double getNutrientQuality() {
        double nutrientQuality = this.nutrient * 0.30000000000000004 + 0.7;
        return nutrientQuality;
    }

    public double getCurrentProductivity() {
        double sunQuality = this.getSunQuality();
        double waterQuality = this.getWaterQuality();
        double nutrientQuality = this.getNutrientQuality();
        double currentProductivity = sunQuality * waterQuality * nutrientQuality;
        return currentProductivity;
    }
}

