/*
 * Decompiled with CFR 0.152.
 */
package hectare.model;

import hectare.model.Cloud;
import hectare.model.Coordinates;
import hectare.model.ForestEntity;
import hectare.model.MountainEntity;
import hectare.model.Tile;
import hectare.model.TownEntity;
import hectare.model.WaterEntity;
import hectare.view.MainWindow;
import hectare.view.utilities.DialogUtilities;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class World
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int WORLD_SIZE = 100;
    private Tile[][] tiles;
    private List<Cloud> clouds = Collections.synchronizedList(new LinkedList());
    private Coordinates queryLocation;
    private int townCount = 0;
    private int townsUnlocked;
    private double totalProsperity;
    private Vector<Coordinates> townPositions;
    private double nextTownProsperity;

    public World(String mapFilename, MainWindow window) {
        int townNum = 0;
        this.townPositions = new Vector();
        if (mapFilename == null) {
            DialogUtilities.showNativeNotification(window, "Error", "Error: map file not found");
            System.exit(200);
        } else {
            try {
                InputStream in = this.getClass().getResourceAsStream(mapFilename);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                this.tiles = new Tile[100][100];
                int i = 0;
                while (i < 100) {
                    String strLine = br.readLine();
                    if (strLine.length() < 100) {
                        DialogUtilities.showNativeNotification(window, "Error", "Error: invalid map");
                        System.exit(200);
                    }
                    int j = 0;
                    while (j < 100) {
                        this.tiles[i][j] = new Tile();
                        char ch = strLine.charAt(j);
                        switch (ch) {
                            case '~': {
                                this.tiles[i][j].setEntity(new WaterEntity());
                                break;
                            }
                            case '^': {
                                this.tiles[i][j].setEntity(new MountainEntity());
                                break;
                            }
                            case '*': {
                                this.tiles[i][j].setEntity(new ForestEntity());
                            }
                        }
                        if (Character.isUpperCase(ch) || Character.isLowerCase(ch)) {
                            Coordinates here = new Coordinates(i, j);
                            this.tiles[i][j].setEntity(new TownEntity());
                            int id = Character.isUpperCase(ch) ? ch - 65 : ch - 97 + 26;
                            if (this.townCount <= id) {
                                this.townCount = id + 1;
                            }
                            this.townPositions.setSize(this.townCount);
                            if (this.townPositions.get(id) != null) {
                                DialogUtilities.showNativeNotification(window, "Error", "Error: invalid map");
                                System.exit(200);
                            }
                            this.townPositions.set(id, here);
                            ++townNum;
                        }
                        ++j;
                    }
                    ++i;
                }
                in.close();
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                e.printStackTrace();
                DialogUtilities.showNativeNotification(window, "Error", "Error: invalid map");
                System.exit(200);
            }
        }
        if (this.townCount == 0 || this.townCount != townNum) {
            DialogUtilities.showNativeNotification(window, "Error", "Error: invalid map");
            System.exit(200);
        }
        this.townsUnlocked = 0;
        this.totalProsperity = 0.0;
        this.nextTownProsperity = 0.0;
    }

    public Tile getTile(Coordinates location) {
        return this.tiles[location.getX()][location.getY()];
    }

    public List<Cloud> getClouds() {
        return this.clouds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloud(Coordinates location, double humidity) {
        List<Cloud> list = this.clouds;
        synchronized (list) {
            this.clouds.add(new Cloud(location, humidity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cloud getCloud(Coordinates position) {
        List<Cloud> list = this.clouds;
        synchronized (list) {
            for (Cloud c : this.clouds) {
                if (!c.getPosition().equals(position)) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Coordinates, Cloud> getCloudIndex() {
        HashMap<Coordinates, Cloud> toReturn = new HashMap<Coordinates, Cloud>();
        List<Cloud> list = this.clouds;
        synchronized (list) {
            for (Cloud c : this.clouds) {
                toReturn.put(c.getPosition(), c);
            }
        }
        return toReturn;
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 100;
    }

    public void setQueryLocation(Coordinates location) {
        this.queryLocation = location;
    }

    public Coordinates getQueryLocation() {
        return this.queryLocation;
    }

    public void setTownCount(int newTownCount) {
        this.townCount = newTownCount;
    }

    public int getTownCount() {
        return this.townCount;
    }

    public void unlockTown() {
        this.getTown(this.townsUnlocked).unlock();
        ++this.townsUnlocked;
    }

    public int getTownsUnlocked() {
        return this.townsUnlocked;
    }

    public void setTotalProsperity(double newTotalProsperity) {
        this.totalProsperity = newTotalProsperity;
    }

    public double getTotalProsperity() {
        return this.totalProsperity;
    }

    public Coordinates getInitTownLoc() {
        return this.townPositions.elementAt(0);
    }

    public Coordinates getTownPosition(int i) {
        return this.townPositions.elementAt(i);
    }

    public TownEntity getTown(int i) {
        Coordinates position = this.townPositions.get(i);
        return (TownEntity)this.getTile(position).getEntity();
    }

    public void setNextTownProsperity(double p) {
        this.nextTownProsperity = p;
    }

    public double getNextTownProsperity() {
        return this.nextTownProsperity;
    }
}

