/*
 * Decompiled with CFR 0.152.
 */
package hectare.testing;

import hectare.controller.Controller;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.World;
import hectare.view.MainWindow;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Test;

public class ControllerTester {
    private static final int NUMSTEP = 1000;
    private static final Vector<String> MAP_TESTS = new Vector();

    @Test
    public void testController() {
        MAP_TESTS.add("/maps/world.txt");
        MAP_TESTS.add("/hectare/testing/maps/test.txt");
        MAP_TESTS.add("/hectare/testing/maps/world1.txt");
        MAP_TESTS.add("/hectare/testing/maps/tester1.txt");
        MAP_TESTS.add("/hectare/testing/maps/tester2.txt");
        MAP_TESTS.add("/hectare/testing/maps/tester3.txt");
        MAP_TESTS.add("/hectare/testing/maps/tester4.txt");
        MAP_TESTS.add("/hectare/testing/maps/tester5.txt");
        MAP_TESTS.add("/hectare/testing/maps/tester6.txt");
        MAP_TESTS.add("/hectare/testing/maps/world2.txt");
        int i = 0;
        while (i < MAP_TESTS.size()) {
            System.err.println("Controller testing with map: " + MAP_TESTS.get(i) + " (" + (i + 1) + " of " + MAP_TESTS.size() + ")");
            GameState state = new GameState(MAP_TESTS.get(i), new MainWindow());
            state.initialize();
            World world = state.getWorld();
            int width = world.getWidth();
            int height = world.getHeight();
            int j = 0;
            while (j < 1000) {
                if (j * 10 % 1000 == 0) {
                    System.err.print(String.valueOf(j * 10 / 1000 * 10) + "%");
                } else if (j * 50 % 1000 == 0) {
                    System.err.print(".");
                }
                for (Controller c : state.getControllers()) {
                    c.step(state);
                }
                int x = 0;
                while (x < width) {
                    int y = 0;
                    while (y < height) {
                        Coordinates c = new Coordinates(x, y);
                        this.testTile(world.getTile(c));
                        ++y;
                    }
                    ++x;
                }
                Assert.assertTrue(world.getClouds().size() <= width * height * 2);
                ++j;
            }
            System.err.println("100%");
            ++i;
        }
    }

    public void testTile(Tile t) {
        Assert.assertTrue(t.getSun() <= Tile.getMaxSun() && t.getSun() >= Tile.getMinSun());
        Assert.assertTrue(t.getGroundwater() <= Tile.getMaxWater() && t.getGroundwater() >= Tile.getMinWater());
        Assert.assertTrue(t.getNutrient() <= Tile.getMaxNutrient() && t.getNutrient() >= Tile.getMinNutrient());
        Assert.assertTrue((int)t.getWind().getX() == 0 || (int)t.getWind().getX() == 1 || (int)t.getWind().getX() == -1);
        Assert.assertTrue((int)t.getWind().getY() == 0 || (int)t.getWind().getY() == 1 || (int)t.getWind().getY() == -1);
    }
}

