/*
 * Decompiled with CFR 0.152.
 */
package hectare.testing;

import hectare.Debug;
import hectare.view.CoordinateConverter;
import hectare.view.IsoPoint;
import hectare.view.ScreenPoint;
import java.awt.Rectangle;
import java.awt.Shape;
import org.junit.Before;
import org.junit.Test;

public class CoordinateConverterTester {
    public static final double EPSILON = 1.0E-4;

    @Before
    public void setup() {
        Debug.setEnabled(true);
    }

    private void fail(String message) throws Exception {
        Debug.write(this, "Failure: " + message);
        throw new Exception(message);
    }

    private boolean withinN(double n1, double n2, double n) {
        return n1 + n >= n2 && n1 - n <= n2;
    }

    @Test
    public void testBasicConstruction() throws Exception {
        float width = 0.1f;
        while (width < 100.0f) {
            float height = 0.1f;
            while (height < 100.0f) {
                CoordinateConverter c = new CoordinateConverter(width, height);
                if (c.getTileWidth() != width) {
                    this.fail("Width = " + c.getTileWidth() + "; should be " + width);
                }
                if (c.getTileHeight() != height) {
                    this.fail("Height = " + c.getTileHeight() + "; should be " + height);
                }
                height += 0.1f;
            }
            width += 0.1f;
        }
    }

    @Test
    public void testAdvancedConstruction() throws Exception {
        Rectangle[] regions = new Rectangle[]{new Rectangle(0, 0, 1, 1), new Rectangle(0, 0, 100, 100), new Rectangle(0, 0, 200, 100), new Rectangle(0, 0, 100, 200), new Rectangle(5, 0, 1, 1), new Rectangle(5, 0, 100, 100), new Rectangle(5, 0, 200, 100), new Rectangle(5, 0, 100, 200), new Rectangle(0, 5, 1, 1), new Rectangle(0, 5, 100, 100), new Rectangle(0, 5, 200, 100), new Rectangle(0, 5, 100, 200), new Rectangle(5, 5, 1, 1), new Rectangle(5, 5, 100, 100), new Rectangle(5, 5, 200, 100), new Rectangle(5, 5, 100, 200), new Rectangle(-5, 0, 1, 1), new Rectangle(-5, 0, 100, 100), new Rectangle(-5, 0, 200, 100), new Rectangle(-5, 0, 100, 200), new Rectangle(0, -5, 1, 1), new Rectangle(0, -5, 100, 100), new Rectangle(0, -5, 200, 100), new Rectangle(0, -5, 100, 200), new Rectangle(-5, -5, 1, 1), new Rectangle(-5, -5, 100, 100), new Rectangle(-5, -5, 200, 100), new Rectangle(-5, -5, 100, 200)};
        int i = 0;
        while (i < regions.length) {
            int mapWidth = 1;
            while (mapWidth < 150) {
                int mapHeight = 1;
                while (mapHeight < 150) {
                    Rectangle region = regions[i];
                    CoordinateConverter c = new CoordinateConverter(mapWidth, mapHeight, region);
                    Shape mapShape = c.mapRectToScreen(0, 0, mapWidth, mapHeight);
                    Rectangle mapRegion = mapShape.getBounds();
                    if (!(this.withinN(mapRegion.width, region.width, 1.0) && this.withinN(mapRegion.height, region.height, 1.0) && this.withinN(mapRegion.x, region.x, 1.0) && this.withinN(mapRegion.y, region.y, 1.0))) {
                        this.fail("Map was not laid out correctly! map size=" + mapWidth + "x" + mapHeight + ", region=" + region + ", map region bounds=" + mapRegion);
                    }
                    ++mapHeight;
                }
                ++mapWidth;
            }
            ++i;
        }
    }

    @Test
    public void testConsistency() throws Exception {
        float tileWidth = 0.1f;
        while (tileWidth < 5.0f) {
            float tileHeight = 0.1f;
            while (tileHeight < 5.0f) {
                float isoX = 0.0f;
                while (isoX < 2.0f * tileWidth) {
                    float isoY = 0.0f;
                    while (isoY < 2.0f * tileHeight) {
                        CoordinateConverter c = new CoordinateConverter(tileWidth, tileHeight);
                        IsoPoint iso1 = new IsoPoint(isoX, isoY, 0.0f);
                        ScreenPoint screen1 = c.getScreenPosition(iso1);
                        IsoPoint iso2 = c.getIsoPosition(screen1.x, screen1.y);
                        ScreenPoint screen2 = c.getScreenPosition(iso2);
                        if (!(this.withinN(iso1.x, iso2.x, 1.0E-4) && this.withinN(iso1.y, iso2.y, 1.0E-4) && this.withinN(iso1.z, iso2.z, 1.0E-4))) {
                            this.fail("Inconsistent conversion (iso->screen->iso): " + iso1 + " -> " + screen1 + " -> " + iso2);
                        }
                        if (!this.withinN(screen1.x, screen2.x, 1.0E-4) || !this.withinN(screen1.y, screen1.y, 1.0E-4)) {
                            this.fail("Inconsistent conversion (screen->iso->screen): " + screen1 + " -> " + iso2 + " -> " + screen2);
                        }
                        isoY += 0.1f;
                    }
                    isoX += 0.1f;
                }
                tileHeight += 0.1f;
            }
            tileWidth += 0.1f;
        }
    }
}

