/*
 * Decompiled with CFR 0.152.
 */
package hectare.testing;

import hectare.Hectare;
import hectare.SoundSystem;
import hectare.controller.Tool;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.testing.OutputCatcher;
import hectare.view.layers.GameLayer;
import hectare.view.layers.NewLoadLayer;
import hectare.view.layers.SingleWidgetLayer;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HectareTester
extends OutputCatcher {
    public static final String TEST_SAVE = "temp.save.hex";
    private HectareThread game;

    @AfterClass
    @BeforeClass
    public static void removeSave() {
        File saveGame = new File(TEST_SAVE);
        saveGame.delete();
    }

    @Test
    public void testNewGame() throws InterruptedException {
        SoundSystem.reset();
        this.game = new HectareThread();
        this.game.setDaemon(true);
        this.game.start();
        Thread.sleep(1000L);
        Hectare.startGame();
        Assert.assertTrue(Hectare.peekLayer() instanceof NewLoadLayer);
        this.assertNoExceptions();
        this.waitForGame();
        this.assertNoExceptions();
    }

    @Test
    public void testInstructions() throws InterruptedException {
        Hectare.showInstructions();
        Assert.assertTrue(Hectare.peekLayer() instanceof SingleWidgetLayer);
        Thread.sleep(5000L);
        Hectare.popLayer();
        this.assertNoExceptions();
    }

    @Test
    public void testPauseSaveLoad() throws InterruptedException {
        Hectare.showPauseMenu();
        this.assertNoExceptions();
        Assert.assertTrue(Hectare.peekLayer() instanceof SingleWidgetLayer);
        File testSave = new File(TEST_SAVE);
        Hectare.saveGame(testSave);
        this.assertNoExceptions();
        this.assertOutput("Game saved");
        Hectare.loadGame(testSave);
        this.assertNoExceptions();
        this.assertOutput("Game loaded");
        Thread.sleep(1000L);
        this.assertNoExceptions();
    }

    @Test
    public void testWinGame() throws InterruptedException {
        Hectare.winGame();
        Thread.sleep(5000L);
        Hectare.popLayer();
        this.assertNoExceptions();
    }

    @Test
    public void testLoseGame() throws InterruptedException {
        Hectare.loseGame();
        Thread.sleep(5000L);
        Hectare.popLayer();
        this.assertNoExceptions();
    }

    @Test
    public void testPlayGame() throws InterruptedException {
        int world_size = 100;
        Random rnd = new Random(1L);
        GameLayer gameLayer = (GameLayer)Hectare.peekLayer();
        GameState state = gameLayer.getState();
        ArrayList<Tool> tools = new ArrayList<Tool>();
        long startTime = System.currentTimeMillis();
        for (Tool tool : state.getTools()) {
            if (!tool.isEnabled()) {
                state.unlockNextTool();
            }
            tools.add(tool);
        }
        this.assertNoExceptions();
        while (System.currentTimeMillis() - startTime < 1200000L) {
            Coordinates target = new Coordinates(rnd.nextInt(world_size), rnd.nextInt(world_size));
            int toUse = rnd.nextInt(tools.size());
            state.setTool((Tool)tools.get(toUse));
            String sound = state.applyTool(target) ? state.getCurrentTool().getSuccessSound() : state.getCurrentTool().getFailureSound();
            SoundSystem.getInstance().playSound(sound);
            this.assertNoExceptions();
        }
    }

    private void waitForGame() throws InterruptedException {
        while (!(Hectare.peekLayer() instanceof GameLayer)) {
            Thread.sleep(1000L);
            this.assertNoExceptions();
        }
    }

    public class HectareThread
    extends Thread {
        @Override
        public void run() {
            Hectare.main(new String[0]);
        }
    }
}

