/*
 * Decompiled with CFR 0.152.
 */
package hectare.testing;

import hectare.Hectare;
import hectare.SoundSystem;
import hectare.model.Cloud;
import hectare.model.Coordinates;
import hectare.model.GameState;
import hectare.model.Tile;
import hectare.model.Vector;
import hectare.model.World;
import hectare.testing.OutputCatcher;
import hectare.view.layers.GameLayer;
import hectare.view.layers.NewLoadLayer;
import org.junit.Assert;
import org.junit.Test;

public class ModelTester
extends OutputCatcher {
    private HectareThread game;

    @Test
    public void newHectare() throws InterruptedException {
        SoundSystem.reset();
        this.game = new HectareThread();
        this.game.setDaemon(true);
        this.game.start();
        Thread.sleep(1000L);
        Hectare.startGame();
        Assert.assertTrue(Hectare.peekLayer() instanceof NewLoadLayer);
        this.assertNoExceptions();
        while (!(Hectare.peekLayer() instanceof GameLayer)) {
            Thread.sleep(1000L);
            this.assertNoExceptions();
        }
        this.assertNoExceptions();
        Assert.assertTrue(Hectare.peekLayer() instanceof GameLayer);
        GameLayer glayer = (GameLayer)Hectare.peekLayer();
        GameState state = glayer.getState();
        World world = state.getWorld();
        int x = 0;
        while (x < world.getWidth()) {
            int y = 0;
            while (y < world.getHeight()) {
                Coordinates c = new Coordinates(x, y);
                this.testCoordinates(c);
                this.testTile(world.getTile(c));
                ++y;
            }
            ++x;
        }
    }

    public void testTile(Tile t) {
        Assert.assertTrue(t.getSun() <= Tile.getMaxSun() && t.getSun() >= Tile.getMinSun());
        Assert.assertTrue(t.getGroundwater() <= Tile.getMaxWater() && t.getGroundwater() >= Tile.getMinWater());
        Assert.assertTrue(t.getNutrient() <= Tile.getMaxNutrient() && t.getNutrient() >= Tile.getMinNutrient());
        Assert.assertTrue((int)t.getWind().getX() == 0 || (int)t.getWind().getX() == 1 || (int)t.getWind().getX() == -1);
        Assert.assertTrue((int)t.getWind().getY() == 0 || (int)t.getWind().getY() == 1 || (int)t.getWind().getY() == -1);
    }

    public void testCoordinates(Coordinates c) {
        Assert.assertTrue(c.getX() >= 0 && c.getX() <= 99);
        Assert.assertTrue(c.getY() >= 0 && c.getY() <= 99);
        int i = 0;
        while (i < 100) {
            int j = 0;
            while (j < 100) {
                Assert.assertTrue(new Coordinates(i, j).getX() == i);
                Assert.assertTrue(new Coordinates(i, j).getY() == j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 100) {
            Assert.assertTrue(new Coordinates(-1, i).getX() == 99 - i);
            Assert.assertTrue(new Coordinates(-1, i).getY() == 99);
            Assert.assertTrue(new Coordinates(100, i).getX() == 99 - i);
            Assert.assertTrue(new Coordinates(100, i).getY() == 0);
            Assert.assertTrue(new Coordinates(i, -1).getX() == 99);
            Assert.assertTrue(new Coordinates(i, -1).getY() == 99 - i);
            Assert.assertTrue(new Coordinates(i, 100).getX() == 0);
            Assert.assertTrue(new Coordinates(i, 100).getY() == 99 - i);
            ++i;
        }
    }

    @Test
    public void testCoordinateClass() {
        Coordinates cInside = new Coordinates(99, 99);
        this.testCoordinates(cInside);
        Coordinates cOutside = new Coordinates(100, 50);
        Assert.assertTrue(cOutside.getX() == 49 && cOutside.getY() == 0);
    }

    @Test
    public void testCloudClass() {
        Cloud c = new Cloud(new Coordinates(0, 0), 2.0);
        c.updateRaining();
        Assert.assertTrue(c.isRaining());
        int i = 0;
        while (i < 30) {
            c.rainfall();
            ++i;
        }
        c.updateRaining();
        Assert.assertTrue(!c.isRaining());
        c.eat(new Cloud(new Coordinates(1, 1), 2.0));
        c.updateRaining();
        Assert.assertTrue(c.isRaining());
    }

    @Test
    public void testVectorClass() {
        double y;
        double x;
        double size;
        Vector v1 = new Vector(5.0, 5.0);
        Vector v2 = new Vector(6.0, 0.1);
        Assert.assertTrue(v1.add(v2).getY() == 5.1);
        Assert.assertTrue(v1.multiply(5.0).getX() == 25.0);
        double length = v1.normalize().getLength();
        Assert.assertTrue("Not close enough to 1: " + length, Math.abs(length - 1.0) < 1.0E-9);
        double epsilon = 1.0E-6;
        int i = 0;
        while (i < 1000) {
            size = Math.random() * 1.0E10;
            x = Math.random() * size;
            y = Math.sqrt(size * size - x * x);
            Assert.assertTrue(Math.abs(new Vector(x, y).getLength() - size) < epsilon * 1.0E10);
            double nx = new Vector(x, y).normalize().getX();
            double ny = new Vector(x, y).normalize().getY();
            Assert.assertTrue(Math.abs(nx / x - ny / y) < epsilon);
            ++i;
        }
        i = 0;
        while (i < 1000) {
            size = Math.random() * 1.0E-10;
            x = Math.random() * size;
            y = Math.sqrt(size * size - x * x);
            Assert.assertTrue(Math.abs(new Vector(x, y).getLength() - size) < epsilon * 1.0E-10);
            System.err.println("error");
            ++i;
        }
        this.assertNoExceptions();
    }

    @Test
    public void alphaTileTest() {
        int numTest = 27;
        double[] groundWater = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        double[] sun = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0};
        double[] nutrient = new double[]{0.0, 0.5, 1.0, 0.0, 0.5, 1.0, 0.0, 0.5, 1.0, 0.0, 0.5, 1.0, 0.0, 0.5, 1.0, 0.0, 0.5, 1.0, 0.0, 0.5, 1.0, 0.0, 0.5, 1.0, 0.0, 0.5, 1.0};
        double[] ans = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, 0.85, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int i = 0;
        while (i < numTest) {
            Tile tile = new Tile();
            tile.setGroundwater(groundWater[i]);
            tile.setSun(sun[i]);
            tile.setNutrient(nutrient[i]);
            Assert.assertTrue(Math.abs(tile.getCurrentProductivity() - ans[i]) < 1.0E-4);
            ++i;
        }
    }

    private class HectareThread
    extends Thread {
        private HectareThread() {
        }

        @Override
        public void run() {
            Hectare.main(new String[0]);
        }
    }
}

