/*
 * Decompiled with CFR 0.152.
 */
package hectare.testing;

import hectare.Debug;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.AssertionFailedError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class OutputCatcher {
    private static final PrintStream REAL_OUT = System.out;
    private static final PrintStream REAL_ERR = System.err;
    private ByteArrayOutputStream output;

    @Before
    public void grabOut() {
        Debug.setEnabled(true);
        this.output = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.output));
        System.setErr(new PrintStream(this.output));
    }

    @After
    public void releaseOut() {
        System.setOut(REAL_OUT);
        System.setErr(REAL_ERR);
    }

    protected String getOutput() {
        return this.output.toString();
    }

    protected void assertOutput(String text) throws AssertionFailedError {
        Assert.assertTrue("Ony have:\n|" + this.getOutput() + "|", this.getOutput().contains(text));
    }

    protected void assertNotOutput(String text) throws AssertionFailedError {
        Assert.assertFalse("Found \"" + text + "\":\n|" + this.getOutput() + "|", this.getOutput().contains(text));
    }

    protected void clearOutput() {
        this.grabOut();
    }

    protected void assertNoExceptions() {
        this.assertNotOutput("Exception");
    }
}

