/*
 * Decompiled with CFR 0.152.
 */
package hectare.testing;

import hectare.SoundSystem;
import hectare.testing.OutputCatcher;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SoundSystemTester
extends OutputCatcher {
    @BeforeClass
    public static void resetSoundSystem() {
        SoundSystem.reset();
    }

    @Test
    public void testGetInstance() {
        SoundSystem sys = SoundSystem.getInstance();
        this.assertNoExceptions();
        this.assertOutput("Initializing sound system");
        this.clearOutput();
        SoundSystem otherSys = SoundSystem.getInstance();
        this.assertNoExceptions();
        this.assertNotOutput("Initializing sound system");
        Assert.assertEquals(sys, otherSys);
    }

    @Test
    public void testClick() throws InterruptedException {
        int i = 0;
        while (i < 10) {
            SoundSystem.getInstance().click();
            this.assertNoExceptions();
            this.clearOutput();
            ++i;
        }
    }

    @Test
    public void testPlaySound() throws InterruptedException {
        LinkedList<String> sounds = new LinkedList<String>();
        sounds.add("applause.wav");
        sounds.add("click.wav");
        sounds.add("cloudmade.wav");
        sounds.add("clunk.wav");
        sounds.add("failure.wav");
        sounds.add("forest.wav");
        sounds.add("newtool.wav");
        sounds.add("nutrients.wav");
        sounds.add("rain_start.wav");
        sounds.add("sunshine.wav");
        sounds.add("townconstructed.wav");
        sounds.add("towndestroyed.wav");
        sounds.add("wind.wav");
        for (String sound : sounds) {
            SoundSystem.getInstance().playSound(sound);
            Thread.sleep(1000L);
            this.assertNoExceptions();
            this.clearOutput();
        }
    }

    @Test
    public void testMusic() throws InterruptedException {
        SoundSystem.getInstance().startMusic();
        Thread.sleep(120000L);
        this.assertNoExceptions();
        this.assertNotOutput("No music");
        this.assertOutput("Changing song");
        this.assertOutput("Loading");
        this.assertOutput("Song over");
    }
}

