/*
 * Decompiled with CFR 0.152.
 */
package hectare.view;

import hectare.view.Notification;
import hectare.view.NotificationHandler;
import hectare.view.utilities.DrawUtilities;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public class NotificationSystem {
    private static NotificationSystem notificationSystem;
    public static final String MAP_NAME = "ISOVIEW";
    public static final String MINIMAP_NAME = "MINIMAP";
    public static final String TOOLBAR_NAME = "TOOLBAR";
    private static final int NAME_INDEX = 0;
    private static final int HANDLER_INDEX = 1;
    private static final int NOTIFICATIONS_INDEX = 2;
    private final ArrayList<ArrayList> handlerMap = new ArrayList();

    public static NotificationSystem getInstance() {
        if (notificationSystem == null) {
            notificationSystem = new NotificationSystem();
        }
        return notificationSystem;
    }

    private NotificationSystem() {
        notificationSystem = this;
    }

    public void postNotification(Notification n, String name) {
        ArrayList handlerList = this.getHandlerList(name);
        if (handlerList != null) {
            ((ArrayList)handlerList.get(2)).add(n);
        }
    }

    public void addHandler(String identifier, NotificationHandler handler) {
        ArrayList<Object> handlerList = new ArrayList<Object>(3);
        handlerList.add(0, identifier);
        handlerList.add(1, handler);
        handlerList.add(2, new ArrayList());
        this.handlerMap.add(handlerList);
    }

    public void paint(Graphics2D g) {
        for (ArrayList list : this.handlerMap) {
            NotificationHandler h = (NotificationHandler)list.get(1);
            ArrayList nots = (ArrayList)list.get(2);
            g.translate(h.getX(), h.getY());
            h.handleNotifications(nots.iterator());
            this.paintNotifications(g, nots.iterator());
            g.translate(-h.getX(), -h.getY());
        }
    }

    private void paintNotifications(Graphics2D g, Iterator<Notification> notifications) {
        while (notifications.hasNext()) {
            Notification n = notifications.next();
            if (n.isDone()) {
                notifications.remove();
                continue;
            }
            if (!n.isEnabled()) continue;
            Dimension size = n.getDrawSize(g);
            Rectangle rect = DrawUtilities.drawBubble(g, size, n.getPointTo());
            n.draw(g, rect);
        }
    }

    private ArrayList getHandlerList(String identifier) {
        for (ArrayList a : this.handlerMap) {
            if (!a.get(0).equals(identifier)) continue;
            return a;
        }
        return null;
    }
}

