/*
 * Decompiled with CFR 0.152.
 */
package hectare.view;

import hectare.Debug;
import hectare.view.utilities.ImageUtilities;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class SlideShow {
    private static final String SLIDE_PATH = "/slideshows/slides/";
    private static final String SLIDESHOW_PATH = "/slideshows/";
    private ArrayList<Slide> slides = new ArrayList();
    private int currentIndex = 0;

    public SlideShow(String filename) {
        InputStream in = this.getClass().getResourceAsStream(SLIDESHOW_PATH + filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Slide slide = this.readSlide(br);
        while (slide != null) {
            this.slides.add(slide);
            slide = this.readSlide(br);
        }
    }

    private Slide readSlide(BufferedReader br) {
        String imageFilename;
        String textFilename;
        String title;
        block7: {
            block6: {
                title = "";
                textFilename = "";
                imageFilename = "";
                try {
                    title = br.readLine();
                    if (title != null) break block6;
                    br.close();
                    return null;
                }
                catch (IOException e) {
                    Debug.write(this, "Could not read slide metadata!");
                    e.printStackTrace();
                    return null;
                }
            }
            textFilename = br.readLine();
            if (textFilename != null) break block7;
            br.close();
            return null;
        }
        imageFilename = br.readLine();
        if (imageFilename == null) {
            br.close();
            return null;
        }
        title = title.trim();
        textFilename = textFilename.trim();
        if ((imageFilename = imageFilename.trim()).equals("")) {
            return new Slide(title, SLIDE_PATH + textFilename);
        }
        return new Slide(title, SLIDE_PATH + textFilename, imageFilename);
    }

    public Slide getSlide() {
        return this.slides.get(this.currentIndex);
    }

    public boolean isBeginning() {
        return this.currentIndex == 0;
    }

    public boolean isEnd() {
        return this.currentIndex == this.slides.size() - 1;
    }

    public Slide next() {
        ++this.currentIndex;
        return this.getSlide();
    }

    public Slide previous() {
        --this.currentIndex;
        return this.getSlide();
    }

    public class Slide {
        private final String title;
        private String text;
        private Image image;

        public Slide(String title, String textFilename) {
            this.title = title;
            try {
                InputStream in = this.getClass().getResourceAsStream(textFilename);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                this.text = "";
                String line = br.readLine();
                while (line != null) {
                    this.text = String.valueOf(this.text) + line + "\n";
                    line = br.readLine();
                }
                br.close();
            }
            catch (IOException e) {
                Debug.write(this, "Cannot read slide text!");
                e.printStackTrace();
            }
            this.image = null;
        }

        public Slide(String title, String textFilename, String imageFilename) {
            this(title, textFilename);
            this.image = ImageUtilities.loadSprite(imageFilename);
        }

        public String getTitle() {
            return this.title;
        }

        public String getText() {
            return this.text;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

