/*
 * Decompiled with CFR 0.152.
 */
package hectare.view;

import hectare.view.utilities.DrawUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public abstract class Widget
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final float ALPHA = 0.75f;
    private Image backbuffer;
    private Graphics2D canvas;

    public Widget(int width, int height) {
        Dimension size = new Dimension(width, height);
        this.setSize(size);
        this.setPreferredSize(size);
        this.backbuffer = new BufferedImage(width, height, 2);
        this.canvas = (Graphics2D)this.backbuffer.getGraphics();
        this.canvas.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        DrawUtilities.selectDefaultFont(this.canvas);
    }

    @Override
    public Graphics getGraphics() {
        return this.canvas;
    }

    @Override
    public void repaint() {
        if (this.isEnabled()) {
            super.repaint();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.isEnabled() && this.needsRedraw()) {
            this.draw(this.canvas);
        }
        g.drawImage(this.backbuffer, 0, 0, this);
    }

    protected abstract void draw(Graphics2D var1);

    protected boolean needsRedraw() {
        return true;
    }

    protected void clearAll() {
        Composite oldcomposite = this.canvas.getComposite();
        AlphaComposite clear = AlphaComposite.Clear;
        this.canvas.setComposite(clear);
        this.canvas.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.canvas.setComposite(oldcomposite);
    }
}

