/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.entitydrawers;

import hectare.model.Coordinates;
import hectare.model.FieldEntity;
import hectare.view.CoordinateConverter;
import hectare.view.EntityDrawer;
import hectare.view.ScreenPoint;
import hectare.view.entitydrawers.WaterDrawer;
import hectare.view.utilities.ImageUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public class FieldDrawer
extends EntityDrawer {
    private static final String FIELD_SPRITE_NAME = "field_bg.png";
    private static final String GOOD_CROP_SPRITE_NAME = "crop_good.png";
    private static final String BAD_CROP_SPRITE_NAME = "crop_bad.png";
    private static final ScreenPoint[] FIELD_POSITIONS = new ScreenPoint[]{new ScreenPoint(0.0, 0.0), new ScreenPoint(0.3, 0.0), new ScreenPoint(0.0, 0.3), new ScreenPoint(-0.3, 0.0), new ScreenPoint(0.0, -0.3), new ScreenPoint(0.15, 0.15), new ScreenPoint(0.15, -0.15), new ScreenPoint(-0.15, 0.15), new ScreenPoint(-0.15, -0.15)};
    private static final float SCALE_FACTOR = 0.8f;
    private static final float CROP_WIDTH_FACTOR = 0.16666667f;
    private static final float CROP_HEIGHT_FACTOR = 0.5f;
    private static Image FIELD_IMAGE;
    private static Image GOOD_CROP_IMAGE;
    private static Image DRY_CROP_IMAGE;
    private static Image[] FIRE_IMAGES;
    private static boolean imagesReady;
    private final FieldEntity field;

    static {
        imagesReady = false;
    }

    public FieldDrawer(FieldEntity f) {
        this.field = f;
    }

    private void buildImages(CoordinateConverter converter) {
        FIELD_IMAGE = ImageUtilities.loadSpriteWithoutCache(FIELD_SPRITE_NAME);
        FIELD_IMAGE = FIELD_IMAGE.getScaledInstance((int)(converter.getTileWidth() * 0.8f), (int)(converter.getTileHeight() * 0.8f), 4);
        GOOD_CROP_IMAGE = ImageUtilities.loadSpriteWithoutCache(GOOD_CROP_SPRITE_NAME);
        GOOD_CROP_IMAGE = GOOD_CROP_IMAGE.getScaledInstance((int)(converter.getTileWidth() * 0.8f * 0.16666667f), (int)(converter.getTileHeight() * 0.8f * 0.5f), 4);
        DRY_CROP_IMAGE = ImageUtilities.loadSpriteWithoutCache(BAD_CROP_SPRITE_NAME);
        DRY_CROP_IMAGE = DRY_CROP_IMAGE.getScaledInstance((int)(converter.getTileWidth() * 0.8f * 0.16666667f), (int)(converter.getTileHeight() * 0.8f * 0.5f), 4);
        FIRE_IMAGES = new Image[3];
        FieldDrawer.FIRE_IMAGES[0] = ImageUtilities.loadSprite("fire_0.png");
        FieldDrawer.FIRE_IMAGES[1] = ImageUtilities.loadSprite("fire_1.png");
        FieldDrawer.FIRE_IMAGES[2] = ImageUtilities.loadSprite("fire_2.png");
        FieldDrawer.FIRE_IMAGES[0] = ImageUtilities.scaleToWidth(FIRE_IMAGES[0], (int)converter.getTileWidth() / 2);
        FieldDrawer.FIRE_IMAGES[1] = ImageUtilities.scaleToWidth(FIRE_IMAGES[1], (int)converter.getTileWidth() / 2);
        FieldDrawer.FIRE_IMAGES[2] = ImageUtilities.scaleToWidth(FIRE_IMAGES[2], (int)converter.getTileWidth() / 2);
    }

    @Override
    public void draw(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        if (!imagesReady) {
            this.buildImages(converter);
            imagesReady = true;
        }
        ScreenPoint center = converter.tileCenter(coords);
        if (this.field.isFlooded()) {
            g.setColor(WaterDrawer.WATER_COLOR);
            g.fill(converter.mapRectToScreen(coords.getX(), coords.getY(), 1, 1));
        }
        g.drawImage(FIELD_IMAGE, (int)(center.x - converter.getTileWidth() * 0.8f / 2.0f), (int)(center.y - converter.getTileHeight() * 0.8f / 2.0f), null);
        double productivity = this.field.getProductivity() * (double)FIELD_POSITIONS.length;
        Image cropImage = GOOD_CROP_IMAGE;
        if (this.field.isOnFire()) {
            cropImage = DRY_CROP_IMAGE;
        }
        int i = 0;
        while ((double)i < productivity) {
            if (i < FIELD_POSITIONS.length) {
                ScreenPoint pos = FIELD_POSITIONS[i];
                float dx = pos.x * converter.getTileWidth();
                float dy = pos.y * converter.getTileHeight();
                g.drawImage(cropImage, (int)(center.x + dx - (float)(cropImage.getWidth(null) / 2)), (int)(center.y + dy - (float)cropImage.getHeight(null)), null);
            }
            ++i;
        }
        if (this.field.isOnFire()) {
            int imgIndex = (int)(Math.random() * 3.0);
            Image img = FIRE_IMAGES[imgIndex];
            int x = (int)(center.x - (float)(img.getWidth(null) / 2));
            int y = (int)(center.y - (float)img.getHeight(null));
            g.drawImage(img, x, y, null);
        }
    }

    @Override
    public void drawMini(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        Shape tileShape = converter.mapRectToScreen(coords.getX(), coords.getY(), 1, 1);
        Color color = new Color(Color.HSBtoRGB((float)(this.field.getProductivity() / 3.0), 1.0f, 1.0f));
        g.setColor(color);
        g.fill(tileShape);
    }

    @Override
    public void drawQueryInfo(Graphics2D g, Rectangle region) {
        int x = region.x;
        int y = region.y + 15;
        g.setColor(Color.black);
        g.drawString("Field", x, y);
        if (this.field.isOnFire()) {
            g.drawString("The field is on fire.", x, y += 15);
        }
        if (this.field.isFlooded()) {
            g.drawString("The field is flooded.", x, y += 15);
        }
    }

    @Override
    public Dimension getQuerySize() {
        if (this.field.isOnFire() && this.field.isFlooded()) {
            return new Dimension(200, 60);
        }
        if (this.field.isFlooded() || this.field.isOnFire()) {
            return new Dimension(200, 45);
        }
        return new Dimension(200, 30);
    }
}

