/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.entitydrawers;

import hectare.model.Coordinates;
import hectare.model.TownEntity;
import hectare.view.CoordinateConverter;
import hectare.view.EntityDrawer;
import hectare.view.ScreenPoint;
import hectare.view.utilities.ImageUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class TownDrawer
extends EntityDrawer {
    private static final float LEFT_HOUSE = 1.0f;
    private static final float RIGHT_HOUSE = 0.0f;
    private static final int SPRITE = 0;
    private static final int MIN_PROSPERITY = 1;
    private static final int MAX_PROSPERITY = 2;
    private static final int SCALE_FACTOR = 3;
    private static final int H_LOCATION = 4;
    private static final int V_LOCATION = 5;
    private static final String HOUSE_LEFT_SPRITE_NAME = "house_left.png";
    private static final String HOUSE_RIGHT_SPRITE_NAME = "house_right.png";
    private static final float V_SCALE_FACTOR = 0.5f;
    private static final float H_SCALE_FACTOR = 0.3f;
    private static final float[][] HOUSE_LAYOUT = new float[][]{{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.5f, 1.0f, 1.2f, 0.25f, 0.25f}, {0.0f, 0.75f, 1.0f, 1.2f, -0.25f, 0.25f}};
    private static Image HOUSE_LEFT_IMAGE;
    private static Image HOUSE_RIGHT_IMAGE;
    private static Image TOWN_INACTIVE_IMAGE;
    private static boolean imagesReady;
    private final TownEntity town;

    static {
        imagesReady = false;
    }

    public TownDrawer(TownEntity t) {
        this.town = t;
    }

    private void drawInactiveTown(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        ScreenPoint center = converter.tileCenter(coords);
        ImageUtilities.ensureSizeIsLoaded(TOWN_INACTIVE_IMAGE);
        int w = TOWN_INACTIVE_IMAGE.getWidth(null);
        int h = TOWN_INACTIVE_IMAGE.getHeight(null);
        int x = (int)(center.x - (float)(w / 5));
        int y = (int)(center.y - (float)h);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(TOWN_INACTIVE_IMAGE, x, y, null);
    }

    private void buildImages(float tileWidth, float tileHeight) {
        HOUSE_LEFT_IMAGE = ImageUtilities.loadSpriteWithoutCache(HOUSE_LEFT_SPRITE_NAME);
        HOUSE_LEFT_IMAGE = HOUSE_LEFT_IMAGE.getScaledInstance((int)(tileWidth * 0.3f), (int)(tileHeight * 0.5f), 4);
        HOUSE_RIGHT_IMAGE = ImageUtilities.loadSpriteWithoutCache(HOUSE_RIGHT_SPRITE_NAME);
        HOUSE_RIGHT_IMAGE = HOUSE_RIGHT_IMAGE.getScaledInstance((int)(tileWidth * 0.3f), (int)(tileHeight * 0.5f), 4);
        TOWN_INACTIVE_IMAGE = ImageUtilities.loadSpriteWithoutCache("entity_town_inactive.png");
        ImageUtilities.ensureSizeIsLoaded(TOWN_INACTIVE_IMAGE);
        TOWN_INACTIVE_IMAGE = ImageUtilities.scaleToWidth(TOWN_INACTIVE_IMAGE, (int)(tileWidth / 3.0f));
    }

    @Override
    public void draw(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        if (!imagesReady) {
            this.buildImages(converter.getTileWidth(), converter.getTileHeight());
            imagesReady = true;
        }
        if (!this.town.isActive()) {
            this.drawInactiveTown(g, coords, converter);
            return;
        }
        double prosperity = this.town.getProsperity();
        ScreenPoint center = converter.tileCenter(coords);
        int i = 0;
        while (i < HOUSE_LAYOUT.length) {
            float[] house = HOUSE_LAYOUT[i];
            if (!(prosperity < (double)house[1]) && !(prosperity > (double)house[2])) {
                Image img = house[0] == 1.0f ? HOUSE_LEFT_IMAGE : HOUSE_RIGHT_IMAGE;
                int width = (int)((float)img.getWidth(null) * house[3]);
                int height = (int)((float)img.getHeight(null) * house[3]);
                int x = (int)(center.x + house[4] * converter.getTileWidth() - (float)(width / 2));
                int y = (int)(center.y + house[5] * converter.getTileHeight() - (float)height);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(img, x, y, width, height, null);
            }
            ++i;
        }
    }

    @Override
    public void drawMini(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        if (!this.town.isActive()) {
            return;
        }
        Shape tileShape = converter.mapRectToScreen(coords.getX(), coords.getY(), 1, 1);
        Color color = new Color(Color.HSBtoRGB((float)(this.town.getProsperity() / 3.0), 1.0f, 1.0f));
        g.setColor(color);
        g.fill(tileShape);
    }

    @Override
    public void drawQueryInfo(Graphics2D g, Rectangle region) {
        if (this.town.isActive()) {
            int x = region.x;
            int y = region.y + 15;
            g.setColor(Color.black);
            g.drawString("Town", x, y);
            g.drawString("Population: " + this.town.getPopulation(), x, y += 15);
            y += 15;
        } else if (this.town.isUnlocked()) {
            int x = region.x;
            int y = region.y + 15;
            g.setColor(Color.black);
            g.drawString("There used to be a town here,", x, y);
            g.drawString("and it will come back soon.", x, y + 15);
        } else {
            int x = region.x;
            int y = region.y + 15;
            g.setColor(Color.black);
            g.drawString("Future location of a town.", x, y);
        }
    }

    @Override
    public Dimension getQuerySize() {
        if (this.town.isUnlocked()) {
            return new Dimension(200, 45);
        }
        return new Dimension(200, 30);
    }

    @Override
    public boolean drawUnderlyingTileInfo() {
        return true;
    }
}

