/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.entitydrawers;

import hectare.model.Coordinates;
import hectare.model.Entity;
import hectare.model.WaterEntity;
import hectare.view.CoordinateConverter;
import hectare.view.EntityDrawer;
import hectare.view.ScreenPoint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class WaterDrawer
extends EntityDrawer {
    public static final Color WATER_COLOR = new Color(0, 48, 224);

    @Override
    public void drawUnderGrid(Graphics2D g, Coordinates coords, CoordinateConverter converter, Entity top, Entity right, Entity bottom, Entity left) {
        int x = coords.getX();
        int y = coords.getY();
        boolean roundTopCorner = !(left instanceof WaterEntity) && !(top instanceof WaterEntity);
        boolean roundLeftCorner = !(left instanceof WaterEntity) && !(bottom instanceof WaterEntity);
        boolean roundRightCorner = !(right instanceof WaterEntity) && !(top instanceof WaterEntity);
        boolean roundBottomCorner = !(right instanceof WaterEntity) && !(bottom instanceof WaterEntity);
        ScreenPoint topCorner = converter.tileTopCorner(x, y);
        ScreenPoint leftCorner = converter.tileLeftCorner(x, y);
        ScreenPoint rightCorner = converter.tileRightCorner(x, y);
        ScreenPoint bottomCorner = converter.tileBottomCorner(x, y);
        ScreenPoint topRightEdgeMidpoint = ScreenPoint.midpoint(topCorner, rightCorner);
        ScreenPoint topLeftEdgeMidpoint = ScreenPoint.midpoint(topCorner, leftCorner);
        ScreenPoint bottomRightEdgeMidpoint = ScreenPoint.midpoint(bottomCorner, rightCorner);
        ScreenPoint bottomLeftEdgeMidpoint = ScreenPoint.midpoint(bottomCorner, leftCorner);
        GeneralPath shape = new GeneralPath();
        shape.moveTo(topRightEdgeMidpoint.x, topRightEdgeMidpoint.y);
        if (roundRightCorner) {
            shape.quadTo(rightCorner.x, rightCorner.y, bottomRightEdgeMidpoint.x, bottomRightEdgeMidpoint.y);
        } else {
            shape.lineTo(rightCorner.x, rightCorner.y);
            shape.lineTo(bottomRightEdgeMidpoint.x, bottomRightEdgeMidpoint.y);
        }
        if (roundBottomCorner) {
            shape.quadTo(bottomCorner.x, bottomCorner.y, bottomLeftEdgeMidpoint.x, bottomLeftEdgeMidpoint.y);
        } else {
            shape.lineTo(bottomCorner.x, bottomCorner.y);
            shape.lineTo(bottomLeftEdgeMidpoint.x, bottomLeftEdgeMidpoint.y);
        }
        if (roundLeftCorner) {
            shape.quadTo(leftCorner.x, leftCorner.y, topLeftEdgeMidpoint.x, topLeftEdgeMidpoint.y);
        } else {
            shape.lineTo(leftCorner.x, leftCorner.y);
            shape.lineTo(topLeftEdgeMidpoint.x, topLeftEdgeMidpoint.y);
        }
        if (roundTopCorner) {
            shape.quadTo(topCorner.x, topCorner.y, topRightEdgeMidpoint.x, topRightEdgeMidpoint.y);
        } else {
            shape.lineTo(topCorner.x, topCorner.y);
            shape.lineTo(topRightEdgeMidpoint.x, topRightEdgeMidpoint.y);
        }
        shape.closePath();
        g.setColor(WATER_COLOR);
        g.fill(shape);
    }

    @Override
    public void drawMini(Graphics2D g, Coordinates coords, CoordinateConverter converter) {
        Shape tileShape = converter.mapRectToScreen(coords.getX(), coords.getY(), 1, 1);
        g.setColor(WATER_COLOR);
        g.fill(tileShape);
    }

    @Override
    public void drawQueryInfo(Graphics2D g, Rectangle region) {
        int x = region.x;
        int y = region.y + 15;
        g.setColor(Color.black);
        g.drawString("Water", x, y);
    }

    @Override
    public Dimension getQuerySize() {
        return new Dimension(200, 30);
    }
}

