/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.overlays;

import hectare.model.Coordinates;
import hectare.model.Tile;
import hectare.model.Vector;
import hectare.view.CoordinateConverter;
import hectare.view.Overlay;
import hectare.view.ScreenPoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;

public class WindOverlay
implements Overlay {
    private static final float SCALE = 10.0f;
    private static final double ARROW_ANGLE_SIZE = 0.75;
    private static final double ARROW_SIZE = 6.0;
    private String myName = "Wind";

    private double polarToY(double len, double dir) {
        return (int)(len * Math.cos(dir));
    }

    private double polarToX(double len, double dir) {
        return (int)(len * Math.sin(dir));
    }

    public void drawArrow(Graphics2D g2d, double x1, double y1, double x2, double y2) {
        double aDir = Math.atan2(x1 - x2, y1 - y2);
        g2d.drawLine((int)x2, (int)y2, (int)x1, (int)y1);
        Polygon p = new Polygon();
        p.addPoint((int)x2, (int)y2);
        p.addPoint((int)(x2 + this.polarToX(6.0, aDir + 0.75)), (int)(y2 + this.polarToY(6.0, aDir + 0.75)));
        p.addPoint((int)(x2 + this.polarToX(6.0, aDir - 0.75)), (int)(y2 + this.polarToY(6.0, aDir - 0.75)));
        g2d.fill(p);
    }

    @Override
    public void draw(Graphics2D g, Coordinates c, Tile t, CoordinateConverter converter) {
        Vector wind = t.getWind();
        Vector v = converter.getScreenVector(wind);
        ScreenPoint tileCenter = converter.tileCenter(c);
        g.setColor(Color.white);
        Object AA = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawArrow(g, tileCenter.x, tileCenter.y, (double)tileCenter.x + v.getX() * 10.0, (double)tileCenter.y + v.getY() * 10.0);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, AA);
    }

    @Override
    public int getDrawOrder() {
        return 2;
    }

    @Override
    public String currentName() {
        return this.myName;
    }
}

