/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.utilities;

import hectare.Debug;
import hectare.Hectare;
import hectare.SoundSystem;
import hectare.view.Layer;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class DialogUtilities {
    private static final String HECTARE_EXTENSION = "hex";
    private static final String HECTARE_FILE_DESCRIPTION = "Hectare Saved Game";

    public static void promptForExit(Component c) {
        Layer l = Hectare.pauseEverything();
        int choice = JOptionPane.showConfirmDialog(c, "Are you sure you want to quit Hectare?", "Quit", 0, -1);
        if (choice == 0) {
            Debug.write(DialogUtilities.class, "User quit game");
            SoundSystem.getInstance().stopMusic();
            System.exit(0);
        }
        Hectare.removeLayer(l);
    }

    public static void promptForEndGame(Component c) {
        int choice = JOptionPane.showConfirmDialog(c, "Are you sure you want to end this game? Any unsaved progress will be lost.", "Quit", 0, -1);
        if (choice == 0) {
            Debug.write(DialogUtilities.class, "User went back to main menu");
            Hectare.backToMainMenu();
        }
    }

    public static void promptForSaveGame(Component c) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter(HECTARE_FILE_DESCRIPTION, HECTARE_EXTENSION));
        int choice = chooser.showSaveDialog(c);
        if (choice == 0) {
            File toSave = chooser.getSelectedFile();
            if (!toSave.getAbsolutePath().endsWith(".hex")) {
                toSave = new File(String.valueOf(toSave.getAbsolutePath()) + "." + HECTARE_EXTENSION);
            }
            Debug.write(DialogUtilities.class, "User saving to " + toSave.getAbsolutePath());
            Hectare.save(toSave);
        }
    }

    public static void promptForLoadGame(Component c) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter(HECTARE_FILE_DESCRIPTION, HECTARE_EXTENSION));
        int choice = chooser.showOpenDialog(c);
        if (choice == 0) {
            File toLoad = chooser.getSelectedFile();
            Debug.write(DialogUtilities.class, "User loading " + toLoad.getAbsolutePath());
            Hectare.load(toLoad);
        }
    }

    public static void showNativeNotification(Component c, String title, String message) {
        JOptionPane.showMessageDialog(c, message, title, -1);
    }
}

