/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.utilities;

import hectare.Debug;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public abstract class ImageUtilities {
    private static final long WAIT_TIME = 5L;
    private static final String SPRITE_PATH = "/sprites/";
    private static final Hashtable<String, Image> IMAGE_CACHE = new Hashtable();

    public static Image createImage(int w, int h) {
        return new BufferedImage(w, h, 2);
    }

    public static Image loadImageWithoutCache(String imageFile) {
        try {
            Debug.write(ImageUtilities.class, "Loading image: " + imageFile);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            URL imageURL = ImageUtilities.class.getResource(imageFile);
            if (imageURL == null) {
                throw new IOException("Image not found: " + imageFile);
            }
            return toolkit.getImage(imageURL);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImage(String imageFile) {
        Image i;
        Hashtable<String, Image> hashtable = IMAGE_CACHE;
        synchronized (hashtable) {
            i = IMAGE_CACHE.get(imageFile);
        }
        if (i != null) {
            return i;
        }
        i = ImageUtilities.loadImageWithoutCache(imageFile);
        hashtable = IMAGE_CACHE;
        synchronized (hashtable) {
            IMAGE_CACHE.put(imageFile, i);
            Debug.write(ImageUtilities.class, "Caching image: " + imageFile);
        }
        return i;
    }

    public static Image loadSpriteWithoutCache(String spriteName) {
        return ImageUtilities.loadImageWithoutCache(SPRITE_PATH + spriteName);
    }

    public static Image loadSprite(String spriteName) {
        return ImageUtilities.loadImage(SPRITE_PATH + spriteName);
    }

    public static void ensureSizeIsLoaded(Image img) {
        try {
            while (img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
                Debug.write(ImageUtilities.class, "Waiting for image width and height: " + img);
                Thread.sleep(5L);
            }
        }
        catch (InterruptedException e) {
            Debug.write(ImageUtilities.class, "Exception while waiting for image size: " + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void ensureCompleteDraw(Graphics g, Image img, int x, int y, int w, int h) {
        BlockingDrawer drawer = new BlockingDrawer(img);
        try {
            drawer.waitForDraw(g, x, y, w, h);
        }
        catch (InterruptedException e) {
            Debug.write(ImageUtilities.class, "Exception while drawing image: " + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void ensureCompleteDraw(Graphics g, Image img, int x, int y) {
        ImageUtilities.ensureSizeIsLoaded(img);
        ImageUtilities.ensureCompleteDraw(g, img, x, y, img.getWidth(null), img.getHeight(null));
    }

    public static Image scaleToWidth(Image img, int w) {
        ImageUtilities.ensureSizeIsLoaded(img);
        int h = (int)((float)w / (float)img.getWidth(null) * (float)img.getHeight(null));
        return img.getScaledInstance(w, h, 4);
    }

    public static Image scaleToHeight(Image img, int h) {
        ImageUtilities.ensureSizeIsLoaded(img);
        int w = (int)((float)h / (float)img.getHeight(null) * (float)img.getWidth(null));
        return img.getScaledInstance(w, h, 4);
    }

    private static class BlockingDrawer
    implements ImageObserver {
        private boolean loaded = false;
        private final Image img;

        public BlockingDrawer(Image imageToDraw) {
            this.img = imageToDraw;
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            Debug.write(this, "Got info: 0x" + Integer.toHexString(infoflags) + " for image " + img);
            if ((infoflags & 0x20) != 0) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.loaded = true;
                return false;
            }
            return true;
        }

        public void waitForDraw(Graphics g, int x, int y, int w, int h) throws InterruptedException {
            boolean stillLoading = g.drawImage(this.img, x, y, w, h, this);
            if (!stillLoading) {
                Debug.write(this, "Waiting for image to draw: " + this.img);
                while (!this.loaded) {
                    Thread.sleep(5L);
                }
                g.drawImage(this.img, x, y, w, h, this);
            }
        }
    }
}

