/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.view.Widget;
import hectare.view.utilities.DrawUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractMenuWidget<T>
extends Widget {
    private static final long serialVersionUID = 1L;
    private static final Color BUTTON_BG_COLOR = Color.gray;
    private static final Color BUTTON_STROKE_COLOR = Color.white;
    private static final Color BUTTON_TEXT_COLOR = Color.black;
    private static final Color BUTTON_MOUSE_OVER_BG_COLOR = Color.white;
    private static final Color BUTTON_MOUSE_OVER_STROKE_COLOR = Color.black;
    private static final Color BUTTON_MOUSE_OVER_TEXT_COLOR = Color.black;
    private static final Cursor POINTER_CURSOR = new Cursor(12);
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);
    private Shape buttonHovered = null;
    private final Map<Shape, T> buttons = Collections.synchronizedMap(new HashMap());
    private final Point mouse = new Point(-1, -1);
    private int nextButtonY = 0;
    private boolean needsRedraw = true;

    public AbstractMenuWidget(int width, int height) {
        super(width, height);
        MenuWidgetMouseListener l = new MenuWidgetMouseListener();
        this.addMouseListener(l);
        this.addMouseMotionListener(l);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.mouse.y = -1;
            this.mouse.x = -1;
        }
    }

    public Point getMouse() {
        return this.mouse;
    }

    public Map<Shape, T> getButtons() {
        return this.buttons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<Shape, T> getButtonAtPosition(Point pos) {
        Map<Shape, T> buttons;
        Map<Shape, T> map = buttons = this.getButtons();
        synchronized (map) {
            for (Map.Entry<Shape, T> entry : buttons.entrySet()) {
                Shape s = entry.getKey();
                if (!s.contains(this.getMouse())) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addButton(T element, Shape button) {
        Map<Shape, T> map = this.buttons;
        synchronized (map) {
            this.buttons.put(button, element);
        }
    }

    protected final void removeButton(Shape button) {
        this.buttons.remove(button);
    }

    protected Shape newCenteredButton(T name, int width, int height, int padding, int addHeight) {
        RectangularShape button = this.makeButtonShape(width, height);
        button = DrawUtilities.center(button, new Rectangle(0, this.nextButtonY + addHeight, this.getWidth(), height));
        this.nextButtonY += addHeight + height + padding;
        this.addButton(name, button);
        return button;
    }

    protected Shape newLeftButton(T name, int width, int height, int padding, int addHeight) {
        RectangularShape button = this.makeButtonShape(width, height);
        button = DrawUtilities.center(button, new Rectangle(0, this.nextButtonY + addHeight, this.getWidth(), height));
        this.nextButtonY += addHeight + height + padding;
        this.addButton(name, button);
        return button;
    }

    protected RectangularShape makeButtonShape(int width, int height) {
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, width / 4, width / 4);
        return rect;
    }

    protected Cursor getPointerCursor() {
        return POINTER_CURSOR;
    }

    protected Cursor getDefaultCursor() {
        return DEFAULT_CURSOR;
    }

    protected void updateHoverStatus() {
        Iterator<Map.Entry<Shape, T>> buttonIterator = this.buttons.entrySet().iterator();
        Shape newButtonHovered = null;
        while (buttonIterator.hasNext()) {
            Map.Entry<Shape, T> entry = buttonIterator.next();
            Shape s = entry.getKey();
            if (!s.contains(this.mouse)) continue;
            newButtonHovered = s;
        }
        if (newButtonHovered != this.buttonHovered) {
            this.buttonHovered = newButtonHovered;
            this.needsRedraw = true;
        }
        this.updateCursor();
    }

    private void updateCursor() {
        Cursor cursor = this.getDefaultCursor();
        if (this.buttonHovered != null) {
            cursor = this.getPointerCursor();
        }
        if (!this.getCursor().equals(cursor)) {
            this.setCursor(cursor);
        }
    }

    @Override
    public boolean needsRedraw() {
        this.updateHoverStatus();
        return this.needsRedraw;
    }

    protected void setNeedsRedraw() {
        this.needsRedraw = true;
    }

    @Override
    protected void draw(Graphics2D g) {
        this.drawBackground(g);
        DrawUtilities.selectDefaultFont(g);
        for (Map.Entry<Shape, T> entry : this.buttons.entrySet()) {
            Shape s = entry.getKey();
            T object = entry.getValue();
            if (s == this.buttonHovered) {
                this.drawMouseOverButton(g, object, s);
                continue;
            }
            this.drawButton(g, object, s);
        }
        this.needsRedraw = false;
    }

    protected void drawBackground(Graphics2D g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void drawButtonWithColor(Graphics2D g, T object, Shape s, Color bgColor, Color strokeColor, Color textColor) {
        Object oldAA = DrawUtilities.enableAA(g);
        g.setColor(bgColor);
        g.fill(s);
        g.setColor(strokeColor);
        g.draw(s);
        g.setColor(textColor);
        DrawUtilities.drawCenteredString(g, object.toString(), s.getBounds());
        DrawUtilities.restoreAA(g, oldAA);
    }

    protected void drawButton(Graphics2D g, T object, Shape s) {
        this.drawButtonWithColor(g, object, s, BUTTON_BG_COLOR, BUTTON_STROKE_COLOR, BUTTON_TEXT_COLOR);
    }

    protected void drawMouseOverButton(Graphics2D g, T object, Shape s) {
        this.drawButtonWithColor(g, object, s, BUTTON_MOUSE_OVER_BG_COLOR, BUTTON_MOUSE_OVER_STROKE_COLOR, BUTTON_MOUSE_OVER_TEXT_COLOR);
    }

    protected abstract void buttonWasClicked(T var1, Shape var2);

    private final class MenuWidgetMouseListener
    implements MouseListener,
    MouseMotionListener {
        private MenuWidgetMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!AbstractMenuWidget.this.isEnabled()) {
                return;
            }
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.x = e.getX();
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.y = e.getY();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!AbstractMenuWidget.this.isEnabled()) {
                return;
            }
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.y = -1;
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.x = -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!AbstractMenuWidget.this.isEnabled()) {
                return;
            }
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.x = e.getX();
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.y = e.getY();
            e.consume();
            Map.Entry button = AbstractMenuWidget.this.getButtonAtPosition(AbstractMenuWidget.this.mouse);
            if (button != null) {
                AbstractMenuWidget.this.buttonWasClicked(button.getValue(), button.getKey());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!AbstractMenuWidget.this.isEnabled()) {
                return;
            }
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.x = e.getX();
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.y = e.getY();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!AbstractMenuWidget.this.isEnabled()) {
                return;
            }
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.x = e.getX();
            ((AbstractMenuWidget)AbstractMenuWidget.this).mouse.y = e.getY();
        }
    }
}

