/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.Debug;
import hectare.Hectare;
import hectare.SoundSystem;
import hectare.view.SlideShow;
import hectare.view.utilities.DrawUtilities;
import hectare.view.utilities.ImageUtilities;
import hectare.view.widgets.AbstractMenuWidget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class SlideShower
extends AbstractMenuWidget<String> {
    private static final long serialVersionUID = 1L;
    private static final String CLOSE_TEXT = "Close";
    private static final String PREVIOUS_TEXT = "<- Previous";
    private static final String NEXT_TEXT = "Next ->";
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 50;
    private static final double HEADER_PORTION = 0.2;
    private static final double CONTENT_PORTION = 0.7;
    private static final double BUTTONS_PORTION = 0.1;
    private static final double TEXT_PORTION = 0.5;
    private static final double IMAGE_PORTION = 0.5;
    private static final double CONTENT_WIDTH_FACTOR = 0.8;
    private static final float HEADER_FONT_SIZE = 72.0f;
    private SlideShow show;
    private Rectangle headerRect;
    private Rectangle contentRect;
    private Rectangle buttonsRect;
    private Rectangle imageRect;
    private Rectangle textRect;
    private Point2D imageUpperLeft;
    private Shape closeButton;
    private Shape previousButton;
    private Shape nextButton;

    public SlideShower(int width, int height, SlideShow toPlay) {
        super(width, height);
        this.show = toPlay;
        this.headerRect = new Rectangle(0, 0, width, (int)(0.2 * (double)height));
        this.contentRect = new Rectangle((int)((double)width * 0.19999999999999996 / 2.0), (int)(0.2 * (double)height), (int)((double)width * 0.8), (int)(0.7 * (double)height));
        this.buttonsRect = new Rectangle(0, (int)(0.8999999999999999 * (double)height), width, (int)(0.1 * (double)height));
        this.closeButton = DrawUtilities.center(this.makeButtonShape(150, 50), this.buttonsRect);
        this.addButton(CLOSE_TEXT, this.closeButton);
        this.previousButton = DrawUtilities.center(this.makeButtonShape(150, 50), new Rectangle(this.buttonsRect.x, this.buttonsRect.y, this.buttonsRect.width / 2, this.buttonsRect.height));
        this.nextButton = DrawUtilities.center(this.makeButtonShape(150, 50), new Rectangle(this.buttonsRect.x + this.buttonsRect.width / 2, this.buttonsRect.y, this.buttonsRect.width / 2, this.buttonsRect.height));
        this.updateSlide();
    }

    protected void updateSlide() {
        SlideShow.Slide slide = this.show.getSlide();
        if (slide.getImage() != null) {
            Debug.write(this, "Displaying image slide: " + slide.getTitle());
            ImageUtilities.ensureSizeIsLoaded(slide.getImage());
            this.imageRect = new Rectangle(this.contentRect.x, this.contentRect.y, (int)((double)this.contentRect.width * 0.5), this.contentRect.height);
            this.textRect = new Rectangle((int)((double)this.contentRect.x + (double)this.contentRect.width * 0.5), this.contentRect.y, (int)((double)this.contentRect.width * 0.5), this.contentRect.height);
            int imageWidth = slide.getImage().getWidth(this);
            int imageHeight = slide.getImage().getHeight(this);
            Rectangle imageArea = DrawUtilities.getCenteredRect(imageWidth, imageHeight, this.imageRect);
            this.imageUpperLeft = new Point2D.Double(imageArea.x, imageArea.y);
        } else {
            Debug.write(this, "Displaying text slide: " + slide.getTitle());
            this.textRect = this.contentRect;
            this.imageRect = null;
            this.imageUpperLeft = null;
        }
        if (this.show.isBeginning()) {
            this.removeButton(this.previousButton);
        } else {
            this.addButton(PREVIOUS_TEXT, this.previousButton);
        }
        if (this.show.isEnd()) {
            this.removeButton(this.nextButton);
        } else {
            this.addButton(NEXT_TEXT, this.nextButton);
        }
    }

    @Override
    protected void drawBackground(Graphics2D g) {
        super.drawBackground(g);
        SlideShow.Slide slide = this.show.getSlide();
        if (slide.getImage() != null) {
            ImageUtilities.ensureCompleteDraw(g, slide.getImage(), (int)this.imageUpperLeft.getX(), (int)this.imageUpperLeft.getY());
        }
        g.setColor(Color.white);
        DrawUtilities.selectDefaultFont(g);
        DrawUtilities.drawCenteredText(g, slide.getText(), this.textRect);
        DrawUtilities.selectFontSize(g, 72.0f);
        DrawUtilities.drawCenteredText(g, slide.getTitle(), this.headerRect);
    }

    @Override
    protected void buttonWasClicked(String object, Shape s) {
        if (s == this.closeButton) {
            SoundSystem.getInstance().click();
            Hectare.popLayer();
        } else if (s == this.previousButton) {
            SoundSystem.getInstance().click();
            this.show.previous();
            this.updateSlide();
        } else if (s == this.nextButton) {
            SoundSystem.getInstance().click();
            this.show.next();
            this.updateSlide();
        }
        this.setNeedsRedraw();
    }
}

