/*
 * Decompiled with CFR 0.152.
 */
package hectare.view.widgets;

import hectare.Debug;
import hectare.SoundSystem;
import hectare.controller.Tool;
import hectare.model.GameState;
import hectare.view.Notification;
import hectare.view.NotificationHandler;
import hectare.view.ScreenPoint;
import hectare.view.utilities.DrawUtilities;
import hectare.view.utilities.ImageUtilities;
import hectare.view.widgets.AbstractMenuWidget;
import hectare.view.widgets.IsoView;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Map;

public class Toolbar
extends AbstractMenuWidget<Tool>
implements NotificationHandler {
    private static final long serialVersionUID = 1L;
    private static final int TOOL_PADDING = 10;
    private static final int TITLE_PAD = 10;
    private final int LEFT_PADDING;
    private final int TOOL_SIZE;
    private final int TOOL_SPRITE_PADDING;
    private final Image TOOL_BG_IMAGE_SELECTED;
    private final Image TOOL_BG_IMAGE_UNSELECTED;
    private final Image TOOL_BG_IMAGE_LOCKED;
    private final GameState state;
    private long lastUpdate;

    public Toolbar(int width, int height, int leftPadding, GameState s, IsoView v) {
        super(width, height);
        this.state = s;
        this.lastUpdate = this.state.getLastUpdateTime();
        this.LEFT_PADDING = leftPadding;
        this.TOOL_SIZE = height - 20;
        this.TOOL_SPRITE_PADDING = this.TOOL_SIZE / 5;
        int x = this.LEFT_PADDING + 10;
        for (Tool t : this.state.getTools()) {
            Rectangle shape = new Rectangle(x, 10, this.TOOL_SIZE, this.TOOL_SIZE);
            t.setPosition(new ScreenPoint(x + this.TOOL_SIZE / 2, 10.0f));
            x += this.TOOL_SIZE + 10;
            this.addButton(t, shape);
        }
        this.TOOL_BG_IMAGE_SELECTED = ImageUtilities.scaleToWidth(ImageUtilities.loadSprite("tool_bg_selected.png"), this.TOOL_SIZE);
        this.TOOL_BG_IMAGE_UNSELECTED = ImageUtilities.scaleToWidth(ImageUtilities.loadSprite("tool_bg_unselected.png"), this.TOOL_SIZE);
        this.TOOL_BG_IMAGE_LOCKED = ImageUtilities.scaleToWidth(ImageUtilities.loadSprite("tool_bg_locked.png"), this.TOOL_SIZE);
        this.setFocusable(true);
    }

    @Override
    protected void drawButton(Graphics2D g, Tool tool, Shape s) {
        Image toolImage = this.TOOL_BG_IMAGE_LOCKED;
        if (this.state.getCurrentTool() == tool && tool.isEnabled()) {
            toolImage = this.TOOL_BG_IMAGE_SELECTED;
        } else if (tool.isEnabled()) {
            toolImage = this.TOOL_BG_IMAGE_UNSELECTED;
        }
        ImageUtilities.ensureCompleteDraw(g, toolImage, s.getBounds().x, s.getBounds().y, this.TOOL_SIZE, this.TOOL_SIZE);
        Image icon = ImageUtilities.loadSprite(tool.getIcon());
        ImageUtilities.ensureSizeIsLoaded(icon);
        int height = this.TOOL_SIZE - this.TOOL_SPRITE_PADDING * 2;
        int width = (int)((float)icon.getWidth(null) * (float)height / (float)icon.getHeight(null));
        Rectangle bounds = DrawUtilities.getCenteredRect(width, height, s.getBounds());
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        ImageUtilities.ensureCompleteDraw(g, icon, bounds.x, bounds.y, width, height);
    }

    @Override
    public boolean needsRedraw() {
        long newUpdate = this.state.getLastUpdateTime();
        if (newUpdate > this.lastUpdate) {
            this.lastUpdate = newUpdate;
            this.setNeedsRedraw();
        }
        return super.needsRedraw();
    }

    @Override
    protected void drawMouseOverButton(Graphics2D g, Tool tool, Shape s) {
        this.drawButton(g, tool, s);
    }

    public void drawMouseOver(Graphics2D g, int xDisplacement, int yDisplacement) {
        Map.Entry button = this.getButtonAtPosition(this.getMouse());
        if (button == null) {
            return;
        }
        Shape s = button.getKey();
        Tool tool = (Tool)button.getValue();
        ScreenPoint buttonCenter = new ScreenPoint(s.getBounds().getCenterX() + (double)xDisplacement, s.getBounds().getY() + (double)yDisplacement);
        String title = tool.getDisplayName();
        String text = tool.getMouseOverText();
        Font font = g.getFont();
        Font largeFont = font.deriveFont((float)font.getSize() * 1.5f);
        g.setFont(largeFont);
        Rectangle2D titleBounds = DrawUtilities.getStringBounds(g, title);
        g.setFont(font);
        Rectangle2D textBounds = DrawUtilities.getStringBounds(g, text);
        Dimension drawSize = new Dimension((int)textBounds.getWidth(), (int)(textBounds.getHeight() + titleBounds.getHeight() + 10.0));
        Composite oldComposite = DrawUtilities.setOpacity(g, 0.75f);
        Rectangle r = DrawUtilities.drawBubble(g, drawSize, buttonCenter, Color.black, Color.white, 15, 30);
        g.setComposite(oldComposite);
        g.setColor(Color.white);
        g.setFont(largeFont);
        Rectangle titleRect = new Rectangle(r.x, r.y, r.width, (int)titleBounds.getHeight());
        DrawUtilities.drawCenteredString(g, title, titleRect);
        g.setFont(font);
        Rectangle textRect = new Rectangle(r.x, r.y + (int)titleBounds.getHeight() + 10, r.width, (int)textBounds.getHeight());
        DrawUtilities.drawCenteredString(g, text, textRect);
    }

    @Override
    protected void buttonWasClicked(Tool tool, Shape s) {
        if (tool.isEnabled()) {
            if (this.state.getCurrentTool() != tool) {
                SoundSystem.getInstance().click();
            }
            this.state.setTool(tool);
            this.setNeedsRedraw();
            Debug.write(this, "tool is set to " + tool);
        }
    }

    public void changeTool(int key) {
        Tool t = this.state.getTools().get(key);
        if (t.isEnabled() && !this.state.getCurrentTool().getDisplayName().equals(t.getDisplayName())) {
            SoundSystem.getInstance().click();
            this.state.setTool(t);
            this.setNeedsRedraw();
            Debug.write(this, "tool is set to " + t);
        }
    }

    @Override
    public void handleNotifications(Iterator<Notification> notifications) {
        while (notifications.hasNext()) {
            Notification n = notifications.next();
            n.setEnabled(true);
        }
    }
}

