# rather than the Linux script with #!...python,
# I've made this a .py file... that should work, right?
#
# pyro/bin/pyro is automatically generated!
# -----------------------------------
# Pyro - robotics control system in Python

# for the time being, I'm going to try to by-pass all of 
# this path stuff. This file is 
#
# F:\Zach\Pyro\pyro-2.0.2\pyro\bin\pyro

import os 
import sys 
# Where are we? Add ../../cwd to our PYTHON search path
# if sys.argv[0][0] == '/':
#     cwd = sys.argv[0]
# else:
#     cwd = os.getcwd() + '/' + sys.argv[0]
# (binpath,spare) = os.path.split(cwd) # peel off pyro filename
# (pyropath,spare) = os.path.split(binpath) # peel off bin dir
# (path,spare) = os.path.split(pyropath) # peel off pyro dir

# we set the path by hand to our best guess...
path = 'C:\\Zach\\Pyro\\pyro-2.0.2'
pyropath = 'C:\\Zach\\Pyro\\pyro-2.0.2\\pyro'
binpath = 'C:\\Zach\\Pyro\\pyro-2.0.2\\pyro\\bin'
sys.path.insert(0, path) # put PARENT at front of list PARENT/pyro/bin/pyro

# I wonder what Aria is -- a simulator?
# I see... it's the pioneer simulator
# sys.path.append("/usr/local/Aria/python") # add Aria
if not os.environ.has_key('PYRO'):
    os.environ['PYRO'] = pyropath
    os.putenv('PYRO', pyropath )

# somewhere lots of environment variables are being set,
# (or, rather, are being set in Linux, but not in Windows)
# I don't know exactly where right now, but I'm  going 
# to set them here...
if not os.environ.has_key('HOME'):
    os.environ['HOME'] = 'C:\\Zach'
    os.putenv('HOME', 'C:\\Zach' )

if not os.environ.has_key('HOSTNAME'):
    os.environ['HOSTNAME'] = 'deckard'
    os.putenv('PYRO', 'deckard' )

# I don't think this gets used under Windows...
# if os.environ.has_key('LD_LIBRARY_PATH'):
#     newlibpath = os.environ['LD_LIBRARY_PATH'] + (':' + pyropath + '/lib')
# else:
#     newlibpath = (pyropath + '/lib')
# os.environ['LD_LIBRARY_PATH'] = newlibpath
# os.putenv('LD_LIBRARY_PATH', newlibpath)

try:
    from pyro.system import share
    from pyro.engine import *
except ImportError:
    raise "something is wrong with the importing of share and engine"

robotfile = 0
services = 0
brainfile = 0
# window = 'GL'
window = 'TK'
pyroargs = []
simulator = 0
configfile = 0
worldfile = 0
evalcommand = ""

def basichelp():
    print "You may need to define the PYRO environment variable. Try:"
    print "         export PYRO=/usr/local/pyro"
    print "or maybe export PYRO=~/pyro"
    print ""
    print "Also, make sure PYRO is in PYTHONPATH. Try:"
    print "         export PYTHONPATH=$PYTHONPATH:$PYRO/bin"

try:
    import pyro
except:
    import sys
    basichelp()
    sys.exit(1)


def process_options():
    import getopt, sys, string
    global robotfile, brainfile, window, simulator, \
           pyroargs, configfile, evalcommand, worldfile, services
    try:
        opts, args = getopt.getopt(sys.argv[1:], \
                                   "r:b:hg:s:a:i:e:w:v:", \
                                   ["robot", "brain", "help", \
                                    "gui", "sim", "args",\
                                    "init", "eval", "world",
                                    "services"])
    except getopt.GetoptError:
        # print help information and exit:
        pyro.system.usage()
        sys.exit(1)

    for o, a in opts:
        if o in ("-h", "--help"):
            pyro.system.usage()
            sys.exit(1)
        elif o in ("-g", "--gui"):
            window = string.upper(a)
        elif o in ("-r", "--robot"):
            robotfile = a
        elif o in ("-s", "--sim"):
            simulator = a
        elif o in ("-b", "--brain"):
            brainfile = a
	elif o in ("-a", "--args"):
            pyroargs = a
	elif o in ("-i", "--init"):
            configfile = a
	elif o in ("-w", "--world"):
            worldfile = a
	elif o in ("-v", "--services"):
            services = a
	elif o in ("-e", "--eval"):
            evalcommand = a

if pyro.startup_check():
    import pyro.system
    from pyro.system.config import Configuration
    process_options()
    c = Configuration(configfile)
    if configfile:
        c.put('config', 'file', configfile)
    if not robotfile:
        robotfile = c.get('robot', 'file')
    else:
        c.put('robot', 'file', robotfile)
    if not services:
        services = c.get('robot', 'services')
    else:
        c.put('robot', 'services', services)
    if not simulator:
        simulator = c.get('simulator', 'file')
    else:
        c.put('simulator', 'file', simulator)
    if not brainfile:
        brainfile = c.get('brain', 'file')
    else:
        c.put('brain', 'file', brainfile)
    if not worldfile:
        worldfile = c.get('world', 'file')
    else:
        c.put('world', 'file', worldfile)
    if not pyroargs:
        pyroargs = c.get('pyro', 'args')
    else:
        c.put('pyro', 'args', pyroargs)
    c.put('pyro', 'gui', window)
    share.config = c
    if services == None:
        services = ""
    eng = Engine(robotfile, brainfile, simulator,
                 pyroargs, c, worldfile, services.split(",") )
    if window == 'GL':
        from pyro.gui.GL import GLgui
        gui = GLgui(eng)
        gui.win.redraw = gui.redraw
    elif window == 'TK':
        from pyro.gui.TK import TKgui
        gui = TKgui(eng)
        gui.win.redraw = gui.redraw
    elif window == 'TTY':
        gui = pyro.gui.gui("tty gui", {}, eng)
    elif window == 'CURSES':
        from pyro.gui.Curses import Curses as Curses
        gui = Curses("curses gui", {}, eng)
    if evalcommand != "":
        evalcommand = evalcommand.split(';')
    else:
        evalcommand = []
    gui.run(evalcommand)
    gui.cleanup()
else:
    basichelp()
