# A Behavior-based brain

from pyro.brain.fuzzy import *
from pyro.brain.behaviors import *
from math import pi

class Avoid (Behavior):
    def direction(self, dir, dist):
        if dist < 1.0:
            if dir < 0.0:
                return 1.0 - dir
            else:
                return -1.0 - dir
        else:
            return 0.0

    def update(self):
        close_dist, close_angl = self.getRobot().get('range', 'value', 'front-all', 'close')
        close_angl /= pi
        print "Closest distance =", close_dist, "angle =", close_angl
        self.IF(Fuzzy(0.0, 1.5) << close_dist, 'translate', 0.0, "TooClose")
        self.IF(Fuzzy(0.0, 1.5) >> close_dist, 'translate', .2, "Ok")
        self.IF(Fuzzy(0.0, 1.5) << close_dist, 'rotate', self.direction(close_angl, close_dist), "TooClose")
        self.IF(Fuzzy(0.0, 1.5) >> close_dist, 'rotate', 0.0, "Ok")

class state1 (State):
    def init(self):
        self.add(Avoid(1, {'translate': .3, 'rotate': .3}))
        print "initialized state", self.name

def INIT(engine): 
    brain = BehaviorBasedBrain({'translate' : engine.robot.translate, \
                                'rotate' : engine.robot.rotate, \
                                'update' : engine.robot.update }, engine)
    brain.add(state1(1)) 
    brain.init()
    return brain
