# MySimpleBrain.py -- exercise from http://emergent.brynmawr.edu/pyro/?page=PyroModuleDirectControl
# A bare brain

from pyro.brain import Brain
from pyro.brain.fuzzy import *
from pyro.brain.behaviors import *
from time import sleep
import random

class StrAndAv(Behavior):
   def update(self):
      self.IF(.4, 'translate', 0.25)
      self.IF(.4, 'rotate', 0.0)
      self.IF(.2, 'translate', 0.0)
      self.IF(.2, 'rotate',-0.7 )

class state1(State):
   def init(self):
      self.add(StrAndAv(1,{'translate':1.0, 'rotate':1.0}));

def INIT(engine):
   brain = BehaviorBasedBrain({'translate': engine.robot.translate,\
                               'rotate': engine.robot.rotate,\
                               'update': engine.robot.update }, engine)
   brain.add(state1(1));
   brain.init()
   return brain


##class Behavior:
##    def __init__(self):
##        self.translate = 0
##        self.rotate = 0
##        self.flag = 0
##
##    def setRobot(self, robot):
##        self.robot = robot
##
##    def getRobot(self):
##        return self.robot        
##
##    def move(self, translate, rotate):
##        self.translate = translate
##        self.rotate = rotate
##        self.flag = 1
        

class Wander(Behavior):
   def update(self):
      self.move( .2, random.random() * 2 - 1)

class Avoid(Behavior):
   def update(self):
      if self.getRobot().get('range', 'value', 'front-all', 'close')[0] < 1:
         self.move( -.2, 0)


class SubsumptionBrain(Brain):
   def __init__(self,engine):
      Brain.__init__(self,'SubsumptionBrain',engine);
      self.behaviors = [];

   def add(self, beh):
      beh.setRobot(self.robot);
      self.behaviors.append(beh);

   def step(self):
      # we'll pass around the behaviors, rather than their indices...
      beh = self.updateAll() # update status of all behaviors
      print "Behavior " + beh.__class__.__name__ + " is in control";
      self.getRobot().move(beh.translate, beh.rotate);
      sleep(.5)

   def updateAll(self):
      # self.behaviors is a list of behavior objects
      for beh in self.behaviors:
         beh.flag = 0;
         beh.update(); # update that behavior
         if (beh.flag):
            return beh;
      # I don't know if beh is still in scope...
      # checking with the python shell seems to incidate it is...
      return beh;
      # otherwise we have to get the lowest-priority (default) behavior
      # and return it

class SimpleBrain(Brain):

   alreadyStuck = False;

   def setup(self, **args):
      robot = self.getRobot();
      robot.br_dir = 'forward';  # br_dir == brain direction

   def step(self):
      robot = self.getRobot();
      robot.move(0.5,0.5);
      sleep(2);
      robot.move(0.5,-0.5);
      sleep(2);
##      if (self.alreadyStuck and not robot.get('self','stall')):
##         self.alreadyStuck = False;
##      if (not self.alreadyStuck and robot.get('self','stall')):
##         print "stuck -- reversing";
##         self.alreadyStuck = True;
##         if robot.br_dir == 'forward':
##            robot.br_dir = 'reverse';
##         else:
##            robot.br_dir = 'forward';
##         print "Robot direction is now " + robot.br_dir;
##      if robot.br_dir == 'forward':
##         velocity = 0.5;
##      else:
##         velocity = -0.5;
##      robot.translate(velocity);           

# -------------------------------------------------------
# This is the interface for calling from the gui engine.
# Takes one param (an engine), and returns a Brain object:
# -------------------------------------------------------

##def INIT(engine):
##   # brain = SimpleBrain('SimpleBrain', engine, my_arg = "testing")
##   brain = SubsumptionBrain( engine )
##   brain.add( Avoid() );
##   brain.add( Wander() );
##   print "The " + engine.robot.name + " robot now has the " + brain.name + " brain.";
##   return brain;
      
