/*
  XRCL: The Extensible Robot Control Language
  (c) 2000, Douglas S. Blank
  University of Arkansas, Roboticists Research Group
  http://ai.uark.edu/xrcl/
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  As a special exception, you have permission to link this program
  with the Qt library and distribute executables, as long as you
  follow the requirements of the GNU GPL in regard to all of the
  software in the executable aside from Qt.
*/

#ifndef __CONSTANTS_H__
 #define __CONSTANTS_H__

static const int   PATHNAME       = 255;
static const int   ZERO           = 0;
static const int   ONE            = 1;
static const int   NEGONE         = -1;

static const float PI             = (float)3.141592653;
static const float FZERO          = (float)0.0;

// Behavior Status States
static const int   xcDNE          = -1;
static const int   xcDORMANT      = 0;
static const int   xcACTIVE       = 1;
static const int   xcGOINGDORMANT = 2;
static const int   xcGOINGACTIVE  = 3;

static const double   xcREVERSE    =   -0.50;
static const double   xcSTOP        =   0.0;
static const double   xcSLOW        =   0.2;
static const double   xcMEDIUM      =   0.5;
static const double   xcFORWARD     =   0.75;
static const double   xcFAST        =   1.0;

static const double   xcLEFT        =   0.50;
static const double   xcRIGHT       =  -0.50;
static const double   xcSTRAIGHT    =   0.0;

//Network constants
#define MAX_HOSTS 15
#define MAX_PORTS 10

const int xcUNION = 0;
const int xcINTERSECTION = 1;
const int xcMIN=0;
const int xcMAX=1;

#define xcPOINT   0
#define xcWALL    1
#define xcHALLWAY 2
#define xcROOM    3
#define xcDOOR    4

#define xcGLOBAL  0
#define xcLOCAL   1

#define xcCOLORFILTER 0
#define xcMOTIONFILTER 1
#define xcVERTICALLINEFILTER 2
#define xcEDGEFILTER 3
#define xcCONVOLUTION 4

#define IROWS 80
#define ICOLS 100

#define xcMAXIMAGEHIST 10

#ifndef NULL 
#define NULL 0
#endif

#endif

