# Simple demonstration of using Python Interface to Aria
# Creates a simple class AriaRobot with some basic methods

# For this import to work, you need to have Aria/python in
# your PYTHONPATH: At the shell:
#     export PYTHONPATH=/usr/local/Aria/python

from AriaPy import *

class AriaRobot:
    """ Simple Aria-based Python robot class """
    def __init__(self):
        """ The constructor """
        print "Connecting to robot..."
        Aria.init()
        self.robot = ArRobot()
        self.gripper = 0
        self.camera = 0
        # first, let's try a TCP connection (for example, a simulator)
        self.conn = ArTcpConnection()
        self.conn.setPort()
        self.robot.setDeviceConnection(self.conn)
        # did that work?
        if (self.robot.blockingConnect() != 1):
            # could not connect to TCP; let's try a serial one:
            self.conn = ArSerialConnection()
            self.conn.setPort()
            self.robot.setDeviceConnection(self.conn)
            if (self.robot.blockingConnect() != 1):
                from sys import exit
                print "Could not connect to robot, exiting"
                exit(1)

    def engage(self):
        """ Enables the robot to move """
        self.robot.runAsync(1)

    def move(self, amt):
        """ A Python wrapper to hide locks """
        self.robot.lock()
        self.robot.move(amt)
        self.robot.unlock()

    def setHeading(self, amt):
        """ A Python wrapper to hide locks """
        self.robot.lock()
        self.robot.setHeading(amt)
        self.robot.unlock()

    def run(self):
        self.engage()
        self.move(1000)
        self.display()
        self.sleep(5000)
        self.setHeading(90)
        self.display()
        self.sleep(5000)
        self.display()

    def sleep(self, amt):
        ArUtil.sleep(amt)

    def display(self):
        self.robot.lock()
        print "I think I am at position (", self.robot.getX(), ",", self.robot.getY(), ",", self.robot.getTh(), ")"
        self.robot.unlock()

    def __del__(self):
        print "Shutting down..."
        self.robot.disconnect()

    def cleanup(self):
        Aria.shutdown()

    def cameraInit(self):
        self.camera = ArSonyPTZ( self.robot )
        self.camera.init()

    def gripperInit(self):
        self.gripper = ArGripper( self.robot )

if __name__ == '__main__':
    # This will execute if you run this script like: python2.2 -i simple.py
    myrobot = AriaRobot()
    #myrobot.run()
