/*
 * This are the Harvey Mudd (H) input/output classes
 *
 * H: for ease of typing
 * HMCInput: handles lots of input functionality
 * HMCOutput: ditto for output
 *
 * Zach Dodds, Fall 2004
 */

import java.io.*;
import java.lang.*;

class H 
{
    public static HMCInput in = new HMCInput(java.lang.System.in);
    public static HMCOutput out = new HMCOutput(java.lang.System.out);
    
    static HMCOutput input_out = out;
    
    static HMCInput console_in = in;
    static HMCOutput console_out = out;
    
    //static int dummyInt = HMCSupport.DummyFunctionForPrinting();
    
    /*
     * clear the screen by printing 50 blank lines
     */
    public static void cls()
    {
    	for (int i=0 ; i<50 ; ++i)
    	{
    		H.pl();
    	}
    }
    
    public static boolean outputAndInputToFile(String fileName)
    {
        boolean ret =  outputToFile(fileName,false);   
                // false means replace the file
                // rather than append to the end of it
        H.input_out = out;
        return ret;
                                               
    }    

    public static boolean outputToFile(String fileName)
    {
        return outputToFile(fileName,false);   // false means replace the file
                                               // rather than append to the end of it
    }
    
    public static boolean inputToFile(String fileName)
    {
        FileOutputStream f = null;
        try
        {
            f = new FileOutputStream(fileName,false); // false means replace the file, if it exists
            PrintStream P = new PrintStream(f);
            input_out = new HMCOutput(P);
            return true;
        }
        catch (Exception e)
        {
            System.out.println("There was a problem opening the file " + fileName);
            System.out.println("H.out will remain the console output.\n\n");
            e.printStackTrace();
        }
        return false;
    }
    
    public static boolean outputToFile(String fileName, boolean append)
    {
        FileOutputStream f = null;
        try
        {
            f = new FileOutputStream(fileName,append);
            PrintStream P = new PrintStream(f);
            out = new HMCOutput(P);
            return true;
        }
        catch (Exception e)
        {
            System.out.println("There was a problem opening the file " + fileName);
            System.out.println("H.out will remain the console output.\n\n");
            e.printStackTrace();
        }
        return false;
    }
    
    public static boolean inputFromFile(String fileName)
    {   
        FileInputStream I = null;
        try
        {
            I = new FileInputStream(fileName);
            in = new HMCInput(I);
            return true;
        }
        catch (Exception e)
        {
            System.out.println("There was a problem opening the file " + fileName);
            System.out.println("Does the file " + fileName + " exist?");
            System.out.println("H.in will remain the console input.\n\n");
            e.printStackTrace();
        }
        return false;
    }
    
    public static boolean outputToConsole()
    {
        out = console_out;
        return true;
    }
    
    public static boolean inputToConsole()
    {
        input_out = console_out;
        return true;
    }
    
    public static boolean inputFromConsole()
    {
        in = console_in;
        return true;
    }
    
    /*
     * formatting shortcuts... H.fmt
     *   take in lots of types and return an appropriately
     *   formatted String 
     * 
     * several versions to allow for default values
     *
     */
     
    public static String fmt(double d)
    {
    	// precision is 3 places after the decimal point by default
    	return fmt(d,3); 
    }
     
    public static String fmt(double d,int precision)
    {
    	// width is 0 (no padding) by default
    	return fmt(d,precision,0); 
    }
     
    public static String fmt(double d,int precision,int width)
    {
    	// justification is to the left by default
    	return fmt(d,precision,width,HMCOutput.LEFT); 
    }
     
    public static String fmt(double d,int precision,int width,int justification)
    {
    	int oldPrecision = H.out.getPrecision();
    	boolean oldFixed = H.out.getFixed();
    	int oldWidth     = H.out.getWidth();
    	int oldJustification = H.out.getJustification();
    	char oldPadChar     = H.out.getPadChar();
    	
    	// set to desired values
    	H.out.setPrecision(precision);
    	H.out.setFixed(true);  // always true for H.fmt
    	H.out.setWidth(width);
    	H.out.setJustification(justification);
    	H.out.setPadChar(' '); // use space for H.fmt
    	
    	String s = H.out.doubleToString(d);
    	
    	// reset the stream...
    	H.out.setPrecision(oldPrecision);
    	H.out.setFixed(oldFixed);
    	H.out.setWidth(oldWidth);
    	H.out.setJustification(oldJustification);
    	H.out.setPadChar(oldPadChar);
    	
    	// return the String
    	return s;
    }
    
    /*
     * shortcuts -- these allow one to type
     *
     *  H.p(<something>) or H.pl(<something>)
     *
     * instead of the longer versions:
     *
     *  H.out.print(<something>)   or HMCSupport.out.print(<something>) or
     *  H.out.println(<something>) or HMCSupport.out.println(<something>) or
     */
    
    public static void p(String o)    { H.out.print(o); }
    public static void p(byte o)      { H.out.print(o); }
    public static void p(Byte o)      { H.out.print(o); }    
    public static void p(boolean o)   { H.out.print(o); }
    public static void p(short o)     { H.out.print(o); }
    public static void p(Short o)     { H.out.print(o); }    
    public static void p(char o)      { H.out.print(o); }
    public static void p(int o)       { H.out.print(o); }
    public static void p(Integer o)   { H.out.print(o); }
    public static void p(float o)     { H.out.print(o); }
    public static void p(Float o)     { H.out.print(o); }
    public static void p(double o)    { H.out.print(o); }
    public static void p(Double o)    { H.out.print(o); }
    public static void p(long o)      { H.out.print(o); }
    public static void p(Long o)      { H.out.print(o); }
    public static void p(Object o)    { H.out.print(o); }
    
    public static void pl(String o)    { H.out.println(o); }
    public static void pl(byte o)      { H.out.println(o); }
    public static void pl(Byte o)      { H.out.println(o); }    
    public static void pl(boolean o)   { H.out.println(o); }
    public static void pl(short o)     { H.out.println(o); }
    public static void pl(Short o)     { H.out.println(o); }     
    public static void pl(char o)      { H.out.println(o); }
    public static void pl(int o)       { H.out.println(o); }
    public static void pl(Integer o)   { H.out.println(o); }
    public static void pl(float o)     { H.out.println(o); }
    public static void pl(Float o)     { H.out.println(o); }
    public static void pl(double o)    { H.out.println(o); }
    public static void pl(Double o)    { H.out.println(o); }
    public static void pl(long o)      { H.out.println(o); }
    public static void pl(Long o)      { H.out.println(o); }
    public static void pl(Object o)    { H.out.println(o); }   
    public static void pl()            { H.out.println(); }  
    
    public static int    ni()          { return H.in.nextInt(); }
    public static long   nlong()       { return H.in.nextLong(); }
    public static float  nf()          { return H.in.nextFloat(); }
    public static double nd()          { return H.in.nextDouble(); }
    public static String nw()          { return H.in.nextWord(); }
    public static String nl()          { return H.in.nextLine(); } 
    public static char   nc()          { return H.in.nextChar(); }
    public static char   nanyc()       { return H.in.nextAnyChar(); }
    
    public static int    ni(String s)    { H.p(s+" "); return H.in.nextInt(); }
    public static long   nlong(String s) { H.p(s+" "); return H.in.nextLong(); }
    public static float  nf(String s)    { H.p(s+" "); return H.in.nextFloat(); }
    public static double nd(String s)    { H.p(s+" "); return H.in.nextDouble(); }
    public static String nw(String s)    { H.p(s+" "); return H.in.nextWord(); }
    public static String nl(String s)    { H.p(s+" "); return H.in.nextLine(); } 
    public static char   nc(String s)    { H.p(s+" "); return H.in.nextChar(); }
    public static char   nanyc(String s) { H.p(s+" "); return H.in.nextAnyChar(); }
    
    // random integer from low to high INCLUSIVE
    public static int    randInt(int low, int high) {
    	// swap parameters if necessary
    	if (low > high) { int tmp = high; high = low; low = tmp; }
    	// +1 makes it inclusive!
    	return low + (int)((high-low+1)*Math.random());
    }
    
    // random long from low to high INCLUSIVE
    public static long   randLong(long low, long high) {
        // swap parameters if necessary
        if (low > high) { long tmp = high; high = low; low = tmp; }
        // +1 makes it inclusive!
        return low + (long)((high-low+1)*Math.random());
    }
    
    // random double from low to high EXCLUSIVE of high: [low,high)
    public static double    randDouble(double low, double high) {
    	// swap parameters if necessary
    	if (low > high) { double tmp = high; high = low; low = tmp; }
    	// Math.random() returns a random # from 0 to 1: [0,1)
    	return low + (high-low)*Math.random();
    }    
    
    // pause simply pauses the calling thread for the specified
    // number of milliseconds...
    public static void pause(int milliseconds)
    {
    	try {
    		Thread.sleep((long)(milliseconds));
    	}
    	catch (Exception e) {
    		e.printStackTrace();
    	}
    }
    
    public static void now() {
		H.pl(System.currentTimeMillis());
	}
  
    public static void main(String[] sa)
    {
        //H.inputFromFile("input2.txt");
        //H.outputAndInputToFile("output.txt");
        //H.outputToFile("output.txt");
        //H.inputToFile("input3.txt");
        
        H.pl("Hello, World! What time is it? ");
        int x2 = H.ni();
        H.pl("x is " + x2);
        
        String s,t,u,v;
        char y;
        char c = 'a';
        while (c>='a') { // capital letters quit...
        
            H.p("Type a char (uc to quit), word, line, char, word, line: ");
	        c = H.nc();
	        s = H.nw();
	        t = H.nl();
	        y = H.nc();
	        u = H.nw();
	        v = H.nl();
	        
			H.pl("char is " + c);
			H.pl("word is " + s);
	        H.pl("line is " + t);
	        H.pl("char is " + y);
	        H.pl("word is " + u);
	        H.pl("line is " + v);
	    }
        
        H.pl("\n\n");
        
        H.pl("Getting a string");
        String s3 = H.nw();
        H.pl("s3 is " + s3);
        
        System.exit(0);
        

        H.p('H');
        H.p("i #1  ");
        H.pl("Hi #2  ");
        
        int i = 5; // i =  H.in.nextInt();
        long l = 7L; // l =  H.in.nextLong();
        double d = 3.14159;  // d = H.in.nextDouble();
        
        H.pl("int i is " + i);
        H.pl("long l is " + l);
        H.pl("double d is " + d);
        H.pl("22/7 is " + (22/7.));
        H.pl(true);
        H.pl(false);
        H.pl();
        
        double[][] D = { {1, 2, 3}, {4, 5, 6}, {7, 8, 9} };
        
        H.out.setWidth(8);
        H.out.setRightJustify();
        H.out.setPrecision(2);
        H.out.setFixed(true);
        H.out.println();
        for (int r=0 ; r<D.length ; ++r)
        {
            for (int col=0 ; col<D[r].length ; ++col)
            {
                H.p(D[r][col]);
            }
            H.pl();
        }
        H.pl();
        
        H.out.setWidth(0);
        H.out.setLeftJustify();
        H.out.setPrecision(0);
        H.out.setFixed(false);
        H.outputToConsole();
        H.out.println("Wow! it worked...");
    }



}




/*
 * By Z. Dodds,
 *    adapted from code by J Hodas with
 *    important improvements, e.g., line/word input
 *    is now compatable, one can get chars, etc.
 *      (prompting and error-catching) by Chris Erickson HMC '06
 *    Thanks, Chris!
 */
 

class HMCInput 
{
  private BufferedReader r;
  private StreamTokenizer theStream;
  private boolean good;
  private boolean tokensWaiting;
  private String lastLineRead;       // this holds the text yet to be processed

  /** 
   * Takes an InputStream and builds an HMCInput stream from it. 
   * 
   * @param I is an InputStream from which the formatted input stream
   * is built.
   */
    
  public HMCInput(InputStream I)
  {
      r = new BufferedReader(new InputStreamReader(I));
      theStream = new StreamTokenizer(r);

      theStream.resetSyntax();
      theStream.wordChars(33, 255);
      theStream.whitespaceChars(0, ' ');
      theStream.eolIsSignificant(true);
      
      good = true;
      tokensWaiting = false;
      lastLineRead = "";
  }


  /**
   * @return Returns true if the input stream is
   * in a good state (i.e. no input errors have occured, or the last error 
   * condition has been cleared.
   */

  public boolean good() 
  {
      return good; 
  }


  /**
   * @return Returns true if the stream has reached End Of File.
   */

  public boolean EOF() 
  { 
      return (theStream.ttype == StreamTokenizer.TT_EOF);
  }
  
  /*
   * this method removes initial whitespace from a string
   */
  String removeWhiteSpace(String s)
  {
    int startindex = 0;
    int len = s.length();
    
    while (startindex < len)
    {
      // anything less than ' ' is a space...
      if (s.charAt(startindex) <= ' ')   
      {
        ++startindex;  
      }
      else
        break;
    }
    
    String ret = "";
    
    try
    {
        ret = s.substring(startindex);
    }
    catch (Exception e) { }
    // if it fails, it's because we're out of range, so the empty string is OK
    
    return ret;
  }
  
  
  public char nextChar()
  {
  	// get rid of leading whitespace
  	// if you want the next char including whitespace,
  	// call nextAnyChar()
    lastLineRead = removeWhiteSpace(lastLineRead);
      
    if (lastLineRead.equals(""))
    {
        tokensWaiting = false;
    }
      
    while (!tokensWaiting) // from a previous read
    {
        lastLineRead = nextLine();  // refill the nextLineRead data member
        
        lastLineRead = removeWhiteSpace(lastLineRead);
      
        if (!lastLineRead.equals(""))
        {
            tokensWaiting = true;
        }
    
        if (good == false)
        {
            if (true /*theStream.nextToken() == StreamTokenizer.TT_EOF*/)
            {
                ; // do something here
                // perhaps print a warning and return some default value "0";
            }
        }  
    }
    
    // the next char must be non-whitespace, so we "remove" that
    // char from the lastLineRead member and return it
    char ret = lastLineRead.charAt(0);
    int linelen = lastLineRead.length();    
    lastLineRead = lastLineRead.substring(1,linelen);
    
    return ret;
  }
  
  public char nextAnyChar()
  {
  	// don't get rid of leading whitespace
  	// if you want the next char including whitespace,
  	// call nextAnyChar()
    // lastLineRead = removeWhiteSpace(lastLineRead);
    
    char ret = '!';
    
    if (lastLineRead.equals(""))
    {
    	// we return the newline char
        ret = '\n';
        
        // no tokens waiting -- important for nextLine to work correectly
        tokensWaiting = false;
        
        // now we need to get a new line for subsequent calls
        lastLineRead = nextLine();  // refill the nextLineRead data member
        
        // we don't remove whitespace in this case!
        //lastLineRead = removeWhiteSpace(lastLineRead);
      
        // nor do we check for empty lines!
        //if (!lastLineRead.equals(""))
        //{
        //    tokensWaiting = true;
        //}
    }
    else
    {
    	ret = lastLineRead.charAt(0);
	    int linelen = lastLineRead.length();    
	    lastLineRead = lastLineRead.substring(1,linelen);
    }
    
    return ret;
  }

  public String nextWord()
  {
    // get rid of leading whitespace
    lastLineRead = removeWhiteSpace(lastLineRead);
      
    if (lastLineRead.equals(""))
    {
        tokensWaiting = false;
    }
      
    while (!tokensWaiting) // from a previous read
    {
        lastLineRead = nextLine();  // refill the nextLineRead data member
        
        lastLineRead = removeWhiteSpace(lastLineRead);
      
        if (!lastLineRead.equals(""))
        {
            tokensWaiting = true;
        }
    
        if (good == false)
        {
            if (true /*theStream.nextToken() == StreamTokenizer.TT_EOF*/)
            {
                ; // do something here
                // perhaps print a warning and return some default value "0";
            }
        }  
    }
    
    // get chars up to the next white space
    int startindex = 0;
    int linelen = lastLineRead.length();
    
    while ( startindex<linelen && lastLineRead.charAt(startindex) > ' ' )
    {
        ++startindex;
    }
    
    String ret = "0";
    
    try {
        ret = lastLineRead.substring(0,startindex);
        lastLineRead = lastLineRead.substring(startindex,linelen);
    } catch (Exception e) { 
        System.err.println("error in nextWord! returning \"0\"");
        e.printStackTrace();
    };
    
    return ret;

  }
    
  public String nextLine()
  {
      String s = "";
      
      // get rid of leading whitespace, if there are tokens waiting
      
      if (tokensWaiting)
      {
          lastLineRead = removeWhiteSpace(lastLineRead);
          
          if (lastLineRead.equals(""))   // don't return an empty line
          {
            tokensWaiting = false;
          }
          else       // return the rest
          {
            tokensWaiting = false;
            return lastLineRead;
          }
      }
      
      if (!tokensWaiting) // from a previous read
      {
          try
          {
             s = r.readLine();
             tokensWaiting = true;
          }
          catch (Exception e)
          {
             good = false;
             // should we take this out?
             // I don't know when this even happens...
             // maybe if the stream is closed or something
             // but if it's a file that reaches the EOF,
             // s is null, but no exception is thrown
             System.err.println("There was a problem getting a line of input.");
             e.printStackTrace();
          }
      }
      
      // tokensWaiting should be false now, because this line is
      // all that's needed
      
      tokensWaiting = false;
      
      if (s == null)
      {
         // end of stream has been reached
         // check if we were reading from a file
         if (H.in != H.console_in)
         {
            // in this case, print a message and start taking
            // more input from stdin
            System.err.println("\n** The end of the input file has been reached.**");
            System.err.println(  "** Further input will be taken from the console:\n");
            H.inputFromConsole();
            // recursively call nextLine and return the result
            return H.in.nextLine(); 
         }
         else
         {
            // in this case, the input is already coming
            // from the console_in -- I don't know how s could
            // be null in this case, but perhaps we'll see...
            System.err.println("Attempt to read past the end of the stream/file.");
            System.err.println("returning the string 0");
            s = "0";
         }
      }
      
      // we check if we're echoing things to a file output
      // if so, we send the input out to the file
      // OR if the input is coming from a file, we echo it
      // either to another file or to the console
      //
      // so, the only time we _don't_ echo the input is when
      // it's coming from the stdin and not going to a file
      if (H.input_out != H.console_out || H.in != H.console_in)  // if file output
      {
         H.input_out.println(s);
      }
      
      // what if we're taking in the input from a file AND
      // sending it out to a file? It seems we should still
      // allow the user to see it! So we do...
      if (H.input_out != H.console_out && H.in != H.console_in) 
      {
         System.out.println(s);
      }
      return s;
      
  }
  
  // Thanks to Chris Erickson (HMC '06):
  
  public int nextInt()
  {
    return nextInt("An int please: ");
  }
  
  // allow a user-supplied String as a
  // prompt (repeated as often as necessary)
  
  public int nextInt(String e)
  {
    String s = "";
    int i = 0;
    boolean good = false;

    while ( !good )
    {
      s = nextWord();
      good = true;
      try
      {
        i = java.lang.Integer.parseInt(s);
      }
      catch ( NumberFormatException x )
      {
        good = false;
        System.out.print(e);
      }
    }

    return i;
  }
  
  // Thanks to Chris Erickson (HMC '06):
  
  public long nextLong()
  {
    return nextLong("A long int please: ");
  }
  
  // allow a user-supplied String as a
  // prompt (repeated as often as necessary)
  
  public long nextLong(String e)
  {
    String s = "";
    long i = 0l;
    boolean good = false;

    while ( !good )
    {
      s = nextWord();
      good = true;
      try
      {
        i = java.lang.Long.parseLong(s);
      }
      catch ( NumberFormatException x )
      {
        good = false;
        System.out.print(e);
      }
    }

    return i;
  }
  
  // Thanks to Chris Erickson (HMC '06):
  
  public float nextFloat()
  {
    return nextFloat("A float please: ");
  }
  
  // allow a user-supplied String as a
  // prompt (repeated as often as necessary)
  
  public float nextFloat(String e)
  {
    String s = "";
    float i = 0;
    boolean good = false;

    while ( !good )
    {
      s = nextWord();
      good = true;
      try
      {
        i = java.lang.Float.parseFloat(s);
      }
      catch ( NumberFormatException x )
      {
        good = false;
        System.out.print(e);
      }
    }

    return i;
  }

  // Thanks to Chris Erickson (HMC '06):
  
  public double nextDouble()
  {
    return nextDouble("A double please: ");
  }
  
  // allow a user-supplied String as a
  // prompt (repeated as often as necessary)
  
  public double nextDouble(String e)
  {
    String s = "";
    double i = 0;
    boolean good = false;

    while ( !good )
    {
      s = nextWord();
      good = true;
      try
      {
        i = java.lang.Double.parseDouble(s);
      }
      catch ( NumberFormatException x )
      {
        good = false;
        //System.out.print("**" + s + "**");
        System.out.print(e);
      }
    }

    return i;
  }
  

   


  static public void main(String[] args)
  {
    ;
  }
  
  
  
}


/*
  An object of class HMCOutput implements the following public methods:

  Initialization:

	  HMCOutput(PrintStream);	Builds HMCOutput object from given stream.
	  HMCOutput();		Builds HMCOutput object from System.in

  HMCSupport.out comes pre-connected to System.out.


  Usage:

    print(x);	Prints the value of x on the stream. The exact 
			    output will depend on the values of various
			    switches described below. Takes values of any
			    type / class.

	println(x);	As above, but followed by a line break.

	println();	Send a line break to the stream.

	flush();	Force the stream to flush output buffers.


  Switches: All of these switches keep their values until explicitly changed.
	         This differs from some of the corresponding stream functions in C++
	         

	setAlwaysFlush(boolean); If set to true, all calls to print
				and println will be immediately followed
				by a flushing of the output buffer. 
				Default is true.	

	setWidth(int); 		Output of subsequent calls to print methods
				will be formatted in a field that many
				characters wide, if they are not already 
				wider than that. Default value is 0.
	
	setPadChar(char); 	Sets the character used to pad out fields.
				Default value is ' '.

	setJustification(int);  Sets the justification within a field.
				Default value is RIGHT. Other excepted values
				are LEFT and CENTER. Any other value
				behaves like RIGHT.

	setLeftJustify()	Sets left justification.
	setRightJustify()	Sets right justification.
	setCenterJustify()	Sets center justification.

	setPrecision(int);	Sets the number of digits to the right of
				the decimal point to which floating point
				values should be truncated. If set to 0,
				truncation does not occur. Default is 0.

	setFixed(boolean);	If set to true, then floating point
				values will be zero-extended on the right
				to yield the current precision setting.
				Default is false.

	     Note that the last two switches, which control formatting 
	     of floating point values, only apply if the entire argument
	     to print (or println) is such a value, since in a call like:

			println("x = " + x);

	     a string representation of x is generated by toString()
	     and println recieves a String, not a number. 
	     
  By Z. Dodds, based on code by J Hodas...
  
  It may seem that all of the different versions of print and println
  aren't needed, but they are -- otherwise the individual types are not handled
  correctly, e.g., setPrecision and setWidth information is lost...
*/	


class HMCOutput 
{
  static final int RIGHT = 1;
  static final int LEFT = 2;
  static final int CENTER = 3;

  private PrintStream theStream;
  private int fieldWidth;
  private int precision;
  private boolean fixed;
  private boolean alwaysFlush;
  private char padChar;
  private int justification;

  public HMCOutput(PrintStream O)
    {
      theStream = O;
      fieldWidth = 0;
      precision = 0;
      fixed = false;
      alwaysFlush = true;
      padChar = ' ';
      justification = RIGHT;
    }

  public HMCOutput()
    {
      this(System.out);
    }
    
  /*
   * some "setter" methods
   */

  public void setWidth(int w)
    {
      fieldWidth = w;
    }

  public void setPadChar(char c)
    {
      padChar = c;
    }

  public void setJustification(int j)
    {
      justification = j;
    }

  public void setLeftJustify()
    {
      setJustification(LEFT);
    }

  public void setRightJustify()
    {
      setJustification(RIGHT);
    }

  public void setCenterJustify()
    {
      setJustification(CENTER);
    }

  public void setPrecision(int p)
    {
      precision = p;
    }

  public void setFixed(boolean f)
    {
      fixed = f;
    }
    
  /* 
   * some "getter" methods, as well...
   */
  public int getWidth()
    {
      return fieldWidth;
    }

  public char getPadChar()
    {
      return padChar;
    }

  public int getJustification()
    {
      return justification;
    }

  public int getPrecision()
    {
      return precision;
    }

  public boolean getFixed()
    {
      return fixed;
    }

  public boolean getAlwaysFlush()
    {
      return alwaysFlush;
    }
    
  /*
   * now, the methods that do the work...
   */

  private void printString(String S, boolean newLine)
    {
      while (S.length() < fieldWidth)
		{
		  switch (justification) 
		  {
			  case RIGHT:
			    S = new String(padChar + S);
			    break;
			  case LEFT:
			    S = new String(S + padChar);
			    break;
			  case CENTER:
			    S = new String(S + padChar);
			    if (S.length() < fieldWidth)
			      S = new String(padChar + S);
			    break;
			  default:		// default behavior is right justification
			    S = new String(padChar + S);
			    break;
		  }
		}

      if (newLine)
		theStream.println(S);
      else 
		theStream.print(S);

      if (alwaysFlush)
		theStream.flush();
    }

  private void printLong(long l, boolean newLine)
  {
      printString(String.valueOf(l), newLine);
  }
    
  String doubleToString(double d)
  {
  	// let's handle the rounding first...
  	// if precision > 0, we know exactly what to
  	// add (for positive numbers) or subtract
  	// (for negative numbers) in order that the truncation
  	// that will happen with the String will actually
  	// produce the rounded value
  	if (precision > 0)
  	{
  		double delta = 0.5 * Math.pow(10,-precision);
  		
  		if (d >= 0)
			d += delta;
  		else
			d -= delta;
  	}
  	
  	// now, we get the String version...
  	String dString = Double.toString(d);

    int eLocation = dString.lastIndexOf('e');

    if (eLocation == -1) 
      eLocation = dString.lastIndexOf('E');

    if (eLocation == -1) 
      eLocation = dString.length();

    String exponent = dString.substring(eLocation);
    String core = dString.substring(0,eLocation);

    int dotLocation = core.lastIndexOf('.');

    String intPart;
    String decPart;
    if (dotLocation == -1) {
      intPart = core;
      decPart = "";
    }
    else {
      intPart = core.substring(0,dotLocation);
      decPart = core.substring(dotLocation+1);
    }

    // truncate to desired precision
    if (precision != 0 && decPart.length() > precision)
        decPart = decPart.substring(0,precision);

    if (exponent.length() > 0 && decPart.length() == 0)
      decPart = "0";

    if (fixed)
      while (decPart.length() < precision)
        decPart = decPart + "0";

    String theNumber;
    if (decPart.length() > 0)
      theNumber = intPart + "." + decPart + exponent;
    else
      theNumber = intPart;
      
    // this is repeated from printString so that the actual
    // String can be returned...
    while (theNumber.length() < fieldWidth)
	{
	    switch (justification) 
	    {
			  case RIGHT:
			    theNumber = new String(padChar + theNumber);
			    break;
			  case LEFT:
			    theNumber = new String(theNumber + padChar);
			    break;
			  case CENTER:
			    theNumber = new String(theNumber + padChar);
			    if (theNumber.length() < fieldWidth)
			      theNumber = new String(padChar + theNumber);
			    break;
			  default:		// default behavior is right justification
			    theNumber = new String(padChar + theNumber);
			    break;
	    }
	}
      
    return theNumber;
  }  

  void printDouble(double d, boolean newLine)
  {
    String theNumber = doubleToString(d);
    printString(theNumber, newLine);
  }
  
  public void print(boolean b)
  {
    printString(b ? "true" : "false",false);
  }  
  
  public void print(byte b)
  {
    printLong((long)b,false);
  } 
  
  public void print(Byte b)
  {
    printLong(b.longValue(),false);
  }   
  
  public void print(short s)
  {
    printLong((long)s,false);
  } 
  
  public void print(Short s)
  {
    printLong(s.longValue(),false);
  }   

  public void print(long l)
  {
    printLong(l,false);
  }

  public void print(Long L)
  {
    printLong(L.longValue(),false);
  }

  public void print(int i)
  {
    printLong((long) i,false);
  }

  public void print(Integer I)
  {
    printLong(I.longValue(),false);
  }

  public void print(double d)
  {
    printDouble(d,false);
  }

  public void print(Double D)
  {
    printDouble(D.doubleValue(),false);
  }

  public void print(float f)
  {
    printDouble((double) f,false);
  }

  public void print(Float F)
  {
    printDouble(F.doubleValue(),false);
  }

  public void print(String S)
  {
    printString(S,false);
  }

  public void print(char c)
  {
    printString(String.valueOf(c),false);
  }

  public void print(Object O)
  {
    printString(O.toString(),false);
  }
  
  /*
   * println functions
   */
  
  public void println(boolean b)
  {
    printString(b ? "true" : "false",true);
  }  
  
  public void println(byte b)
  {
    printLong((long)b,true);
  } 
  
  public void println(Byte b)
  {
    printLong(b.longValue(),true);
  }   
  
  public void println(short s)
  {
    printLong((long)s,true);
  } 
  
  public void println(Short s)
  {
    printLong(s.longValue(),true);
  }  

  public void println(long l)
  {
    printLong(l,true);
  }

  public void println(Long L)
  {
    printLong(L.longValue(),true);
  }

  public void println(int i)
  {
    printLong((long) i,true);
  }

  public void println(Integer I)
  {
    printLong(I.longValue(),true);
  }

  public void println(double d)
  {
    printDouble(d,true);
  }

  public void println(Double D)
  {
    printDouble(D.doubleValue(),true);
  }

  public void println(float f)
  {
    printDouble((double) f,true);
  }

  public void println(Float F)
  {
    printDouble(F.doubleValue(),true);
  }

  public void println(String S)
  {
    printString(S,true);
  }

  public void println(char c)
  {
    printString(String.valueOf(c),true);
  }

  public void println(Object O)
  {
    printString(O.toString(),true);
  }

  public void println() 
  {
    theStream.println();

    if (alwaysFlush)
      theStream.flush();
  }

  public void flush()
  {
    theStream.flush();
  }


  static public void main(String[] args)
  {
    ;
  }

}







