/***********************
 *
 *  KbdInput.cc - KbdInput class code
 *
 ***********************/

#include "KbdInput.hh"

#include <stdio.h>
#include <sgtty.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>

static char pgetchar();
static int pintro();
static int pexit();
static struct sgttyb sg;

KbdInput::KbdInput()
{
  rawInputIsOn = 0;
  on();
}

KbdInput::~KbdInput()
{
  off();
}

int
KbdInput::isOn()
{
  return rawInputIsOn;
}

void
KbdInput::on()
{
  if (!rawInputIsOn)
  {
    pintro();
    rawInputIsOn = 1;
  }
}

void
KbdInput::off()
{
  if (rawInputIsOn)
  {
    pexit();
    rawInputIsOn = 0;
  }
}

char
KbdInput::nextChar()
{
  return ( pgetchar() );
}

static
char
pgetchar()
{
  char thechar;
  read(0, &thechar, sizeof(thechar));  /* 0 == stdin */
  if (errno == EWOULDBLOCK) {
    errno = 0;
    return 0;}
  else {
    return thechar;
  }
}

static
void
dopexit(int signal)
{
  pexit();
  exit(1);
}

static
int
pintro()
{
  int pexit();
  signal(SIGINT, dopexit);
  fcntl(0, F_SETFL, O_NONBLOCK);   
  ioctl(0, TIOCGETP, &sg);  
  sg.sg_flags |= RAW;  
  sg.sg_flags &= ~ECHO;  
  ioctl(0, TIOCSETP, &sg);  
  return 1;
}

static
int
pexit()
{
  sg.sg_flags &= ~RAW; 
  sg.sg_flags |= ECHO;
  ioctl(0, TIOCSETP, &sg);
  fcntl(0, F_SETFL, 0);
  return 1;
}


