/***********************
 *
 *  Timing.cc - Timing class code
 *
 ***********************/

#include "Timing.hh"

Timing::Timing()
{
  reset();
}

Timing::~Timing()
{
  ;
}

long int
Timing::randomLongInt()
{
  gettimeofday(&tp, NULL); 
  long int L =  tp.tv_sec ^ tp.tv_usec; // ^ is xor
  return(L);
}

void
Timing::wait(double seconds)
{
  double fixedTime = getCurrentTime();
  while ( fixedTime + seconds > getCurrentTime() );
}

void
Timing::reset()
{
  getCurrentTime();
  heldTime = currentTime;
  loopHasBegun = 0;
  loopIterations = 0;
}

double
Timing::getCurrentTime()
{
  gettimeofday(&tp, NULL); 
  currentTime = (double)tp.tv_sec + tp.tv_usec/1000000.0;
  return(currentTime);
}

void
Timing::loopInfo(double nOfSecondsPerPrint)
{
  if (!loopHasBegun) {
    reset();
    loopHasBegun = 1;}
  else {
    ++loopIterations;
    getCurrentTime();
    if ( heldTime + nOfSecondsPerPrint < currentTime ) {
      double loopsPerSecond = loopIterations/(currentTime-heldTime);
      cerr << loopsPerSecond << " loops per second\n";
      heldTime = currentTime;
      loopIterations = 0;
    }
  }
}
