The main file for calculating medians and diameters is `RunTests.py`. To compute a single median reconciliation or the median reconciliation graph, use `DTLMedian.py`. To compute aggregate statistics about an entire data set, use `DataAnalysis.py`.

## How to use RunTests.py

### The RunTests.py CLI

Running RunTests from the command line has the following usage pattern:

> RunTests.py [options] file d t l

In this command, `file` is the relative path to the newick file you wish to compute the diameter of, `d`, `t`, and `l` are the event costs. Specifically, `d` is the event cost of duplications, `t` is the event cost of transfers, and `l` is the event cost of losses. This command will calculate the diameter of the file, and print the result to the screen.

#### Optional Flags

There are several flags availible:

* `-l` or `--log` takes one argument, a path to a csv file. It will log the results of the calculation to a row in the provided csv file, creating the file if necessary. Be sure to specify a path without a file extension, as this program will add one for you. 

* `-q` or `--quiet` supresses all text output (except that generated by the `-i` flag).

* `-i` or `--iterate` takes two arguments, and tells the program to iterate over several numbered files and perform the calculation. This first argument is the starting number, and the second argument is the ending number. Note that when this flag is active, the `file` required argument will replace any `#` characters in the file name with whatever number it is currently on, and use that file in its current calculation.

* `-L` or `--loud` prints the bell character after each failed iteration when using the `-i` flag.

* `-d` or `--debug` prints out every (reasonably sized) dynamic programming table generated by this program.

Some flags add extra computations that are output to the screen or logged to a csv file, in addition to the diameter. Those flags are:

* `-z` or `--zero-loss` calculates the diameter when losses do not contribute to the total.

* `-m` or `--median-count` calculates the number of median reconciliations

* `-M` or `--median-diameter` calculates the diameter of the median space

* `-w` or `--worst-median` calculates the distance of a median reconciliation to the furthest MPR, when the median reconciliation is chosen to maximize that distance.

* `-c` or `--cluster` takes one argument, a number. It will select that many median reconciliations at random, and find the distance from each one to the furthest MPR. Usage of the log (`-l`) flag is mandatory when using this mode as it will generate a log file for each file that is calculated, in addton to recording the average, mean, best, and worst distances computed, and the total number of unique medians seen, in the regular logfile.

There is also limited capability to output reconciliation graphs to SIF files, for viewing in external tools, like Cytoscape. These are controlled by two flags:

* `-s` or `--save-graph` saves the entire MPR DTL reconciliation graph to an SIF file in the folder `graphs/`.

* `-S` or `--save-median-graph` saves the median-space DTL reconciliation graph to an SIF file in the folder `graphs/`.


#### Examples

To calculate a single diameter from file `tree1.newick` with costs `D=2`, `T=3`, and `L=1`, use

> python RunTests.py tree1.newick 2 3 1

To log the result to the end of a log file `Results.csv`, use

> python RunTests.py -l Results tree1.newick 2 3 1 

To calculate the diameters for files `tree1.newick`, `tree2.newick`, and `tree4.newick`, use

>python RunTests.py -i 1 5 tree#.newick 2 3 1

The program will skip over the non-existent `tree3.newick`.

To calculate the diameters for every file in the TreeLifeData folder, logging the result to COG_results.csv, while suppressing text and showing tables, use

>python RunTests.py -i 1 6000 -l COG_results -qd TreeLifeData/COG####.newick 2 3 1

To calculate the zero loss diameter of `tree1.newick`, use

> python RunTests.py -z tree1.newick 2 3 1

To calculate the number of medians, the diameter of the median space, and the distance of the worst median from the furthest MPR of `tree1.newick` and log it to `logs/median.csv`, use

> python RunTests.py -mMw -l "logs/median" tree1.newick 2 3 1

To calculate 100 random medians of the entire TreeLifeData dataset, make a warning sound any time the process fails, and log the results to a folder called `results` use

> python RunTests.py -c 100 -L -l results TreeLifeData/COG####.newick 2 3 1

### Via Interactive Mode:

To calculate the diameter for a single file in interactive mode, use `calculate_diameter_from_file`. To get the diameters for a set of numbered files, use `repeatedly_calculate_diameter`.

## How to Use DTLMedian.py

### From the Command Line

DTLMedian.py has the following usage pattern:

> DTLMedian.py filename dup_cost transfer_cost loss_cost [-r] [-c]

`filename` is the path to a `.newick` file containing the two trees and the tip mapping. The cost parameters specify the relative cost of duplication, transfer and loss which should be inversely proportional to the frequency of those events. By default, all valid calls will return the full median reconciliation, however the user may add to the output by including the options shown below.

#### Optional Flags

* -r or --random: adds a random median MPR, drawn from the median reconciliation, to the output

* -c or --count: adds the number of median MPRs that could be derived from the median reconciliation to the output

If both of these options are selected, the order of the printed output is: the median reconciliation, the number of medians, a randomly selected median.

## How To Use DataAnalysis.py

### From the Command Line

#### Required Argument:

Running DataAnalysis from the command line has the following usage pattern:

> DataAnalysis.py [options] file

In this command, `file` is the relative path to the csv file (output by Diameter.py) you wish to analyze. By default DataAnalysis will find the minimum, maximum, median, and mean of:
* The number of MPRs
* The diameter found
* The size of the gene tree
* The normalized diameter

and the running time of

* Building the DTL reconciliation graph
* Calculating the diameter
* Both combined

#### Optional Flags

`-p`: show plots. By default, DataAnalysis will plot the normalized diameter against gene tree size and MPR count.

`-n`: include another plot that uses the non-normalized diameter.

`-t`: include another plot that plots the timings of the different portions of Diameter.

`-z`: also make all plots for a zero loss version of the logfile (it will look for one with the same name but ending in `\_zl`)

`-l`: LaTeX for plot text rendering

In addition to those plot options, there are a couple more usable flags:

`-c COMPARE_FILE` compares the given csv file with another one (`COMPARE_FILE`) that has the same calculated files in the same order. It will note any mismatches between the two file's diameters.

`-k CHECK_PATH` compares the given csv file with the path that the newick files you originally reconciled reside (`CHECK_PATH`), and notifies you of any duplicate files in your log, or files in the path that are not in the log.

