#! /usr/bin/env python
import sys
import os
import time
import threading


#while True:
#    line = sys.stdin.readline()
#    if line == '':
#        break
#    print line.strip()
#    os.system('say \'%s\'' % line.strip())

statements = []
statementsLock = threading.Lock()
statementsAvailible = threading.Event()


def consume():
    while True:
        statementsAvailible.wait()
        statementsLock.acquire()
        statement = statements[-1]
        #for s in statements:
        #    print string.strip(s)
        del statements[:]
        statementsAvailible.clear()
        statementsLock.release()
        os.system('say \'%s\'' % statement.strip())

def produce():
    while True:
        line = sys.stdin.readline()
        if line == '':
            return
        print line.strip()
        statementsLock.acquire()
        statements.append(line)
        statementsAvailible.set()
        statementsLock.release()

if __name__ == '__main__':
    consumer = threading.Thread(target=consume, name='consumer')
    consumer.setDaemon(True);
    consumer.start()
    produce()
