
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <string>
#include <math.h>
#include <cv.h>
#include <cxcore.h>
#include <highgui.h>
#include "BlobResult.h"

using namespace std;

/* Global variables */

char imageWindowName[] = "VideoTool";
//char paintedWindowName[] = "Undistorted image";
char paintedWindowName[] = "Painted image";

void setGlobals();  // the code appears at the very bottom of this file

// Our global color definitions...
/* Grey tracking:
double Hue_Min = 0.0;
double Hue_Max = 1.0;
double Sat_Min = 0.0;
double Sat_Max = 0.25;
double Val_Min = 0.0;
double Val_Max = 1.0;
 */
/* Yellow Ball Tracking (Dodd's lab)
double Hue_Min = 0.13;
double Hue_Max = 0.25;
double Sat_Min = 0.5;
double Sat_Max = 1.0;
double Val_Min = 0.7;
double Val_Max = 1.0;
 */
/* Yellow Page Tracking (Dorm room)
 */
double Hue_Min = 0.13;
double Hue_Max = 0.25;
double Sat_Min = 0.5;
double Sat_Max = 1.0;
double Val_Min = 0.5;
double Val_Max = 1.0;
/*
 */


// Function Prototypes
void RGBtoHSV( double r, double g, double b, double *h, double *s, double *v );
bool isColor(int r, int g, int b, double h, double s, double v);
void processColor( IplImage* frame, IplImage* f_p );
bool checkKeyPresses();

// here, static refers to the fact that these variables
// are local to this file (they're not available in other files,
// which is safer because it allows reuse of their names)
static CvSize imageSize;
static CvPoint old_click_pt;
static CvPoint new_click_pt;
static double framenum;

// global points for drawing boxes, defining loops, etc.
static CvPoint centerPoint;
static CvPoint scanBox;
static CvPoint scanBox2;


// more global variables
// these are simply recording all the different states you
// can put the program in via the keyboard
static bool bmpRecording = false;
static bool capturing = true;
static bool getImageFromFile = false;
static bool getImageAgainFromFile = false;
static bool getImage0FromMyImages = false;
static bool saveNextImage = false;
static bool quittingTime = false;
static bool detectColor = true;
static bool showing_savedImage = false;
static bool saveOnlyOneImageToFile = true;
static bool firstTimeForSet = true;

static char* filename = new char[150];
static char* filename2 = new char[150];
static int frameNumber = 0;
static int keyCode = -1;

// pointers to images in memory
static IplImage *frame;
static IplImage* frame_painted;

static IplImage** setimages;


// handle mouse clicks here
void mouse_callback(int event, int x, int y, int flags, void* param)
{
    if (event == CV_EVENT_LBUTTONDOWN)
    {
        // cout << "(x,y) = (" << x << "," << y << ")" << endl;

        // reset old_click_pt
        old_click_pt.x = new_click_pt.x;
        old_click_pt.y = new_click_pt.y;

        // get new click point -- note the coordinate change in y
        new_click_pt.x = x;  // coming in from the window system
        new_click_pt.y = imageSize.height-y;  // window system and images have different y axes
    }
}


// print pixel information
void pixelInformation(IplImage* f)
{
    if (f == NULL) return;

    // see if things have changed...
    if (new_click_pt.x != old_click_pt.x || new_click_pt.y != old_click_pt.y) // has it changed?
    {
        if (new_click_pt.x < 0 || new_click_pt.x > imageSize.width-1 || new_click_pt.y < 0 || new_click_pt.y > imageSize.height-1) return;
        // draw a line from old to new
        // cvLine(frame,old_click_pt,new_click_pt,CV_RGB(255,0,0),/*thickness*/1,/*connectivity*/8);
        // set the old = the new
        old_click_pt.x = new_click_pt.x;
        old_click_pt.y = new_click_pt.y;
        // print the RGB values and coordinates of the newly clicked point:
        // note that blue is #0, green is #1, and red is #2 !!

        /* note that this uses the undistorted frame right here... */

        // this is insane!!!
        // see the processColor function for an explanation
        // of why we need "realy" for images from file
        int realy = new_click_pt.y;
        if (true || getImageAgainFromFile || getImageFromFile) 
        {
            realy = imageSize.height - realy;
        }
        uchar* pixel = cvPtr2D(f,realy,new_click_pt.x);

        cout << "(x,y) = (" << new_click_pt.x << "," << new_click_pt.y << ") with (r,g,b) = ("
             << (int)(pixel[2]) << "," << (int)(pixel[1]) << "," << (int)(pixel[0]) << ")" << endl;

        double hue,sat,val;
        RGBtoHSV((double)pixel[2],(double)pixel[1],(double)pixel[0],&hue,&sat,&val);

        cout << "           and (h,s,v) = (" << hue << "," << sat << "," << val << ")" << endl;
    }
}



/* End of globals */

int main(int argc, char *argv[])
{
    /* start of our frame-grabbing program */

    setGlobals();

    cvNamedWindow( imageWindowName, CV_WINDOW_AUTOSIZE );
    cvNamedWindow( paintedWindowName, CV_WINDOW_AUTOSIZE );


    /*
     * set up the mouse input
     */
    //cvSetMouseCallback( imageWindowName, mouse_callback );
    cvSetMouseCallback( imageWindowName, mouse_callback /*theMouseCallback*/ );

    /*
     * more camera-specific stuff
     */
    CvCapture* capture = 0;
    capture = cvCaptureFromCAM(0);

    // this is allocating the undis_frame once (it will get written each time)
    // get one frame and then copy it...
    if (cvGrabFrame(capture)) 
    {
        frame = cvRetrieveFrame( capture );
        frame_painted = cvCloneImage(frame);
    }
    else
    {
        cout << "No camera??" << endl;
        capturing = false;
    }

    // main loop
    while (!quittingTime)
    {
        /*
         * live video capture
         */
        if (capturing)
        {
            if( !cvGrabFrame( capture ))   break;
            frame = cvRetrieveFrame( capture );
            if( !frame ) break;

            cvReleaseImage(&frame_painted);
            frame_painted = cvCloneImage(frame);
        }
        /*
         * takeing image frames from file
         */
        else if (getImageFromFile || getImageAgainFromFile)
        {
            /*
             * first-time load from file
             */
            if (getImageFromFile) {  
                // ask for a frame filename
                int i;
                // should factor this path out!!
                if (getImage0FromMyImages) { 
                    i = 0;
                    getImage0FromMyImages = false;
                }
                else {
                    cout << "What image number (in .\\MyImages): ";
                    cin >> i;
                }
                sprintf(filename2,".\\MyImages\\image%05d.bmp",i);
                // we probably need to release the images returned by cvLoadImage somewhere...
                //frame = cvLoadImage(filename2);
                //cvReleaseImage(&frame);
                frame = cvLoadImage(filename2);
                cvReleaseImage(&frame_painted);
                frame_painted = cvLoadImage(filename2);
                if (frame == NULL) {
                    cout << "Could not find that image.\n";
                    continue;
                }
                getImageFromFile = false;
                getImageAgainFromFile = true;
            }
            /*
             * future loads just need to clear the drawing image
             */
            else if (getImageAgainFromFile) {
                cvReleaseImage(&frame_painted);
                frame_painted = cvCloneImage(frame);
            }
        }
        /*
         * this doesn't seem necessary...
         */
        else
        {
            ;
        }

        /*
         * this call will check for any mouse clicks, non-blocking
         *
         * ** click only on the undis_image (undistorted image) **
         */
        pixelInformation(frame);

        // save images to a file, if desired
        if (bmpRecording == true && capturing == true)
        {
            // this will write the file to the subfolder MyImages
            // in the directory in which the .sln file is located
            sprintf(filename2,".\\MyImages\\image%05d.bmp",frameNumber);
            cout << "Captured single image named: " << filename2 <<  endl;
            cvSaveImage(filename2,frame);
            ++frameNumber;

            // stop recording if we only wanted one image
            if (saveOnlyOneImageToFile == true) bmpRecording = false;
        }

        // here we can add graphics to each frame
        // in order that they show up on the screen
        // we also decide what to display in this routine
        if (detectColor == true)
        {
            processColor(frame,frame_painted);
        }

        /*
         * Find the yellow ball blob.
         */
        IplImage* gray = cvCreateImage(cvSize(frame_painted->width,
                frame_painted->height), IPL_DEPTH_8U, 1);
        cvCvtColor(frame_painted, gray, CV_BGR2GRAY);
        CBlobResult blobs;
        blobs = CBlobResult(gray, NULL, 100, true );
        blobs.Filter( blobs, B_INCLUDE, CBlobGetMean(), B_GREATER, 200);
        CBlob yellowBall;
        blobs.GetNthBlob(CBlobGetArea(), 0, yellowBall);
        blobs.PrintBlobs("blobres");
        yellowBall.FillBlob(frame_painted, CV_RGB(255, 255, 0));
        int errorX = int(CBlobGetXCenter()(yellowBall)) - (centerPoint.x);
        int errorY = int(CBlobGetYCenter()(yellowBall)) - (centerPoint.y);
        const int maxError = 75;
        const int minArea = 50;
        if (yellowBall.Area() >= minArea)
        {
            if (abs(errorX) <= maxError && abs(errorY) <= maxError ||
                    CBlobGetXYInside(centerPoint)(yellowBall))
            {
                cout << "go";
            }
            else
            {
                if (errorX > maxError)
                {
                    cout << "right ";
                }
                else if (errorX < -maxError)
                {
                    cout << "left ";
                }
                if (errorY > maxError)
                {
                    cout << "down";
                }
                else if (errorY < -maxError)
                {
                    cout << "up";
                }
            }
            cout << endl;
        }
        
        cvReleaseImage(&gray);

        /*
         * display everything in the windows
         */
        cvShowImage(imageWindowName, frame);  // camera image
        cvShowImage(paintedWindowName, frame_painted);  // undis. image with user's graphics

        if (checkKeyPresses())
            break;
    }

    // release things before quitting
    cvReleaseCapture( &capture );
    cvDestroyWindow("result");

    return 0;
}


// just in case you'd like to use these...
inline double mymin(double a, double b) { return a<b?a:b; }
inline double mymax(double a, double b) { return a>b?a:b; }

// read about HSV at http://en.wikipedia.org/wiki/HSV_color_space
// and http://www.cs.rit.edu/~ncs/color/t_convert.html#RGB%20to%20HSV%20&%20HSV%20to%20RGB
//
// feel free to grab code from above or elsewhere online, if you'd like to 
// be sure you understand what RANGE _your_ code for HSV is "returning"
// in the h, s, and v pointers...
void RGBtoHSV( double r, double g, double b, double *h, double *s, double *v )
{
    double maxRGB;
    double minRGB;
    double delta;

    // get max and min
    if(r >= g && r >= b)
    {
        maxRGB = r;
        if(g >= b)
            minRGB = b;
        else
            minRGB = g;
    }
    else if(g >= b)
    {
        maxRGB = g;
        if(r >= b)
            minRGB = b;
        else
            minRGB = r;
    }
    else
    {
        maxRGB = b;
        if(r >= g)
            minRGB = g;
        else
            minRGB = r;
    }

    delta = maxRGB - minRGB;
    *v = maxRGB/255.0;

    if (maxRGB <= 0.0)
    {
        *h = -1;
        *s = 0;
        return;
    }

    *s = delta/maxRGB;   // better scaling than 255!
    if(delta == 0)
    {
        *h = -1;
        return;
    }

/*
    float f = ((r == minRGB) ? (g - b) : ((g == minRGB) ? b - r : r - g))/255.;
    float i = (r == minRGB) ? 3 : ((g == minRGB) ? 5 : 1);
    *h = i - f /(delta/255.);
*/

    if(r == maxRGB)
        *h = (g - b)/delta;
    else if (g == maxRGB)
        *h = 2 + (b-r)/delta;
    else
        *h = 4 + (r-g)/delta;
    *h = *h / 6;
    if (*h < 0) *h += 1;

}

// this determines whether a pixel is Color or not...
bool isColor(int r, int g, int b, double hue, double sat, double val)
{
    return ((((hue >= Hue_Min) || (Hue_Min < 0 && hue >= Hue_Min + 1)) &&
                (hue <= Hue_Max))  || hue == -1) &&
        (sat >= Sat_Min) && (sat <= Sat_Max) &&
        (val >= Val_Min) && (val <= Val_Max);
}

// here is where we seek out the color and indicate what we've found
// the input named "frame" is the source location of our pixels
// the "output" named f_p is the destination for drawing
void processColor(IplImage* frame, IplImage* f_p)
{
    // some useful local variables...
    int r,g,b;
    double hue,sat,val;

    // pixels are handled as uchar*'s
    uchar* color;     // a pixel from the input, "frame"
    uchar* painted;   // a pixel from the output, "painted"

    // this draws a rectangle from scanBox to scanBox2 with the color
    // specified by the three RGB values in the CV_RGB macro
    // the R, G, and B channels are all 0 to 255...

    // see the "this is insane!" caution below in order to
    // use graphics on the live video stream...
    //cvRectangle(f_p, scanBox, scanBox2, CV_RGB(0,0,255), 1); // 1 == thickness
    //cvCircle( f_p, scanBox, 10,  CV_RGB(255,255,0), /*thickness*/ 1 );

    // This loops through the pixels in the rectangle specified
    // by scanBox and scanBox2 (see setGlobals for their corners)

    int xtotal = 0;
    int ytotal = 0;
    int xlow = (int)mymin(scanBox.x,scanBox2.x);
    int xhi = (int)mymax(scanBox.x,scanBox2.x);
    int ylow = (int)mymin(scanBox.y,scanBox2.y);
    int yhi = (int)mymax(scanBox.y,scanBox2.y);
    for (int x = xlow; x<xhi; x++)      //the x direction goes left to right       
    {
        for (int y = ylow; y<yhi; y++)  //the y direction goes top to bottom
        {
            // this is insane!!!
            // unfortunately, access to the pixels is different depending on
            // the source of the pixels: static images and video reverse their
            // y orientations

            // we handle this here...
            int realy = y;
            if (getImageAgainFromFile || getImageFromFile) 
            {
                realy = imageSize.height - realy;  // reverse if static image
            }

            // note that we need to use "realy" in each of these cases
            color = cvPtr2D(frame,realy,x);    // get the pixel we care about
            painted = cvPtr2D(f_p,realy,x);    // get the pixel we (might) change

            r = (double)(color[2]);  // the red component of the pixel we care about
            g = (double)(color[1]);  // the green component of the pixel we care about
            b = (double)(color[0]);  // the blue component of the pixel we care about

            RGBtoHSV(r,g,b,&hue,&sat,&val);

            if(isColor(r,g,b,hue,sat,val) &&
                    x > xlow && y > ylow && x < xhi-1 && y < yhi-1)
            {
                painted[2] = 255;
                painted[1] = 255;
                painted[0] = 255;
            }
            else {
                painted[2] = 0;
                painted[1] = 0;
                painted[0] = 0;
            }
            
        }
    }
}

bool checkKeyPresses()
{
    /*
     * conditionals to handle keypresses
     *
     * gets keypress and checks for 'q' to quit
     */
    if( (keyCode = cvWaitKey( 10 )) == ((int)'q') ) {
        return true;                       // quit everything
    }
    else if (keyCode == (int)'1') {
        if(Hue_Max - .01 >= -.5) Hue_Max -= .01;
    }
    else if (keyCode == (int)'2') {
        if(Hue_Max + .01 <= 1.0) Hue_Max += .01;
    }
    else if (keyCode == (int)'3') {
        if(Sat_Max - .01 >= 0) Sat_Max -= .01;
    }
    else if (keyCode == (int)'4') {
        if(Sat_Max + .01 <= 1.0) Sat_Max += .01;
    }
    else if (keyCode == (int)'5') {
        if(Val_Max - .01 >= 0) Val_Max -= .01;
    }
    else if (keyCode == (int)'6') {
        if(Val_Max + .01 <= 1.0) Val_Max += .01;
    }
    else if (keyCode == (int)'!') {
        if(Hue_Min - .01 >= -.5) Hue_Min -= .01;
    }
    else if (keyCode == (int)'@') {
        if(Hue_Min + .01 <= 1.0) Hue_Min += .01;
    }
    else if (keyCode == (int)'#') {
        if(Sat_Min - .01 >= 0) Sat_Min -= .01;
    }
    else if (keyCode == (int)'$') {
        if(Sat_Min + .01 <= 1.0) Sat_Min += .01;
    }
    else if (keyCode == (int)'%') {
        if(Val_Min - .01 >= 0) Val_Min -= .01;
    }
    else if (keyCode == (int)'^') {
        if(Val_Min + .01 <= 1.0) Val_Min += .01;
    }
    else if (keyCode == (int)'p' || keyCode == int('P')) {
        cout << "Hue_Max: " << Hue_Max << " Hue_Min: " << Hue_Min << endl;
        cout << "Sat_Max: " << Sat_Max << " Sat_Min: " << Sat_Min << endl;
        cout << "Val_Max: " << Val_Max << " Val_Min: " << Val_Min << endl;
    }
    /*
     * write frames to file == 'f'
     */
    else if (keyCode == (int)'f') {                           
        if (bmpRecording) {
            cout << "Stopping the writing to bitmaps\n";
            bmpRecording = false;
        } else {
            cout << "Starting to write to bitmaps\n";
            bmpRecording = true;
        }
        showing_savedImage = false;
    } 
    /*
     * gets image from a file # in ./MyImages (hardcoded)
     */
    else if (keyCode == (int)'g') {
        cout << "Getting image from file.\n";
        capturing = false;
        getImageFromFile = true;
        getImageAgainFromFile = false;
        bmpRecording = false;
        saveNextImage = false;
        showing_savedImage = true;
    } 
    /*
     * toggle continuous video
     */
    else if (keyCode == (int)'s') {
        if (capturing) {
            cout << "Stopping continuous capturing.\n";
            capturing = false;
            getImageFromFile = false;
        } else {
            cout << "Starting continuous capturing.\n";
            capturing = true;
            getImageFromFile = false;
            getImageAgainFromFile = false;
            /* reset undis_image */
            // note this assumes that everything went well
            // initially with the first captured frame... !!
            //cvReleaseImage(&undis_frame);
            //undis_frame = cvCloneImage(frame);
            cvReleaseImage(&frame_painted);
            frame_painted = cvCloneImage(frame);
            // not to mention that these transition images have to be released!
        }
        showing_savedImage = false;
    } 
    else if (keyCode == (int)'e') {
        // emulate server behavior
        saveNextImage = true;
        showing_savedImage = false;
    } 
    /*
     * toggle finding color (and displaying)
     */
    else if (keyCode == (int)'r') {
        detectColor = !detectColor;
    }
    /*
     * the spacebar advances the image in the VideoBMPs directory
     */
    else if (keyCode == (int)' ') {
        if (showing_savedImage == true)
        {
            int i;
            // get the last frame number from the variable filename2
            sscanf(filename2,".\\MyImages\\image%05d.bmp",&i);
            // reset filename2 to hold the next frame number
            sprintf(filename2,".\\MyImages\\image%05d.bmp",++i);
            cvReleaseImage(&frame);
            frame = cvLoadImage(filename2);
            cvReleaseImage(&frame_painted);
            frame_painted = cvLoadImage(filename2);

            // wrap around! (if necessary)
            if (frame == NULL) 
            {
                i = 0;
                sprintf(filename2,".\\MyImages\\image%05d.bmp",i);
                cvReleaseImage(&frame);
                frame = cvLoadImage(filename2);
                cvReleaseImage(&frame_painted);
                frame_painted = cvLoadImage(filename2);
                //continue;
            }
            else 
            {
                // we should be OK to keep going now
                cout << "Getting image " <<  i << " from .\\MyImages.\n";
                getImageAgainFromFile = true;
                getImageFromFile = false;
            }
        }
        /*
         * initial hit of the space bar...
         */
        else {
            cout << "No image from file is currently showing..." << endl;
            cout << "Getting image 0 from .\\MyImages.\n";
            capturing = false;
            getImageFromFile = true;
            getImageAgainFromFile = false;
            getImage0FromMyImages = true;
            bmpRecording = false;
            saveNextImage = false;
            showing_savedImage = true;
        }
    }
    return false; // Don't quit yet.
}
    

void setGlobals()
{
    // mouse click locations (old and new, to tell if we've
    // clicked on a new point
    old_click_pt.x = 0;
    old_click_pt.y = 0;
    new_click_pt.x = 0;
    new_click_pt.y = 0;


    // theseimage sizes are hard-coded, but should probably be obtained for each
    // image individually -- however, with our cameras and images, this is safe.
    imageSize.width = 640; imageSize.height = 480;

    // set up some global points for drawing, etc.
    centerPoint.x = imageSize.width/2;
    centerPoint.y = imageSize.height/2;

    scanBox.x = 0;   // p4 and p5 are the rectangle in which we
    scanBox.y = 0;   // search for pixels of the correct h, s, v...

    scanBox2.x = imageSize.width;
    scanBox2.y = imageSize.height;

}

