
/* File: tables.c */

/*
 * Change directions to offsets.  Nearby grids and LOS to them.
 * Effects of stats, Deadliness, melee blows, speed to energy, experience,
 * racial costs for skills, racial stat and ability adjustments.  Spell
 * data and titles.  Chest traps, set items, color and stat names.
 * Window names, option names, descriptions, and default values.  Custom
 * display text, inscription text.  Monster spells.  Skills, talents,
 * object flags, precognition messages.
 *
 * Copyright (c) 1998 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"


/*
 * Global array for looping through the "keypad directions"
 */
const s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
const s16b ddx[10] =
{  0, -1,  0,  1, -1,  0,  1, -1,  0,  1 };

const s16b ddy[10] =
{  0,  1,  1,  1,  0,  0,  0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
const s16b ddx_ddd[9] =
{  0,  0,  1, -1,  1, -1,  1, -1,  0 };

const s16b ddy_ddd[9] =
{  1, -1,  0,  0,  1,  1, -1, -1,  0 };


/*
 * Number of grids in circles with radii from 0 to 5
 */
byte grids_in_radius[6] =
{
	1, 9, 21, 37, 61, 89
};

/*
 * Hack -- quick way to scan nearby grids up to radius 3
 */
s16b nearby_grids_y[37] =
{
	 0,

	 1,  0, -1,  0,  1, -1, -1,  1,

	 2,  0, -2,  0,  2,  1, -1, -2, -2, -1,  1,  2,

	 3,  0, -3,  0,  3,  1, -1, -3, -3, -1,  1,  3,  2, -2, -2,  2
};
s16b nearby_grids_x[37] =
{
	 0,

	 0,  1,  0, -1,  1,  1, -1, -1,

	 0,  2,  0, -2,  1,  2,  2,  1, -1, -2, -2, -1,

	 0,  3,  0, -3,  1,  3,  3,  1, -1, -3, -3, -1,  2,  2, -2, -2
};

/*
 * For all grids within a distance of five from an origin at (5, 5),
 * store the grids that could block line of sight to it.  -LM-
 *
 * For example, LOS to the origin and all neighors is blocked by nothing,
 * but LOS to the grid (10, 6) can be blocked at (6, 5) and (7, 5).
 *
 * Calculated using "los()", but slightly stricter at long range to
 * avoid "pockets".
 */
byte los_nearby_table[803] =
{
   5,  5, 100,
   4,  4, 100,
   4,  5, 100,
   4,  6, 100,
   5,  4, 100,
   5,  6, 100,
   6,  4, 100,
   6,  5, 100,
   6,  6, 100,
   3,  4,  4,  5, 100,
   3,  5,  4,  5, 100,
   3,  6,  4,  5, 100,
   4,  3,  5,  4, 100,
   4,  7,  5,  6, 100,
   5,  3,  5,  4, 100,
   5,  7,  5,  6, 100,
   6,  3,  5,  4, 100,
   6,  7,  5,  6, 100,
   7,  4,  6,  5, 100,
   7,  5,  6,  5, 100,
   7,  6,  6,  5, 100,
   2,  4,  3,  4,  4,  5, 100,
   2,  5,  3,  5,  4,  5, 100,
   2,  6,  3,  6,  4,  5, 100,
   3,  3,  4,  4, 100,
   3,  7,  4,  6, 100,
   4,  2,  4,  3,  5,  4, 100,
   4,  8,  4,  7,  5,  6, 100,
   5,  2,  5,  3,  5,  4, 100,
   5,  8,  5,  6,  5,  7, 100,
   6,  2,  5,  4,  6,  3, 100,
   6,  8,  5,  6,  6,  7, 100,
   7,  3,  6,  4, 100,
   7,  7,  6,  6, 100,
   8,  4,  6,  5,  7,  4, 100,
   8,  5,  6,  5,  7,  5, 100,
   8,  6,  6,  5,  7,  6, 100,
   1,  4,  2,  4,  3,  4,  3,  5,  4,  5, 100,
   1,  5,  2,  5,  3,  5,  4,  5, 100,
   1,  6,  2,  6,  3,  5,  3,  6,  4,  5, 100,
   2,  2,  3,  3,  4,  4, 100,
   2,  3,  3,  3,  3,  4,  4,  4,  4,  5, 100,
   2,  7,  3,  6,  3,  7,  4,  5,  4,  6, 100,
   2,  8,  3,  7,  4,  6, 100,
   3,  2,  3,  3,  4,  3,  4,  4,  5,  4, 100,
   3,  8,  3,  7,  4,  6,  4,  7,  5,  6, 100,
   4,  1,  4,  2,  4,  3,  5,  3,  5,  4, 100,
   4,  9,  4,  7,  4,  8,  5,  6,  5,  7, 100,
   5,  1,  5,  2,  5,  3,  5,  4, 100,
   5,  9,  5,  6,  5,  7,  5,  8, 100,
   6,  1,  5,  3,  5,  4,  6,  2,  6,  3, 100,
   6,  9,  5,  6,  5,  7,  6,  7,  6,  8, 100,
   7,  2,  5,  4,  6,  3,  6,  4,  7,  3, 100,
   7,  8,  5,  6,  6,  6,  6,  7,  7,  7, 100,
   8,  2,  6,  4,  7,  3, 100,
   8,  3,  6,  4,  6,  5,  7,  3,  7,  4, 100,
   8,  7,  6,  5,  6,  6,  7,  6,  7,  7, 100,
   8,  8,  6,  6,  7,  7, 100,
   9,  4,  6,  5,  7,  4,  7,  5,  8,  4, 100,
   9,  5,  6,  5,  7,  5,  8,  5, 100,
   9,  6,  6,  5,  7,  5,  7,  6,  8,  6, 100,
   0,  4,  1,  4,  2,  4,  2,  5,  3,  5,  4,  5, 100,
   0,  5,  1,  5,  2,  5,  3,  5,  4,  5, 100,
   0,  6,  1,  6,  2,  6,  2,  5,  3,  5,  4,  5, 100,
   1,  2,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,  4,  5, 100,
   1,  3,  2,  3,  2,  4,  3,  4,  4,  4,  4,  5, 100,
   1,  7,  2,  6,  2,  7,  3,  6,  4,  5,  4,  6, 100,
   1,  8,  2,  7,  2,  8,  3,  6,  3,  7,  4,  5,  4,  6, 100,
   2,  1,  2,  2,  3,  2,  3,  3,  4,  3,  4,  4,  5,  4, 100,
   2,  9,  2,  8,  3,  7,  3,  8,  4,  6,  4,  7,  5,  6, 100,
   3,  1,  3,  2,  4,  2,  4,  3,  4,  4,  5,  4, 100,
   3,  9,  3,  8,  4,  6,  4,  7,  4,  8,  5,  6, 100,
   4,  0,  4,  1,  4,  2,  5,  2,  5,  3,  5,  4, 100,
   4, 10,  4,  8,  4,  9,  5,  6,  5,  7,  5,  8, 100,
   5,  0,  5,  1,  5,  2,  5,  3,  5,  4, 100,
   5, 10,  5,  6,  5,  7,  5,  8,  5,  9, 100,
   6,  0,  5,  2,  5,  3,  5,  4,  6,  1,  6,  2, 100,
   6, 10,  5,  6,  5,  7,  5,  8,  6,  8,  6,  9, 100,
   7,  1,  5,  4,  6,  2,  6,  3,  6,  4,  7,  2, 100,
   7,  9,  5,  6,  6,  6,  6,  7,  6,  8,  7,  8, 100,
   8,  1,  5,  4,  6,  3,  6,  4,  7,  2,  7,  3,  8,  2, 100,
   8,  9,  5,  6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8, 100,
   9,  2,  6,  4,  6,  5,  7,  3,  7,  4,  8,  2,  8,  3, 100,
   9,  3,  6,  4,  6,  5,  7,  4,  8,  3,  8,  4, 100,
   9,  7,  6,  5,  6,  6,  7,  6,  8,  6,  8,  7, 100,
   9,  8,  6,  5,  6,  6,  7,  6,  7,  7,  8,  7,  8,  8, 100,
  10,  4,  6,  5,  7,  5,  8,  5,  8,  4,  9,  4, 100,
  10,  5,  6,  5,  7,  5,  8,  5,  9,  5, 100,
  10,  6,  6,  5,  7,  5,  8,  5,  8,  6,  9,  6, 100
};





/*
 * Global array for converting numbers to uppercase hexadecimal digit
 * This array can also be used to convert a number to an octal digit
 */
const char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Global array for converting letters to indexes and back again.
 *
 * Numerals and '+/-' are near the end to help keep the navigation and
 * manipulation keys free.  '?' is absent to ensure that context-specific
 * help works.
 */
const char index_chars[] =
{
	"abcdefghijklmnopqrstuvwxyz"
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	":;.,\"\'[](){}<>\\/|-_=+~!@#$%^&*`0123456789"
};

/*
 * Similar array for use when we do not want any upper case indexes.
 */
const char index_chars_lower[] =
{
	"abcdefghijklmnopqrstuvwxyz"
	":;.,\"\'[](){}<>\\/|-_=+~!@#$%^&*`0123456789"
};


/*
 * Stat Table (INT/WIS) -- extra tenth-mana-points per level.
 */
const byte adj_mag_mana[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	5	/* 7 */,
	6	/* 8 */,
	7	/* 9 */,
	8	/* 10 */,
	9  /* 11 */,
	10 /* 12 */,
	11	/* 13 */,
	12	/* 14 */,
	13	/* 15 */,
	14	/* 16 */,
	15	/* 17 */,
	16	/* 18/00-18/09 */,
	17	/* 18/10-18/19 */,
	18	/* 18/20-18/29 */,
	19	/* 18/30-18/39 */,
	21	/* 18/40-18/49 */,
	23	/* 18/50-18/59 */,
	26	/* 18/60-18/69 */,
	29	/* 18/70-18/79 */,
	33	/* 18/80-18/89 */,
	37	/* 18/90-18/99 */,
	41	/* 18/100-18/109 */,
	45	/* 18/110-18/119 */,
	50	/* 18/120-18/129 */,
	55	/* 18/130-18/139 */,
	60	/* 18/140-18/149 */,
	65	/* 18/150-18/159 */,
	70	/* 18/160-18/169 */,
	74	/* 18/170-18/179 */,
	78	/* 18/180-18/189 */,
	81	/* 18/190-18/199 */,
	84	/* 18/200-18/209 */,
	87	/* 18/210-18/219 */,
	90	/* 18/220+ */
};

/*
 * Stat Table (INT/WIS) -- Failure rate adjustment (plus 128)
 */
const byte adj_mag_fail[] =
{
	128 +120	/* 3 */,
	128 + 75	/* 4 */,
	128 + 40	/* 5 */,
	128 + 30	/* 6 */,
	128 + 16	/* 7 */,
	128 + 10	/* 8 */,
	128 +  8	/* 9 */,
	128 +  6	/* 10 */,
	128 +  5	/* 11 */,
	128 +  4	/* 12 */,
	128 +  3	/* 13 */,
	128 +  2	/* 14 */,
	128 +  1	/* 15 */,
	128 -  0	/* 16 */,
	128 -  1	/* 17 */,
	128 -  2	/* 18/00-18/09 */,
	128 -  3	/* 18/10-18/19 */,
	128 -  4	/* 18/20-18/29 */,
	128 -  5	/* 18/30-18/39 */,
	128 -  6	/* 18/40-18/49 */,
	128 -  7	/* 18/50-18/59 */,
	128 -  8	/* 18/60-18/69 */,
	128 -  9	/* 18/70-18/79 */,
	128 - 10	/* 18/80-18/89 */,
	128 - 11	/* 18/90-18/99 */,
	128 - 12	/* 18/100-18/109 */,
	128 - 13	/* 18/110-18/119 */,
	128 - 14	/* 18/120-18/129 */,
	128 - 15	/* 18/130-18/139 */,
	128 - 16	/* 18/140-18/149 */,
	128 - 17	/* 18/150-18/159 */,
	128 - 18	/* 18/160-18/169 */,
	128 - 19	/* 18/170-18/179 */,
	128 - 20	/* 18/180-18/189 */,
	128 - 21	/* 18/190-18/199 */,
	128 - 22	/* 18/200-18/209 */,
	128 - 23	/* 18/210-18/219 */,
	128 - 25	/* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentage of normal.
 */
const byte adj_chr_gold[] =
{
	140	/* 3 */,
	135	/* 4 */,
	132	/* 5 */,
	127	/* 6 */,
	123	/* 7 */,
	120	/* 8 */,
	118	/* 9 */,
	116	/* 10 */,
	114	/* 11 */,
	112	/* 12 */,
	110	/* 13 */,
	108	/* 14 */,
	106	/* 15 */,
	104	/* 16 */,
	102	/* 17 */,
	100	/* 18/00-18/09 */,
	99	/* 18/10-18/19 */,
	99	/* 18/20-18/29 */,
	98	/* 18/30-18/39 */,
	98	/* 18/40-18/49 */,
	97	/* 18/50-18/59 */,
	97	/* 18/60-18/69 */,
	96	/* 18/70-18/79 */,
	96	/* 18/80-18/89 */,
	95	/* 18/90-18/99 */,
	94	/* 18/100-18/109 */,
	94	/* 18/110-18/119 */,
	93	/* 18/120-18/129 */,
	92	/* 18/130-18/139 */,
	91	/* 18/140-18/149 */,
	90	/* 18/150-18/159 */,
	89	/* 18/160-18/169 */,
	88	/* 18/170-18/179 */,
	87	/* 18/180-18/189 */,
	85	/* 18/190-18/199 */,
	83	/* 18/200-18/209 */,
	81	/* 18/210-18/219 */,
	80	/* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
const byte adj_int_dev[] =
{
	128 - 18	/* 3 */,
	128 - 10	/* 4 */,
	128 - 6	/* 5 */,
	128 - 3	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 0	/* 16 */,
	128 + 0	/* 17 */,
	128 + 1	/* 18/00-18/09 */,
	128 + 1	/* 18/10-18/19 */,
	128 + 1	/* 18/20-18/29 */,
	128 + 1	/* 18/30-18/39 */,
	128 + 2	/* 18/40-18/49 */,
	128 + 2	/* 18/50-18/59 */,
	128 + 2	/* 18/60-18/69 */,
	128 + 3	/* 18/70-18/79 */,
	128 + 3	/* 18/80-18/89 */,
	128 + 4	/* 18/90-18/99 */,
	128 + 5	/* 18/100-18/109 */,
	128 + 6	/* 18/110-18/119 */,
	128 + 7	/* 18/120-18/129 */,
	128 + 8	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 10	/* 18/160-18/169 */,
	128 + 11	/* 18/170-18/179 */,
	128 + 12	/* 18/180-18/189 */,
	128 + 13	/* 18/190-18/199 */,
	128 + 14	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
const byte adj_wis_sav[] =
{
	128 - 9	/* 3 */,
	128 - 5	/* 4 */,
	128 - 2	/* 5 */,
	128 - 1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 1	/* 8 */,
	128 + 1	/* 9 */,
	128 + 1	/* 10 */,
	128 + 1	/* 11 */,
	128 + 1	/* 12 */,
	128 + 1	/* 13 */,
	128 + 1	/* 14 */,
	128 + 2	/* 15 */,
	128 + 2	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 3	/* 18/10-18/19 */,
	128 + 3	/* 18/20-18/29 */,
	128 + 3	/* 18/30-18/39 */,
	128 + 3	/* 18/40-18/49 */,
	128 + 4	/* 18/50-18/59 */,
	128 + 4	/* 18/60-18/69 */,
	128 + 5	/* 18/70-18/79 */,
	128 + 5	/* 18/80-18/89 */,
	128 + 6	/* 18/90-18/99 */,
	128 + 7	/* 18/100-18/109 */,
	128 + 8	/* 18/110-18/119 */,
	128 + 9	/* 18/120-18/129 */,
	128 + 10	/* 18/130-18/139 */,
	128 + 11	/* 18/140-18/149 */,
	128 + 12	/* 18/150-18/159 */,
	128 + 13	/* 18/160-18/169 */,
	128 + 14	/* 18/170-18/179 */,
	128 + 15	/* 18/180-18/189 */,
	128 + 16	/* 18/190-18/199 */,
	128 + 17	/* 18/200-18/209 */,
	128 + 18	/* 18/210-18/219 */,
	128 + 19	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming (also getting out of pits)
 */
const byte adj_dis[] =
{
	128 - 12	/* 3 */,
	128 - 7	/* 4 */,
	128 - 3	/* 5 */,
	128 - 2	/* 6 */,
	128 - 1	/* 7 */,
	128 - 1	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 1	/* 12 */,
	128 + 1	/* 13 */,
	128 + 1	/* 14 */,
	128 + 2	/* 15 */,
	128 + 2	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 3	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 5	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 5	/* 18/60-18/69 */,
	128 + 6	/* 18/70-18/79 */,
	128 + 6	/* 18/80-18/89 */,
	128 + 7	/* 18/90-18/99 */,
	128 + 8	/* 18/100-18/109 */,
	128 + 8	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 8	/* 18/130-18/139 */,
	128 + 8	/* 18/140-18/149 */,
	128 + 9	/* 18/150-18/159 */,
	128 + 9	/* 18/160-18/169 */,
	128 + 9	/* 18/170-18/179 */,
	128 + 9	/* 18/180-18/189 */,
	128 + 9	/* 18/190-18/199 */,
	128 + 10	/* 18/200-18/209 */,
	128 + 10	/* 18/210-18/219 */,
	128 + 10	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
const byte adj_dex_ta[] =
{
	128 + -12	/* 3 */,
	128 + -7	/* 4 */,
	128 + -4	/* 5 */,
	128 + -2	/* 6 */,
	128 + -2	/* 7 */,
	128 + -1	/* 8 */,
	128 + -1	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 1	/* 16 */,
	128 + 1	/* 17 */,
	128 + 2	/* 18/00-18/09 */,
	128 + 2	/* 18/10-18/19 */,
	128 + 2	/* 18/20-18/29 */,
	128 + 2	/* 18/30-18/39 */,
	128 + 2	/* 18/40-18/49 */,
	128 + 3	/* 18/50-18/59 */,
	128 + 3	/* 18/60-18/69 */,
	128 + 3	/* 18/70-18/79 */,
	128 + 4	/* 18/80-18/89 */,
	128 + 5	/* 18/90-18/99 */,
	128 + 6	/* 18/100-18/109 */,
	128 + 7	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 9	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};

/*
 * Stat Table (DEX) -- bonus to dodging
 */
const byte adj_dex_dodge[] =
{
	0	/* 3 */,
	0	/* 4 */,
	1	/* 5 */,
	2	/* 6 */,
	3	/* 7 */,
	4	/* 8 */,
	5	/* 9 */,
	6	/* 10 */,
	7	/* 11 */,
	8	/* 12 */,
	9	/* 13 */,
	10	/* 14 */,
	11	/* 15 */,
	12	/* 16 */,
	13	/* 17 */,
	14	/* 18/00-18/09 */,
	15	/* 18/10-18/19 */,
	16	/* 18/20-18/29 */,
	17	/* 18/30-18/39 */,
	18	/* 18/40-18/49 */,
	19	/* 18/50-18/59 */,
	20	/* 18/60-18/69 */,
	21	/* 18/70-18/79 */,
	22	/* 18/80-18/89 */,
	23	/* 18/90-18/99 */,
	24	/* 18/100-18/109 */,
	24	/* 18/110-18/119 */,
	25	/* 18/120-18/129 */,
	26	/* 18/130-18/139 */,
	26	/* 18/140-18/149 */,
	27	/* 18/150-18/159 */,
	27	/* 18/160-18/169 */,
	28	/* 18/170-18/179 */,
	28	/* 18/180-18/189 */,
	29	/* 18/190-18/199 */,
	29	/* 18/200-18/209 */,
	30	/* 18/210-18/219 */,
	30	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to Deadliness (plus 128).  To compensate
 * for changes elsewhere, STR now has a larger effect. -LM-
 */
const byte adj_str_td[] =
{
	128 + -8	/* 3 */,
	128 + -4	/* 4 */,
	128 + -3	/* 5 */,
	128 + -2	/* 6 */,
	128 + -2	/* 7 */,
	128 + -1	/* 8 */,
	128 + -1	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 1	/* 12 */,
	128 + 1	/* 13 */,
	128 + 2	/* 14 */,
	128 + 2	/* 15 */,
	128 + 3	/* 16 */,
	128 + 3	/* 17 */,
	128 + 4	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 5	/* 18/20-18/29 */,
	128 + 5	/* 18/30-18/39 */,
	128 + 6	/* 18/40-18/49 */,
	128 + 7	/* 18/50-18/59 */,
	128 + 8	/* 18/60-18/69 */,
	128 + 9	/* 18/70-18/79 */,
	128 + 10	/* 18/80-18/89 */,
	128 + 11	/* 18/90-18/99 */,
	128 + 12	/* 18/100-18/109 */,
	128 + 13	/* 18/110-18/119 */,
	128 + 14	/* 18/120-18/129 */,
	128 + 15	/* 18/130-18/139 */,
	128 + 16	/* 18/140-18/149 */,
	128 + 17	/* 18/150-18/159 */,
	128 + 18	/* 18/160-18/169 */,
	128 + 19	/* 18/170-18/179 */,
	128 + 20	/* 18/180-18/189 */,
	128 + 21	/* 18/190-18/199 */,
	128 + 22	/* 18/200-18/209 */,
	128 + 23	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to all types of mon-magical combat (plus 128).
 * To compensate for changes elsewhere, DEX now has a larger effect.  -LM-
 */
const byte adj_dex_th[] =
{
	128 + -15	/* 3 */,
	128 + -10	/* 4 */,
	128 +  -6	/* 5 */,
	128 +  -3	/* 6 */,
	128 +  -2	/* 7 */,
	128 +  -1	/* 8 */,
	128 +  -1	/* 9 */,
	128 +   0	/* 10 */,
	128 +   0	/* 11 */,
	128 +   1	/* 12 */,
	128 +   1	/* 13 */,
	128 +   2	/* 14 */,
	128 +   2	/* 15 */,
	128 +   3	/* 16 */,
	128 +   3	/* 17 */,
	128 +   4	/* 18/00-18/09 */,
	128 +   4	/* 18/10-18/19 */,
	128 +   5	/* 18/20-18/29 */,
	128 +   5	/* 18/30-18/39 */,
	128 +   6	/* 18/40-18/49 */,
	128 +   7	/* 18/50-18/59 */,
	128 +   8	/* 18/60-18/69 */,
	128 +   9	/* 18/70-18/79 */,
	128 +  10	/* 18/80-18/89 */,
	128 +  11	/* 18/90-18/99 */,
	128 +  12	/* 18/100-18/109 */,
	128 +  13	/* 18/110-18/119 */,
	128 +  15	/* 18/120-18/129 */,
	128 +  17	/* 18/130-18/139 */,
	128 +  19	/* 18/140-18/149 */,
	128 +  21	/* 18/150-18/159 */,
	128 +  23	/* 18/160-18/169 */,
	128 +  25	/* 18/170-18/179 */,
	128 +  27	/* 18/180-18/189 */,
	128 +  29	/* 18/190-18/199 */,
	128 +  31	/* 18/200-18/209 */,
	128 +  33	/* 18/210-18/219 */,
	128 +  35	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
const byte adj_str_wgt[] =
{
	6	/* 3 */,
	7	/* 4 */,
	8	/* 5 */,
	9	/* 6 */,
	10	/* 7 */,
	11	/* 8 */,
	12	/* 9 */,
	13	/* 10 */,
	14	/* 11 */,
	14	/* 12 */,
	15	/* 13 */,
	16	/* 14 */,
	16	/* 15 */,
	17	/* 16 */,
	17	/* 17 */,
	18	/* 18/00-18/09 */,
	18	/* 18/10-18/19 */,
	19	/* 18/20-18/29 */,
	19	/* 18/30-18/39 */,
	20	/* 18/40-18/49 */,
	21	/* 18/50-18/59 */,
	22	/* 18/60-18/69 */,
	23	/* 18/70-18/79 */,
	24	/* 18/80-18/89 */,
	25	/* 18/90-18/99 */,
	26	/* 18/100-18/109 */,
	27	/* 18/110-18/119 */,
	27	/* 18/120-18/129 */,
	28	/* 18/130-18/139 */,
	29	/* 18/140-18/149 */,
	30	/* 18/150-18/159 */,
	30	/* 18/160-18/169 */,
	30	/* 18/170-18/179 */,
	30	/* 18/180-18/189 */,
	30	/* 18/190-18/199 */,
	30	/* 18/200-18/209 */,
	30	/* 18/210-18/219 */,
	30	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 *
 * These figures have dropped considerably in Sangband, partly because
 * weapons aren't as heavy as they used to be.
 */
const byte adj_str_hold[] =
{
	3	/* 3 */,
	4	/* 4 */,
	5	/* 5 */,
	6	/* 6 */,
	7	/* 7 */,
	8	/* 8 */,
	9	/* 9 */,
	10	/* 10 */,
	11	/* 11 */,
	12	/* 12 */,
	13	/* 13 */,
	14	/* 14 */,
	15	/* 15 */,
	16	/* 16 */,
	17	/* 17 */,
	19	/* 18/00-18/09 */,
	20	/* 18/10-18/19 */,
	21	/* 18/20-18/29 */,
	23	/* 18/30-18/39 */,
	25	/* 18/40-18/49 */,
	27	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	33	/* 18/70-18/79 */,
	36	/* 18/80-18/89 */,
	40	/* 18/90-18/99 */,
	45	/* 18/100-18/109 */,
	50	/* 18/110-18/119 */,
	55	/* 18/120-18/129 */,
	60	/* 18/130-18/139 */,
	65	/* 18/140-18/149 */,
	70	/* 18/150-18/159 */,
	75	/* 18/160-18/169 */,
	80	/* 18/170-18/179 */,
	85	/* 18/180-18/189 */,
	90	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
const byte adj_str_dig[] =
{
	0	/* 3 */,
	0	/* 4 */,
	1	/* 5 */,
	2	/* 6 */,
	3	/* 7 */,
	4	/* 8 */,
	4	/* 9 */,
	5	/* 10 */,
	5	/* 11 */,
	6	/* 12 */,
	6	/* 13 */,
	7	/* 14 */,
	7	/* 15 */,
	8	/* 16 */,
	8	/* 17 */,
	9	/* 18/00-18/09 */,
	10	/* 18/10-18/19 */,
	11	/* 18/20-18/29 */,
	12	/* 18/30-18/39 */,
	14	/* 18/40-18/49 */,
	16	/* 18/50-18/59 */,
	18	/* 18/60-18/69 */,
	20	/* 18/70-18/79 */,
	22	/* 18/80-18/89 */,
	24	/* 18/90-18/99 */,
	26	/* 18/100-18/109 */,
	27	/* 18/110-18/119 */,
	28	/* 18/120-18/129 */,
	30	/* 18/130-18/139 */,
	31	/* 18/140-18/149 */,
	33	/* 18/150-18/159 */,
	34	/* 18/160-18/169 */,
	36	/* 18/170-18/179 */,
	37	/* 18/180-18/189 */,
	38	/* 18/190-18/199 */,
	40	/* 18/200-18/209 */,
	40	/* 18/210-18/219 */,
	40	/* 18/220+ */
};


/*
 * Stat Table (CON) -- base rate of recovery from poison, disease, stuns,
 * and cuts.
 */
const byte adj_con_fix[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	0	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	6	/* 18/130-18/139 */,
	6	/* 18/140-18/149 */,
	7	/* 18/150-18/159 */,
	7	/* 18/160-18/169 */,
	8	/* 18/170-18/179 */,
	8	/* 18/180-18/189 */,
	8	/* 18/190-18/199 */,
	9	/* 18/200-18/209 */,
	9	/* 18/210-18/219 */,
	9	/* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128)
 */
const byte adj_con_mhp[] =
{
	128 + -5	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -2	/* 6 */,
	128 + -1	/* 7 */,
	128 + -1	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 1	/* 13 */,
	128 + 1	/* 14 */,
	128 + 2	/* 15 */,
	128 + 2	/* 16 */,
	128 + 3	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 5	/* 18/30-18/39 */,
	128 + 5	/* 18/40-18/49 */,
	128 + 6	/* 18/50-18/59 */,
	128 + 6	/* 18/60-18/69 */,
	128 + 7	/* 18/70-18/79 */,
	128 + 8	/* 18/80-18/89 */,
	128 + 9	/* 18/90-18/99 */,
	128 + 10	/* 18/100-18/109 */,
	128 + 11	/* 18/110-18/119 */,
	128 + 12	/* 18/120-18/129 */,
	128 + 13	/* 18/130-18/139 */,
	128 + 14	/* 18/140-18/149 */,
	128 + 15	/* 18/150-18/159 */,
	128 + 16	/* 18/160-18/169 */,
	128 + 18	/* 18/170-18/179 */,
	128 + 20	/* 18/180-18/189 */,
	128 + 22	/* 18/190-18/199 */,
	128 + 24	/* 18/200-18/209 */,
	128 + 25	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * Stat Table (STR, DEX) -- power increase to wrestling, karate  -JL-
 */
const byte adj_ma[] =
{
	0  /* 3 */ ,
	0  /* 4 */ ,
	0  /* 5 */ ,
	0  /* 6 */ ,
	0  /* 7 */ ,
	0  /* 8 */ ,
	0  /* 9 */ ,
	0  /* 10 */ ,
	0  /* 11 */ ,
	0  /* 12 */ ,
	0  /* 13 */ ,
	1  /* 14 */ ,
	1  /* 15 */ ,
	1  /* 16 */ ,
	1  /* 17 */ ,
	2  /* 18/00-18/09 */ ,
	2  /* 18/10-18/19 */ ,
	2  /* 18/20-18/29 */ ,
	3  /* 18/30-18/39 */ ,
	3  /* 18/40-18/49 */ ,
	4  /* 18/50-18/59 */ ,
	4  /* 18/60-18/69 */ ,
	5  /* 18/70-18/79 */ ,
	6  /* 18/80-18/89 */ ,
	7  /* 18/90-18/99 */ ,
	8  /* 18/100-18/109 */ ,
	9  /* 18/110-18/119 */ ,
	10 /* 18/120-18/129 */ ,
	11 /* 18/130-18/139 */ ,
	12 /* 18/140-18/149 */ ,
	13 /* 18/150-18/159 */ ,
	14 /* 18/160-18/169 */ ,
	15 /* 18/170-18/179 */ ,
	16 /* 18/180-18/189 */ ,
	17 /* 18/190-18/199 */ ,
	18 /* 18/200-18/209 */ ,
	19 /* 18/210-18/219 */ ,
	20 /* 18/220+ */
};



/*
 * Stat Table (STR) -- help index into the "blow" table
 */
const byte adj_str_blow[] =
{
	3	/* 3 */,
	4	/* 4 */,
	5	/* 5 */,
	6	/* 6 */,
	7	/* 7 */,
	8	/* 8 */,
	9	/* 9 */,
	10	/* 10 */,
	11	/* 11 */,
	12	/* 12 */,
	13	/* 13 */,
	14	/* 14 */,
	15	/* 15 */,
	16	/* 16 */,
	17	/* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};

/*
 * Stat Table (DEX) -- index into the "blow" table
 */
const byte adj_dex_blow[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	1	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	4	/* 18/70-18/79 */,
	4	/* 18/80-18/89 */,
	5	/* 18/90-18/99 */,
	6	/* 18/100-18/109 */,
	7	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	9	/* 18/130-18/139 */,
	10	/* 18/140-18/149 */,
	11	/* 18/150-18/159 */,
	11	/* 18/160-18/169 */,
	11	/* 18/170-18/179 */,
	11	/* 18/180-18/189 */,
	11	/* 18/190-18/199 */,
	11	/* 18/200-18/209 */,
	11	/* 18/210-18/219 */,
	11	/* 18/220+ */
};



/*
 * Conversion of plusses to Deadliness to a percentage added to damage.
 * Much of this table is not intended ever to be used, and is included
 * only to handle possible inflation elsewhere.
 */
const byte deadliness_conversion[151] =
{
	  0,
	  5,  10,  14,  18,  22,  26,  30,  33,  36,  39,
	 42,  45,  48,  51,  54,  57,  60,  63,  66,  69,
	 72,  75,  78,  81,  84,  87,  90,  93,  96,  99,
	102, 104, 107, 109, 112, 114, 117, 119, 122, 124,
	127, 129, 132, 134, 137, 139, 142, 144, 147, 149,
	152, 154, 157, 159, 162, 164, 167, 169, 172, 174,
	176, 178, 180, 182, 184, 186, 188, 190, 192, 194,
	196, 198, 200, 202, 204, 206, 208, 210, 212, 214,
	216, 218, 220, 222, 224, 226, 228, 230, 232, 234,
	236, 238, 240, 242, 244, 246, 248, 250, 251, 253,

	255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255
};

/*
 * This table is used to help calculate the number of blows the player
 * can make in a single round of attacks (one player turn) with a
 * weapon that is not too heavy to wield effectively.
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below.
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by 6, and then divide it by the effective weapon
 * weight (in deci-pounds), rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above).
 *
 * (Some interesting calculations)
 * The character cannot get five blows with any weapon greater than 24
 * lb, and cannot get six with any weapon greater than ~15 lb.
 */
const byte blows_table[12][12] =
{
	            /*  <- Dexterity factor -> */
  /* 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11+ */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2 }, /*  0         */
  {  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3 }, /*  1    ^    */
  {  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  4 }, /*  2    |    */
  {  2,  2,  2,  2,  3,  3,  3,  3,  3,  4,  4,  4 }, /*  3         */
  {  2,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,  4 }, /*  4  Ratio  */
  {  2,  2,  2,  3,  3,  3,  4,  4,  4,  4,  4,  4 }, /*  5  of STR */
  {  2,  2,  2,  3,  3,  4,  4,  4,  4,  4,  4,  5 }, /*  6  over   */
  {  2,  2,  3,  3,  3,  4,  4,  4,  4,  4,  5,  5 }, /*  7  weight */
  {  2,  2,  3,  3,  4,  4,  4,  4,  4,  5,  5,  5 }, /*  8         */
  {  2,  2,  3,  3,  4,  4,  4,  4,  5,  5,  5,  6 }, /*  9    |    */
  {  2,  3,  3,  3,  4,  4,  4,  5,  5,  5,  6,  6 }, /* 10    V    */
  {  2,  3,  3,  4,  4,  4,  5,  5,  5,  6,  6,  6 }  /* 11+        */
};



/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * further increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * See also the table "extract_energy_mon".
 */
const byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  6,  6,  7,  7,  8,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};



/*
 * Player Sexes
 *
 *  Title,
 *  Winner
 */
const player_sex sex_info[MAX_SEXES] =
{
	{
		"Female",
		"she",
		"Queen"
	},

	{
		"Male",
		"he",
		"King"
	}
};



/*
 * Base experience needed to advance a skill to the next level.
 *
 * The actual amount needed is:
 * value from this table, indexed by current skill percentage *
 * (skill base cost / 100) *
 * (racial modifier /  10), all divided by EXP_ADJ (currently 6)
 *
 * Note:
 * These values are derived from the Angband "exp_to_level" table as
 * modified by LM, adjusted to compensate for changes in number of character
 * levels and in the rate at which monster exps increase with depth.
 */
const s32b player_exp[PY_MAX_POWER + 1] =
{
         0,
         5,       10,       17,       25,       35,
        45,       55,       70,       85,      105,    /* 10 */
       125,      150,      180,      215,      255,
       300,      345,      400,      460,      530,    /* 20 */
       600,      700,      800,      900,     1025,
      1150,     1300,     1450,     1600,     1800,    /* 30 */
      2050,     2300,     2600,     2950,     3300,
      3750,     4225,     4750,     5350,     6050,    /* 40 */
      6800,     7700,     8700,     9750,    11000,
     12350,    13900,    15700,    17700,    19900,    /* 50 */
     22500,    25250,    28500,    32000,    36000L,
     40500L,   45750L,   51250L,   57750L,   65000L,   /* 60 */
     73125L,   82250L,   92500L,  104000L,  117000L,
    131500L,  148000L,  166000L,  187000L,  210000L,   /* 70 */
    235000L,  264000L,  295000L,  330000L,  369000L,
    410000L,  455000L,  505000L,  560000L,  620000L,   /* 80 */
    685000L,  757500L,  837500L,  925000L, 1017500L,
   1117500L, 1225000L, 1337500L, 1455000L, 1577500L,   /* 90 */
   1700000L, 1825000L, 1950000L, 2075000L, 2200000L,
   2325000L, 2450000L, 2575000L, 2700000L, 2850000L    /* 100 */
};


/*
 * Table of racial adjustment factors to skill raise costs.  Values for
 * some skills also alter the effectiveness of that skill.
 *
 * A value of 10 is average.
 */
const byte race_adj_cost_skill[NUM_SKILLS][MAX_RACES] =
{
                /* Hum  Elf  Hob  Gno  Dwa  HlO  HlT  Dun  HiE  DkE  Gia  */
  /* sword   */  { 10,  11,  12,  12,  10,   8,   9,  10,  10,   9,  11 },
  /* hafted  */  { 10,  13,  13,  12,   9,   9,   7,  10,  12,  13,  10 },
  /* polearm */  { 10,  12,  14,  12,   8,   9,   9,  10,  11,  11,  10 },
  /* x-bow   */  { 10,  11,  11,  10,  10,  10,  10,  10,  10,  11,  13 },
  /* bow     */  { 10,   8,   9,  10,  14,  10,  13,  10,   8,   9,  13 },
  /* sling   */  { 10,  10,   7,  10,  13,  10,  15,  10,  10,  10,  13 },
  /* throw   */  { 10,  10,   8,  10,  12,  10,   8,  10,   9,  11,  10 },
  /* wrestle */  { 10,  13,  15,  14,   9,  10,   9,  10,  12,  13,   7 },
  /* karate  */  { 10,   9,  10,  10,  12,  13,  15,  10,   8,  11,  13 },

  /* spell   */  { 10,   9,  11,   9,  11,  11,  12,  10,  10,   8,  10 },
  /* mana    */  { 10,   9,  10,   9,  10,  11,  11,  10,   9,   8,  10 },

  /* wizard  */  { 10,   9,  11,   8,  12,  12,  13,  10,   9,   9,  11 },
  /* piety   */  { 10,  11,  11,  10,   8,  11,  11,  10,  11,  10,  12 },
  /* nature  */  { 10,   8,  10,  10,  12,  15,  10,  10,   8,  14,   9 },
  /* dominio */  { 10,  11,  11,   9,  10,   9,   9,  10,  10,   9,  10 },

  /* device  */  { 10,   9,  11,   8,  10,  12,  16,  10,   9,   8,  11 },
  /* burglar */  { 10,  10,   7,  10,  12,  10,  12,  10,  10,   9,  14 },

  /* percept */  { 10,   9,   8,   9,  11,  11,  12,  10,   9,   8,  15 },
  /* stealth */  { 10,   8,   7,  10,  15,  10,  13,  10,   8,   9,  15 },
  /* disarm  */  { 10,   9,   7,  10,  10,  10,  12,  10,  10,  11,  13 },
  /* dodging */  { 10,   9,   8,  10,  10,  10,  20,  10,   9,  10,  15 },
  /* save    */  { 10,  10,   8,  10,   8,  11,  12,  10,   9,   9,  11 },

  /* f_weap  */  { 10,  12,  11,  11,   7,  10,  11,  10,  12,   8,   9 },
  /* f_bow   */  { 10,  10,  11,  11,  11,  11,  11,  10,  10,   8,  12 },
  /* f_armor */  { 10,  12,  11,  11,   7,  10,  11,  10,  12,  11,   9 },
  /* alchemy */  { 10,  11,  12,   8,  14,  13,  11,  10,  11,  10,  13 },
  /* infuse  */  { 10,  10,  13,   9,  11,  13,  13,  10,  10,   7,  13 },

  /* XXX1    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 },

  /* XXX1    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 },
  /* XXX2    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 },
  /* XXX3    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 },
  /* XXX4    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 },
  /* XXX5    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 },
  /* XXX6    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 },
  /* XXX7    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 },
  /* XXX8    */  { 10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10 }
};


/*
 * Character Races
 *
 * Title,
 * STR, INT, WIS, DEX, CON, CHR,
 *
 * disarm   device  save  stealth  percep  melee  missile  throwing
 * r_dis,  r_dev,  r_sav,  r_stl,  r_srh,  r_thn,  r_thb,  r_tht
 *
 * hitdie,
 * Age (Base, Mod),
 *
 *    Note:  Base age is minimum.  Maximum is Base + Mod.
 *
 * Male   (Base Hgt, Mod Hgt, Base Wgt, Mod Wgt),
 * Female (Base Hgt, Mod Hgt, Base Wgt, Mod Wgt),
 *
 *    Note:  Actual character height and weight may (rarely) vary
 *    from the norm as much as 4 times modifier value, minus 1.
 *
 * infravision range
 *
 *    Racial flags1, flags2, flags3  (these correspond to the object flags)
 */
player_race race_info[MAX_RACES] =
{
	{
		"Human",
		{ 0,  0,  0,  0,  0,  0 },
		  0,  0,  0,  0,  0,  0,  0,  0,
		 10,
		 16, 10,
		 68,  3, 135, 10,
		 64,  3, 120,  9,
		  0,
		 0L, 0L, 0L
	},

	{
		"Elf",
		{-1,  2,  1,  1, -2,  1 },
		  3,  2,  4,  3,  5,  -2,  2,  0,
		  8,
		300, 100,
		 65,  3, 115,   8,
		 62,  3, 105,   7,
		  0,
		 0L, TR2_RES_LITE, 0L
	},

	{
		"Hobbit",
		{-2,  1,  1,  3,  2,  1 },
		  5,  2, 10,  3, 10, -4,  2,  2,
		  7,
		 21,  12,
		 41,  2,  70,  5,
		 39,  2,  65,  4,
		  3,
		 TR1_SUST_DEX, 0L, 0L
	},

	{
		"Gnome",
		{-1,  2,  0,  2,  0, -2 },
		  4,  3,  6,  1,  5, -3,  0,  0,
		  8,
		 50,  40,
		 44,  2,  80,  6,
		 41,  2,  70,  5,
		  3,
		 0L, 0L, TR3_FREE_ACT
	},

	{
		"Dwarf",
		{ 2, -2,  2, -2,  2, -2 },
		 -2,  0,  8, -2,  0,  2,  0,  0,
		 11,
		 35,  50,
		 52,  2, 120,  7,
		 48,  2, 105,  6,
		  4,
		 0L, TR2_RES_BLIND, 0L
	},

	{
		"Half-Orc",
		{ 2, -1, -1,  0,  2, -3 },
		 -2, -1, -4, -1, -6,  2,  0,  0,
		 11,
		 16,  8,
		 64,  3, 140,  8,
		 60,  3, 125,  7,
		  3,
		 0L, TR2_RES_DARK, 0L
	},

	{
		"Half-Troll",
		{ 4, -4, -1, -3,  4, -4 },
		 -5, -4, -4, -1,-10,  2,  -4,  0,
		 12,
		 50,  50,
		 77,  3, 360, 28,
		 72,  3, 300, 22,
		  3,
		 TR1_SUST_STR, 0L, 0L
	},

	{
		"D['u]nadan",  /* Dunadan */
		{ 1,  1,  3,  2,  3,  2 },
		  5,  3, 10,  1, 10,  4,  2,  2,
		 11,
		 50,  20,
		 72,  3, 160, 10,
		 68,  3, 140,  9,
		  0,
		 TR1_SUST_CON, 0L, 0L
	},

	{
		"High-Elf",
		{ 1,  3, -1,  3,  1,  3 },
		  6,  5, 10,  3, 12,  2,  4,  2,
		 10,
		400, 200,
		 76,  3, 150, 12,
		 71,  3, 130, 10,
		  0,
		 0L, TR2_RES_LITE, TR3_SEE_INVIS
	},

	{
		"Dark-Elf",
		{-1,  3,  0,  2, -2, -1 },
		  5,  2,  0,  2,  8, -2,  0,  0,
		  8,
		 80, 150,
		 65,  2, 105, 6,
		 60,  2,  95, 5,
		  2,
		 TR1_SUST_INT, 0L, 0L
	},

	{
		"Giant",
		{ 3,  0, -2, -2,  2, -1 },
		 -5, -1,  0, -2,-16,  2, -2,  0,
		 13,
		 20, 10,
		110, 6, 500, 36,
		102, 6, 400, 30,
		  0,
		 0L, 0L, 0L
	}
};


/*
 * The spell information table.  Each realm has a list of spells,
 * organized into spellbooks.  -LM-
 *
 *    Character title, Spell book tval, Spell stat, Special skill that
 *    aids magic, Max armour weight that avoids mana penalties.
 *
 *    Number of spells (max is 64), array (not spell) index of first
 *    spell in each of the active books, listed by sval.
 *
 *    Array of spells, listed by spellbook.  The index controls spell
 *    name (see next table) and effects (see cmd5.c).  Max index = 255.
 *     { Index, Lev, Mana, Fail, Exp/Lev }
 */
const player_magic magic_info[MAX_REALM + 1] =
{
	{
		/*** Warrior ***/

		"Warrior", 0,  A_STR,  0,  0,

		/* 0 spells in zero books. */
		0,	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

		{
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0},
			{  0,   99,  0,  0,   0}
		}
	},

	{
		/*** Wizard ***/

		"Wizard", TV_MAGIC_BOOK,  A_INT,  S_WIZARDRY,  250,

		/* 53 spells in seven books */
		53,	{ 0, 10, 20, 29, 34, 41, 47, 54, 54, 54, 54},

		{
			/* Apprentice's Magic (sval 0) */
			{  0,    1,  2, 20,   0},    /* Magic Missile */
			{  1,    1,  2, 20,   0},    /* Detect Monsters */
			{  2,    3,  2, 20,   0},    /* Phase Door */
			{  3,    6,  3, 20,   0},    /* Light Area */
			{  4,    6,  3, 20,   0},    /* Bar Door */
			{  5,    8,  3, 25,   0},    /* Cure Light Wounds */
			{  6,   10,  4, 35,   0},    /* Detect Doors and Stairs */
			{  7,   11,  4, 25,   0},    /* Stinking Cloud */
			{  8,   12,  2, 25,   0},    /* Confuse Monster */
			{  9,   14,  4, 25,   0},    /* Spear of Light */

			/* Conjurings and Tricks (sval 1) */
			{ 10,   18,255, 25,   1},    /* Wonder */
			{ 11,   20,  5, 25,   1},    /* Teleport Self */
			{ 12,   22,  3, 25,   1},    /* Blink Away */
			{ 13,   24,  3, 25,   1},    /* Sleep Monster */
			{ 14,   26,  5, 25,   2},    /* Sound Blast */
			{ 15,   28,  6, 25,   2},    /* Fireflash */
			{ 16,   30,  6, 25,   2},    /* Magic Disarm */
			{ 17,   32,  3, 25,   2},    /* Slow Monster */
			{ 18,   34,  6, 30,   3},    /* Fire Bolt */
			{ 19,   36,  5, 35,   3},    /* Polymorph */

			/* Elemental Sorcery (sval 2) */
			{ 20,   38,  8, 35,   3},    /* Identify */
			{ 21,   40,  4, 30,   3},    /* Evasion */
			{ 22,   42,  2, 30,   4},    /* Tap Magical Energy */
			{ 23,   46,  8, 35,   4},    /* Elemental Protection */
			{ 24,   46, 10, 30,   4},    /* Cone of Cold */
			{ 25,   50,  6, 35,   4},    /* Detect Enchantment */
			{ 26,   54, 12, 30,   5},    /* Haste Self */
			{ 27,   58, 13, 30,   6},    /* Wall of Fire */
			{ 28,   64, 18, 30,   9},    /* Chromatic Burst */

			/* Phantasms and Illusions (sval 3) */
			{ 29,   50,  5, 25,   4},    /* Frighten Monster */
			{ 30,   54, 10, 25,   5},    /* Cloaking */
			{ 31,   60, 12, 25,   8},    /* Mass Confusion */
			{ 32,   66, 19, 25,  12},    /* Chaos Cloud */
			{ 33,   72,255, 25,  20},    /* Blinding and Befuddlement */

			/* Mordenkainen's Escapes (sval 4) */
			{ 34,   54,  8, 25,   6},    /* Door Creation */
			{ 35,   60, 10, 25,   8},    /* Stair Creation */
			{ 36,   62, 11, 25,   9},    /* Dancing Feet */
			{ 37,   64, 13, 25,  11},    /* Teleport Other */
			{ 38,   68, 13, 25,  16},    /* Teleport Level */
			{ 39,   70, 10, 25,  20},    /* Phase Warp */
			{ 40,   74, 22, 25,  25},    /* Word of Recall */

			/* Grimoire of Wizardry (sval 5) */
			{ 41,   58, 12, 30,  10},    /* Detection */
			{ 42,   64, 14, 30,  15},    /* Magic Shield */
			{ 43,   68, 16, 30,  25},    /* Aura of Frost */
			{ 44,   68, 16, 30,  25},    /* Aura of Fire */
			{ 45,   78, 25, 35,  22},    /* Foes a-Phasing */
			{ 46,   88, 20, 35,  45},    /* Wizardly Enhancement */

			/* Raal's Tome of Destruction (sval 6) */
			{ 47,   70, 15, 30,  22},    /* Arc of Force */
			{ 48,   74, 40, 30,  25},    /* Call Destruction */
			{ 49,   82, 23, 30,  30},    /* Plasma Vortex */
			{ 50,   86, 13, 30,  42},    /* Rift */
			{ 51,   90, 27, 30,  52},    /* Mana Storm */
			{ 52,   94,255, 30,  65},    /* Prismatic Armageddon */

			{ 53,  255,  0,  0,   0},
			{ 54,  255,  0,  0,   0},
			{ 55,  255,  0,  0,   0},
			{ 56,  255,  0,  0,   0},
			{ 57,  255,  0,  0,   0},
			{ 58,  255,  0,  0,   0},
			{ 59,  255,  0,  0,   0},
			{ 60,  255,  0,  0,   0},
			{ 61,  255,  0,  0,   0},
			{ 62,  255,  0,  0,   0},
			{ 63,  255,  0,  0,   0}
		}
	},

	{
		/*** Priest ***/

		"Priest", TV_PRAYER_BOOK,  A_WIS,  S_PIETY,  300,

		/* 54 prayers in seven books */
		54,	{ 0, 10, 20, 30, 36, 41, 48, 54, 54, 54, 54},

		{
			/* Novitiate (sval 0) */
			{ 64,    1,  2, 20,   0},    /* Detect Evil */
			{ 65,    1,  2, 20,   0},    /* Cure Minor Wounds */
			{ 66,    3,  2, 20,   0},    /* Bless */
			{ 67,    4,  2, 25,   0},    /* Boldness */
			{ 68,    6,  2, 20,   0},    /* Radiance */
			{ 69,    7,  3, 15,   0},    /* Spiritual Hammer */
			{ 70,    8,  3, 30,   0},    /* Detect Doors and Stairs */
			{ 71,   10,  3, 20,   0},    /* Scare Monster */
			{ 72,   11,  4, 20,   0},    /* Dispel Poison */
			{ 73,   13,  4, 25,   0},    /* Blink */

			/* Words of Wisdom (sval 1) */
			{ 74,   14,  4, 25,   0},    /* Sense Invisible */
			{ 75,   16,  4, 25,   0},    /* Shining Spear */
			{ 76,   18,  4, 25,   1},    /* Scan Object */
			{ 77,   20,  5, 30,   1},    /* Sustenance */
			{ 78,   22,  7, 30,   2},    /* Orb of Draining */
			{ 79,   24,  7, 35,   1},    /* Sense Surroundings */
			{ 80,   26,  7, 25,   2},    /* Remove Curse */
			{ 81,   28,  4, 30,   2},    /* Resist Heat and Cold */
			{ 82,   30,  4, 25,   2},    /* Turn Evil */
			{ 83,   33,  8, 25,   3},    /* Cure Major Wounds */

			/* Holy of Holies (sval 2) */
			{ 84,   35,  5, 30,   4},    /* Prayer */
			{ 85,   38,  7, 30,   3},    /* Protection from Evil */
			{ 86,   40,  8, 30,   4},    /* Exorcism */
			{ 87,   44, 10, 30,   4},    /* Dispel Evil */
			{ 88,   48, 11, 30,   3},    /* Divine Light */
			{ 89,   50,  1, 30,   4},    /* Meditation */
			{ 90,   58, 12, 30,   5},    /* Portal */
			{ 91,   60, 22, 30,   6},    /* Heal */
			{ 92,   69, 30, 40,  15},    /* Glyph of Warding */
			{ 93,   75, 30, 35,  22},    /* Holy Word */

			/* Shining Spirit (sval 3) */
			{ 94,   52,  5, 30,   8},    /* Unbarring Ways */
			{ 95,   52,  5, 30,   8},    /* Untrapping Chant */
			{ 96,   56,  6, 30,   9},    /* Eyes Undeceivable */
			{ 97,   56,  6, 30,   9},    /* Unveil Traps */
			{ 98,   72, 20, 30,  15},    /* Light Chambers */
			{ 99,   84, 50, 35,  35},    /* Clairvoyance */

			/* Canon of Judgment (sval 4) */
			{100,   54, 12, 25,   9},    /* Holy Lance */
			{101,   54, 17, 30,   9},    /* Concentrate Light */
			{102,   58, 20, 30,  13},    /* Banishment */
			{103,   64, 20, 30,  19},    /* Judgment */
			{104,   78, 24, 35,  32},    /* Starburst */

			/* Insight and Purifications (sval 5) */
			{105,   60,  8, 25,  11},    /* Resist Ethereal */
			{106,   62, 18, 30,  13},    /* Perception */
			{107,   64, 18, 40,  15},    /* Self Knowledge */
			{108,   70, 30, 40,  22},    /* Dispel Curse */
			{109,   72, 18, 40,  27},    /* Holy Aura */
			{110,   80, 60, 50,  35},    /* Restoration */
			{111,   80, 60, 50,  35},    /* Remembrance */

			/* Testament of the Almighty (sval 6) */
			{112,   76, 13, 30,  32},    /* Sacred Shield */
			{113,   76, 25, 30,  32},    /* Life */
			{114,   82, 24, 40,  37},    /* Word of Destruction */
			{115,   86, 25, 32,  45},    /* Smite Evil */
			{116,   86, 23, 32,  45},    /* Annihilation */
			{117,   96, 30, 25,  75},    /* Call on Varda */

			{118,  255,  0,  0,   0},
			{119,  255,  0,  0,   0},
			{120,  255,  0,  0,   0},
			{121,  255,  0,  0,   0},
			{122,  255,  0,  0,   0},
			{123,  255,  0,  0,   0},
			{124,  255,  0,  0,   0},
			{125,  255,  0,  0,   0},
			{126,  255,  0,  0,   0},
			{127,  255,  0,  0,   0}
		}
	},

	{
		/*** Druid ***/

		"Druid", TV_NATURE_BOOK,  A_WIS,  S_NATURE,  250,

		/* 54 spells in seven books */
		54,	{ 0, 10, 20, 30, 35, 42, 48, 54, 54, 54, 54},

		{
			/* Call of the Wild (sval 0) */
			{128,    1,  2, 20,   0},    /* Lightning Spark */
			{129,    1,  2, 20,   0},    /* Sense Life */
			{130,    3,  2, 20,   0},    /* Minor Healing */
			{131,    6,  3, 20,   0},    /* Song of Morning */
			{132,    8,  3, 20,   0},    /* Sustain Self */
			{133,   10,  3, 22,   0},    /* Blink */
			{134,   11,  4, 22,   0},    /* Regain Health */
			{135,   12,  4, 22,   0},    /* Frost Bolt */
			{136,   14,  4, 22,   0},    /* Ray of Sunlight */
			{137,   16,  4, 22,   0},    /* Turn Stone to Mud */

			/* Communion with Nature (sval 1) */
			{138,   18,  3, 22,   1},    /* Sleep Creature */
			{139,   19,  5, 22,   1},    /* Counter-Poison */
			{140,   21,  6, 22,   1},    /* Detect Traps/Doors */
			{141,   22,  6, 25,   1},    /* Snuff Small Life */
			{142,   24,  7, 25,   1},    /* Ignite Blaze */
			{143,   26,  2, 25,   2},    /* Change Weather */
			{144,   28,  7, 25,   2},    /* Form of the Goat */
			{145,   30,  9, 25,   2},    /* Sense Area */
			{146,   32,  7, 25,   3},    /* Poison Bolt */
			{147,   34,  9, 25,   3},    /* Resist Elements */

			/* Book of Combat (sval 2) */
			{148,   36,  9, 30,   3},    /* Acid Blast */
			{149,   39, 10, 30,   4},    /* Wither Foe */
			{150,   44,255, 30,   4},    /* Blizzard */
			{151,   46,255, 30,   4},    /* Fireball */
			{152,   50, 14, 40,   5},    /* Form of the Bear */
			{153,   54,  1, 30,   6},    /* Natural Vitality */
			{154,   58,255, 30,   7},    /* Chain Lightning */
			{155,   62, 16, 40,   8},    /* Detect all */
			{156,   66, 16, 35,   9},    /* Identify */
			{157,   74, 24, 35,  14},    /* Thunderclap */

			/* Druidic Transformations (sval 3) */
			{158,   30,  4, 40,   7},    /* Form of the Mouse */
			{159,   36,  9, 40,  10},    /* Form of the Hound */
			{160,   46, 12, 40,  15},    /* Form of the Cheetah */
			{161,   56, 18, 40,  20},    /* Form of the Lion */
			{162,   82, 29, 45,  30},    /* Form of the Dragon */

			/* Weather Mastery (sval 4) */
			{163,   60, 8, 40,  20},    /* Hold Weather */
			{164,   66, 9, 38,  22},    /* Summer's Gaze */
			{165,   66, 9, 38,  22},    /* Winter's Grip */
			{166,   72, 9, 37,  25},    /* Drought */
			{167,   72, 9, 37,  25},    /* Deluge */
			{168,   76, 9, 35,  27},    /* Wind Songs */
			{169,   76, 9, 35,  27},    /* Still Winds */

			/* Primal Forces (sval 5) */
			{170,   70, 20, 30,  22},    /* Ice Storm */
			{171,   75, 20, 30,  22},    /* Essence of Flame */
			{172,   79, 21, 30,  27},    /* Lethal Plague */
			{173,   81, 21, 35,  30},    /* Cyclone */
			{174,   84, 22, 30,  30},    /* Hurricane of Acid */
			{175,   88, 22, 30,  35},    /* Thunder Strike */

			/* Spirit of Yavanna (sval 6) */
			{176,   60,  9, 30,  15},    /* Song of Protection */
			{177,   68, 18, 30,  20},    /* Essence of Speed */
			{178,   74, 28, 30,  30},    /* Herbal Healing */
			{179,   76, 30, 35,  32},    /* Create Athelas */
			{180,   80, 30, 35,  37},    /* Form of the Ent */
			{181,   98, 34, 25,  70},    /* Intervention of Yavanna */

			{182,  255,  0,  0,   0},
			{183,  255,  0,  0,   0},
			{184,  255,  0,  0,   0},
			{185,  255,  0,  0,   0},
			{186,  255,  0,  0,   0},
			{187,  255,  0,  0,   0},
			{188,  255,  0,  0,   0},
			{189,  255,  0,  0,   0},
			{190,  255,  0,  0,   0},
			{191,  255,  0,  0,   0}
		}
	},

	{
		/*** Necromancer ***/

		"Necromancer", TV_DARK_BOOK,  A_INT,  S_DOMINION,  250,

		/* 54 curses in seven books */
		54,	{ 0, 10, 20, 30, 36, 42, 48, 54, 54, 54, 54},

		{
			/* Beginner's Curses (sval 0) */
			{192,    1,  2, 20,   0},    /* Magic Bolt */
			{193,    1,  2, 20,   0},    /* Detect Evil */
			{194,    3,  3, 25,   0},    /* Sense Blood */
			{195,    6,  2, 20,   0},    /* Break Curse */
			{196,    6,  2, 25,   0},    /* Black Blessing */
			{197,    8,  3, 20,   0},    /* Malediction */
			{198,   10,  2, 20,   0},    /* Horrify */
			{199,   13,  3, 45,   1},    /* Become Bat */
			{200,   15,  3, 20,   0},    /* Dark Bolt */
			{201,   18,  4, 20,   0},    /* Noxious Fumes */

			/* Darker Elements (sval 1) */
			{202,   19,  5, 25,   1},    /* Cure Poison */
			{203,   20,  5, 10,   1},    /* Invoke Spirits */
			{204,   22,  5, 30,   1},    /* Dispel Evil */
			{205,   24,  5, 25,   1},    /* Eyes of the Night */
			{206,   26,  6, 50,   2},    /* Shadow Shifting */
			{207,   30,  8, 55,   2},    /* Detect Traps */
			{208,   32,  8, 55,   2},    /* Detect Doors/Stairs */
			{209,   34,  6, 25,   2},    /* Death Claw */
			{210,   36,  6, 30,   3},    /* Mental Awareness */
			{211,   38,  6, 30,   4},    /* Mass Panic */

			/* Frightful Realms (sval 2) */
			{212,   42,  7, 30,   4},    /* Mists of Lethargy */
			{213,   44,  9, 30,   4},    /* Spear of Ice */
			{214,   46, 10, 30,   4},    /* Doom Bolt */
			{215,   46, 10, 50,   4},    /* Shadow Warping */
			{216,   50, 18, 40,   5},    /* Feed off Light */
			{217,   54,255, 30,   5},    /* Dark Ball */
			{218,   58, 30, 35,   6},    /* Genocide */
			{219,   62, 14, 30,   6},    /* Exorcism */
			{220,   66, 19, 30,   8},    /* Mists of Death */
			{221,   72, 22, 30,  15},    /* The Overmind */

			/* Mysteries of Angmar (sval 3) */
			{222,   48,  4, 25,   6},    /* Corpse Light */
			{223,   52,  6, 30,   7},    /* Probing */
			{224,   60,  9, 35,  12},    /* Shadow Mapping */
			{225,   68, 12, 35,  20},    /* Interrogate */
			{226,   75, 19, 35,  30},    /* Shadow Shield */
			{227,   82, 35, 40,  40},    /* Wraithform */

			/* Doomspells (sval 4) */
			{228,   60, 12, 25,  12},    /* Darkfire */
			{229,   64, 19, 30,  16},    /* Vampiric Drain */
			{230,   68, 20, 30,  20},    /* Blight Upon Nature */
			{231,   72, 21, 35,  25},    /* Smash Undead */
			{232,   76, 30, 35,  30},    /* Destroy Cavern */
			{233,   86, 22, 35,  40},    /* Annihilation */

			/* Triumph of the Will (sval 5) */
			{234,   60, 10, 30,  15},    /* Mind over Body */
			{235,   64, 11, 30,  17},    /* Ward Against Evil */
			{236,   66, 15, 35,  18},    /* Necromantic Rage */
			{237,   68, 19, 35,  22},    /* Dispel Curse */
			{238,   78,  0, 35,  30},    /* Ritual of Blood */
			{239,   84, 20, 35,  40},    /* Mental Barrier */

			/* Necronomicon (sval 6) */
			{240,   72, 20, 30,  25},    /* Teleport Other */
			{241,   74, 20, 30,  27},    /* Forbid Summoning */
			{242,   81, 20, 35,  35},    /* Lich Powers */
			{243,   82, 60, 35,  35},    /* Mass Genocide */
			{244,   92, 23, 30,  50},    /* Darkness Storm */
			{245,   96,255, 30,  70},    /* Mana Frenzy */

			{246,  255,  0,  0,   0},
			{247,  255,  0,  0,   0},
			{248,  255,  0,  0,   0},
			{249,  255,  0,  0,   0},
			{250,  255,  0,  0,   0},
			{251,  255,  0,  0,   0},
			{252,  255,  0,  0,   0},
			{253,  255,  0,  0,   0},
			{254,  255,  0,  0,   0},
			{255,  255,  0,  0,   0}
		}
	}
};


/*
 * Names of the spells (mage spells, priestly prayers, nature magics,
 * and Necromantic spells).  Spells are listed by index (see table above
 * for index assignments, and cmd5.c for the effects associated with each
 * index).
 */
cptr spell_names[256] =
{
/*** Wizard's Spells ***/

	/* Apprentice's Magic (sval 0) */
	"Magic Missile",                /* Index 0 */
	"Detect Monsters",
	"Phase Door",
	"Light Area",
	"Bar Door",
	"Cure Light Wounds",
	"Detect Doors and Stairs",
	"Stinking Cloud",
	"Confuse Monster",
	"Spear of Light",

	/* Lesser Conjury (sval 1) */
	"Wonder",                      /* Index 10 */
	"Teleport Self",
	"Blink Away",
	"Sleep Monster",
	"Sound Blast",
	"Fireflash",
	"Magic Disarm",
	"Slow Monster",
	"Fire Bolt",
	"Polymorph",

	/* Elemental Sorcery (sval 2) */
	"Identify",                    /* Index 19 */
	"Evasion",
	"Tap Magical Energy",
	"Elemental Protection",
	"Cone of Cold",
	"Detect Enchantment",
	"Haste Self",
	"Wall of Fire",
	"Chromatic Burst",

	/* Phantasms and Illusions (sval 3) */
	"Frighten Monster",                     /* Index 28 */
	"Cloaking",
	"Mass Confusion",
	"Chaos Cloud",
	"Blinding and Befuddlement",

	/* Mordenkainen's Escapes (sval 4) */
	"Door Creation",                /* Index 34 */
	"Stair Creation",
	"Dancing Feet",
	"Teleport Other",
	"Teleport Level",
	"Phase Warp",
	"Word of Recall",

	/* Grimoire of Wizardry (sval 5) */
	"Detection",                 /* Index 41 */
	"Magic Shield",
	"Aura of Frost",
	"Aura of Fire",
	"Foes a-Phasing",
	"Wizardly Enhancement",

	/* Raal's Tome of Destruction (sval 6) */
	"Arc of Force",                 /* Index 47 */
	"Call Destruction",
	"Plasma Vortex",
	"Rift",
	"Mana Storm",
	"Prismatic Armageddon",

	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",


/*** Priestly Prayers ***/

	/* Novitiate (sval 0) */
	"Detect Evil",                  /* Index 64 */
	"Cure Minor Wounds",
	"Bless",
	"Boldness",
	"Radiance",
	"Spiritual Hammer",
	"Detect Doors and Stairs",
	"Scare Monster",
	"Dispel Poison",
	"Blink",

	/* Words of Wisdom (sval 1) */
	"Sense Invisible",                  /* Index 74 */
	"Shining Spear",
	"Scan Object",
	"Sustenance",
	"Orb of Draining",
	"Sense Surroundings",
	"Remove Curse",
	"Resist Heat and Cold",
	"Turn Evil",
	"Cure Major Wounds",

	/* Holy of Holies (sval 2) */
	"Prayer",                       /* Index 84 */
	"Protection from Evil",
	"Exorcism",
	"Dispel Evil",
	"Divine Light",
	"Meditation",
	"Portal",
	"Heal",
	"Glyph of Warding",
	"Holy Word",

	/* Shining Spirit (sval 3) */
	"Unbarring Ways",               /* Index 94 */
	"Untrapping Chant",
	"Eyes Undeceivable",
	"Unveil Traps",
	"Light Chambers",
	"Clairvoyance",

	/* Canon of Judgment (sval 4) */
	"Holy Lance",                 /* Index 100 */
	"Concentrate Light",
	"Banishment",
	"Judgment",
	"Starburst",

	/* Insight and Purifications (sval 5) */
	"Resist Ethereal",                   /* Index 106 */
	"Perception",
	"Self Knowledge",
	"Dispel Curse",
	"Holy Aura",
	"Restoration",
	"Remembrance",

	/* Testament of the Almighty (sval 6) */
	"Sacred Shield",                         /* Index 112 */
	"Life",
	"Word of Destruction",
	"Smite Evil",
	"Annihilation",
	"Call on Varda",

	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",


/*** Druidic Lore ***/

	/* Call of the Wild (sval 0) */
	"Lightning Spark",              /* Index 128 */
	"Sense Life",
	"Minor Healing",
	"Song of Morning",
	"Sustain Self",
	"Blink",
	"Regain Health",
	"Frost Bolt",
	"Ray of Sunlight",
	"Turn Stone to Mud",

	/* Communion with Nature (sval 1) */
	"Sleep Creature",               /* Index 138 */
	"Counter-Poison",
	"Detect Traps/Doors",
	"Snuff Small Life",
	"Ignite Blaze",
	"Change Weather",
	"Form of the Goat",
	"Sense Area",
	"Poison Bolt",
	"Resist Elements",

	/* Book of Combat (sval 2) */
	"Acid Blast",                    /* Index 148 */
	"Wither Foe",
	"Blizzard",
	"Fireball",
	"Form of the Bear",
	"Natural Vitality",
	"Chain Lightning",
	"Detect all",
	"Identify",
	"Thunderclap",

	/* Druidic Transformations (sval 3) */
	"Form of the Mouse",            /* Index 158 */
	"Form of the Hound",
	"Form of the Cheetah",
	"Form of the Lion",
	"Form of the Dragon",

	/* Weather Mastery (sval 4) */
	"Hold Weather",                 /* Index 163 */
	"Summer's Gaze",
	"Winter's Grip",
	"Drought",
	"Deluge",
	"Wind Songs",
	"Still Winds",

	/* Primal Forces (sval 5) */
	"Ice Storm",             /* Index 170 */
	"Essence of Flame",
	"Lethal Plague",
	"Cyclone",
	"Hurricane of Acid",
	"Thunder Strike",

	/* Spirit of Yavanna (sval 6) */
	"Song of Protection",           /* Index 176 */
	"Essence of Speed",
	"Herbal Healing",
	"Create Athelas",
	"Form of the Ent",
	"Intervention of Yavanna",

	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",

/*** Necromantic Curses ***/

	/* Beginner's Curses (sval 0) */
	"Magic Bolt",                   /* Index 192 */
	"Detect Evil",
	"Sense Blood",
	"Break Curse",
	"Black Blessing",
	"Malediction",
	"Horrify",
	"Become Bat",
	"Dark Bolt",
	"Noxious Fumes",

	/* Darker Elements (sval 1) */
	"Cure Poison",                  /* Index 202 */
	"Invoke Spirits",
	"Dispel Evil",
	"Eyes of the Night",
	"Shadow Shifting",
	"Detect Traps",
	"Detect Doors/Stairs",
	"Death Claw",
	"Mental Awareness",
	"Mass Panic",

	/* Frightful Realms (sval 2) */
	"Mists of Lethargy",            /* Index 212 */
	"Spear of Ice",
	"Doom Bolt",
	"Shadow Warping",
	"Feed off Light",
	"Dark Ball",
	"Genocide",
	"Exorcism",
	"Mists of Death",
	"The Overmind",

	/* Mysteries of Angmar (sval 3) */
	"Corpse Light",                 /* Index 222 */
	"Probing",
	"Shadow Mapping",
	"Interrogate",
	"Shadow Shield",
	"Wraithform",

	/* Doomspells (sval 4) */
	"Darkfire",                     /* Index 228 */
	"Vampiric Drain",
	"Blight Upon Nature",
	"Smash Undead",
	"Destroy Cavern",
	"Annihilation",

	/* Bodily Infusions (sval 5) */
	"Mind over Body",               /* Index 234 */
	"Ward Against Evil",
	"Necromantic Rage",
	"Dispel Curse",
	"Ritual of Blood",
	"Mental Barrier",

	/* Necronomicon (sval 6) */
	"Teleport Other",               /* Index 240 */
	"Forbid Summoning",
	"Lich Powers",
	"Mass Genocide",
	"Darkness Storm",
	"Mana Frenzy",

	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)",
	"(blank)"
};



/*
 * Array of projection names.  Only projections with names can be
 * individually edited inside the game; the others should always
 * either be invisible or white.
 *
 * List must be NULL-terminated.
 */
cptr projection_names[] =
{
	"",
	"Rock", "Shot", "Arrow", "Missile", "Poison Missile",
	"Whip", "Hurt", "Acid", "Lightning", "Fire",
	"Frost", "Poison", "Plasma", "Hellfire", "Ice",
	"", "", "", "", "Weak Light",
	"Light", "Light (phial)", "Weak Darkness", "Darkness", "Morgul-Darkness",
	"Confusion", "Sound", "Shards", "Inertia", "Gravity",
	"Force", "Water", "Wind", "Storm", "",
	"", "", "", "", "Nexus",
	"Nether", "Chaos", "Disenchantment", "Time", "Mana",
	"", "", "", "", "",
	"", "", "Meteor", "Holy Orb", "Black Orb",
	"Death", "Vampiric Drain", "Death Cloud", "Spores", "",
	"", "", "", "Curse", "Smite",
	"Dispel", "", "Psionic Force", "", "",
	NULL
};


/*
 * Artifacts may gain in power when matched with others.  -GS-
 *
 * WARNING:  The code does not check to see if the object already has the
 * flag that the set is adding (this can happen if the artifact gives random
 * qualities).  If it does, then it will _lose_ that flag when the set is
 * broken.  XXX XXX XXX
 *
 * WARNING:  Sets are only applied when items are worn/wielded, and only
 * unapplied when items are taken off/unwielded.  XXX XXX
 */
set_type s_info[MAX_S_IDX] =
{
	/* Blank Set */
	{
		"Dummy", 0, "",
		{
			/*  */
			{ 0,        0,  0,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  0L, 0L, 0L },

			/*  */
			{ 0,       0,  0,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  0L, 0L, 0L }
		}
	},

	/* Fist of Leaping Flame set */
	{
		"Fist of Leaping Flame", 2, "It is part of the set of the Fist of Leaping Flame",
		{
			/* Narthanc */
			{ ART_NARTHANC,        0,  0,  0,       0,  1,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  TR1_VORPAL, 0L, 0L },

			/* Paurlhach */
			{ ART_PAURLHACH,       5,  5,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  0L, 0L, 0L }
		}
	},

	/* Icefist set */
	{
		"Icefist", 2, "It is part of the set of the Icefist",
		{
			/* Nimthanc */
			{ ART_NIMTHANC,        0,  0,  0,       0,  1,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  TR1_VORPAL, 0L, 0L },

			/* Paurnimmen */
			{ ART_PAURNIMMEN,      5,  5,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  0L, 0L, 0L }
		}
	},

	/* Lightning Blow set */
	{
		"Lightning Blow", 2, "It is part of the set of the Lightning Blow",
		{
			/* Aethanc */
			{ ART_AETHANC,         0,  0,  0,       0,  1,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  TR1_VORPAL, 0L, 0L },

			/* Pauraegen */
			{ ART_PAURAEGEN,       5,  5,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  0L, 0L, 0L }
		}
	},

	/* Fist of Water set */
	{
		"Fist of Water", 2, "It is part of the Fist of Water set",
		{
			/* Nenthanc */
			{ ART_NENTHANC,        0,  0,  0,       0,  1,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  TR1_VORPAL, 0L, 0L },

			/* Paurnen */
			{ ART_PAURNEN,         5,  5,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  0L, 0L, 0L }
		}
	},

	/* Holy Fire Set */
	{
		"Flame of Wrath", 2, "It is part of a set of items infused with holy fire",
		{
			/* The Amulet of Carlammas */
			{ART_CARLAMMAS,        0,  0,  0,       0,  0,  0,
			  2, (TR_PVAL_WIS),
			  0, 0L,
			  0, 0L,
			  0L, (TR2_RES_FEAR), 0L },

			/* The Morning Star 'Firestar' */
			{ART_FIRESTAR,         0,  0,  0,       0,  0,  3,
			  0, 0L,
			  2, (TR_PVAL_STR),
			  0, 0L,
			  (TR1_SLAY_EVIL), 0L, 0L }
		}
	},

	/* Shadow Set */
	{
		"Shadow Ward", 2, "It is one of the Shadow Ward items",
		{
			/* The Soft Leather Armour 'Hithlomir' */
			{ART_HITHLOMIR,        0,  0,  0,       0,  0,  0,
			  0, (TR_PVAL_AWARE),
			  0, 0L,
			  0, 0L,
			  0L, (TR2_RES_BLIND), 0L },

			/* The Set of Leather Gloves 'Cammithrim' */
			{ART_CAMMITHRIM,       0,  0,  0,       0,  0,  0,
			  2, (TR_PVAL_DEX | TR_PVAL_DEVICE),
			  0, 0L,
			  0, 0L,
			  (TR1_SUST_DEX), 0L, 0L }
		}
	},

	/* Eorl/Rohan Set */
	{
		"Eorl's Battlegear", 2, "It is part of the battlegear of Eorl the Young",
		{
			/* Lance of the Eorlingas */
			{ART_EORLINGAS,        0,  0,  0,       0,  0,  0,
			  0, (TR_PVAL_CON),
			  0, 0L,
			  0, 0L,
			  0L, 0L, (TR3_REGEN) },

			/* The Metal Brigandine Armour of the Rohirrim */
			{ART_ROHIRRIM,         0,  0,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  0L, 0L, (TR3_FREE_ACT) }
		}
	},

	/* Elf-friend's Set */
	{
		"Elven Gifts", 2,"It is from a group of Elven items once entrusted to Hobbits",
		{
			/* The Phial of Galadriel */
			{ART_GALADRIEL,        0,  0,  0,       0,  0,  0,
			  0, 0L,
			  1, (TR_PVAL_WIS | TR_PVAL_CHR),
			  0, 0L,
			  0L, (TR2_RES_DARK), 0L },

			/* The Small Sword 'Sting' */
			{ART_STING,            0,  0,  0,       0,  0,  0,
			  0, (TR_PVAL_STEALTH),
			  0, 0L,
			  0, 0L,
			  0L, 0L, (TR3_REGEN | TR3_SLOW_DIGEST) }
		}
	},

	/* Gil-Galad's Set */
	{
		"Gil-Galad's Battlegear", 2, "It is part of the battlegear of Gil-Galad",
		{
			/* The Shield of Deflection of Gil-Galad */
			{ART_GIL_GALAD,        0,  0,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  (TR1_SUST_DEX), (TR2_RES_FIRE | TR2_RES_POIS), 0L },

			/* The Spear 'Aeglos' */
			{ART_AEGLOS,           0,  0,  0,       0,  0,  0,
			  0, 0L,
			  0, 0L,
			  0, 0L,
			  (TR1_SLAY_DEMON), (TR2_RES_DARK), 0L }
		}
	}
};


/*
 * Hack -- Have a basic set of colors to show "news.txt"
 */
color_type color_table[MAX_COLORS] =
{
	{ 'd', "Dark",           0, 0, 0, 0, 0 },
	{ 'w', "White",          1, 0, 255, 255, 255 },
	{ 's', "Slate",          2, 0, 144, 144, 144 },
	{ 'o', "Orange",         3, 0, 255, 128,   0 },
	{ 'r', "Red",            4, 0, 192,   0,   0 },
	{ 'g', "Green",          5, 0,   0, 128,   0 },
	{ 'b', "Blue",           6, 0,   0,   0, 224 },
	{ 'u', "Umber",          7, 0, 144,  64,   0 },
	{ 'D', "Light Dark",     8, 0,  96,  96,  96 },
	{ 'W', "Light Slate",    9, 0, 192, 192, 192 },
	{ 'v', "Light Purple",  10, 0, 255,   0, 255 },
	{ 'y', "Yellow",        11, 0, 255, 255,   0 },
	{ 'R', "Light Red",     12, 0, 255,  48,  48 },
	{ 'G', "Light Green",   13, 0,   0, 240,   0 },
	{ 'B', "Light Blue",    14, 0,   0, 240, 240 },
	{ 'U', "Light Umber",   15, 0, 192, 128,  64 },

	/* Rest to be filled in when the game loads */
};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[A_MAX] =
{
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: "
};


/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[A_MAX] =
{
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: "
};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 */
cptr window_flag_desc[32] =
{
	"Display inventory",
	"Display equipment",
	"Display character screen",
	"Display equipment attributes",
	"Display visible monsters",
	"Display nearby objects",
	"Display messages",
	"Display overhead view",
	"Display monster recall",
	"Display object recall",
	"Display list of commands",
	NULL,
	NULL,
	NULL,
#ifdef ALLOW_BORG
	"Display borg messages",
	"Display borg status",
#else
	NULL,
	NULL,
#endif
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};



/*
 * Options -- textual names (where defined)
 */
cptr option_text[OPT_MAX] =
{
	/* Game behavior */
	"rogue_like_commands",		/* OPT_rogue_like_commands */
	"verify_destroy",			/* OPT_verify_destroy */
	NULL,
	"always_pickup",			/* OPT_always_pickup */
	"query_floor",			/* OPT_query_floor */
	"never_haggle",				/* OPT_never_haggle */
	"use_old_target",			/* OPT_use_old_target */
	"run_ignore_stairs",		/* OPT_run_ignore_stairs */
	"run_ignore_doors",			/* OPT_run_ignore_doors */
	"run_cut_corners",			/* OPT_run_cut_corners */
	"xchars_to_file",			/* OPT_xchars_to_file */
	"stack_force_notes",		/* OPT_stack_force_notes */
	"stack_force_costs",		/* OPT_stack_force_costs */
	"allow_quantity",			/* OPT_allow_quantity */
	"change_save_names",		/* OPT_change_save_names */
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,


	/* Disturbance and Warning */
	"disturb_move",				/* OPT_disturb_move */
	NULL,
	"disturb_panel",			/* OPT_disturb_panel */
	"disturb_state",			/* OPT_disturb_state */
	"disturb_minor",			/* OPT_disturb_minor */
	"alert_hitpoint",			/* OPT_alert_hitpoint */
	NULL,
	"ring_bell",				/* OPT_ring_bell */
	"quick_messages",			/* OPT_quick_messages */
	"compress_messages",		/* OPT_compress_messages */
	"flush_failure",			/* OPT_flush_failure */
	"flush_disturb",			/* OPT_flush_disturb */
	"delay_failure",			/* OPT_delay_failure */
	NULL,
	NULL,
	NULL,
	"colored_hit_msg",		/* OPT_colored_hit_msg */
	"colored_hurt_char",		/* OPT_colored_hurt_char */
	NULL,
	NULL,


	/* Visual Interface */
	NULL,
	"remember_seen_grids",		/* OPT_remember_seen_grids */
	"torch_light",			/* OPT_torch_light */
	"sight_light",			/* OPT_sight_light */
	"wall_lighting",		/* OPT_wall_lighting */
	"floor_lighting",		/* OPT_floor_lighting */
	"highlight_player",			/* OPT_highlight_player */
	"fresh_after",				/* OPT_fresh_after */
	"traps_display_on_top",  /* OPT_traps_display_on_top */
	"depth_in_feet",			/* OPT_depth_in_feet */
	"show_labels",				/* OPT_show_labels */
	"show_weights",				/* OPT_show_weights */
	"show_flavors",				/* OPT_show_flavors */
	"use_metric",				/* OPT_use_metric */
	"always_show_list",         /* OPT_always show list */
	"message_to_window",        /* OPT_message_to_window */
	NULL,
	NULL,
	NULL,
	NULL,

	/* Blank page */
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,


	/* Difficulty and Assistance options */
	"  ",	/* Section header */
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,

	"  ",	/* Section header */
	NULL,
	NULL,
	NULL,
	"help_know",				/* OPT_cheat_know */
	"beginner_play",			/* OPT_beginner_play */
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,


	/* Birth options */

	NULL,
	"birth_autoroll",                 /* OPT_birth_autoroll */
	"ironman_play",                  /* OPT_ironman_play */
	"birth_no_stores",                /* OPT_birth_no_stores */
	"birth_no_artifacts",             /* OPT_birth_no_artifacts */
	"birth_no_return_stair",         /* OPT_no_dungeon_stair */
	"birth_smart_cheat",              /* OPT_smart_cheat */
	NULL,
	NULL,
	NULL
};


/*
 * Options -- descriptions (where defined)
 */
cptr option_desc[OPT_MAX] =
{
	/* Game behavior */
	"Rogue-like commands", /* OPT_rogue_like_commands */
	"Verify destruction of objects",			/* OPT_verify_destroy */
	NULL,
	"Pick things up by default",			/* OPT_always_pickup */
	"Display things before picking them up",			/* OPT_query_floor */
	"Never haggle in stores",				/* OPT_never_haggle */
	"Use old target by default",			/* OPT_use_old_target */
	"Ignore stairs when running",				/* OPT_run_ignore_stairs */
	"Ignore doors when running",				/* OPT_run_ignore_doors */
	"Cut corners when running",				/* OPT_run_cut_corners */
	"Allow accents in output files",			/* OPT_xchars_to_file */
	"Merge inscriptions when stacking",		/* OPT_stack_force_notes */
	"Merge discounts when stacking",		/* OPT_stack_force_costs */
	"Allow quantity specification",				/* OPT_allow_quantity */
	"Change savefile names",		/* OPT_change_save_names */
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,


	/* Disturbance and Warning */
	"Disturb whenever any monster moves",			/* OPT_disturb_move */
	NULL,
	"Disturb whenever map panel changes",			/* OPT_disturb_panel */
	"Disturb whenever player state changes",			/* OPT_disturb_state */
	"Disturb whenever minor things happen",			/* OPT_disturb_minor */
	"Alert user to critical hitpoints",			/* OPT_alert_hitpoint */
	NULL,
	"Audible bell (on errors, etc)",				/* OPT_ring_bell */
	"Activate quick messages",				/* OPT_quick_messages */
	"Compress messages in savefiles",		/* OPT_compress_messages*/
	"Flush input on various failures",			/* OPT_flush_failure */
	"Flush input whenever disturbed",			/* OPT_flush_disturb */
	"Delay on failure",						/* OPT_flush_failure */
	NULL,
	NULL,
	NULL,
	"Colored messages when hit hard",		/* OPT_colored_hit_msg */
	"Special colors for hurt character",		/* OPT_colored_hurt_char */
	NULL,
	NULL,


	/* Visual Interface */
	NULL,
	"Map remembers all seen grids",			/* OPT_remember_seen_grids */
	"Use special colors for torch light",			/* OPT_torch_light */
	"Use special colors for field of view",			/* OPT_sight_light */
	"Use special colors for wall grids",		/* OPT_wall_lighting */
	"Use special colors for floor grids",		/* OPT_floor_lighting */
	"Highlight the player with the cursor",			/* OPT_highlight_player */
	"Flush output after various things",		/* OPT_fresh_after */
	"Don't hide traps when objects pile on them",  /* OPT_traps_display_on_top */
	"Show dungeon level in feet (or meters)",			/* OPT_depth_in_feet */
	"Show labels in equipment listings",				/* OPT_show_labels */
	"Show weights in all object listings",				/* OPT_show_weights */
	"Show flavors in object descriptions",				/* OPT_show_flavors */
	"Use metric (SI) measurements",				/* OPT_use_metric */
	"Menus pop up when selecting various things",   /* OPT_always show list */
	"Move old messages to sub-window automatically",  /* OPT_message_to_window */
	NULL,
	NULL,
	NULL,
	NULL,



	/* Blank page */
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,


	/* Difficulty and Assistance options */
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,

	/* Cheating options */
	NULL,
	NULL,
	NULL,
	NULL,
	"Know complete monster info",		/* OPT_cheat_know */
	"Allow multiple lives",		/* OPT_beginner_play */
	NULL,
	NULL,
	NULL,
	NULL,
	" ",                                      /* Blank line XXX XXX */


	/* Birth options (appear only on the character birth screen) */
	NULL,
	"Allow specification of minimal stats",   /* OPT_birth_autoroll */
	"No return until victorious",      /* OPT_ironman_play */
	"Lock the doors of stores and the home",  /* OPT_birth_no_stores */
	"Do not create artifacts",                /* OPT_birth_no_artifacts */
	"No stairs back the way you came",        /* OPT_birth_no_return_stair */
	"Monsters exploit your weaknesses",       /* OPT_birth_smart_cheat */
	NULL,
	NULL,
	NULL
};


/*
 * Options -- normal values
 */
const bool option_norm[OPT_MAX] =
{
	/* Game behavior */
	FALSE,		/* OPT_rogue_like_commands */
	TRUE, 		/* OPT_verify_destroy */
	FALSE,		/* xxx */
	FALSE,		/* OPT_always_pickup */
	TRUE, 		/* OPT_query_floor */
	FALSE,		/* OPT_never_haggle */
	FALSE,		/* OPT_use_old_target */
	TRUE, 		/* OPT_run_ignore_stairs */
	TRUE, 		/* OPT_run_ignore_doors */
	FALSE, 		/* OPT_run_cut_corners */
	TRUE, 		/* OPT_xchars_to_file */
	TRUE, 		/* OPT_stack_force_notes */
	FALSE,		/* OPT_stack_force_costs */
	TRUE, 		/* OPT_allow_quantity */
	FALSE,		/* OPT_change_save_names */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */


	/* Disturbance and Warning */
	FALSE,		/* OPT_disturb_move */
	FALSE,		/* xxx */
	TRUE, 		/* OPT_disturb_panel */
	TRUE, 		/* OPT_disturb_state */
	FALSE,		/* OPT_disturb_minor */
	TRUE, 		/* OPT_alert_hitpoint */
	FALSE, 		/* xxx */
	TRUE, 		/* OPT_ring_bell */
	TRUE, 		/* OPT_quick_messages */
	FALSE,		/* OPT_compress_messages */
	TRUE, 		/* OPT_flush_failure */
	TRUE, 		/* OPT_flush_disturb */
	TRUE, 		/* OPT_delay_failure */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	TRUE, 		/* OPT_colored_hit_msg */
	TRUE, 		/* OPT_colored_hurt_char */
	FALSE,		/* xxx */
	FALSE,		/* xxx */


	/* Visual Interface */
	FALSE,		/* xxx */
	TRUE, 		/* OPT_remember_seen_grids */
	TRUE, 		/* OPT_torch_light */
	TRUE, 		/* OPT_sight_light */
	TRUE, 		/* OPT_wall_lighting */
	TRUE, 		/* OPT_floor_lighting */
	FALSE,		/* OPT_highlight_player */
	FALSE,		/* OPT_fresh_after */
	TRUE, 		/* OPT_traps_display_on_top */
	FALSE,		/* OPT_depth_in_feet */
	TRUE, 		/* OPT_show_labels */
	TRUE, 		/* OPT_show_weights */
	TRUE, 		/* OPT_show_flavors */
	FALSE,		/* OPT_use_metric */
	TRUE, 		/* OPT_always show list */
	FALSE,		/* OPT_message_to_window */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */


	/* Blank page */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */


	/* Difficulty options */
	FALSE,		/* section header */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */

	/* Cheating/Assistance options */
	FALSE,		/* section header */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* OPT_cheat_know */
	FALSE,		/* OPT_beginner_play */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */
	FALSE,		/* xxx */


	/* Birth options */

	FALSE,
	FALSE,		/* OPT_birth_autoroll */
	FALSE,		/* OPT_ironman_play */
	FALSE,		/* OPT_birth_no_stores */
	FALSE,		/* OPT_birth_no_artifacts */
	FALSE, 		/* OPT_birth_no_return_stair */
	FALSE,		/* OPT_birth_smart_cheat */
	FALSE,
	FALSE,
	FALSE
};


/*
 * Option screen interface
 *
 * Note the special significance given to the constant "255".
 */
const byte option_page[OPT_PAGE_MAX][OPT_PAGE_PER] =
{
	/*** Game behavior ***/

	{
		OPT_rogue_like_commands,
		OPT_verify_destroy,
		255,
		OPT_always_pickup,
		OPT_query_floor,
		OPT_never_haggle,
		OPT_use_old_target,
		OPT_run_ignore_stairs,
		OPT_run_ignore_doors,
		OPT_run_cut_corners,
		OPT_stack_force_notes,
		OPT_stack_force_costs,
		OPT_allow_quantity,
		OPT_change_save_names,
		OPT_xchars_to_file,
		255,
		255,
		255,
		255,
		255
	},

	/*** Disturbance And Warning ***/

	{
		OPT_disturb_move,
		255,
		OPT_disturb_panel,
		OPT_disturb_state,
		OPT_disturb_minor,
		OPT_alert_hitpoint,
		255,
		OPT_ring_bell,
		OPT_quick_messages,
		OPT_compress_messages,
		OPT_flush_failure,
		OPT_flush_disturb,
		OPT_delay_failure,
		255,
		255,
		255,
		OPT_colored_hit_msg,
		OPT_colored_hurt_char,
		255,
		255
	},

	/*** Visual Interface ***/

	{
		255,
		OPT_remember_seen_grids,
		OPT_torch_light,
		OPT_sight_light,
		OPT_wall_lighting,
		OPT_floor_lighting,
		OPT_highlight_player,
		OPT_fresh_after,
		OPT_traps_display_on_top,
		OPT_depth_in_feet,
		OPT_show_labels,
		OPT_show_weights,
		OPT_show_flavors,
		OPT_use_metric,
		OPT_always_show_list,
		OPT_message_to_window,
		255,
		255,
		255,
		255
	},

	/*** Unused ***/

	{
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255,
		255
	},

	/*** Birth and Difficulty ***/

	{
		255,
		OPT_beginner_play,
		OPT_ironman_play,
		OPT_birth_no_stores,
		OPT_birth_no_artifacts,
		OPT_birth_no_return_stair,
		OPT_birth_smart_cheat,
		255,
		255,
		OPT_birth_autoroll,
		255,
		255,
		255,
		255,
		OPT_cheat_know,
		255,
		255,
		255,
		255,
		255
	}
};


/*
 * Default values of various numerical options
 */




/*
 * Text of left panel custom displays
 *
 * See "defines.h" for indexes.
 */
cptr custom_display_text[] =
{
	"",
	"(blank line)",
	"Health of closest monster (named)",
	"Kill count",
	"Score",
	"Fame",
	"Time",
	"Luck",
	"Regeneration",
	"Quest status",
	"Active Target",
	"Realm-specific conditions",
	"",
	"",
	"Attack Modifiers",
	"Oppositions (elements, etc.)",
	"Fear/Boldness/Heroism/Berserk",
	"Protections and Blessings",
	"Weather",
	"",
	"Noise",
	"Invisibility",
	NULL
};


/*
 * Object inscription text
 */
cptr inscrip_text[MAX_INSCRIP] =
{
	NULL,
	"terrible",
	"worthless",
	"cursed",
	"broken",
	"average",
	"good",
	"excellent",
	"special",
	"uncursed",
	"indestructible",
	"blessed",
	"blessed!",
	"cursed!",
	"unknown",
	"unknown (sensed)",
	"cursed"
};


byte mana_cost_RF4[32]=
{
	1,      /* RF4_SHRIEK */
	0,      /* RF4_LASH */
	0,      /* RF4_BOULDER */
	0,      /* RF4_SHOT */
	0,      /* RF4_ARROW */
	0,      /* RF4_BOLT */
	0,      /* RF4_MISSL */
	0,      /* RF4_PMISSLE */
	0,      /* RF4_BRTH_ACID */
	0,      /* RF4_BRTH_ELEC */
	0,      /* RF4_BRTH_FIRE */
	0,      /* RF4_BRTH_COLD */
	0,      /* RF4_BRTH_POIS */
	0,      /* RF4_BRTH_PLAS */
	0,      /* RF4_BRTH_LITE */
	0,      /* RF4_BRTH_DARK */
	0,      /* RF4_BRTH_CONFU */
	0,      /* RF4_BRTH_SOUND */
	0,      /* RF4_BRTH_SHARD */
	0,      /* RF4_BRTH_INER */
	0,      /* RF4_BRTH_GRAV */
	0,      /* RF4_BRTH_FORCE */
	0,      /* RF4_BRTH_NEXUS */
	0,      /* RF4_BRTH_NETHR */
	0,      /* RF4_BRTH_CHAOS */
	0,      /* RF4_BRTH_DISEN */
	0,      /* RF4_BRTH_TIME */
	0,      /* RF4_BRTH_MANA */
	0,      /* RF4_XXX3 */
	0,      /* RF4_XXX4 */
	0,      /* RF4_XXX5 */
	0       /* RF4_XXX6 */
};

byte mana_cost_RF5[32]=
{
	4,      /* RF5_BALL_ACID */
	4,      /* RF5_BALL_ELEC */
	4,      /* RF5_BALL_FIRE */
	4,      /* RF5_BALL_COLD */
	4,      /* RF5_BALL_POIS */
	5,      /* RF5_BALL_LITE */
	5,      /* RF5_BALL_DARK */
	6,      /* RF5_BALL_CONFU */
	4,      /* RF5_BALL_SOUND */
	4,      /* RF5_BALL_SHARD */
	5,      /* RF5_BALL_WIND  */
	5,      /* RF5_BALL_STORM */
	6,      /* RF5_BALL_NETHR */
	7,      /* RF5_BALL_CHAOS */
	5,      /* RF5_BALL_MANA */
	0,      /* RF5_XXX1 */
	4,      /* RF5_BOLT_ACID */
	4,      /* RF5_BOLT_ELEC */
	4,      /* RF5_BOLT_FIRE */
	4,      /* RF5_BOLT_COLD */
	4,      /* RF5_BOLT_POIS */
	4,      /* RF5_BOLT_PLAS */
	4,      /* RF5_BOLT_ICE */
	5,      /* RF5_BOLT_WATER */
	5,      /* RF5_BOLT_NETHER */
	4,      /* RF5_BOLT_MANA */
	0,      /* RF5_XXX3 */
	3,      /* RF5_BEAM_ELEC */
	6,      /* RF5_BEAM_ICE */
	7,      /* RF5_BEAM_NETHER */
	7,      /* RF5_ARC__HFIRE */
	5       /* RF5_ARC__FORCE */
};

byte mana_cost_RF6[32]=
{
	6,      /* RF6_HASTE */
	0,      /* RF6_ADD_MANA */
	0,      /* RF6_HEAL */
	3,      /* RF6_CURE */
	1,      /* RF6_BLINK */
	6,      /* RF6_TPORT */
	0,      /* RF6_XXX1 */
	4,      /* RF6_TELE_SELF_TO */
	4,      /* RF6_TELE_TO */
	8,      /* RF6_TELE_AWAY */
	8,      /* RF6_TELE_LEVEL */
	0,      /* RF6_XXX3 */
	1,      /* RF6_DARKNESS */
	2,      /* RF6_TRAPS */
	6,      /* RF6_FORGET */
	0,      /* RF6_DRAIN_MANA */
	0,      /* RF6_XXX4 */
	4,      /* RF6_CURSE */
	4,      /* RF6_MIND_BLAST */
	0,      /* RF6_XXX7 */
	4,      /* RF6_WOUND */
	5,      /* RF6_HELLDARK */
	4,      /* RF6_HOLY_SMITE */
	0,      /* RF6_XXX8 */
	0,      /* RF6_XXX9 */
	2,      /* RF6_HUNGER */
	0,      /* RF6_XX11 */
	1,      /* RF6_SCARE */
	3,      /* RF6_BLIND */
	4,      /* RF6_CONF */
	5,      /* RF6_SLOW */
	6       /* RF6_HOLD */
};

byte mana_cost_RF7[32]=
{
	11,     /* RF7_S_KIN */ /* Summon - 4 */
	0,      /* RF7_XXX1 */
	0,      /* RF7_XXX2 */
	7,      /* RF7_S_MONSTER */ /* Summon - 1 */
	11,     /* RF7_S_MONSTERS */ /* Summon - 4 */
	0,      /* RF7_XXX3 */
	0,      /* RF7_XXX4 */
	7,      /* RF7_S_BEETLE */
	9,     /* RF7_S_ANT */ /* Summon - 3 */
	9,     /* RF7_S_SPIDER */ /* Summon - 3 */
	9,     /* RF7_S_HOUND */ /* Summon - 2 */
	12,     /* RF7_S_ANIMAL */ /* Summon - 4 */
	0,      /* RF7_XXX6 */
	0,      /* RF7_XXX7 */
	11,     /* RF7_S_THIEF */ /* Summon - 4 */
	5,      /* RF7_S_BERTBILLTOM */ /* Summon - 2 */
	5,      /* RF7_S_ORC */ /* Summon - 1 */
	8,     /* RF7_S_ANGEL */ /* Summon - 1 */
	0,      /* RF7_XX10 */
	0,      /* RF7_XX11 */
	11,     /* RF7_S_DRAGON */ /* Summon - 1 */
	20,     /* RF7_S_HI_DRAGON */ /* Summon - 4 */
	0,      /* RF7_XX12 */
	0,      /* RF7_XX13 */
	7,     /* RF7_S_DEMON */ /* Summon - 1 / 2-3 */
	12,     /* RF7_S_HI_DEMON */ /* Summon - 6 */
	0,      /* RF7_XX14 */
	0,      /* RF7_XX15 */
	9,     /* RF7_S_UNDEAD */ /* Summon - 1 */
	16,     /* RF7_S_HI_UNDEAD */ /* Summon - 4 */
	16,     /* RF7_S_WRAITH */ /* Summon - 6 */
	16      /* RF7_S_UNIQUE */ /* Summon - 4 */
};

/*
 * d_base:     base desirability for AI.
 * d_summ:     desriability for AI per monster level
 *		  times 0-3 based on number of clear spaces
 * d_hurt:     desirability for AI per monster spell power
 *		  times 0-3 based on damage taken
 * d_mana:     desirability for AI per monster spell power
 *		  times 0-2 based on mana shortage
 * d_esc:      desirability for AI per monster level
 *		  times 0-3 based on fear, and damage taken
 * d_tact:     desirability for AI per monster level, modified
 *		  times 0-3 based on proximity, min_range, and best_range
 * d_res:      category of 'resistability' checked by monster AI
 *		 for purposes of desirability.
 * d_range:    % of spell desirability retained for each step past 'range'
 */
byte spell_desire_RF4[32][8] =
{
  /* d_base  d_hurt      d_esc      d_res             */
  /*     d_summ   d_mana      d_tact         d_range  */
	{ 30,  0,   0,   5,     0,   0,    0      ,  100}, /* RF4_SHRIEK    */
	{ 40,  0,   0,   5,     0,   0,    0      ,    0}, /* RF4_LASH      */
	{ 40,  0,   0,   5,     0,   0, LRN_ARCH  ,   33}, /* RF4_BOULDER   */
	{ 40,  0,   0,   5,     0,   0, LRN_ARCH  ,   50}, /* RF4_SHOT      */
	{ 40,  0,   0,   5,     0,   0, LRN_ARCH  ,   50}, /* RF4_ARROW     */
	{ 40,  0,   0,   5,     0,   0, LRN_ARCH  ,   50}, /* RF4_BOLT      */
	{ 35,  0,   0,   5,     0,   0, LRN_ARCH  ,   50}, /* RF4_MISSL     */
	{ 40,  0,   0,   5,     0,   0, LRN_PARCH ,   50}, /* RF4_PMISSL    */
	{ 65,  0,   0,   5,     0,   0, LRN_ACID  ,   90}, /* RF4_BRTH_ACID */
	{ 65,  0,   0,   5,     0,   0, LRN_ELEC  ,   90}, /* RF4_BRTH_ELEC */
	{ 65,  0,   0,   5,     0,   0, LRN_FIRE  ,   90}, /* RF4_BRTH_FIRE */
	{ 65,  0,   0,   5,     0,   0, LRN_COLD  ,   90}, /* RF4_BRTH_COLD */
	{ 65,  0,   0,   5,     0,   0, LRN_POIS  ,   90}, /* RF4_BRTH_POIS */
	{ 65,  0,   0,   5,     0,   0, LRN_PLAS  ,   90}, /* RF4_BRTH_PLAS */
	{ 50,  0,   0,   5,     0,   0, LRN_LITE  ,   90}, /* RF4_BRTH_LITE */
	{ 50,  0,   0,   5,     0,   0, LRN_DARK  ,   90}, /* RF4_BRTH_DARK */
	{ 50,  0,   0,   5,     0,   0, LRN_CONFU ,   90}, /* RF4_BRTH_CONFU*/
	{ 50,  0,   0,   5,     0,   0, LRN_SOUND ,   90}, /* RF4_BRTH_SOUND*/
	{ 50,  0,   0,   5,     0,   0, LRN_SHARD ,   90}, /* RF4_BRTH_SHARD*/
	{ 50,  0,   0,   5,     0,   0,    0      ,   90}, /* RF4_BRTH_INER */
	{ 50,  0,   0,   5,     0,   0, LRN_SOUND2,   90}, /* RF4_BRTH_GRAV */
	{ 50,  0,   0,   5,     0,   0, LRN_SOUND2,   90}, /* RF4_BRTH_FORCE*/
	{ 50,  0,   0,   5,     0,   0, LRN_NEXUS ,   90}, /* RF4_BRTH_NEXUS*/
	{ 50,  0,   0,   5,     0,   0, LRN_NETHR ,   90}, /* RF4_BRTH_NETHR*/
	{ 50,  0,   0,   5,     0,   0, LRN_CHAOS ,   90}, /* RF4_BRTH_CHAOS*/
	{ 50,  0,   0,   5,     0,   0, LRN_DISEN ,   90}, /* RF4_BRTH_DISEN*/
	{ 50,  0,   0,   5,     0,   0,    0      ,   90}, /* RF4_BRTH_TIME */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF4_XXX2 */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF4_XXX3 */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF4_XXX4 */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF4_XXX5 */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100} /* RF4_XXX6 */
};


byte spell_desire_RF5[32][8] =
{
  /* d_base  d_hurt      d_esc      d_res             */
  /*     d_summ   d_mana      d_tact         d_range  */
	{ 50,  0,   0,   0,     0,   0, LRN_ACID  ,  100}, /* RF5_BALL_ACID */
	{ 50,  0,   0,   0,     0,   0, LRN_ELEC  ,  100}, /* RF5_BALL_ELEC */
	{ 50,  0,   0,   0,     0,   0, LRN_FIRE  ,  100}, /* RF5_BALL_FIRE */
	{ 50,  0,   0,   0,     0,   0, LRN_COLD  ,  100}, /* RF5_BALL_COLD */
	{ 50,  0,   0,   0,     0,   0, LRN_POIS  ,  100}, /* RF5_BALL_POIS */
	{ 40,  0,   0,   0,     0,   0, LRN_LITE  ,  100}, /* RF5_BALL_LITE */
	{ 40,  0,   0,   0,     0,   0, LRN_DARK  ,  100}, /* RF5_BALL_DARK */
	{ 40,  0,   0,   0,     0,   0, LRN_CONFU ,  100}, /* RF5_BALL_CONFU*/
	{ 40,  0,   0,   0,     0,   0, LRN_SOUND ,  100}, /* RF5_BALL_SOUND*/
	{ 40,  0,   0,   0,     0,   0, LRN_SHARD ,  100}, /* RF5_BALL_SHARD*/
	{ 40,  0,   0,   0,     0,   0, LRN_WIND  ,  100}, /* RF5_BALL_WIND */
	{ 40,  0,   0,   0,     0,   0, LRN_STORM ,  100}, /* RF5_BALL_STORM*/
	{ 40,  0,   0,   0,     0,   0, LRN_NETHR ,  100}, /* RF5_BALL_NETHR*/
	{ 40,  0,   0,   0,     0,   0, LRN_CHAOS ,  100}, /* RF5_BALL_CHAOS*/
	{ 40,  0,   0,   0,     0,   0,    0      ,  100}, /* RF5_BALL_MANA */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF5_XXX1 */
	{ 40,  0,   0,   0,     0,   0, LRN_ACID  ,  100}, /* RF5_BOLT_ACID */
	{ 40,  0,   0,   0,     0,   0, LRN_ELEC  ,  100}, /* RF5_BOLT_ELEC */
	{ 40,  0,   0,   0,     0,   0, LRN_FIRE  ,  100}, /* RF5_BOLT_FIRE */
	{ 40,  0,   0,   0,     0,   0, LRN_COLD  ,  100}, /* RF5_BOLT_COLD */
	{ 40,  0,   0,   0,     0,   0, LRN_POIS  ,  100}, /* RF5_BOLT_POIS */
	{ 50,  0,   0,   0,     0,   0, LRN_PLAS  ,  100}, /* RF5_BOLT_PLAS */
	{ 50,  0,   0,   0,     0,   0, LRN_ICE   ,  100}, /* RF5_BOLT_ICE  */
	{ 35,  0,   0,   0,     0,   0, LRN_WATER ,  100}, /* RF5_BOLT_WATER*/
	{ 35,  0,   0,   0,     0,   0, LRN_NETHR ,  100}, /* RF5_BOLT_NETHR*/
	{ 30,  0,   0,   0,     0,   0,    0      ,  100}, /* RF5_BOLT_MANA */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF5_XXX3      */
	{ 50,  0,   0,   0,     0,   0, LRN_ELEC  ,    0}, /* RF5_BEAM_ELEC */
	{ 50,  0,   0,   0,     0,   0, LRN_ICE   ,    0}, /* RF5_BEAM_ICE  */
	{ 50,  0,   0,   0,     0,   0, LRN_NETHR ,    0}, /* RF5_BEAM_NETHR*/
	{ 50,  0,   0,   0,     0,   0, LRN_FIRE  ,   90}, /* RF5_ARC__HFIRE*/
	{ 40,  0,   0,   0,     0,   0,    0      ,    0} /* RF5_ARC__FORCE*/
};


byte spell_desire_RF6[32][8] =
{
  /* d_base  d_hurt      d_esc      d_res             */
  /*     d_summ   d_mana      d_tact         d_range  */
	{ 50,  0,   0,   0,     0,   0,    0      ,  100}, /* RF6_HASTE     */
	{ 15,  0,   0,   25,    0,   0,    0      ,  100}, /* RF6_ADD_MANA  */
	{ 10,  0,   20,  0,     0,   0,    0      ,  100}, /* RF6_HEAL      */
	{ 50,  0,   0,   0,     0,   0,    0      ,  100}, /* RF6_CURE      */
	{ 27,  0,   0,   0,     10,  15,   0      ,  100}, /* RF6_BLINK     */
	{ 10,  0,   0,   0,     20,  10,   0      ,  100}, /* RF6_TPORT     */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF6_XXX1      */
	{ 30,  0,   0,   0,     0,   0,    0      ,  100}, /* RF6_TELE_SELF_TO*/
	{ 30,  0,   0,   0,     0,   10,   0      ,  100}, /* RF6_TELE_TO   */
	{ 10,  0,   0,   0,     20,  10,   0      ,  100}, /* RF6_TELE_AWAY */
	{ 10,  0,   0,   0,     20,  10,LRN_NEXUS_SAVE,    100}, /* RF6_TELE_LEVEL */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF6_XXX3      */
	{ 20,  0,   0,   0,     5,   0,    0      ,  100}, /* RF6_DARKNESS  */
	{ 25,  0,   0,   0,     5,   0,    0      ,  100}, /* RF6_TRAPS     */
	{ 20,  0,   0,   0,     5,   0, LRN_SAVE  ,  100}, /* RF6_FORGET    */
	{ 25,  0,   0,   15,    0,   0, LRN_MANA  ,  100}, /* RF6_DRAIN_MANA*/
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF6_XXX4      */
	{ 40,  0,   0,   0,     0,   0,    0      ,  100}, /* RF6_CURSE     */
	{ 45,  0,   0,   0,     0,   0, LRN_SAVE  ,  100}, /* RF6_MIND_BLAST*/
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF6_XXX5 */
	{ 40,  0,   0,   0,     0,   0, LRN_SAVE  ,  100}, /* RF6_WOUND     */
	{ 50,  0,   0,   0,     0,   0,LRN_DARK_SAVE,100}, /* RF6_HELLDARK  */
	{ 50,  0,   0,   0,     0,   0,LRN_HOLY_SAVE,100}, /* RF6_HOLY_SMITE*/
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF6_XXX8      */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF6_XXX9      */
	{ 25,  0,   0,   0,     0,   0,  LRN_SAVE ,  100}, /* RF6_HUNGER    */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF6_XX11      */
	{ 25,  0,   0,   0,     0,   0, LRN_FEAR_SAVE, 100}, /* RF6_SCARE */
	{ 30,  0,   0,   0,     0,   0, LRN_BLIND_SAVE,100}, /* RF6_BLIND */
	{ 30,  0,   0,   0,     0,   0, LRN_CONFU_SAVE,100}, /* RF6_CONF  */
	{ 40,  0,   0,   0,     0,   0, LRN_FREE_SAVE, 100}, /* RF6_SLOW  */
	{ 35,  0,   0,   0,     0,   0, LRN_FREE_SAVE, 100}  /* RF6_HOLD  */
};


byte spell_desire_RF7[32][8] =
{
  /* d_base  d_hurt      d_esc      d_res             */
  /*     d_summ   d_mana      d_tact         d_range  */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_KIN     */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XXX1      */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XXX2      */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_MONSTER */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_MONSTERS*/
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XXX3      */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XXX4      */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_BEETLE  */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_ANT     */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_SPIDER  */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_HOUND   */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_ANIMAL  */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XXX6      */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XXX7      */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_THIEF   */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_BERTBILLTOM*/
	{ 0,   10,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_ORC     */
	{ 0,   18,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_ANGEL   */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XX10      */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XX11      */
	{ 0,   13,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_DRAGON  */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_HI_DRAGON*/
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XX12      */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XX13      */
	{ 0,   16,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_DEMON   */
	{ 0,   18,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_HI_DEMON*/
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XX14      */
	{ 0,   0,   0,   0,     0,   0,    0      ,  100}, /* RF7_XX15      */
	{ 0,   15,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_UNDEAD  */
	{ 0,   17,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_HI_UNDEAD*/
	{ 0,   18,  0,   0,     0,   0,    0      ,  100}, /* RF7_S_WRAITH  */
	{ 0,   18,  0,   0,     0,   0,    0      ,  100}  /* RF7_S_UNIQUE  */
};

/*
 * Spell and attack ranges.
 */
byte spell_range_RF4[32] =
{
	0,
	3,
	4,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	6,
	0,
	0,
	0,
	0,
	0
};

byte spell_range_RF5[32] =
{
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	6,
	12,
	10,
	6,
	8,
};

byte spell_range_RF6[32] =
{
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0
};

byte spell_range_RF7[32] =
{
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
};




/*
 * Skill information table.
 *
 * Title of skill, info blurb, cost of skill.
 * name, desc, cost_adj
 *
 * Position of skill in this table should correspond with the skill index.
 *
 * Note: Swordsmanship gives bonuses to jousting, and vice-versa, at
 *      a rate of half a level per level.  These two skill also affect and
 *      are affected by clubbing.
 * Note: Crossbows gives bonuses to bows, and vice-versa, at a rate of
 *      half a level per level.
 * Note: Burglary gives bonuses to perception, sneaking, disarming, and
 *      dodging.
 */
const skill_type skill_info[NUM_SKILLS] =
{
	{"Swordsmanship", "ability to fight with swords",                   12},
	{"Clubbing", "ability to fight with blunt (hafted) weapons",        12},
	{"Jousting", "ability to fight with pole-mounted weapons",          12},
	{"Archery - Xbows", "ability to use crossbows",                      9},
	{"Archery - Bows", "ability to use bows",                            9},
	{"Archery - Slings", "ability to use slings",                        7},
	{"Throwing", "ability to throw weapons and objects",                 9},

	{"Wrestling", "ability to grapple and throw your opponents",        10},
	{"Karate", "ability to kick and punch your opponents",              10},

	{"Spellcasting", "spell level",                                     16},
	{"Magical Power", "mana supply",                                    12},

	{"Wizardry", "understanding of sorcery and raw magic",               6},
	{"Holy Alliance", "understanding of piety and faith",                6},
	{"Nature Lore", "understanding of nature",                           6},
	{"Blood Dominion", "understanding of necromancy and the undead",     6},

	{"Magical Device", "understanding of magical devices",              13},
	{"Burglary", "skill in thievery and trap-setting",                  14},

	{"Perception", "ability to notice the things around you",            7},
	{"Stealth", "stealth",                                               6},
	{"Disarming", "ability to disarm traps",                             4},
	{"Dodging", "ability to evade attacks and use armour effectively",   6},
	{"Spell Resistance", "resistance to magical attacks",                6},

	{"Weaponsmithing", "ability to forge weapons",                      10},
	{"Bowmaking", "ability to make bows and arrows",                    10},
	{"Armor Forging", "ability to forge armor",                         14},
	{"Alchemy", "ability to create scrolls, potions, rings, & amulets",  9},
	{"Magical Infusion", "ability to magically enhance objects",        13},

	{NULL, NULL, 0},
	{NULL, NULL, 0},
	{NULL, NULL, 0},
	{NULL, NULL, 0},
	{NULL, NULL, 0},
	{NULL, NULL, 0},
	{NULL, NULL, 0},
	{NULL, NULL, 0},
	{NULL, NULL, 0}
};


/*
 * Talent information table.
 *
 * name, index, skill, min_level, timeout
 *
 * Name - name of the talent.  Names longer then 23 characters are trouble.
 * Index char - the list index of the talent, and therefore the command
 *    that the player will press to use it.  You can use the same index for
 *    more than one talent, but only if the character can match the require-
 *    ments for only one at any given time.  You can change indexes between
 *    versions of the game; just don't do it needlessly.  Note that indexes
 *    should be in alphabetical order.  Sneaking should have an index of 's'.
 * Skill - skill required for talent.
 * Level - level of skill (from 1 to 100) required to use this talent.
 *    Many talents also have other requirements.
 * Timeout - Time between uses of this talent.
 */
talent_type talent_info[NUM_TALENTS] =
{
	/* Combat talents */
	{"Turn skin to stone",          'a', S_WRESTLING,    65, 140},
	{"Berserk fury",                'b', S_WRESTLING,    80, 140},
	{"Resist damage",               'c', S_KARATE,       90, 140},
	{"Learn about monster",         'd', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	/* Specialized realm talents */
	{"Detect magic",                'e', S_WIZARDRY,     40,  40},
	{"Phase warp",                  'f', S_WIZARDRY,     70,  10},
	{"Tap magical energy",          'g', S_WIZARDRY,     75,  10},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	{"Sense evil",                  'h', S_PIETY,        30,  50},
	{"Restore stats",               'i', S_PIETY,        75, 400},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	{"Sense animals",               'j', S_NATURE,       25,  40},
	{"Mend self",                   'k', S_NATURE,       50,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	{"Sense undead",                'l', S_DOMINION,     25,  40},
	{"Restore experience",          'm', S_DOMINION,     85, 400},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	/* Magical device */
	{"Sense charges",               'n', S_DEVICE,       70,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	/* Burglary */
	{"Detect and nab objects",      'o', S_BURGLARY,     40,   0},
	{"Poison ammo",                 'p', S_BURGLARY,     55,   0},
	{"Hit and run",                 'q', S_BURGLARY,     70,  10},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	/* Utility skills */
	{"Predict weather",             'r', S_PERCEPTION,    0, WEATHER_LENGTH},
	{"Sneaking",                    's', S_STEALTH,      10,   0},
	{"Sense area",                  't', S_PERCEPTION,   55,  70},
	{"Superstealth",                'u', S_STEALTH,      75, 200},

	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	/* Object-manipulation talents */
	{"Recharging",                  'v', S_INFUSION,     30,   0},
	{"Weapon forging",              'w', S_FORGE_WEAPON, 15,   0},
	{"Armour forging",              'x', S_FORGE_ARMOR,  15,   0},
	{"Bowmaking and Fletchery",     'y', S_FORGE_BOW,    15,   0},
	{"Alchemy",                     'z', S_ALCHEMY,      LEV_REQ_ALCHEMY,   0},
	{"Save/stop saving bottl/parch",'$', S_ALCHEMY,      LEV_REQ_ALCHEMY,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},

	/* Miscellaneous */
	{"Dragon-breathing",            '[', NUM_SKILLS,      0,   2},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0},
	{NULL,                          '?', NUM_SKILLS,      0,   0}
};




/*
 * Creation-related data for object flags
 *
 * essence_sval, cost, prob, desc
 *
 * Essence type (sval) that it uses and generates.
 * Minimum cost in essences.  If flag is pval-dependant, then cost is
 *   when asking for a pval of 10.
 * Probability of essence generation:  100 is normal.
 *
 * Names of pval-dependant flags must not exceed 20 chars.
 * Names of non pval-dependant flags must not exceed 25 chars.
 */
flag_data flag_creation_data[128] =
{
	/* Flags_pval */
	{ ESSENCE_FORCE,   8, 150, "Strength" },
	{ ESSENCE_KNOW,    8, 150, "Intelligence" },
	{ ESSENCE_BLESS,   8, 150, "Wisdom" },
	{ ESSENCE_LIFE,    8, 150, "Dexterity" },
	{ ESSENCE_SHIELD,  8, 150, "Constitution" },
	{ ESSENCE_LITE,    8, 150, "Charisma" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX0)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX1)" },

	{ ESSENCE_DARK ,   8,  50, "Stealth" },
	{ ESSENCE_KNOW,    6, 100, "Awareness" },
	{ ESSENCE_FIRE,    3,  25, "Infravision" },
	{ ESSENCE_FORCE,   6,  70, "Tunneling" },
	{ ESSENCE_TIME,   10, 200, "Speed" },
	{ ESSENCE_DARK,   12, 100, "Invisibility" },
	{ ESSENCE_KNOW,    4,  40, "Disarming" },
	{ ESSENCE_MAGIC,  12, 100, "Magic Device" },
	{ ESSENCE_BLESS,   7, 150, "Saving Throw" },
	{ ESSENCE_MAGIC,   7, 100, "Mana" },
	{ ESSENCE_LITE,   30, 150, "Light Radius" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX6)" },

	{ ESSENCE_DEATH,  30, 100, "Combat Blows" },
	{ ESSENCE_TIME,   30, 100, "Shooting Speed" },
	{ ESSENCE_DEATH,  30, 100, "Extra Might" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX7)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX8)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX9)" },
	{ ESSENCE_MAGIC,   0,   0, "(XX10)" },
	{ ESSENCE_MAGIC,   0,   0, "(XX11)" },
	{ ESSENCE_MAGIC,   0,   0, "(XX12)" },
	{ ESSENCE_MAGIC,   0,   0, "(XX13)" },
	{ ESSENCE_MAGIC,   0,   0, "(XX14)" },
	{ ESSENCE_MAGIC,   0,   0, "(XX15)" },


	/* Flags1 */
	{ ESSENCE_BLESS,   1,  60, "Sust Strength" },
	{ ESSENCE_BLESS,   1,  60, "Sust Intelligence" },
	{ ESSENCE_BLESS,   1,  60, "Sust Wisdom" },
	{ ESSENCE_BLESS,   1,  60, "Sust Dexterity" },
	{ ESSENCE_BLESS,   1,  60, "Sust Constitution" },
	{ ESSENCE_BLESS,   1,  60, "Sust Charisma" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX0)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX1)" },
	{ ESSENCE_DEATH,   2, 100, "Slay Animal" },
	{ ESSENCE_BLESS,   2, 100, "Slay Evil" },
	{ ESSENCE_LIFE,    2, 100, "Slay Undead" },
	{ ESSENCE_BLESS,   2, 100, "Slay Demon" },
	{ ESSENCE_DEATH,   1,  50, "Slay Orc" },
	{ ESSENCE_DEATH,   1,  50, "Slay Troll" },
	{ ESSENCE_DEATH,   1,  50, "Slay Giant" },
	{ ESSENCE_DEATH,   2,  50, "Slay Dragon" },
	{ ESSENCE_DEATH,   0,  75, "Kill Dragon" },   /* Cannot be created */
	{ ESSENCE_MAGIC,   0,   0, "(XXX3)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX4)" },
	{ ESSENCE_ACID,    3, 100, "Acid Brand" },
	{ ESSENCE_ELEC,    3, 100, "Electric Brand" },
	{ ESSENCE_FIRE,    2, 100, "Fire Brand" },
	{ ESSENCE_COLD,    2, 100, "Frost Brand" },
	{ ESSENCE_POIS,    3, 100, "Poison Brand" },
	{ ESSENCE_FIRE,    0, 250, "Flame Brand" },   /* Cannot be created */
	{ ESSENCE_POIS,    0, 250, "Venom Brand" },   /* Cannot be created */
	{ ESSENCE_MAGIC,   0,   0, "Returning" },
	{ ESSENCE_DEATH,   2,  50, "Vorpal" },
	{ ESSENCE_MAGIC,   0,   0, "Throwing Weapon" },   /* Cannot be created */
	{ ESSENCE_MAGIC,   4,  50, "Perfect Balance" },
	{ ESSENCE_MAGIC,   0,   0, "2H required" },
	{ ESSENCE_MAGIC,   0,   0, "2H desired" },


	/* Flags2 */
	{ ESSENCE_ACID,    5, 400, "Immunity to Acid" },
	{ ESSENCE_ELEC,    5, 400, "Immunity to Elec" },
	{ ESSENCE_FIRE,    5, 400, "Immunity to Fire" },
	{ ESSENCE_COLD,    5, 400, "Immunity to Cold" },
	{ ESSENCE_ACID,    1, 100, "Resist Acid" },
	{ ESSENCE_ELEC,    1, 100, "Resist Elec" },
	{ ESSENCE_FIRE,    1, 100, "Resist Fire" },
	{ ESSENCE_COLD,    1, 100, "Resist Cold" },
	{ ESSENCE_POIS,    3, 100, "Resist Poison" },
	{ ESSENCE_LITE,    2, 100, "Resist Light" },
	{ ESSENCE_DARK,    2, 100, "Resist Darkness" },
	{ ESSENCE_FORCE,   2,  30, "Resist Fear" },
	{ ESSENCE_DARK,    3, 100, "Resist Blindness" },
	{ ESSENCE_CONFU,   3, 100, "Resist Confusion" },
	{ ESSENCE_FORCE,   2, 100, "Resist Sound" },
	{ ESSENCE_FORCE,   2, 100, "Resist Shards" },
	{ ESSENCE_NEXUS,   2, 100, "Resist Nexus" },
	{ ESSENCE_NETHR,   2, 100, "Resist Nether" },
	{ ESSENCE_CHAOS,   2, 100, "Resist Chaos" },
	{ ESSENCE_MAGIC,   3, 150, "Resist Disenchant" },
	{ ESSENCE_MAGIC,   0,  50, "Resist Draining" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX2)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX3)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX4)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX5)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX6)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX7)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX8)" },
	{ ESSENCE_ACID,    0,  10, "Ignore Acid" },
	{ ESSENCE_ELEC,    0,  10, "Ignore Electricity" },
	{ ESSENCE_FIRE,    0,  10, "Ignore Fire" },
	{ ESSENCE_COLD,    0,  10, "Ignore Cold" },


	/* Flags3 */
	{ ESSENCE_LIFE,    1,  50, "Slow Digestion" },
	{ ESSENCE_FORCE,   1,  30, "Feather Fall" },
	{ ESSENCE_LITE,    3, 200, "Glowing (+1 light)" },
	{ ESSENCE_LIFE,    1,  50, "Regeneration" },
	{ ESSENCE_KNOW,    9, 300, "Telepathy" },
	{ ESSENCE_KNOW,    1,  75, "See Invisible" },
	{ ESSENCE_TIME,    1,  25, "Free Action" },
	{ ESSENCE_LIFE,    2, 100, "Hold Life" },
	{ ESSENCE_BLESS,   2, 100, "Blessed" },
	{ ESSENCE_FORCE,   3, 100, "Impact Blows" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX1)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX2)" },
	{ ESSENCE_LITE,    0,   0, "Is lit" },  /* XXX */
	{ ESSENCE_MAGIC,   0,   0, "Instant Artifact" },
	{ ESSENCE_MAGIC,   0,   0, "Easy Know" },
	{ ESSENCE_MAGIC,   0,   0, "Hide Type" },
	{ ESSENCE_MAGIC,   0,   0, "Show Mods" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX4)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX5)" },
	{ ESSENCE_MAGIC,   0,   0, "Needs no Fuel" },
	{ ESSENCE_DEATH,   0, 100, "Requires Feeding" },
	{ ESSENCE_MAGIC,   0,  50, "Prevents Magic" },
	{ ESSENCE_NEXUS,   0,  50, "Random Teleport" },
	{ ESSENCE_MAGIC,   0,   0, "Aggravation" },
	{ ESSENCE_NETHR,   0, 100, "Drains Experience" },
	{ ESSENCE_NETHR,   0, 100, "Drains Hitpoints" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX8)" },
	{ ESSENCE_MAGIC,   0,   0, "(XXX9)" },
	{ ESSENCE_MAGIC,   0,   0, "Hidden Curse" },
	{ ESSENCE_MAGIC,   0,   0, "Cursed" },
	{ ESSENCE_MAGIC,   0,   0, "Heavily Cursed" },
	{ ESSENCE_MAGIC,   0,   0, "Permanently Cursed" }
};


/*
 * Text of precognition messages.
 *
 * '#' -- "a", "2", 3", etc.   '##' -- "an"
 * '*' -- "s"    '**' -- "es"
 * '@' -- "1 time", "2 times", etc.
 */
cptr precog_msg_text[PRECOG_MSG_INDEX_MAX] =
{
	"",
	"You sense & horde* of monsters.",
	"You sense & gathering* of monsters.",
	"You sense & very dangerous place*.",
	"You sense & dangerous place*.",
	"",
	"",
	"You sense & terrible presence*.",
	"You sense & powerful presence*.",
	"You sense & presence*.",
	"You sense something terribly dangerous @.",
	"You sense something very dangerous @.",
	"You sense something dangerous @.",
	"",
	"",
	"",
	"You sense & remarkable object*.",
	"You sense & powerful object*.",
	"You sense & object* of wondrous power.",
	"",
	"",
	""
};


/*
 * Table of character type names.
 */
cptr character_type_name[PCHAR_MAX] =
{
	"Beginner",
	"",
	"Normal",
	"",
	"Ironman",
	""
};

/*
 * Table of character type descriptions.
 */
cptr character_type_desc[PCHAR_MAX] =
{
	"Beginner character: Can cheat death.",
	"",
	"Normal character: One life only.",
	"",
	"Ironman character: Cannot go upwards or recall.",
	""
};
