
/* File: defines.h */

/*
 * Copyright (c) 1999 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * You have been warned.
 */





/*
 * Name of the version/variant
 */
#define VERSION_NAME    "Sangband"


/*
 * Current version string
 */
#define VERSION_STRING   "0.9.9, beta 21"

/*
 * Current (Sangband) version numbers
 */
#define VERSION_MAJOR   0
#define VERSION_MINOR   9
#define VERSION_PATCH   9

/*
 * This value is used for beta versions
 */
#define VERSION_EXTRA   21

/*
 * Number of grids in each block (vertically).
 * Hard-coded to 11 by quite a lot of things.
 */
#define BLOCK_HGT   11

/*
 * Number of grids in each block (horizontally).
 * Hard-coded to 11 by quite a lot of things.
 */
#define BLOCK_WID   11


/*
 * Number of grids in each panel (vertically)
 * Must be a multiple of BLOCK_HGT
 */
#define PANEL_HGT   11

/*
 * Number of grids in each panel (horizontally)
 * Must be a multiple of BLOCK_WID
 */
#define PANEL_WID   33


/* See "variable.c" for "map_rows". */

/*
 * Number of grids used to display the dungeon (horizontally).
 * Must be a multiple of 33, probably hard-coded to 66.
 */
#define SCREEN_WID   66


/*
 * Maximum number of grids in each dungeon (vertically)
 * Must be a multiple of PANEL_HGT.
 * Must be less or equal to 256
 */
#define DUNGEON_HGT_MAX    66

/*
 * Maximum number of grids in each dungeon (horizontally)
 * Must be a multiple of PANEL_WID, and possibly of SCREEN_WID
 * Must be less or equal to 256
 */
#define DUNGEON_WID_MAX   198


/*
 * Maximum number of Angband windows.
 *
 * This number is fixed at 8 in savefiles.
 */
#define ANGBAND_TERM_MAX    8

/*
 * Number of colors.  Can not be increased above 128 unless the graphical
 * code is rewritten.
 */
#define MAX_COLORS        128



/*
 * Maximum number of artifact sets
 */
#define MAX_S_IDX       10

/*
 * Maximum number of quest memory areas
 */
#define MAX_QM_IDX      50


/*
 * Store index definitions (see "store.c", etc)
 */
#define STORE_GENERAL    0
#define STORE_ARMOR      1
#define STORE_WEAPON     2
#define STORE_TEMPLE     3
#define STORE_ALCHEMY    4
#define STORE_MAGIC      5
#define STORE_SPELLBOOK  6
#define STORE_HOME       7
#define STORE_INN        8

/*
 * Total number of stores (see "store.c", etc)
 */
#define MAX_STORES       9

/*
 * Total number of owners per store (see "store.c", etc)
 */
#define MAX_OWNERS       6

/*
 * Total number of owners per store (see "store.c", etc)
 */
#define MAX_OWNERS       6


/*
 * Maximum number of player "sex" types (see "table.c", etc)
 */
#define MAX_SEXES        2

/*
 * Maximum number of magical realms (see "table.c", etc)
 */
#define MAX_REALM        4


/*
 * Number of tval/min-sval/max-sval slots per ego_item
 */
#define EGO_TVALS_MAX    3

/*
 * Maximum number of high scores in the high score file
 */
#define MAX_HISCORES  100


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
#define MAX_DEPTH  128


/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * were octagonal, we would never require more than 1520 entries in the
 * array.
 */
#define VIEW_MAX  1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" and "LITE_MAX" for proper functioning
 * of "update_view()" and "update_lite()".  We must also be as large as the
 * largest illuminatable room, at least in theory.
 */
#define TEMP_MAX  2000

/*
 * Maximum size of the "lite" array (see "cave.c").
 *
 * If memory were free, we should be as large as the view array, but
 * in anything but extrordinary situations, 500 grids /should/ be enough.
 */
#define LITE_MAX  500


/*
 * Maximum size of the "effect_grid" array (see "effect.c")
 * We must be at least as large as all simultaneous effects that need
 * to "linger" between turns.
 */
#define EFFECT_GRID_MAX  1500


/*
 * Maximum distance from the character to store flow (noise) information
 */
#define NOISE_STRENGTH   45

/*
 * Character turns it takes for smell to totally dissipate
 */
#define SMELL_STRENGTH   50


/*
 * OPTION: Maximum number of macros (see "util.c")
 * Default: assume at most 256 macros are used
 */
#define MACRO_MAX    256

/*
 * OPTION: Maximum number of "quarks" (see "util.c")
 * Default: assume at most 512 different inscriptions are used
 */
#define QUARK_MAX    512

/*
 * OPTION: Maximum number of messages to remember (see "util.c")
 * Default: assume maximal memorization of 2048 total messages
 */
#define MESSAGE_MAX    2048

/*
 * OPTION: Maximum space for the message text buffer (see "util.c")
 * Default: assume that each of the 2048 messages is repeated an
 * average of three times, and has an average length of 48
 */
#define MESSAGE_BUF    32768


/*
 * Maximum value storable in a "byte" (hard-coded)
 */
#define MAX_UCHAR       255

/*
 * Maximum value storable in a "s16b" (hard-coded)
 */
#define MAX_SHORT       32767


/*
 * Store constants
 */
#define STORE_INVEN_MAX   24		/* Max number of discrete objs in inven */
#define STORE_OBJ_LEVEL    5		/* Magic Level for normal items */
#define STORE_MAX_KEEP    18		/* Max slots to "always" keep full */
#define STORE_SHUFFLE   1500		/* 1/Chance (per turnover) of owner change */
#define STORE_TURNS       50		/* Number of turns (x10) between turnovers */
#define STORE_STOCK_SIZE 180		/* Size of store stock table */


/*
 * Misc constants
 */
#define TOWN_DAWN    10000  /* Number of turns from dawn to dawn XXX */
#define BREAK_GLYPH    300  /* Rune of protection resistance */
#define BTH_PLUS_ADJ     2  /* Value of each object plus to Skill */
#define MON_MULT_ADJ     8  /* High value slows multiplication */
#define MON_DRAIN_LIFE   2  /* 1/100ths of player exp drained per hit */

#define MAX_GLYPHS       4


/*
 * The experience cost adjustment.  Base cost is divided by this figure.
 *
 * This value was derived by noting that it takes approximately 600 level
 * raises (taking varying skill costs into account) to closely duplicate
 * an Angband-equivalent Warrior at highest level (i.e. level 100).  To
 * restore parity, the cost of each skill increase is therefore divided by
 * six.  Be very careful about adjusting this figure.
 */
#define EXP_ADJ          6

/*
 * The character power adjustment.  Character power is determined by summing
 * up the character's exp in all skills as adjusted by the skill cost
 * together, and dividing that total by this value.
 *
 * POWER_ADJ should equal EXP_ADJ.
 */
#define POWER_ADJ        6


/*
 * Percentage of maximum noise you can make just walking around, given a
 * stealth of zero.
 */
#define WAKEUP_ADJ      20

/*
 * There is a 8.5% chance of inflating the requested object_level during
 * the creation of an object (see "get_obj_num()" in "object.c").  Lower
 * values yield better objects more often.
 *
 * In Sangband, objects are more often generated out of depth, but not
 * by as much.
 */
#define GREAT_OBJ       12

/*
 * There is a 8.5% chance that ego-items with an inflated base-level are
 * generated when an object is turned into an ego-item (see make_ego_item()
 * in object2.c).  As above, lower values yield better ego-items more often.
 */
#define GREAT_EGO        12


/*
 * There is a 20% chance for a non-ego weapon to get the plusses or
 * minuses that ego-weapons get.
 */
#define XTRA_BONUS       5


/*
 * There is a 1/25 (4%) chance of inflating the requested monster_level
 * during the creation of a monsters (see "get_mon_num()" in "monster2.c").
 * Lower values yield harder monsters more often.
 */
#define NASTY_MON       25

/*
 * Chance for essences to be created (out of 1000).
 */
#define ESSENCE_PROB    125


/*
 * Refueling constants
 */
#define FUEL_TORCH    5000		/* Maximum amount of fuel in a torch */
#define FUEL_LAMP    15000		/* Maximum amount of fuel in a lantern */


/*
 * Maximum sighting and firing distances
 */
#define MAX_SIGHT       20			/* Maximum view distance */
#define MAX_RANGE       20			/* Maximum range (spells, etc) */


/*
 * If "m_ptr->marked is equal or greater then this number, display object
 * in memorized color.  This is an egregious hack.  XXX XXX XXX  -LM-
 */
#define COLORED_OBJ_MIN    200

/*
 * There is a 1/200 basal chance per round of creating a new monster
 */
#define MAX_M_ALLOC_CHANCE    200

/*
 * The maximum number of randomly allocated monsters that level 100 can
 * have is 30.
 */
#define MIN_M_ALLOC_LEVEL  30

/*
 * The town starts out with 8 residents during the day
 */
#define MIN_M_ALLOC_TD     8

/*
 * The town starts out with 4 residents during the night
 */
#define MIN_M_ALLOC_TN      4



/*
 * Player character types used by character_type
 */
#define PCHAR_BEGINNER   0    /* Beginner character, cheats death */
/* xxx for future addition */
#define PCHAR_NORMAL     2    /* Normal character, one life only */
/* xxx for future addition */
#define PCHAR_IRONMAN    4    /* Ironman character */

#define PCHAR_MAX        6    /* Maximum number of character types */


/*
 * Player constants
 */
#define PY_MAX_EXP      99999999L   /* Maximum exp */
#define PY_MAX_GOLD    999999999L   /* Maximum gold */
#define PY_MAX_POWER         100    /* Maximum character power */

/*
 * Player "food" crucial values for most characters
 */
#define PY_FOOD_MAX      15000	/* Food value (Bloated) */
#define PY_FOOD_FULL     10000	/* Food value (Normal) */
#define PY_FOOD_ALERT     2000	/* Food value (Hungry) */
#define PY_FOOD_WEAK      1000	/* Food value (Weak) */
#define PY_FOOD_FAINT      500	/* Food value (Fainting) */
#define PY_FOOD_STARVE     100	/* Food value (Starving) */

/*
 * Player regeneration constants
 */
#define PY_REGEN_NORMAL     30	/* Normal regen: 30/10000ths HP per HP per turn */
#define PY_REGEN_WEAK       15	/* Regeneration when weak */
#define PY_REGEN_FAINT       5	/* Regeneration when fainting */
#define PY_REGEN_HPBASE    400	/* Bonus to regeneration:  1/25 HP per turn */
#define PY_REGEN_MNBASE    400	/* Bonus to regeneration:  1/25 HP per turn */



/*
 * Flags for player_type.spell_flags[]
 */
#define PY_SPELL_WORKED     0x02 /* Spell has been successfully tried */
#define PY_SPELL_FORGOTTEN  0x04 /* Spell has been forgotten */

/*
 * Maximum number of player spells
 */
#define PY_MAX_SPELLS	64


/*
 * Maximum number of "normal" pack slots, and the index of the "overflow"
 * slot, which can hold an item, but only temporarily, since it causes the
 * pack to "overflow", dropping the "last" item onto the ground.  Since this
 * value is used as an actual slot, it must be less than "INVEN_WIELD" (below).
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles.
 */
#define INVEN_PACK      23

/*
 * Indexes used for various equipment slots (hard-coded by savefiles, etc).
 */
#define INVEN_WIELD     24
#define INVEN_BOW       25
#define INVEN_LEFT      26
#define INVEN_RIGHT     27
#define INVEN_NECK      28
#define INVEN_LITE      29
#define INVEN_BODY      30
#define INVEN_OUTER     31
#define INVEN_ARM       32
#define INVEN_HEAD      33
#define INVEN_HANDS     34
#define INVEN_FEET      35

#define INVEN_SUBTOTAL  36
#define INVEN_POUCH     36  /* Appears if character has any essences */

/* 10 quiver slots */

#define INVEN_Q1        37
#define INVEN_Q2        38
#define INVEN_Q3        39
#define INVEN_Q4        40
#define INVEN_Q5        41
#define INVEN_Q6        42
#define INVEN_Q7        43
#define INVEN_Q8        44
#define INVEN_Q9        45
#define INVEN_Q0        46

#define QUIVER_SLOTS   10



/*
 * Each throwing weapon in the "quiver" takes up the space of this
 * many pieces of ammo.
 */
#define THROWER_AMMO_FACTOR   5


/*
 * Total number of inventory slots (hard-coded to be <= 47).
 */
#define INVEN_TOTAL     47


/*
 * A "stack" of items is limited to less than 100 items (hard-coded).
 */
#define MAX_STACK_SIZE      100


/*
 * Maximum number of objects allowed in a single dungeon grid.
 *
 * The main-screen has a minimum size of 24 rows, so we can always
 * display 23 objects + 1 header line.
 */
#define MAX_FLOOR_STACK			23


/*
 * Total number of stats.
 */
#define A_MAX     6

/*
 * Indexes of the various "stats" (hard-coded by savefiles, etc).
 */
#define A_STR     0
#define A_INT     1
#define A_WIS     2
#define A_DEX     3
#define A_CON     4
#define A_CHR     5

/*
 * Player sex constants (hard-coded by save-files, arrays, etc)
 */
#define SEX_FEMALE       0
#define SEX_MALE         1

/*
 * Player race constants (hard-coded by save-files, arrays, etc)
 */
#define RACE_HUMAN        0
#define RACE_ELF          1
#define RACE_HOBBIT       2
#define RACE_GNOME        3
#define RACE_DWARF        4
#define RACE_HALF_ORC     5
#define RACE_HALF_TROLL   6
#define RACE_DUNADAN      7
#define RACE_HIGH_ELF     8
#define RACE_DARK_ELF     9
#define RACE_GIANT       10

#define MAX_RACES        11



/* Player realms */
#define MAGE      1
#define PRIEST    2
#define DRUID     3
#define NECRO     4
#define NONE      0




/* Skill Indexes (see the table "skill_type") */
#define S_NOSKILL       -1       /* no skill */
#define S_SWORD          0       /* swords */
#define S_HAFTED         1       /* hafted weapons */
#define S_POLEARM        2       /* polearms */

#define S_CROSSBOW       3       /* crossbows */
#define S_BOW            4       /* bows */
#define S_SLING          5       /* slings */
#define S_THROWING       6       /* throwing */

#define S_WRESTLING      7       /* wrestling */
#define S_KARATE         8       /* karate */

#define S_MAGIC          9       /* spell level */
#define S_MPOWER        10       /* mana level */

#define S_WIZARDRY      11       /* sorcery fail chance, magic knowledge */
#define S_PIETY         12       /* priestly fail chance, protect from evil */
#define S_NATURE        13       /* druidic fail chance, protect from natural */
#define S_DOMINION      14       /* necro fail chance, protect from undead */

#define S_DEVICE        15       /* magical devices */
#define S_BURGLARY      16       /* thieving ability */

#define S_PERCEPTION    17       /* perception, searching, awareness */
#define S_STEALTH       18       /* intrinsic stealth, noise-making */
#define S_DISARM        19       /* disarming */
#define S_DODGING       20       /* dodging and armor use skill */
#define S_SAVE          21       /* saving throw */

#define S_FORGE_WEAPON  22       /* weaponsmithing */
#define S_FORGE_BOW     23       /* bow and missile making */
#define S_FORGE_ARMOR   24       /* armor forging */
#define S_ALCHEMY       25       /* scroll, potion, ring, & amulet creation */
#define S_INFUSION      26       /* magical enhancement (using essences) */

#define S_XXX1          28       /*  */
#define S_XXX1          28       /*  */
#define S_XXX2          29       /*  */
#define S_XXX3          30       /*  */
#define S_XXX4          31       /*  */
#define S_XXX5          32       /*  */
#define S_XXX6          33       /*  */
#define S_XXX7          33       /*  */
#define S_XXX8          34       /*  */

#define NUM_SK_USED     27
#define NUM_SKILLS      36


/*
 * The various oaths and commitments a character can make.
 */
#define OATH_OF_IRON            0x01
#define OATH_OF_SORCERY         0x02
#define COVENANT_OF_FAITH       0x04
#define YAVANNAS_FELLOWSHIP     0x08
#define BLACK_MYSTERY           0x10
#define BURGLARS_GUILD          0x20


/*
 * Minimum skill level for various things.
 */
#define LEV_REQ_BURGLE        4  /* S_BURGLARY - stealing, light weapons */
#define LEV_REQ_LOCK_DOOR     7  /* S_BURGLARY - lock doors */
#define LEV_REQ_TRAP         10  /* S_BURGLARY - setting traps */
#define LEV_REQ_GUILD        20  /* S_BURGLARY - Entrance to the Guild */
#define LEV_REQ_PRECOG       40  /* S_PERCEPTION - precog messages */
#define LEV_REQ_ALCHEMY      10  /* S_ALCHEMY - make potions and scrolls */
#define LEV_REQ_ALCHEMY_RING 35  /* S_ALCHEMY - make rings and amulets */
#define LEV_REQ_INFUSE       10  /* S_INFUSION - infuse wargear */
#define LEV_REQ_GRENADE      15  /* S_INFUSION - magical grenades */
#define LEV_REQ_XTRA_LIGHT   95  /* S_PIETY - extra light */
#define LEV_REQ_RECHARGE     30  /* S_DEVICE - allow essence-based recharging */


#define LEV_REQ_WRESTLE_STR_BONUS1   40  /* STR and DEX bonuses */
#define LEV_REQ_WRESTLE_STR_BONUS2   75
#define LEV_REQ_KARATE_STR_BONUS1    60
#define LEV_REQ_KARATE_DEX_BONUS1    40
#define LEV_REQ_KARATE_DEX_BONUS2    80
#define LEV_REQ_WRESTLE_DEX_BONUS1   60



/*
 * Talent indexes.
 */
#define TALENT_STONESKIN            0
#define TALENT_BERSERK              1
#define TALENT_RESIST_DAM           2
#define TALENT_PROBING              3
#define TALENT_XXX1                 4
#define TALENT_XXX2                 5
#define TALENT_XXX3                 6
#define TALENT_XXX4                 7

#define TALENT_DET_MAGIC            8
#define TALENT_PHASE_WARP           9
#define TAP_ENERGY                 10
#define TALENT_XXX5                11

#define TALENT_DET_EVIL            12
#define TALENT_RESTORATION         13
#define TALENT_XXX6                14
#define TALENT_XXX7                15

#define TALENT_DET_ANIMAL          16
#define TALENT_MEND_WOUNDS         17
#define TALENT_XXX8                18
#define TALENT_XXX9                19

#define TALENT_DET_UNDEAD          20
#define TALENT_REMEMBRANCE         21
#define TALENT_XX10                22
#define TALENT_XX11                23

#define TALENT_ID_CHARGES          24
#define TALENT_XX12                25

#define TALENT_D_OR_NAB_OBJECT     26
#define TALENT_POISON_AMMO         27
#define TALENT_HIT_AND_RUN         28
#define TALENT_XX14                29

#define TALENT_PRED_WEATH          30
#define TALENT_SNEAKING            31
#define TALENT_SENSE_AREA          32
#define TALENT_SUPERSTEALTH        33
#define TALENT_XX15                34
#define TALENT_XX16                35
#define TALENT_XX17                36
#define TALENT_XX18                37

#define TALENT_RECHARGING          38
#define TALENT_WEAPON_SMITH        39
#define TALENT_ARMOUR_SMITH        40
#define TALENT_MISSILE_SMITH       41
#define TALENT_ALCHEMY             42
#define TALENT_SAVE_BOTTLE         43
#define TALENT_XX20                44
#define TALENT_XX21                45
#define TALENT_XX22                46
#define TALENT_XX23                47

#define TALENT_DRAGON_BREATHING    48
#define TALENT_XX24                49
#define TALENT_XX25                50
#define TALENT_XX26                51
#define TALENT_XX27                52
#define TALENT_XX28                53
#define TALENT_XX29                54
#define TALENT_XX30                55

#define NUM_TALENTS 56


/*
 * Specialties (used for tailored rewards and titles).
 */
#define SPECIALTY_NONE               0
#define SPECIALTY_HAND_BURGLAR       1
#define SPECIALTY_FIGHT_BURGLAR      2
#define SPECIALTY_PURE_BURGLAR       3
#define SPECIALTY_P_WIZARD           4
#define SPECIALTY_H_WIZARD           5
#define SPECIALTY_P_PRIEST           6
#define SPECIALTY_H_PRIEST           7
#define SPECIALTY_P_DRUID            8
#define SPECIALTY_H_DRUID            9
#define SPECIALTY_P_NECRO            10
#define SPECIALTY_H_NECRO            11
#define SPECIALTY_SWORDS             12
#define SPECIALTY_POLEARMS           13
#define SPECIALTY_HAFTED             14
#define SPECIALTY_MISSILE_MAGIC      15
#define SPECIALTY_CROSSBOW           16
#define SPECIALTY_BOW                17
#define SPECIALTY_SLING              18
#define SPECIALTY_WRESTLING          19
#define SPECIALTY_KARATE             20
#define SPECIALTY_THROWING           21
#define SPECIALTY_FIGHTER            22
#define SPECIALTY_DEVICE             23
#define SPECIALTY_FORGING            24
#define SPECIALTY_ALCHEMY            25
#define SPECIALTY_INFUSION           26
#define SPECIALTY_MAGE_BURGLAR       27
#define SPECIALTY_PRIEST_BURGLAR     28
#define SPECIALTY_DRUID_BURGLAR      29
#define SPECIALTY_NECRO_BURGLAR      30

/*
 * Precognition message indexes.
 */
#define PRECOG_WIPE                  -1
#define PRECOG_DISPLAY                0

#define PRECOG_GEN_HORDE              1
#define PRECOG_GEN_COMMUNITY          2
#define PRECOG_GEN_DANGEROUS          3
#define PRECOG_GEN_VERY_DANGEROUS     4

#define PRECOG_MON_UNIQUE_HEAVY       7
#define PRECOG_MON_UNIQUE_MEDIUM      8
#define PRECOG_MON_UNIQUE_LIGHT       9
#define PRECOG_MON_DEPTH_HEAVY       10
#define PRECOG_MON_DEPTH_MEDIUM      11
#define PRECOG_MON_DEPTH_LIGHT       12

#define PRECOG_OBJ_GREAT_POWER       16
#define PRECOG_OBJ_REMARKABLE        17
#define PRECOG_OBJ_WONDROUS          18

#define PRECOG_MSG_INDEX_MAX         22


/*
 * Maximum value for the weather.  If this value is changed, some of the
 * numbers in the function "predict_weather()", in spells2.c and in the
 * function "left_panel_display()", in xtra1.c, should also be changed.
 */
#define MAX_WEATHER       7

/*
 * The time, measured in tens of game turns, between random changes in the
 * weather varies between this value and twice this value.
 */
#define WEATHER_LENGTH    300


/*
 * Torches with less fuel than this burn more dimly
 */
#define TORCH_LOW       1500

/*
 * Inn names
 */
#define MAX_INN_NAMES      11






/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 */

#define ROW_NAME         1
#define COL_NAME         0		/* <short name of character> */

#define ROW_TITLE        2
#define COL_TITLE        0		/* <title> or <mode> */


#define ROW_EXP          4
#define COL_EXP          0		/* "EXP xxxxxxxx" */

#define ROW_GOLD         5
#define COL_GOLD         0		/* "AU xxxxxxxxx" */

#define ROW_EQUIPPY      6
#define COL_EQUIPPY      0		/* "xxxxxxxxxxx" */

#define ROW_STAT         7
#define COL_STAT         0		/* "xxx   xxxxxx" */

#define ROW_SHAPE       13
#define COL_SHAPE        0	/* Name of current shape, if non-normal */

#define ROW_AC          14
#define COL_AC           0		/* "Cur AC xxxxx" */

#define ROW_HP          15
#define COL_HP           0		/* "Cur HP xxxxx" */

#define ROW_SP          16
#define COL_SP           0		/* "Max SP xxxxx" */

#define ROW_INFO        17
#define COL_INFO         0		/* "xxxxxxxxxxxx" */

/* Blank lines for customization */

#define COL_HUNGRY       0		/* "Weak" / "Hungry" / "Full" / "Gorged" */

#define COL_CONDITIONS   7    /* Priority queue of condition statuses */

#define COL_STATE       40		/* <state> */

#define COL_SPEED       51		/* "Slow (-NN)" or "Fast (+NN)" */

#define COL_UNCAST      62		/* "Uncast: N" */

#define COL_DEPTH       72		/* "Lev NNN" / "NNNN ft" */

#define ROW_MAP          1
#define COL_MAP         13

/*
 * Quest types
 */
#define QUEST_FIXED         1
#define QUEST_RANDOM        2

/*
 * Quest reward types
 */
#define REWARD_GOLD         1
#define REWARD_GOOD_ITEM    2
#define REWARD_GREAT_ITEM   3

/*
 * Quest item name parts
 */
#define QUEST_NAME_1       11
#define QUEST_NAME_2       14
#define QUEST_NAME_3       11


/*
 * Values for amount of space available to place monsters.
 *
 * See monster2.c, "check_monster_space()"
 */
#define SPACE_LOTS          3
#define SPACE_SOME          2
#define SPACE_ONE           1
#define SPACE_UNKNOWN       0

/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_KIN          1
#define SUMMON_BEETLE      10
#define SUMMON_ANT         11
#define SUMMON_SPIDER      12
#define SUMMON_HOUND       13
#define SUMMON_ANIMAL      14
#define SUMMON_BERTBILLTOM 15
#define SUMMON_DEMON       16
#define SUMMON_UNDEAD      17
#define SUMMON_DRAGON      18
#define SUMMON_HI_DEMON    20
#define SUMMON_HI_UNDEAD   21
#define SUMMON_HI_DRAGON   22

#define SUMMON_ANGEL       28
#define SUMMON_ORC         29
#define SUMMON_WRAITH      31
#define SUMMON_UNIQUE      32
#define SUMMON_ELEMENTAL   33
#define SUMMON_VORTEX      34
#define SUMMON_HYBRID      35
#define SUMMON_BIRD        36
#define SUMMON_THIEF       38

#define SUMMON_INDEX       40






/*
 * Spell types used by project(), and related functions.
 *
 * See the table "projection_names" for display names.
 */
#define GF_ROCK            1	/* Physical missiles */
#define GF_SHOT            2
#define GF_ARROW           3
#define GF_MISSILE         4
#define GF_PMISSILE        5
#define GF_WHIP            6	/* Used for lash/spit attacks. */
#define GF_HURT            7	/* Hurt, no resists or side-effects */


#define GF_ACID            8	/* The basic elements & poison */
#define GF_ELEC            9
#define GF_FIRE           10
#define GF_COLD           11
#define GF_POIS           12

#define GF_PLASMA         13	/* Variations on the elements */
#define GF_HELLFIRE       14
#define GF_ICE            15

#define GF_LITE_WEAK      20	/* Light and darkness */
#define GF_LITE           21
#define GF_LITE_EXTRA     22
#define GF_DARK_WEAK      23
#define GF_DARK           24
#define GF_MORGUL_DARK    25

#define GF_CONFUSION      26	/* Physical */
#define GF_SOUND          27
#define GF_SHARD          28
#define GF_INERTIA        29
#define GF_GRAVITY        30
#define GF_FORCE          31
#define GF_WATER          32
#define GF_WIND           33
#define GF_STORM          34

#define GF_NEXUS          40	/* Magical */
#define GF_NETHER         41
#define GF_CHAOS          42
#define GF_DISENCHANT     43
#define GF_TIME           44
#define GF_MANA           45

#define GF_METEOR         53	/* Special attacks */
#define GF_HOLY_ORB       54
#define GF_BLACK_ORB      55
#define GF_DEATH          56
#define GF_VAMP_DRAIN     57
#define GF_DEATH_CLOUD    58
#define GF_SPORE          59
#define GF_FORGET         60

#define GF_CURSE          64	/* Attack plus hindrance */
#define GF_SMITE          65
#define GF_DISPEL         66
#define GF_DISPEL_SMALL   67
#define GF_PSI            68
#define GF_MADNESS        69

#define GF_DO_FEAR        78	/* Pure hindrance */
#define GF_DO_TURN        79
#define GF_DO_SLOW        80
#define GF_DO_CONF        81
#define GF_DO_SLEEP       82
#define GF_DO_STUN        83

#define GF_DO_CLONE       86	/* Other monster-affect */
#define GF_DO_POLY        87
#define GF_DO_HEAL        88
#define GF_DO_SPEED       89

#define GF_COME_HITHER    92	/* Movement */
#define GF_AWAY           93

#define GF_KILL_WALL     100	/* Dungeon-altering */
#define GF_FORCE_DOOR    101
#define GF_KILL_DOOR     102
#define GF_KILL_TRAP     103
#define GF_MAKE_WALL     104
#define GF_MAKE_DOOR     105
#define GF_MAKE_TRAP     106
#define GF_JAM_DOOR      107
#define GF_FETCH_OBJ     108
#define GF_DISINTEGRATE  109
#define GF_MAKE_WATER    110
#define GF_MAKE_TREES    111
#define GF_MAKE_LAVA     112


#define GF_ENLIGHTENMENT 130	/* Special */
#define GF_GAIN_LEVEL    131
#define GF_PROTECTION    132
#define GF_DO_PANIC_EVIL 133




/*
 * Some constants for the "learn" code.  These generalized from the
 * old DRS constants.
 */
#define LRN_FREE_SAVE     14
#define LRN_MANA          15
#define LRN_ACID          16
#define LRN_ELEC          17
#define LRN_FIRE          18
#define LRN_COLD          19
#define LRN_POIS          20
#define LRN_FEAR_SAVE     21
#define LRN_LITE          22
#define LRN_DARK          23
#define LRN_BLIND         24
#define LRN_CONFU         25
#define LRN_SOUND         26
#define LRN_SHARD         27
#define LRN_NEXUS         28
#define LRN_NETHR         29
#define LRN_CHAOS         30
#define LRN_DISEN         31
#define LRN_SAVE          39
#define LRN_ARCH          40
#define LRN_PARCH         41
#define LRN_ICE           42
#define LRN_PLAS          43
#define LRN_SOUND2        44 /* attacks which aren't resisted, but res sound prevent stun */
#define LRN_STORM         45
#define LRN_WATER         46
#define LRN_WIND          47 /* Conf resist prevents confusion */
#define LRN_NEXUS_SAVE    48 /* Both resist Nexus and Saves apply */
#define LRN_BLIND_SAVE    49 /* Both resist Blind and Saves apply */
#define LRN_CONFU_SAVE    50 /* Both resist Confusion and Saves apply */
#define LRN_DARK_SAVE     51
#define LRN_HOLY_SAVE     52


#define LRN_MAX           60


/*
 * Number of keymap modes (original and roguelike)
 */
#define KEYMAP_MODES           2

/*
 * Mode for original keyset commands
 */
#define KEYMAP_MODE_ORIG       0

/*
 * Mode for roguelike keyset commands
 */
#define KEYMAP_MODE_ROGUE      1



/*** Monster Indexes (see "lib/edit/monster.txt") ***/

/*
 * When defining a new monster, be sure to add a note to that monster's
 * entry in the edit file, so that both values are kept in sync.
 *
 * At some point, someone might want to think about defining monsters
 * using "rval", "mval" pairs instead of indexes.
 */

#define MON_TOWN_THIEF         6
#define MON_ANIM_TORCH        41
#define MON_MAGIC_MUSHROOM   204
#define MON_MANA_FLY         352
#define MON_CHAOS_TILE       426
#define MON_TORNADO          527
#define MON_MANA_VORTEX      539
#define MON_UNDEAD_MYSTIC    567
#define MON_CHAOS_HOUND      602
#define MON_SHADOW_BREEDER   621
#define MON_CHEST_MIMIC      644
#define MON_UNMAKER          655
#define MON_HELL_TYRANT      657
#define MON_SMEAGOL          690
#define MON_SAURON           767
#define MON_MORGOTH          768




/*** Terrain Feature Indexes (see "lib/edit/terrain.txt") ***/

/*
 * Special notes:
 * 1) All terrain features with indexes less than "FEAT_SECRET" can
 *    be run on.  See "run_test()".  XXX XXX
 */


/* Nothing */
#define FEAT_NONE          0

/* Feeatures that do not block line of sight */
#define FEAT_FLOOR         1


#define FEAT_LESS2         4
#define FEAT_MORE2         5
#define FEAT_OPEN          6
#define FEAT_BROKEN        7
#define FEAT_LESS          8
#define FEAT_MORE          9

/* Special dungeon features.  */
#define FEAT_LAVA          10
#define FEAT_WATER         11
#define FEAT_TREE          12

/* Doors */
#define FEAT_DOOR_HEAD     32
#define FEAT_DOOR_TAIL     47

/* Extra */
#define FEAT_SECRET        48
#define FEAT_RUBBLE        49

/* Seams */
#define FEAT_MAGMA         50
#define FEAT_QUARTZ        51
#define FEAT_MAGMA_H       52
#define FEAT_QUARTZ_H      53
#define FEAT_MAGMA_K       54
#define FEAT_QUARTZ_K      55

/* Walls */
#define FEAT_WALL_EXTRA    56
#define FEAT_WALL_INNER    57
#define FEAT_WALL_OUTER    58
#define FEAT_WALL_SOLID    59
#define FEAT_PERM_EXTRA    60
#define FEAT_PERM_INNER    61
#define FEAT_PERM_OUTER    62
#define FEAT_PERM_SOLID    63
#define FEAT_PILLAR        64
#define FEAT_PILLAR_GOLD   65

/* Shops */
#define FEAT_SHOP_HEAD     84
#define FEAT_SHOP_INN      92
#define FEAT_SHOP_TAIL     92


/*** Artifact indexes (see "lib/edit/artifact.txt") ***/


/* Light Sources */
#define ART_GALADRIEL         1
#define ART_ELENDIL           2
#define ART_THRAIN            3
#define ART_PALANTIR          4

/* Amulets */
#define ART_CARLAMMAS         6
#define ART_INGWE             7
#define ART_DWARVES           8

/* Rings */
#define ART_BARAHIR          12
#define ART_TULKAS           13
#define ART_NARYA            14
#define ART_NENYA            15
#define ART_VILYA            16
#define ART_POWER            17

/* Dragon Scale */
#define ART_RAZORBACK        23
#define ART_BLADETURNER      24

/* Hard Armour */
#define ART_SOULKEEPER       26
#define ART_ISILDUR          27
#define ART_ROHIRRIM         28
#define ART_BELEGENNON       29
#define ART_CELEBORN         30
#define ART_ARVEDUI          31
#define ART_CASPANION        32

/* Soft Armour */
#define ART_HIMRING          36
#define ART_HITHLOMIR        37
#define ART_THALKETTOTH      38

/* Shields */
#define ART_ELEMENTS         43
#define ART_THORIN           44
#define ART_CELEGORM         45
#define ART_ANARION          46
#define ART_EARENDIL         47
#define ART_GIL_GALAD        48

/* Helms and Crowns */
#define ART_MORGOTH          51
#define ART_BERUTHIEL        52
#define ART_THRANDUIL        53
#define ART_THENGEL          54
#define ART_HAMMERHAND       55
#define ART_DOR_LOMIN        56
#define ART_HOLHENNETH       57
#define ART_GORLIM           58

#define ART_GONDOR           61
#define ART_NUMENOR          62

/* Cloaks */
#define ART_COLLUIN          66
#define ART_HOLCOLLETH       67
#define ART_THINGOL          68
#define ART_THORONGIL        69
#define ART_COLANNON         70
#define ART_LUTHIEN          71
#define ART_TUOR             72

/* Gloves */
#define ART_CAMBELEG         77
#define ART_CAMMITHRIM       78
#define ART_PAURLHACH        79
#define ART_PAURNIMMEN       80
#define ART_PAURAEGEN        81
#define ART_PAURNEN          82
#define ART_CAMLOST          83
#define ART_FINGOLFIN        84

/* Boots */
#define ART_FEANOR           89
#define ART_DAL              90
#define ART_THROR            91
#define ART_GIMLI            92
#define ART_NEVRAST          93

/* Swords */
#define ART_MAEDHROS         97
#define ART_ANGRIST          98
#define ART_NARTHANC         99
#define ART_NIMTHANC        100
#define ART_AETHANC         101
#define ART_NENTHANC        102
#define ART_RILIA           103
#define ART_BELANGIL        104
#define ART_CALRIS          105
#define ART_ARUNRUTH        106
#define ART_GLAMDRING       107
#define ART_AEGLIN          108
#define ART_ORCRIST         109
#define ART_GURTHANG        110
#define ART_ZARCUTHRA       111
#define ART_MORMEGIL        112
#define ART_GONDRICAM       113
#define ART_CRISDURIAN      114
#define ART_AGLARANG        115
#define ART_RINGIL          116
#define ART_ANDURIL         117
#define ART_ANGUIREL        118
#define ART_ELVAGIL         119
#define ART_FORASGIL        120
#define ART_CARETH          121
#define ART_STING           122
#define ART_HARADEKKET      123
#define ART_GILETTAR        124
#define ART_DOOMCALLER      125
#define ART_EOWYN           126
#define ART_AR_PHARAZON     127
#define ART_WHISPER_DEATH   128


/* Polearms */
#define ART_THEODEN         133
#define ART_PAIN            134
#define ART_OSONDIR         135
#define ART_TIL             136
#define ART_AEGLOS          137
#define ART_OROME           138
#define ART_NIMLOTH         139
#define ART_EORLINGAS       140
#define ART_DURIN           141
#define ART_EONWE           142
#define ART_BELEGOST        143
#define ART_LOTHARANG       144
#define ART_MUNDWINE        145
#define ART_BARUKKHELED     146
#define ART_WRATH           147
#define ART_ULMO            148
#define ART_AVAVIR          149
#define ART_MELKOR          150
#define ART_BALLI           151
#define ART_LIGHTNING_LANCE 152
#define ART_SLAUGHTERFIELD  153

/* Hafted */
#define ART_GROND           158
#define ART_TOTILA          159
#define ART_THUNDERFIST     160
#define ART_BLOODSPIKE      161
#define ART_FIRESTAR        162
#define ART_TARATOL         163
#define ART_AULE            164
#define ART_NAR             165
#define ART_ERIRIL          166
#define ART_OLORIN          167
#define ART_DEATHWREAKER    168
#define ART_TURMIL          169
#define ART_SKULLCLEAVER    170
#define ART_GOTHMOG         171
#define ART_NARAD_AI_MENU   172
#define ART_MJOLLNIR        173

/* Bows */
#define ART_HARAD           178
#define ART_BELTHRONDING    179
#define ART_BARD            180

#define ART_CUBRAGOL        183
#define ART_BUCKLAND        184

/* Diggers */
#define ART_EREBOR          186


/*
 * Hack -- first normal and random artifact in the artifact list.  All of
 * the artifacts with indexes from 1 to 22 are "special" (lights, rings,
 * amulets), and the ones from 23 to 209 are "normal".
 */
#define ART_MIN_NORMAL     23
#define ART_MIN_RANDOM    210

/* Size of artifact names list.  Must be greater than "z_info->a_max". */
#define ART_LIST_SIZE     300


/*** Activation constants.  Max is 255. ***/

/* Light Sources */
#define ACTIV_GALADRIEL       1
#define ACTIV_ELENDIL         2
#define ACTIV_THRAIN          3
#define ACTIV_PALANTIR        4

/* Amulets */
#define ACTIV_CARLAMMAS       6
#define ACTIV_INGWE           7

/* Rings */
#define ACTIV_TULKAS         10
#define ACTIV_NARYA          11
#define ACTIV_NENYA          12
#define ACTIV_VILYA          13
#define ACTIV_POWER          14

/* Dragon Scale */
#define ACTIV_RAZORBACK      22
#define ACTIV_BLADETURNER    23

/* Hard Armour */
#define ACTIV_SOULKEEPER     24
#define ACTIV_BELEGENNON     25
#define ACTIV_CELEBORN       26
#define ACTIV_CASPANION      27
#define ACTIV_HIMRING        28

/* Shields */
#define ACTIV_ELEMENTS       32
#define ACTIV_EARENDIL       33
#define ACTIV_GIL_GALAD      34

/* Helms and Crowns */
#define ACTIV_HOLHENNETH     37
#define ACTIV_GONDOR         38

/* Cloaks */
#define ACTIV_COLLUIN        41
#define ACTIV_HOLCOLLETH     42
#define ACTIV_THINGOL        43
#define ACTIV_COLANNON       44
#define ACTIV_LUTHIEN        45

/* Gloves */
#define ACTIV_CAMBELEG       51
#define ACTIV_CAMMITHRIM     52
#define ACTIV_PAURLHACH      53
#define ACTIV_PAURNIMMEN     54
#define ACTIV_PAURAEGEN      55
#define ACTIV_PAURNEN        56
#define ACTIV_FINGOLFIN      57

/* Boots */
#define ACTIV_FEANOR         61
#define ACTIV_DAL            62
#define ACTIV_GIMLI          63

/* Swords */
#define ACTIV_RILIA          69
#define ACTIV_BELANGIL       70
#define ACTIV_ARUNRUTH       71
#define ACTIV_RINGIL         72
#define ACTIV_ANDURIL        73
#define ACTIV_DOOMCALLER     74
#define ACTIV_AR_PHARAZON    75

/* Polearms */
#define ACTIV_THEODEN        78
#define ACTIV_AEGLOS         79
#define ACTIV_OROME          80
#define ACTIV_EONWE          81
#define ACTIV_LOTHARANG      82
#define ACTIV_ULMO           83
#define ACTIV_AVAVIR         84
#define ACTIV_MELKOR         85
#define ACTIV_SLAUGHTERFIELD 86

/* Hafted */
#define ACTIV_TOTILA         89
#define ACTIV_FIRESTAR       90
#define ACTIV_TARATOL        91
#define ACTIV_ERIRIL         92
#define ACTIV_OLORIN         93
#define ACTIV_TURMIL         94
#define ACTIV_SKULLCLEAVER   95

/* Bows */
#define ACTIV_HARAD          99
#define ACTIV_BARD          100
#define ACTIV_BUCKLAND      101

/* Diggers */
#define ACTIV_EREBOR        103


/* Random Artifact activations */


/* Random Artifacts */
#define ACTIV_RANDOM_FIRE1           125
#define ACTIV_RANDOM_FIRE2           126
#define ACTIV_RANDOM_FIRE3           127
#define ACTIV_RANDOM_COLD1           128
#define ACTIV_RANDOM_COLD2           129
#define ACTIV_RANDOM_COLD3           130
#define ACTIV_RANDOM_ACID1           131
#define ACTIV_RANDOM_ACID2           132
#define ACTIV_RANDOM_ACID3           133
#define ACTIV_RANDOM_ELEC1           134
#define ACTIV_RANDOM_ELEC2           135
#define ACTIV_RANDOM_ELEC3           136
#define ACTIV_RANDOM_POIS1           137
#define ACTIV_RANDOM_POIS2           138
#define ACTIV_RANDOM_LIGHT1          139
#define ACTIV_RANDOM_LIGHT2          140
#define ACTIV_RANDOM_DISPEL_UNDEAD   141
#define ACTIV_RANDOM_DISPEL_EVIL     142
#define ACTIV_RANDOM_SMITE_UNDEAD    143
#define ACTIV_RANDOM_SMITE_DEMON     144
#define ACTIV_RANDOM_SMITE_DRAGON    145
#define ACTIV_RANDOM_HOLY_ORB        146
#define ACTIV_RANDOM_BLESS           147
#define ACTIV_RANDOM_FRIGHTEN_ALL    148
#define ACTIV_RANDOM_HEAL1           149
#define ACTIV_RANDOM_HEAL2           150
#define ACTIV_RANDOM_HEAL3           151
#define ACTIV_RANDOM_CURE            152
#define ACTIV_RANDOM_PROT_FROM_EVIL  153
#define ACTIV_RANDOM_CHAOS           154
#define ACTIV_RANDOM_SHARD_SOUND     155
#define ACTIV_RANDOM_NETHR           156
#define ACTIV_RANDOM_LINE_LIGHT      157
#define ACTIV_RANDOM_STARBURST       158
#define ACTIV_RANDOM_EARTHQUAKE      159
#define ACTIV_RANDOM_IDENTIFY        160
#define ACTIV_RANDOM_SPEED           161
#define ACTIV_RANDOM_TELEPORT_AWAY   162
#define ACTIV_RANDOM_HEROISM         163
#define ACTIV_RANDOM_STORM_DANCE     164
#define ACTIV_RANDOM_RESIST_ELEMENTS 165
#define ACTIV_RANDOM_RESIST_ALL      166
#define ACTIV_RANDOM_TELEPORT1       167
#define ACTIV_RANDOM_TELEPORT2       168
#define ACTIV_RANDOM_RECALL          169
#define ACTIV_RANDOM_REGAIN          170
#define ACTIV_RANDOM_RESTORE         171
#define ACTIV_RANDOM_SHIELD          172
#define ACTIV_RANDOM_BRAND_MISSILE   173
#define ACTIV_RANDOM_DEADLY_SHOOTING 174
#define ACTIV_RANDOM_DETECT_MONSTERS 175
#define ACTIV_RANDOM_DETECT_EVIL     176
#define ACTIV_RANDOM_DETECT_ALL      177
#define ACTIV_RANDOM_MAGIC_MAP       178
#define ACTIV_RANDOM_DETECT_D_S_T    179
#define ACTIV_RANDOM_CONFU_FOE       180
#define ACTIV_RANDOM_SLEEP_FOE       181
#define ACTIV_RANDOM_TURN_FOE        182
#define ACTIV_RANDOM_SLOW_FOE        183
#define ACTIV_RANDOM_BANISH_EVIL     184
#define ACTIV_RANDOM_DISARM          185
#define ACTIV_RANDOM_CONFU_FOES      186
#define ACTIV_RANDOM_SLEEP_FOES      187
#define ACTIV_RANDOM_TURN_FOES       188
#define ACTIV_RANDOM_SLOW_FOES       189
#define ACTIV_RANDOM_BERSERK         190
#define ACTIV_RANDOM_LIGHT_AREA      191
#define ACTIV_RANDOM_SELF_KNOWLEDGE  192


/* Ego-item activations */
#define ACTIV_EGO_HERO               205
#define ACTIV_EGO_WHIP               206

#define ACTIV_SHOT_PIERCING          209
#define ACTIV_SHOT_DAMAGE            210
#define ACTIV_SHOT_IMPACT            211
#define ACTIV_SHOT_ACCURATE          212
#define ACTIV_SHOT_FIRE              213
#define ACTIV_SHOT_COLD              214

/* Magical item activations */
#define ACTIV_HOLINESS      218
#define ACTIV_RING_ACID     219
#define ACTIV_RING_ELEC     220
#define ACTIV_RING_FIRE     221
#define ACTIV_RING_COLD     222
#define ACTIV_RING_POIS     223

#define ACTIV_AMULET_SUSTENANCE  227
#define ACTIV_AMULET_ESCAPING    228
#define ACTIV_AMULET_MANA        229
#define ACTIV_AMULET_RECHARGING  230


/* Dragon scale mail activations */
#define ACTIV_DSM_BLACK        239
#define ACTIV_DSM_BLUE         240
#define ACTIV_DSM_WHITE        241
#define ACTIV_DSM_RED          242
#define ACTIV_DSM_GREEN        243
#define ACTIV_DSM_MULTIHUED    244
#define ACTIV_DSM_SHINING      246

#define ACTIV_DSM_MORPHIC      248
#define ACTIV_DSM_BRONZE       249
#define ACTIV_DSM_GOLD         250
#define ACTIV_DSM_CHAOS        252
#define ACTIV_DSM_LAW          253
#define ACTIV_DSM_BALANCE      254
#define ACTIV_DSM_POWER        255


/*** Ego-Item indexes (see "lib/edit/ego_item.txt") ***/


/* Nothing */
/* xxx */
/* xxx */
/* xxx */

/* Body Armor */
#define EGO_RESIST_ACID             4
#define EGO_RESIST_ELEC             5
#define EGO_RESIST_FIRE             6
#define EGO_RESIST_COLD             7
#define EGO_RESISTANCE              8
#define EGO_ELVENKIND               9
/* xxx */
#define EGO_PERMANENCE             11
/* xxx */
#define EGO_PLAGUE                 13
#define EGO_CRUSHING               14
#define EGO_NAKEDNESS              15

/* Shields */
#define EGO_ENDURE_ACID            16
#define EGO_ENDURE_ELEC            17
#define EGO_ENDURE_FIRE            18
#define EGO_ENDURE_COLD            19
#define EGO_ENDURANCE              20
/* xxx */
#define EGO_HEXED                  22
#define EGO_TREACHERY              23

/* Crowns and Helms */
#define EGO_INTELLIGENCE           24
#define EGO_WISDOM                 25
#define EGO_BEAUTY                 26
#define EGO_MAGI                   27
#define EGO_MIGHT                  28
#define EGO_LORDLINESS             29
#define EGO_SEEING                 30
#define EGO_INFRAVISION            31
#define EGO_LITE                   32
#define EGO_TELEPATHY              33
#define EGO_REGENERATION           34
#define EGO_MIND_MELT              35
#define EGO_STUPIDITY              36
#define EGO_NAIVETY                37
#define EGO_UGLINESS               38
#define EGO_WITHERING              39

/* Cloaks */
#define EGO_PROTECTION             40
#define EGO_STEALTH                41
#define EGO_AMAN                   42
/* xxx */
#define EGO_ENVELOPING             44
#define EGO_VULNERABILITY          45
/* xxx */

/* Gloves */
#define EGO_FREE_ACTION            48
#define EGO_SLAYING                49
#define EGO_AGILITY                50
#define EGO_POWER                  51
#define EGO_MAGIC_MASTERY          52
/* xxx */
#define EGO_FUMBLING               54
#define EGO_UNMAGIC                55

/* Boots */
#define EGO_SLOW_DESCENT           56
#define EGO_QUIET                  57
#define EGO_MOTION                 58
#define EGO_SPEED                  59
/* xxx */
#define EGO_NOISE                  61
#define EGO_GREAT_MASS             62
#define EGO_PITILESS_TORMENT       63

/* Weapons */
#define EGO_HA                     64
#define EGO_DF                     65
#define EGO_BLESS_BLADE            66
#define EGO_SEPENTINE              67
#define EGO_WEST                   68
/* xxx */
#define EGO_MYSTIC                 70
#define EGO_CHANCE                 71
#define EGO_DEATH                  72
#define EGO_BATTLE                 73
#define EGO_HEROISM                74

#define EGO_BRAND_ACID             78
#define EGO_BRAND_ELEC             79
#define EGO_BRAND_FIRE             80
#define EGO_BRAND_COLD             81
#define EGO_BRAND_POIS             82
#define EGO_SLAY_ANIMAL            85
#define EGO_SLAY_EVIL              86
#define EGO_SLAY_UNDEAD            87
#define EGO_SLAY_DEMON             88
#define EGO_SLAY_ORC               89
#define EGO_SLAY_TROLL             90
#define EGO_SLAY_GIANT             91
#define EGO_SLAY_DRAGON            92

#define EGO_KILL_ANIMAL            96
#define EGO_KILL_UNDEAD            97
#define EGO_KILL_DEMON             98
#define EGO_KILL_DRAGON            99
#define EGO_BALROG                100
/* xxx */
/* xxx */
/* xxx */
/* xxx */
#define EGO_CORRODED              105
#define EGO_DIGGING               106
/* xxx */
#define EGO_MORGUL                108
#define EGO_SAVAGERY              109

/* Bows */
#define EGO_ACCURACY              110
#define EGO_VELOCITY              111
#define EGO_STALKING              112
#define EGO_HOLINESS              113
#define EGO_EXTRA_MIGHT           114
#define EGO_EXTRA_SHOTS           115
#define EGO_DISPAIR               116
/* xxx */

/* Ammo */
#define EGO_HURT_ANIMAL           118
#define EGO_HURT_EVIL             119
#define EGO_HURT_UNDEAD           120
#define EGO_HURT_DEMON            121
#define EGO_HURT_ORC              122
#define EGO_HURT_TROLL            123
#define EGO_HURT_GIANT            124
#define EGO_HURT_DRAGON           125

#define EGO_ACIDIC                128
#define EGO_ELECT                 129
#define EGO_FLAME                 130
#define EGO_FROST                 131
#define EGO_POISON                132

#define EGO_BRILLIANCE            134
#define EGO_WOUNDING              135
#define EGO_IMPACT                136
#define EGO_BACKBITING            137

#define EGO_ACUITY                140
#define EGO_VISION                141
#define EGO_BRIGHTNESS            142
#define EGO_PHLOGISTON            143
#define EGO_ELDAMAR               144
#define EGO_SHADOWS               145

/* miscellaneous */
#define EGO_TELEPORTATION         154


/* forged */
#define EGO_FORGED_COPPER         155
#define EGO_FORGED_BRONZE         156
#define EGO_FORGED_IRON           157
#define EGO_FORGED_STEEL          158
#define EGO_FORGED_RUNEGOLD       159
#define EGO_FORGED_MITHRIL        160
#define EGO_FORGED_ADAMANT        161

#define EGO_SHATTERED             163
#define EGO_BLASTED               164




/*** Object "tval" and "sval" codes ***/

/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 */
#define TV_NONE                     0

#define TV_SKELETON                 1	/* Skeletons ('`') */
#define TV_JUNK                     2	/* Sticks, Pottery, etc ('`') */
#define TV_SPIKE                    3	/* Spikes ('`') */

#define TV_COMPONENT                5	/* Components (for making wearables) */
#define TV_PARCHMENT                6	/* Parchments (for making scrolls) */
#define TV_BOTTLE                   7	/* Bottles (for making potions) */

#define TV_CHEST                   10	/* Chests ('~') */

#define TV_SHOT                    16	/* Ammo for slings */
#define TV_ARROW                   17	/* Ammo for bows */
#define TV_BOLT                    18	/* Ammo for crossbows */

#define TV_DIGGING                 20	/* Shovels/Picks */
#define TV_HAFTED                  21	/* Priestly (blunt hafted) Weapons */
#define TV_POLEARM                 22	/* Axes and Pikes */
#define TV_SWORD                   23	/* Hand-held edged Weapons */

#define TV_SLING                   25	/* Slings */
#define TV_BOW                     26	/* Bows */
#define TV_CROSSBOW                27	/* Crossbows */

#define TV_BOOTS                   30	/* Boots */
#define TV_GLOVES                  31	/* Gloves */
#define TV_HELM                    32	/* Helms */
#define TV_CROWN                   33	/* Crowns */
#define TV_SHIELD                  34	/* Shields */
#define TV_CLOAK                   35	/* Cloaks */
#define TV_SOFT_ARMOR              36	/* Soft Body Armor */
#define TV_HARD_ARMOR              37	/* Hard Body Armor */
#define TV_DRAG_ARMOR              38	/* Dragon Scale Mail */

#define TV_LITE                    39	/* Light Sources (including Specials) */
#define TV_AMULET                  40	/* Amulets (including Specials) */
#define TV_RING                    45	/* Rings (including Specials) */
#define TV_STAFF                   55	/* Staffs */
#define TV_WAND                    65	/* Wands */
#define TV_ROD                     66	/* Rods */
#define TV_SCROLL                  70	/* Scrolls */
#define TV_POTION                  75	/* Potions */
#define TV_FLASK                   77	/* Flasks of oil */
#define TV_FOOD                    80	/* Food and mushrooms */

#define TV_MAGIC_BOOK              90	/* Books of Sorcery */
#define TV_PRAYER_BOOK             91	/* Books of Piety */
#define TV_NATURE_BOOK             92	/* Stones of Nature Lore */
#define TV_DARK_BOOK               93	/* Tomes of Necromancy */

/* Tvals after this point should not belong to items that go in the backpack */

#define TV_ESSENCE                 98	/* Essences (for infusing objects) */
#define TV_POUCH                   99  /* Pouch to hold essences -- Hack! */
#define TV_GOLD                   100	/* Treasure */

#define TV_MAX                    101  /* The maximum allowable tval */


/* The "sval" codes for TV_JUNK */
#define SV_BOULDER                       3 /* Miscellaneous heavy rocks */
#define SV_BLANKET                       4 /* Protective blankets */


/* The "sval" codes for TV_CHEST */
#define SV_SW_CHEST                      1	/*  Small wooden chest. */
#define SV_SI_CHEST                      2	/*  Small iron chest. */
#define SV_SS_CHEST                      3	/*  Small steel chest. */
#define SV_SJ_CHEST                      4	/*  Small jeweled chest. */
#define SV_LW_CHEST                      5	/*  Large wooden chest. */
#define SV_LI_CHEST                      6	/*  Large iron chest. */
#define SV_LS_CHEST                      7	/*  Large steel chest. */
#define SV_LJ_CHEST                      8	/*  Large jeweled chest. */


/* The "sval" codes for TV_SHOT/TV_ARROW/TV_BOLT */
#define SV_AMMO_LIGHT                    1	/* cheap shots, arrows, bolts */
#define SV_AMMO_NORMAL                   2	/* shots, arrows, bolts */
#define SV_AMMO_HEAVY                    3	/* seeker shots, arrows, bolts */

/* The "sval" codes for TV_SLING, TV_BOW, and TV_CROSSBOW */
#define SV_SLING                         2	/* (x2) */
#define SV_SHORT_BOW                    12	/* (x2) */
#define SV_LONG_BOW                     13	/* (x3) */
#define SV_HAND_XBOW                    22	/* (x2) */
#define SV_LIGHT_XBOW                   23	/* (x3) */
#define SV_HEAVY_XBOW                   24	/* (x4) */
#define SV_TRIPLE_XBOW                  29	/* (x2) */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL                        1
#define SV_GNOMISH_SHOVEL                2
#define SV_DWARVEN_SHOVEL                3
#define SV_PICK                          4
#define SV_ORCISH_PICK                   5
#define SV_DWARVEN_PICK                  6

/* The "sval" values for TV_HAFTED */
#define SV_WHIP                          2	/* 1d6 */
#define SV_QUARTERSTAFF                  3	/* 1d9 */
#define SV_THROWING_HAMMER               4  /* 2d4 */
#define SV_MACE                          5	/* 2d4 */
#define SV_BALL_AND_CHAIN                6	/* 2d4 */
#define SV_WAR_HAMMER                    8	/* 3d3 */
#define SV_SPIKED_CLUB                  10	/* 1d7 */
#define SV_MORNING_STAR                 12	/* 2d6 */
#define SV_FLAIL                        13	/* 2d6 */
#define SV_LEAD_FILLED_MACE             15	/* 3d4 */
#define SV_TWO_HANDED_FLAIL             18	/* 3d6 */
#define SV_MACE_OF_DISRUPTION           20	/* 4d6 */
#define SV_GROND                        50	/* 9d9 */

/* The "sval" values for TV_POLEARM */
#define SV_JAVELIN                       1	/* 1d5 */
#define SV_SPEAR                         2	/* 1d6 */
#define SV_WARSPIKE                      3	/* 1d5+ */
#define SV_TRIDENT                       4	/* 1d7 */
#define SV_PIKE                          5	/* 1d13 */
#define SV_THROWING_AXE                  8	/* 2d3 */
#define SV_BEAKED_AXE                    9	/* 2d6 */
#define SV_BROAD_AXE                    10	/* 2d6 */
#define SV_BATTLE_AXE                   11	/* 2d8 */
#define SV_GREAT_AXE                    12	/* 4d4 */
#define SV_GLAIVE                       15	/* 3d4 */
#define SV_HALBERD                      16	/* 3d5 */
#define SV_SCYTHE                       18	/* 4d3 */
#define SV_SCYTHE_OF_SLICING            19	/* 6d4 */

/* The "sval" codes for TV_SWORD */
#define SV_BROKEN_SWORD                  2	/* 1d2 */
#define SV_THROWING_KNIFE                3	/* 1d3 */
#define SV_DAGGER                        4	/* 1d4 */
#define SV_MAIN_GAUCHE                   5	/* 1d5 */
#define SV_RAPIER                        7	/* 1d6 */
#define SV_SMALL_SWORD                   8	/* 1d6 */
#define SV_SHORT_SWORD                  10	/* 1d7 */
#define SV_SABRE                        11	/* 1d7 */
#define SV_CUTLASS                      12	/* 1d7 */
#define SV_SACRIFICIAL_DAGGER           15	/* 2d4 */
#define SV_BROAD_SWORD                  16	/* 2d5 */
#define SV_LONG_SWORD                   17	/* 2d5 */
#define SV_SCIMITAR                     18	/* 2d5 */
#define SV_KATANA                       20	/* 3d4 */
#define SV_BASTARD_SWORD                21	/* 2d7 */
#define SV_TWO_HANDED_SWORD             25	/* 2d10 */
#define SV_FELLBLADE                    27	/* 2d5+ */
#define SV_EXECUTIONERS_SWORD           28	/* 2d12 */
#define SV_BLUESTEEL_BLADE              29	/* 3d7 */
#define SV_BLADE_OF_CHAOS               30	/* 2d14 */

/* The "sval" codes for TV_SHIELD */
#define SV_SMALL_LEATHER_SHIELD          2
#define SV_SMALL_METAL_SHIELD            3
#define SV_LARGE_LEATHER_SHIELD          4
#define SV_LARGE_METAL_SHIELD            5
#define SV_KNIGHT_SHIELD                 6
#define SV_BODY_SHIELD                   7
#define SV_SHIELD_OF_DEFLECTION         10

/* The "sval" codes for TV_HELM and TV_CROWN */
#define SV_HARD_LEATHER_CAP              2
#define SV_METAL_CAP                     3
#define SV_BARBUT                        4
#define SV_IRON_HELM                     5
#define SV_STEEL_HELM                    6
#define SV_DRAGON_HELM                   7
#define SV_IRON_CROWN                   10
#define SV_GOLDEN_CROWN                 11
#define SV_JEWELED_CROWN                12
#define SV_MORGOTH                      50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_SANDALS               1
#define SV_PAIR_OF_SOFT_LEATHER_BOOTS    2
#define SV_PAIR_OF_HARD_LEATHER_BOOTS    3
#define SV_PAIR_OF_METAL_SHOD_BOOTS      4
#define SV_PAIR_OF_DWARVEN_BOOTS         5

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK                         1
#define SV_BATTLE_CAPE                   2
#define SV_ELVEN_CLOAK                   3
#define SV_SHADOW_CLOAK                  4
#define SV_ETHEREAL_CLOAK                6

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES         1
#define SV_SET_OF_MAIL_GAUNTLETS         2
#define SV_SET_OF_STEEL_GAUNTLETS        3
#define SV_SET_OF_CESTI                  4

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_FILTHY_RAG                    1
#define SV_ROBE                          2
#define SV_SOFT_LEATHER_ARMOR            4
#define SV_SOFT_STUDDED_LEATHER          5
#define SV_HARD_LEATHER_ARMOR            6
#define SV_HARD_STUDDED_LEATHER          7
#define SV_LEATHER_SCALE_MAIL           11	/* 10 */

/* The "sval" codes for TV_HARD_ARMOR */
#define SV_BRIGANDINE_ARMOR              1	/* 12 */
#define SV_RUSTY_CHAIN_MAIL              2	/* 14- */
#define SV_CHAIN_MAIL                    3	/* 14 */
#define SV_METAL_SCALE                   4	/* 15 */
#define SV_AUGMENTED_CHAIN_MAIL          6	/* 16 */
#define SV_SEGMENTED_PLATE               8	/* 19 */
#define SV_PARTIAL_PLATE_ARMOUR         12	/* 21 */
#define SV_FULL_PLATE_ARMOUR            15	/* 25 */
#define SV_RIBBED_PLATE_ARMOUR          18	/* 28 */
#define SV_MITHRIL_CHAIN_MAIL           20	/* 28+ */
#define SV_MITHRIL_PLATE_MAIL           25	/* 35+ */
#define SV_ADAMANTITE_PLATE_MAIL        30	/* 40+ */

/* The "sval" codes for TV_DRAG_ARMOR */
#define SV_DRAGON_BLACK                  1
#define SV_DRAGON_BLUE                   2
#define SV_DRAGON_WHITE                  3
#define SV_DRAGON_RED                    4
#define SV_DRAGON_GREEN                  5
#define SV_DRAGON_MULTIHUED              6
#define SV_DRAGON_SHINING               10
#define SV_DRAGON_MORPHIC               13
#define SV_DRAGON_BRONZE                14
#define SV_DRAGON_GOLD                  16
#define SV_DRAGON_CHAOS                 18
#define SV_DRAGON_LAW                   19
#define SV_DRAGON_BALANCE               20
#define SV_DRAGON_POWER                 30

/* The sval codes for TV_LITE */
#define SV_LITE_TORCH                    0
#define SV_LITE_LANTERN                  1
#define SV_LITE_GALADRIEL                4
#define SV_LITE_ELENDIL                  5
#define SV_LITE_THRAIN                   6
#define SV_LITE_PALANTIR                 7


/* The "sval" codes for TV_AMULET */
#define SV_AMULET_DOOM                   0
#define SV_AMULET_TELEPORT               1
#define SV_AMULET_INFRAVISION            2
#define SV_AMULET_SLOW_DIGEST            3
#define SV_AMULET_FEATHER_FALL           4
#define SV_AMULET_MAGIC_MASTERY          5
#define SV_AMULET_SUSTENANCE             6
#define SV_AMULET_ESCAPING               7
#define SV_AMULET_MANA                   8
#define SV_AMULET_RECHARGING             9
#define SV_AMULET_THE_MAGI              10
#define SV_AMULET_INTELLIGENCE          11
#define SV_AMULET_WISDOM                12
#define SV_AMULET_CHARISMA              13
#define SV_AMULET_STUPIDITY             14
#define SV_AMULET_NAIVETE               15
#define SV_AMULET_UGLINESS              16
#define SV_AMULET_SAVING_THROW          17
/* xxx */
/* xxx */
#define SV_AMULET_CARLAMMAS             20
#define SV_AMULET_INGWE                 21
#define SV_AMULET_DWARVES               22



/* The sval codes for TV_RING */
#define SV_RING_WOE                      0
#define SV_RING_AGGRAVATION              1
#define SV_RING_TELEPORTATION            2
/* xxx */
/* xxx */
#define SV_RING_HOLINESS                 5
#define SV_RING_DARKNESS                 6
#define SV_RING_RESIST_ACID              7
#define SV_RING_RESIST_FIRE              8
#define SV_RING_RESIST_COLD              9
#define SV_RING_RESIST_POIS             10
#define SV_RING_RESIST_NETHER           11
#define SV_RING_RESIST_CHAOS            12
/* xxx */
/* xxx */
#define SV_RING_SUST_BODY               15
#define SV_RING_SUST_MIND               16
#define SV_RING_PROTECTION              17
#define SV_RING_ACID                    18
#define SV_RING_ELEC                    19
#define SV_RING_FLAMES                  20
#define SV_RING_ICE                     21
#define SV_RING_POIS                    22
#define SV_RING_FREE_ACTION             23
#define SV_RING_SEE_INVIS               24
#define SV_RING_AWARENESS               25
#define SV_RING_INVIS                   26
#define SV_RING_SPEED                   27
#define SV_RING_STR                     28
#define SV_RING_DEX                     29
#define SV_RING_CON                     30
#define SV_RING_WEAKNESS                31
#define SV_RING_CLUMSINESS              32
#define SV_RING_VULNER                  33
#define SV_RING_SKILL                   34
#define SV_RING_DEADLINESS              35
#define SV_RING_COMBAT                  36
/* xxx */
/* xxx */
/* xxx */
/* xxx */
/* xxx */
#define SV_RING_BARAHIR                 42
#define SV_RING_TULKAS                  43
#define SV_RING_NARYA                   44
#define SV_RING_NENYA                   45
#define SV_RING_VILYA                   46
#define SV_RING_POWER                   47


/* The "sval" codes for TV_STAFF */
#define SV_STAFF_DARKNESS                0
#define SV_STAFF_SLOWNESS                1
#define SV_STAFF_HASTE_MONSTERS          2
#define SV_STAFF_SUMMONING               3
#define SV_STAFF_TELEPORTATION           4
#define SV_STAFF_IDENTIFY                5
#define SV_STAFF_REMOVE_CURSE            6
#define SV_STAFF_STARLIGHT               7
#define SV_STAFF_LIGHT                   8
#define SV_STAFF_MAPPING                 9
#define SV_STAFF_DETECT_GOLD            10
#define SV_STAFF_DETECT_ITEM            11
#define SV_STAFF_DETECT_TRAP            12
#define SV_STAFF_DETECT_DOOR            13
#define SV_STAFF_DETECT_INVIS           14
#define SV_STAFF_DETECT_EVIL            15
#define SV_STAFF_CURE_MEDIUM            16
/* xxx */
#define SV_STAFF_HEALING                18
#define SV_STAFF_BANISHMENT             19
#define SV_STAFF_SLEEP_MONSTERS         20
#define SV_STAFF_SLOW_MONSTERS          21
#define SV_STAFF_SPEED                  22
#define SV_STAFF_PROBING                23
#define SV_STAFF_DISPEL_EVIL            24
#define SV_STAFF_POWER                  25
#define SV_STAFF_HOLINESS               26
/* xxx */
#define SV_STAFF_EARTHQUAKES            28
#define SV_STAFF_DESTRUCTION            29
#define SV_STAFF_DETECTION              30
#define SV_STAFF_DOOMSPELLS             31
#define SV_STAFF_CHAOS                  32


/* The "sval" codes for TV_WAND */
#define SV_WAND_HEAL_MONSTER             0
#define SV_WAND_HASTE_MONSTER            1
#define SV_WAND_CLONE_MONSTER            2
#define SV_WAND_TELEPORT_AWAY            3
#define SV_WAND_DISARMING                4
#define SV_WAND_FORCE_DOOR               5
#define SV_WAND_STONE_TO_MUD             6
#define SV_WAND_LITE                     7
#define SV_WAND_SLEEP_MONSTER            8
#define SV_WAND_SLOW_MONSTER             9
#define SV_WAND_CONFUSE_MONSTER         10
#define SV_WAND_FEAR_MONSTER            11
#define SV_WAND_POLYMORPH               12
#define SV_WAND_STINKING_CLOUD          13
#define SV_WAND_MAGIC_MISSILE           14
#define SV_WAND_ACID_BOLT               15
#define SV_WAND_ELEC_BOLT               16
#define SV_WAND_FIRE_BOLT               17
#define SV_WAND_COLD_BOLT               18
#define SV_WAND_ACID_BALL               19
#define SV_WAND_ELEC_BALL               20
#define SV_WAND_FIRE_BALL               21
#define SV_WAND_COLD_BALL               22
#define SV_WAND_WONDER                  23
#define SV_WAND_DRAIN_LIFE              24
#define SV_WAND_ANNIHILATION            25
#define SV_WAND_DRAGON_FIRE             26
#define SV_WAND_DRAGON_COLD             27
#define SV_WAND_DRAGON_BREATH           28
#define SV_WAND_DOOM_BOLT               29
#define SV_WAND_WIZARDRY                30


/* The "sval" codes for TV_ROD */
#define SV_ROD_DETECT_TRAP               0
#define SV_ROD_DETECT_DOOR               1
#define SV_ROD_IDENTIFY                  2
#define SV_ROD_RECALL                    3
#define SV_ROD_ILLUMINATION              4
#define SV_ROD_MAPPING                   5
/* xxx */
#define SV_ROD_PROBING                   7
#define SV_ROD_CURING                    8
#define SV_ROD_HEALING                   9
#define SV_ROD_RESTORATION              10
#define SV_ROD_SPEED                    11
/* xxx */
#define SV_ROD_TELEPORT_AWAY            13
#define SV_ROD_DISARMING                14
#define SV_ROD_LITE                     15
#define SV_ROD_BLINKING                 16
#define SV_ROD_SUMMON_HITHER            17
#define SV_ROD_DRAIN_LIFE               18
#define SV_ROD_POLYMORPH                19
#define SV_ROD_ACID_BOLT                20
#define SV_ROD_ELEC_BOLT                21
#define SV_ROD_FIRE_BOLT                22
#define SV_ROD_COLD_BOLT                23
#define SV_ROD_ACID_BALL                24
#define SV_ROD_ELEC_BALL                25
#define SV_ROD_FIRE_BALL                26
#define SV_ROD_COLD_BALL                27
#define SV_ROD_LIGHTNINGSTRIKE          28
#define SV_ROD_NORTHWINDS               29
#define SV_ROD_DRAGONFIRE               30
#define SV_ROD_GLAURUNGS                31


/* The "sval" codes for TV_SCROLL */
#define SV_SCROLL_DARKNESS               0
#define SV_SCROLL_AGGRAVATE_MONSTER      1
#define SV_SCROLL_CURSE_ARMOR            2
#define SV_SCROLL_CURSE_WEAPON           3
#define SV_SCROLL_SUMMON_MONSTER         4
#define SV_SCROLL_SUMMON_UNDEAD          5
#define SV_SCROLL_SUMMON_DEMONS          6
#define SV_SCROLL_TRAP_CREATION          7
#define SV_SCROLL_PHASE_DOOR             8
#define SV_SCROLL_TELEPORT               9
#define SV_SCROLL_TELEPORT_LEVEL        10
#define SV_SCROLL_WORD_OF_RECALL        11
#define SV_SCROLL_LEARN_MAGIC           12
#define SV_SCROLL_IDENTIFY              13
#define SV_SCROLL_STAR_IDENTIFY         14
#define SV_SCROLL_REMOVE_CURSE          15
#define SV_SCROLL_STAR_REMOVE_CURSE     16
#define SV_SCROLL_ENCHANT_ARMOR         17
#define SV_SCROLL_ENCHANT_WEAPON_TO_HIT 18
#define SV_SCROLL_ENCHANT_WEAPON_TO_DAM 19
#define SV_SCROLL_STAR_ENCHANT_ARMOR    20
#define SV_SCROLL_STAR_ENCHANT_WEAPON   21
#define SV_SCROLL_RECHARGING            22
#define SV_SCROLL_STAR_RECHARGING       23
#define SV_SCROLL_LIGHT                 24
#define SV_SCROLL_MAPPING               25
#define SV_SCROLL_DETECT_GOLD           26
#define SV_SCROLL_DETECT_ITEM           27
#define SV_SCROLL_DETECT_TRAP           28
#define SV_SCROLL_DETECT_DOOR           29
#define SV_SCROLL_DETECT_INVIS          30
#define SV_SCROLL_ELEMENTAL_ATTACKS     31
#define SV_SCROLL_SATISFY_HUNGER        32
#define SV_SCROLL_BLESSING              33
#define SV_SCROLL_HOLY_CHANT            34
#define SV_SCROLL_HOLY_PRAYER           35
#define SV_SCROLL_MONSTER_CONFUSION     36
#define SV_SCROLL_PROTECTION_FROM_EVIL  37
#define SV_SCROLL_RUNE_OF_PROTECTION    38
#define SV_SCROLL_FORCE_DOOR            39
#define SV_SCROLL_QUESTING              40
#define SV_SCROLL_STAR_DESTRUCTION      41
#define SV_SCROLL_POISON_CLOUD          42
#define SV_SCROLL_NEXUS_STORM           43
#define SV_SCROLL_GENOCIDE              44
#define SV_SCROLL_MASS_GENOCIDE         45
#define SV_SCROLL_ACQUIREMENT           46
#define SV_SCROLL_STAR_ACQUIREMENT      47
#define SV_SCROLL_ALTER_REALITY         48
#define SV_SCROLL_MADNESS               49
#define SV_SCROLL_NIGHTFALL             50
#define SV_SCROLL_TREES                 51
#define SV_SCROLL_WATER                 52
#define SV_SCROLL_LAVA                  53

/* Number of scroll titles.  Must be equal to maximum scroll index, plus one */
#define MAX_SCROLL_IDX                  54


/* The "sval" codes for TV_POTION */
#define SV_POTION_WATER                  0
#define SV_POTION_APPLE_JUICE            1
#define SV_POTION_SLIME_MOLD             2
#define SV_POTION_GRENADE                3
#define SV_POTION_SLOWNESS               4
#define SV_POTION_SALT_WATER             5
#define SV_POTION_POISON                 6
#define SV_POTION_BLINDNESS              7
/* xxx */
#define SV_POTION_CONFUSION              9
/* xxx */
#define SV_POTION_SLEEP                 11
/* xxx */
#define SV_POTION_LOSE_MEMORIES         13
/* xxx */
/* xxx */
#define SV_POTION_DEC_STR               16
#define SV_POTION_DEC_INT               17
#define SV_POTION_DEC_WIS               18
#define SV_POTION_DEC_DEX               19
#define SV_POTION_DEC_CON               20
#define SV_POTION_DEC_CHR               21
#define SV_POTION_DETONATIONS           22
#define SV_POTION_DEATH                 23
#define SV_POTION_INFRAVISION           24
#define SV_POTION_DETECT_INVIS          25
#define SV_POTION_SLOW_POISON           26
#define SV_POTION_MENTAL_AWARENESS      27
#define SV_POTION_INVIS                 28
#define SV_POTION_SPEED                 29
#define SV_POTION_RESIST_HEAT           30
#define SV_POTION_RESIST_COLD           31
#define SV_POTION_RESIST_POIS           32
#define SV_POTION_RESIST_ALL            33
#define SV_POTION_CURE_LIGHT            34
#define SV_POTION_CURE_SERIOUS          35
#define SV_POTION_CURE_CRITICAL         36
#define SV_POTION_HEALING               37
#define SV_POTION_STAR_HEALING          38
#define SV_POTION_LIFE                  39
#define SV_POTION_RESTORE_MANA          40
#define SV_POTION_RESTORE_EXP           41
#define SV_POTION_RES_STR               42
#define SV_POTION_RES_INT               43
#define SV_POTION_RES_WIS               44
#define SV_POTION_RES_DEX               45
#define SV_POTION_RES_CON               46
#define SV_POTION_RES_CHR               47
#define SV_POTION_INC_STR               48
#define SV_POTION_INC_INT               49
#define SV_POTION_INC_WIS               50
#define SV_POTION_INC_DEX               51
#define SV_POTION_INC_CON               52
#define SV_POTION_INC_CHR               53
/* xxx */
#define SV_POTION_AUGMENTATION          55
#define SV_POTION_ENLIGHTENMENT         56
#define SV_POTION_STAR_ENLIGHTENMENT    57
#define SV_POTION_SELF_KNOWLEDGE        58
#define SV_POTION_GAIN_SKILL            59
#define SV_POTION_STAR_GAIN_SKILL       60
#define SV_POTION_TROLLFORM             61
#define SV_POTION_DRAGONFORM            62

/* The "sval" codes for TV_FOOD */

#define SV_FOOD_BLINDNESS                0
#define SV_FOOD_PARANOIA                 1
#define SV_FOOD_CONFUSION                2
#define SV_FOOD_HALLUCINATION            3
#define SV_FOOD_PARALYSIS                4
/* xxx */
#define SV_FOOD_POISON                   6
#define SV_FOOD_ENVENOMATION             7
#define SV_FOOD_SICKNESS                 8
#define SV_FOOD_DISEASE                  9
#define SV_FOOD_RUINATION               10
#define SV_FOOD_METAMORPHOSIS           11
#define SV_FOOD_MANIA                   12
/* xxx */
#define SV_FOOD_REGEN_MANA              14
#define SV_FOOD_CURE_POISON             15
#define SV_FOOD_CURE_BLINDNESS          16
#define SV_FOOD_CURE_CONFUSION          17
#define SV_FOOD_MENDING                 18
#define SV_FOOD_CURING                  19
#define SV_FOOD_RESTORING               20
/* xxx */
#define SV_FOOD_BOLDNESS                22
#define SV_FOOD_HEROISM                 23
#define SV_FOOD_BERSERKERGANG           24
#define SV_FOOD_VITALITY                25
#define SV_FOOD_ARMOURING               26
/* xxx */
/* xxx */
#define SV_FOOD_SLIME_MOLD              29
#define SV_FOOD_BISCUIT                 30
#define SV_FOOD_JERKY                   31
#define SV_FOOD_RATION                  32
#define SV_FOOD_BEORNING                33
#define SV_FOOD_WAYBREAD                34
#define SV_FOOD_PINT_OF_ALE             35
#define SV_FOOD_PINT_OF_WINE            36
#define SV_FOOD_ATHELAS                 37
#define SV_FOOD_ORCISH_FIREWATER        38


/*
 * Components, used to make weapons, missiles, and armour.
 *
 * Note that indexes are assumed to follow that of the component,
 * parchment, or bottle with sval 0 in sequential order.
 */
#define SV_COMPONENT_COPPER              0
#define SV_COMPONENT_BRONZE              1
#define SV_COMPONENT_IRON                2
#define SV_COMPONENT_STEEL               3
#define SV_COMPONENT_RUNEGOLD            4
#define SV_COMPONENT_MITHRIL             5
#define SV_COMPONENT_ADAMANT             6

/*
 * Parchments, used to make scrolls
 */
#define SV_PARCHMENT_RAG                 0
#define SV_PARCHMENT_PAPER               1
#define SV_PARCHMENT_VELLUM              2
#define SV_PARCHMENT_SILK                3
#define SV_PARCHMENT_ETHER               4

/*
 * Bottles, used to make potions
 */
#define SV_BOTTLE_CLAY                   0
#define SV_BOTTLE_GLASS                  1
#define SV_BOTTLE_CRYSTAL                2
#define SV_BOTTLE_AGATE                  3
#define SV_BOTTLE_DIAMOND                4

/*
 * Essences, used to add magic
 */
#define ESSENCE_ACID                     0
#define ESSENCE_ELEC                     1
#define ESSENCE_FIRE                     2
#define ESSENCE_COLD                     3
#define ESSENCE_POIS                     4
#define ESSENCE_LITE                     5
#define ESSENCE_DARK                     6
#define ESSENCE_CONFU                    7
#define ESSENCE_FORCE                    8
#define ESSENCE_NEXUS                    9
#define ESSENCE_NETHR                   10
#define ESSENCE_CHAOS                   11
#define ESSENCE_TIME                    12
#define ESSENCE_MAGIC                   13
#define ESSENCE_LIFE                    14
#define ESSENCE_DEATH                   15
#define ESSENCE_KNOW                    16
#define ESSENCE_SHIELD                  17
#define ESSENCE_BLESS                   18

#define ESSENCE_MAX_SVAL                18


/*
 * Special spellbook index
 */
#define SV_DARK_BOOK_NECRONOMICON        6

/*
 * Number of essence types (used to determine the size of the pouch).
 */
#define NUM_ESSENCE                     22
#define ESSENCE_MAX_SVAL                18

/*
 * Hack -- Sval of the pouch.
 */
#define SV_POUCH                         0


/* The "sval" codes for TV_GOLD  -LM- */
#define SV_COPPER                        1
#define SV_SILVER                        2
#define SV_GARNETS                       3
#define SV_AMBER                         4
#define SV_BERYLS                        5
#define SV_AMYTHYST                      6
#define SV_GOLD                          7
#define SV_PEARLS                        8
#define SV_PLATINUM                      9
#define SV_MITHRIL                      10
#define SV_ADAMANTITE                   11



/* Special treasures -- dropped by monsters */
#define SV_SAPPHIRE                     16
#define SV_EMERALD                      17
#define SV_RUBY                         18
#define SV_DIAMOND                      19
#define SV_AETHEROI                     24

/*
 * Special treasure index - first special treasure
 */
#define FIRST_SPECIAL_TREASURE           16



/*
 * Special "sval" limit -- first "normal" food (no longer requires a flavor)
 */
#define SV_FOOD_MIN_FOOD                29

/*
 * Maximum base AC of current shield types (used in deflecting missiles
 * and bolts)
 */
#define MAX_SHIELD_BASE_AC              12

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_MIN_LARGE               5

/*
 * Special "sval" limit -- first "good" magic/prayer book
 */
#define SV_BOOK_MIN_GOOD                 3

/*
 * Special "sval" limit -- maximum allowed spellbook sval (used to prevent
 * illegal access to tables)
 */
#define SV_BOOK_MAX                      9

/*
 * Special "sval" limit -- max normal treasure sval
 * (used in function "make_gold")
 */
#define SV_GOLD_MAX                     11

/*
 * Special "sval" limits -- special treasure values
 * (used in function "make_special_gold")
 */
#define SV_SPECIAL_GOLD_MIN             16
#define SV_SPECIAL_GOLD_MAX             19

/*
 * Special "sval" values -- any and all
 */
#define SV_ANY			    254
#define SV_ALL				255


/*
 * 1/x chance of reducing stats (for elemental attacks).  From Zangband.
 */
#define HURT_CHANCE                     25


/*
 * Maximal component, parchment, and bottle svals.
 */
#define SV_COMPONENT_MAX                 5
#define SV_PARCHMENT_MAX                 6
#define SV_BOTTLE_MAX                    6




/*
 * -Bahman Rabii-
 * If a spell/wand/rod/etc calls fire_bolt() followed by fire_cloud()
 * and the targeted monster is killed by the first fire_bolt(), then
 * the target is cleared and the second fire_cloud() will start at
 * the character's location. For example:
 *
 *     fire_bolt(GF_POIS, dir, damroll(plev / 2, 11));
 *     fire_cloud(GF_POIS, dir, 30, 6);
 *
 * The solution is to remember the target, and if the monster is
 * killed by the fire_bolt() then the target is set to the location
 * the monster was at. The macros to do this are:
 *
 * TARGET_DECLARE  -- Declare some variables
 * TARGET_PRESERVE -- Remember the current target location
 * TARGET_RESTORE  -- Set the target to the saved location
 *
 * The above statements would now be written:
 *
 *     TARGET_DECLARE
 *     ...
 *     TARGET_PRESERVE
 *     fire_bolt(GF_POIS, dir, damroll(plev / 2, 11));
 *     TARGET_RESTORE
 *     fire_cloud(GF_POIS, dir, 30, 6);
 */

#define TARGET_DECLARE \
	int save_target_y = 0, save_target_x = 0; \
	bool save_target_set;

#define TARGET_PRESERVE \
	if ((dir == 5) && target_okay() && p_ptr->target_who) \
	{ \
		save_target_y = p_ptr->target_row; \
		save_target_x = p_ptr->target_col; \
		save_target_set = TRUE; \
	} \
	else save_target_set = FALSE;

#define TARGET_RESTORE \
	if (save_target_set && !p_ptr->target_set) \
		target_set_location(save_target_y, save_target_x);



/*** Function flags ***/


#define PROJECT_NO                  0
#define PROJECT_NOT_CLEAR           1
#define PROJECT_CLEAR               2

/*
 * Bit flags for the "project()", the "projectable()", and/or the
 * "project_path()" functions.
 *
 *   BEAM:  Work as a beam weapon (affect every grid passed through)
 *   ARC:   Act as an arc spell (a portion of a caster-centered ball)
 *   STAR:  Act as a starburst - a randomized ball
 *   BOOM:  Explode in some way
 *   WALL:  Affect one layer of any wall, even if not passable
 *   PASS:  Ignore walls entirely
 *   GRID:  Affect each grid in the "blast area" in some way
 *   ITEM:  Affect objects
 *   KILL:  Affect monsters
 *   PLAY:  Explicitly affect the player
 *   SAFE:  Hack -- do not affect monsters of caster's type
 *   HIDE:  Hack -- disable graphical effects of projection
 *   STOP:  Stop as soon as we hit a monster
 *   JUMP:  Jump directly to the target location
 *   THRU:  Continue "through" the target (used for projectiles)
 *   CHCK:  Note occupied grids, but do not stop at them
 *   ORTH:  Projection cannot move diagonally (used for wall spells)
 */

/* Projection types */
#define PROJECT_BEAM         0x00000001
#define PROJECT_ARC          0x00000002
#define PROJECT_STAR         0x00000004
#define PROJECT_XXX1         0x00000008
#define PROJECT_XXX2         0x00000010
#define PROJECT_XXX3         0x00000020

/* What projections do */
#define PROJECT_BOOM         0x00000040
#define PROJECT_WALL         0x00000080
#define PROJECT_PASS         0x00000100
#define PROJECT_XXX4         0x00000200
#define PROJECT_XXX5         0x00000400

/* What projections affect */
#define PROJECT_GRID         0x00000800
#define PROJECT_ITEM         0x00001000
#define PROJECT_KILL         0x00002000
#define PROJECT_PLAY         0x00004000
#define PROJECT_SAFE         0x00008000
#define PROJECT_XXX6         0x00010000
#define PROJECT_XXX7         0x00020000

/* Graphics */
#define PROJECT_HIDE         0x00040000
#define PROJECT_NO_REDRAW    0x00080000
#define PROJECT_NO_TRAIL     0x00100000

/* How projections travel */
#define PROJECT_STOP         0x00200000
#define PROJECT_JUMP         0x00400000
#define PROJECT_THRU         0x00800000
#define PROJECT_CHCK         0x01000000
#define PROJECT_ORTH         0x02000000
#define PROJECT_XX10         0x04000000

/* Projection blockage indicators */
#define PATH_G_FULL          0
#define PATH_G_BLCK          1
#define PATH_G_WALL          2
#define PATH_G_NONE        100


/*
 * An arc with a width (in degrees) less than this value will lose less
 * power over distance.
 */
#define ARC_STANDARD_WIDTH     90

/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT     0x01
#define ENCH_TODAM     0x02
#define ENCH_TOAC      0x04


/*
 * Bit flags for the "target_set" function XXX XXX XXX
 *
 *  KILL: Target monsters
 *  LOOK: Describe grid fully
 *  XTRA: Currently unused flag
 *  GRID: Select from all grids
 *  FIRE: Require line of fire
 */
#define TARGET_KILL    0x01
#define TARGET_LOOK    0x02
#define TARGET_XTRA    0x04
#define TARGET_GRID    0x08
#define TARGET_FIRE    0x10


/*
 * Bit flags for the "monster_desc" function
 */
#define MDESC_OBJE     0x01		/* Objective (or Reflexive) */
#define MDESC_POSS     0x02		/* Possessive (or Reflexive) */
#define MDESC_IND1     0x04		/* Indefinites for hidden monsters */
#define MDESC_IND2     0x08		/* Indefinites for visible monsters */
#define MDESC_PRO1     0x10		/* Pronominalize hidden monsters */
#define MDESC_PRO2     0x20		/* Pronominalize visible monsters */
#define MDESC_HALU     0x40		/* Allow hallucinations */
#define MDESC_SHOW     0x80		/* Assume the monster is visible */


/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP      0x01		/* Allow equip items */
#define USE_INVEN      0x02		/* Allow inven items */
#define USE_FLOOR      0x04		/* Allow floor items */

/*
 * Bit flags for the "drop_near" function
 */
#define DROP_NO_MSG          0x01		/* No messages */
#define DROP_HERE            0x02		/* Drop object at given location */
#define DROP_CHAR_DROP       0x04      /* Character dropped the object */

/*
 * Modes for the "do_spell" function
 */
#define SPELL_CAST         1
#define SPELL_INFO         2
#define SPELL_DESC         3
#define SPELL_MANA         4
#define SPELL_FAIL         5


/*
 * Modes for the "use_item_describe" function.
 */
#define USE_ITEM_DESC_FIRE   1
#define USE_ITEM_DESC_THROW  2



/*
 * Modes for object usage functions
 *
 * Note:  Object descriptions are in data files.  It is certainly possible
 * to transfer all other modes (for spells and objects both) to data files,
 * but it is uncertain whether that would be a practical, rather than
 * philosophical, good thing.
 */
#define OBJECT_USE         1
#define OBJECT_INFO        2
#define OBJECT_THROW       3


/*
 * Flags for object generation.  "(obj_gen_flags & (flag))"
 */
#define OBJ_GEN_UNIQUE         0x00000001  /* Dropped by unique */
#define OBJ_GEN_STORE          0x00000002  /* Store object */
#define OBJ_GEN_NO_ROLLS       0x00000004  /* No re-roll for ego/artifact */
#define OBJ_GEN_HIDDEN_CURSE   0x00000008  /* Force cursed ego-item */


/*
 * Modes for the "do_talent" function
 */
#define TALENT_USE         1
#define TALENT_INFO        2
#define TALENT_DESC        3
#define TALENT_CHECK       4


/*
 * Modes for the "check_blanket" function
 */
#define CHECK_BLANKET_ACID   1
#define CHECK_BLANKET_ELEC   2
#define CHECK_BLANKET_FIRE   3
#define CHECK_BLANKET_COLD   4
#define CHECK_BLANKET_DISEN  5
#define CHECK_BLANKET_DRAIN  6
#define CHECK_BLANKET_CURSE  7


/*
 * Effect index defines
 */
#define EFFECT_EXPLOSION         1      /* A radiating explosion */

#define EFFECT_IRREGULAR_CLOUD   4      /* A standard lingering cloud */
#define EFFECT_DEATH_CLOUD       6      /* A cloud of death */
#define EFFECT_WALL              8      /* An advancing wall */
#define EFFECT_SEEKER_VORTEX     9      /* A seeking vortex */
#define EFFECT_RANDOM_DOTS      10      /* Lots of random dots */

/*
 * Effect flags (reorder them later)
 */
#define EF1_HURT_PLAY       0x0001  /* Effect can hurt the character */
#define EF1_HURT_EVIL       0x0002  /* Effect hurts only evil monsters */
#define EF1_CHARACTER       0x0004  /* Effect is cast by the character */
/* xxx (many) */
#define EF1_TWEAKED         0x8000  /* Effect has been tweaked */


/*** Player flags ***/

/*
 * Bit flags for the "p_ptr->suppress" variable
 */
#define SUPPRESS_DISPLAY_EVIL       0x01   /* Don't show evil monsters    */
#define SUPPRESS_DISPLAY_UNDEAD     0x02   /* Don't show undead monsters  */
#define SUPPRESS_DISPLAY_ANIMAL     0x04   /* Don't show natural monsters */


/*
 * Possible values for the "p_ptr->get_help_index" variable
 */
#define HELP_GENERAL                0
#define HELP_CMD_REVIEW             1
#define HELP_CMD_INSCRIP            2
#define HELP_TARGET                 3
#define HELP_CHAR_SCREEN_MAIN       4
#define HELP_CHAR_SCREEN_FLAGS      5
#define HELP_CHAR_SCREEN_COMBAT     6
#define HELP_CMD_MACRO              7
#define HELP_CMD_VISUALS            8
#define HELP_CMD_COLORS             9

#define HELP_BIRTH_GENDER          10
#define HELP_BIRTH_RACE            11
#define HELP_BIRTH_CLASS           12  /* Not used in Sangband */
#define HELP_BIRTH_XTRA1           13  /* Not used yet */
#define HELP_BIRTH_XTRA2           14  /* Not used yet */

#define HELP_STAT_STR              15
#define HELP_STAT_INT              16
#define HELP_STAT_WIS              17
#define HELP_STAT_DEX              18
#define HELP_STAT_CON              19
#define HELP_STAT_CHR              20
#define HELP_STAT_XX1              21  /* Not used yet */
#define HELP_STAT_XX2              22  /* Not used yet */

#define HELP_TUTORIAL              23

#define HELP_STORE                 24
#define HELP_QUEST                 25


/* Variant-specific topics */
#define HELP_SKILLS               125
        /* Lots of individual skills */

#define HELP_TALENTS              166
#define HELP_FORGING              167
#define HELP_INFUSION             168


/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE      0x00000001L	/* Combine the pack */
#define PN_REORDER      0x00000002L	/* Reorder the pack */
#define PN_PICKUP0      0x00000004L	/* Notice stuff (allow pickup) */
#define PN_PICKUP1      0x00000008L	/* Pick up stuff */

/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS        0x00000001L	/* Calculate bonuses */
#define PU_TORCH        0x00000002L	/* Calculate torch radius */
#define PU_FLOW         0x00000004L	/* Erase and recalc flow-by-sound */
#define PU_SCORE        0x00000008L	/* Calculate score */
#define PU_HP           0x00000010L	/* Calculate chp and mhp */
#define PU_MANA         0x00000020L	/* Calculate csp and msp */
#define PU_SPELLS       0x00000040L	/* Calculate spells */
/* xxx (many) */
#define PU_FORGET_VIEW  0x00010000L		/* Forget field of view */
#define PU_UPDATE_VIEW  0x00020000L		/* Update field of view */
/* xxx (many) */
#define PU_MONSTERS     0x01000000L	/* Update monsters */
#define PU_DISTANCE     0x02000000L	/* Update distances */
/* xxx */
#define PU_PANEL        0x80000000L	/* Update panel */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_NAME         0x00000001L	/* Display Short Name */
#define PR_RACE         0x00000002L	/* Display Race */
#define PR_TITLE        0x00000004L	/* Display Title */
#define PR_EXP          0x00000008L	/* Display Experience */
#define PR_GOLD         0x00000010L	/* Display Gold */
#define PR_EQUIPPY      0x00000020L	/* Display Equippy chars */
#define PR_STATS        0x00000040L	/* Display Stats */
#define PR_SHAPE        0x00000080L	/* Display Shapechange */
#define PR_ARMOR        0x00000100L	/* Display Armor */
#define PR_HP           0x00000200L	/* Display Hitpoints */
#define PR_MANA         0x00000400L	/* Display Mana */
#define PR_HEALTH       0x00000800L	/* Display Health Bar */
#define PR_HEALTH_EXTRA 0x00001000L	/* Display Extra Health Bars */
/* xxx */
/* xxx */
/* xxx */
#define PR_HUNGER       0x00010000L	/* Display Extra (Hunger) */
#define PR_CONDITIONS   0x00020000L	/* Display Temporary conditions */
#define PR_STATE        0x00040000L	/* Display Extra (State) */
#define PR_SPEED        0x00080000L	/* Display Extra (Speed) */
#define PR_UNCAST       0x00100000L	/* Display Extra (Uncast spells) */
#define PR_DEPTH        0x00200000L	/* Display Depth */
/* xxx */
/* xxx */
#define PR_EXTRA        0x01000000L	/* Display Extra Info */
#define PR_BASIC        0x02000000L	/* Display Basic Info */
/* xxx */
#define PR_MAP          0x08000000L	/* Display Map */
/* xxx */
/* xxx */
/* xxx */
/* xxx */


/*
 * Bit flags for the "p_ptr->window" variable (etc)
 */
#define PW_INVEN        0x00000001L  /* Display inven/equip */
#define PW_EQUIP        0x00000002L  /* Display equip/inven */
#define PW_PLAYER_0     0x00000004L  /* Display player (basic) */
#define PW_PLAYER_1     0x00000008L  /* Display player (extra) */
#define PW_M_LIST       0x00000010L  /* Show monster list */
#define PW_O_LIST       0x00000020L  /* Show object list */
#define PW_MESSAGE      0x00000040L  /* Display messages */
#define PW_OVERHEAD     0x00000080L  /* Display overhead view */
#define PW_MONSTER      0x00000100L  /* Display monster recall */
#define PW_OBJECT       0x00000200L  /* Display object recall */
#define PW_CMDLIST      0x00000400L  /* Display of useful commands */
/* xxx */
/* xxx */
/* xxx */
#define PW_BORG_1       0x00004000L  /* Display borg messages */
#define PW_BORG_2       0x00008000L  /* Display borg status */


/*
 * Number of "basic" displays
 */
#define BASIC_WINDOW_DISPLAYS   10




/*
 * Indexes of left panel custom displays
 */
#define DISPLAY_BLANK              1   /* blank line */
#define DISPLAY_HEALTH             2   /* monster name and health bar */
#define DISPLAY_TOTAL_KILLS        3   /* p_ptr->total_kills */
#define DISPLAY_SCORE              4   /* score */
#define DISPLAY_FAME               5   /* p_ptr->fame */
#define DISPLAY_TIME               6   /* elapsed time */
#define DISPLAY_LUCK               7   /* p_ptr->luck */
#define DISPLAY_REGEN              8   /* regeneration */
#define DISPLAY_QUEST              9   /* quest status */
#define DISPLAY_TARGET            10   /* current target */
#define DISPLAY_REALM_COND        11   /* realm-specific conditions */
/* xxx */
/* xxx */
#define DISPLAY_SPECIAL_ATTACK    14   /* p_ptr->special_attack */
#define DISPLAY_OPPOSE            15   /* p_ptr->oppose_xxx */
#define DISPLAY_FEAR              16   /* p_ptr->afraid/bold/hero/berserk */
#define DISPLAY_PROT_BLESS        17   /* p_ptr->blessed/shield/res_dam */
#define DISPLAY_WEATHER           18   /* p_ptr->weather */
/* xxx */
#define DISPLAY_NOISE             20   /* noise */
#define DISPLAY_INVISIBILITY      21   /* p_ptr->invisibility */
/* xxx */



/*
 * Start of customized display area
 */
#define ROW_CUSTOM                17

/*
 * Maximum number of custom displays rows.  The actual maximum depends on
 * how much space the player gives the main display; it can be as little
 * as three.
 */
#define CUSTOM_DISPLAY_ROWS       44 - ROW_CUSTOM


/*
 * Bitflags for the offscreen monster threat display.  (non-functional)
 */
#define DISPLAY_THREAT_N     0x0001
#define DISPLAY_THREAT_NE    0x0002
#define DISPLAY_THREAT_E     0x0004
#define DISPLAY_THREAT_SE    0x0008
#define DISPLAY_THREAT_S     0x0010
#define DISPLAY_THREAT_SW    0x0020
#define DISPLAY_THREAT_W     0x0040
#define DISPLAY_THREAT_NW    0x0080


/*
 * Types of blows for "monster_evade_or_resist()"
 */
#define BLOW_MELEE     1
#define BLOW_MISSILE   2
#define BLOW_THROWN    3
#define BLOW_TRAP      4


/*
 * Shapechange values.
 */
#define SHAPE_NORMAL        0
#define SHAPE_GOAT          1
#define SHAPE_BEAR          2
#define SHAPE_MOUSE         3
#define SHAPE_HOUND         4
#define SHAPE_CHEETAH       5
#define SHAPE_LION          6
#define SHAPE_DRAGON        7
#define SHAPE_ENT           8
#define SHAPE_TROLL         9

#define SHAPE_BAT          11



/*
 * Bit flags for the "p_ptr->special_attack" variable.  -LM-
 */
#define ATTACK_NORMAL      0x0000
#define ATTACK_CONFUSE     0x0001
#define ATTACK_BLKBRTH     0x0002
#define ATTACK_FLEE        0x0004
#define ATTACK_XX01        0x0008
#define ATTACK_XX02        0x0010
#define ATTACK_HOLY        0x0020
#define ATTACK_VORPAL      0x0040
#define ATTACK_SNEAK       0x0080
#define ATTACK_PIERCING    0x0100
#define ATTACK_DAMAGE      0x0200
#define ATTACK_IMPACT      0x0400
#define ATTACK_ACCURATE    0x0800
#define ATTACK_SHOT_FIRE   0x1000
#define ATTACK_SHOT_COLD   0x2000
#define ATTACK_BARD        0x4000
#define ATTACK_DEADLY      0x8000


/*** Player ailments - breakpoints */

#define HVY_STUN        50
#define KNOCKED_OUT    100

#define WOUND_MORTAL  1000


/* Berserkers are weak for a time after their rage passes. */
#define BERSERK_WEAKNESS_LENGTH   50

/* Necromancers are weak for a time after their rage passes. */
#define NECRO_WEAKNESS_LENGTH     30




/*** Feature flags ***/

/*
 * Special feature type flags
 */
#define TF_LOS          0x00000001L  /* LOS passes through this */
#define TF_PROJECT      0x00000002L  /* Projections can pass through this */
#define TF_PASSABLE     0x00000004L  /* Can be passed through by all creatures */
#define TF_INTERESTING  0x00000008L  /* Looking around notices this */
#define TF_PERMANENT    0x00000010L  /* Feature is permanent */
#define TF_NO_SCENT     0x00000020L  /* Cannot store scent */
#define TF_OBJECT       0x00000040L  /* Can hold objects */
#define TF_TRAP         0x00000080L  /* Can hold traps */
#define TF_TORCH_ONLY   0x00000100L  /* Becomes bright only when torch-lit */
/* xxx (many) */
#define TF_FLOOR        0x00010000L  /* A clear floor */
#define TF_WALL         0x00020000L  /* Is a solid wall */
#define TF_ROCK         0x00040000L  /* Is rocky */
#define TF_GRANITE      0x00080000L  /* Is a granite rock wall */
#define TF_DOOR_ANY     0x00100000L  /* Is any door */
#define TF_DOOR_CLOSED  0x00200000L  /* Is a closed door */
#define TF_SHOP         0x00400000L  /* Is a shop */
/* xxx (many) */




/*** Cave flags ***/


/*
 * Special cave grid flags
 */
#define CAVE_MARK         0x0001  /* Memorized feature */
#define CAVE_GLOW         0x0002  /* Self-illuminating (permanent light) */
#define CAVE_ICKY         0x0004  /* Part of a vault */
#define CAVE_ROOM         0x0008  /* Part of a room */
#define CAVE_SEEN         0x0010  /* Actually seeable by the character */
#define CAVE_VIEW         0x0020  /* In character field of sight */
#define CAVE_TEMP         0x0040  /* Temporary flag (hard-coded position) */
#define CAVE_LOS          0x0080  /* Blocks line of sight */

#define CAVE_FIRE         0x0100  /* Is in line of fire */
#define CAVE_EFFT         0x0200  /* Is being hit by an effect */
#define CAVE_LITE         0x0400  /* Temporary light (light source) */
#define CAVE_TRAP         0x0800  /* Has at least one trap */
#define CAVE_XX12         0x1000  /*  */
#define CAVE_XX13         0x2000  /*  */
#define CAVE_XX14         0x4000  /*  */
#define CAVE_XX15         0x8000  /*  */




/*** Trap defines ***/


/*
 * Limit on number of trap kinds
 */
#define TRAP_KIND_MAX   20

/* Trap kinds */
#define TRAP_NONE              0
#define TRAP_LOOSE_ROCK        1
#define TRAP_GLYPH             2

#define TRAP_MONSTER           5
#define TRAP_DOOR              6
#define TRAP_PIT               7
#define TRAP_DART              8
#define TRAP_SPOT              9
#define TRAP_GAS              10
#define TRAP_SUMMON           11
#define TRAP_ALTER_DUNGEON    12
#define TRAP_HEX              13
#define TRAP_PORTAL           14
#define TRAP_MURDER_HOLE      15


/*
 * Trap flags
 */
#define TRAP_PLAY              0x0001
#define TRAP_KILL              0x0002
#define TRAP_NASTY             0x0004
#define TRAP_EASY_DISARM       0x0008
#define TRAP_NO_DISARM         0x0010
#define TRAP_VISIBLE           0x0020
#define TRAP_NO_EXP            0x0040
#define TRAP_XXX2              0x0080
#define TRAP_XXX3              0x0100
#define TRAP_XXX4              0x0200
#define TRAP_XXX5              0x0400
#define TRAP_XXX6              0x0800
#define TRAP_XXX7              0x1000
#define TRAP_XXX8              0x2000
#define TRAP_XXX9              0x4000
#define TRAP_XX10              0x8000



/*** Object flags ***/


/*
 * Chest trap types
 */
#define CHEST_GAS                 1
#define CHEST_DRAIN_STAT          2
#define CHEST_SUMMON              3
#define CHEST_WEIRD               4
#define CHEST_CURSE               5


/*
 * The special inscriptions.  Hard-coded by savefiles.
 */
#define INSCRIP_NULL              0
#define INSCRIP_TERRIBLE          1
#define INSCRIP_WORTHLESS         2
#define INSCRIP_CURSED            3
#define INSCRIP_BROKEN            4
#define INSCRIP_AVERAGE           5
#define INSCRIP_GOOD              6
#define INSCRIP_EXCELLENT         7
#define INSCRIP_SPECIAL           8
#define INSCRIP_UNCURSED          9
#define INSCRIP_INDESTRUCTIBLE   10

#define INSCRIP_BLESSED          11
#define INSCRIP_VERY_BLESSED     12
#define INSCRIP_VERY_CURSED      13

#define INSCRIP_UNCERTAIN        14
#define INSCRIP_UNCERTAIN_SENSED 15
#define INSCRIP_CURSED2          16

/*
 * Number of special inscriptions, plus one.
 */
#define MAX_INSCRIP              17


/*
 * Some bit-flags for the "smart" field
 *
 * Most of these map to the "TR2_xxx" flags
 */

#define SM_IMM_ACID           0x00000001L
#define SM_IMM_ELEC           0x00000002L
#define SM_IMM_FIRE           0x00000004L
#define SM_IMM_COLD           0x00000008L
#define SM_RES_ACID           0x00000010L
#define SM_RES_ELEC           0x00000020L
#define SM_RES_FIRE           0x00000040L
#define SM_RES_COLD           0x00000080L
#define SM_RES_POIS           0x00000100L
#define SM_RES_LITE           0x00000200L
#define SM_RES_DARK           0x00000400L
#define SM_RES_FEAR           0x00000800L
#define SM_RES_BLIND          0x00001000L
#define SM_RES_CONFU          0x00002000L
#define SM_RES_SOUND          0x00004000L
#define SM_RES_SHARD          0x00008000L
#define SM_RES_NEXUS          0x00010000L
#define SM_RES_NETHR          0x00020000L
#define SM_RES_CHAOS          0x00040000L
#define SM_RES_DISEN          0x00080000L
#define SM_OPP_ACID           0x00100000L
#define SM_OPP_ELEC           0x00200000L
#define SM_OPP_FIRE           0x00400000L
#define SM_OPP_COLD           0x00800000L
#define SM_OPP_POIS           0x01000000L
#define SM_OPP_XXX1           0x02000000L
#define SM_OPP_XXX2           0x04000000L
#define SM_OPP_XXX3           0x08000000L
#define SM_GOOD_SAVE          0x10000000L
#define SM_PERF_SAVE          0x20000000L
#define SM_IMM_FREE           0x40000000L
#define SM_IMM_MANA           0x80000000L


/*
 * All objects use object flags.
 *
 * The first set of flags all depend on pval.  Because an object may have
 * several different pvals, each affecting any number of flags in the set,
 * the entire set is duplicated for each pval.  Should any flag be
 * affected by more than one pval, only the first pval is used.
 *
 * There are three sets of non pval-dependant flags:
 * "flags1" contains sustains and most weapon-specific attributes.
 * "flags2" contains immunities, resistances, and protections.
 * "flags3" contains everything else.
 */
#define TR_PVAL_STR            0x00000001L   /* STR += pval */
#define TR_PVAL_INT            0x00000002L   /* INT += pval */
#define TR_PVAL_WIS            0x00000004L   /* WIS += pval */
#define TR_PVAL_DEX            0x00000008L   /* DEX += pval */
#define TR_PVAL_CON            0x00000010L   /* CON += pval */
#define TR_PVAL_CHR            0x00000020L   /* CHR += pval */
#define TR_PVAL_XXX6           0x00000040L   /*  */
#define TR_PVAL_XXX7           0x00000080L   /*  */

#define TR_PVAL_STEALTH        0x00000100L   /* Stealth      += pval */
#define TR_PVAL_AWARE          0x00000200L   /* Search       += pval * 5 */
#define TR_PVAL_INFRA          0x00000400L   /* Infra        += pval */
#define TR_PVAL_TUNNEL         0x00000800L   /* Tunnel       += pval * 20 */
#define TR_PVAL_SPEED          0x00001000L   /* Speed        += pval */
#define TR_PVAL_INVIS          0x00002000L   /* Invis        += pval * 5 */
#define TR_PVAL_DISARM         0x00004000L   /* Disarming    += pval * 10 */
#define TR_PVAL_DEVICE         0x00008000L   /* Devices      += pval * 5 */
#define TR_PVAL_SAVE           0x00010000L   /* Saving throw += pval * 5 */
#define TR_PVAL_MANA           0x00020000L   /* Mana         += pval * 15 */
#define TR_PVAL_LIGHT          0x00040000L   /* Light radius == pval */
#define TR_PVAL_XX19           0x00080000L   /*  */

#define TR_PVAL_BLOWS          0x00100000L   /* Blows += pval */
#define TR_PVAL_SHOTS          0x00200000L   /* Shots += pval */
#define TR_PVAL_MIGHT          0x00400000L   /* Might += pval */
#define TR_PVAL_XX23           0x00800000L   /*  */
#define TR_PVAL_XX24           0x01000000L   /*  */
#define TR_PVAL_XX25           0x02000000L   /*  */
#define TR_PVAL_XX26           0x04000000L   /*  */
#define TR_PVAL_XX27           0x08000000L   /*  */
#define TR_PVAL_XX28           0x10000000L   /*  */
#define TR_PVAL_XX29           0x20000000L   /*  */
#define TR_PVAL_XX30           0x40000000L   /*  */
#define TR_PVAL_XX31           0x80000000L   /*  */


/*
 * Flags1:  Sustains, most weapon-specific flags
 */
#define TR1_SUST_STR           0x00000001L   /* Sustain STR */
#define TR1_SUST_INT           0x00000002L   /* Sustain INT */
#define TR1_SUST_WIS           0x00000004L   /* Sustain WIS */
#define TR1_SUST_DEX           0x00000008L   /* Sustain DEX */
#define TR1_SUST_CON           0x00000010L   /* Sustain CON */
#define TR1_SUST_CHR           0x00000020L   /* Sustain CHR */
#define TR1_XXX6               0x00000040L   /*  */
#define TR1_XXX7               0x00000080L   /*  */
#define TR1_SLAY_ANIMAL        0x00000100L   /* +10 against animals */
#define TR1_SLAY_EVIL          0x00000200L   /* +10 against evil */
#define TR1_SLAY_UNDEAD        0x00000400L   /* +18 against undead */
#define TR1_SLAY_DEMON         0x00000800L   /* +18 against demons */
#define TR1_SLAY_ORC           0x00001000L   /* +10 against orcs */
#define TR1_SLAY_TROLL         0x00002000L   /* +18 against trolls */
#define TR1_SLAY_GIANT         0x00004000L   /* +18 against giants */
#define TR1_SLAY_DRAGON        0x00008000L   /* +18 against dragons */
#define TR1_KILL_DRAGON        0x00010000L   /* +27 against dragons */
#define TR1_XX17               0x00020000L   /*  */
#define TR1_XX18               0x00040000L   /*  */
#define TR1_BRAND_ACID         0x00080000L   /* +10 acid brand */
#define TR1_BRAND_ELEC         0x00100000L   /* +14 electric brand */
#define TR1_BRAND_FIRE         0x00200000L   /* +14 fire brand */
#define TR1_BRAND_COLD         0x00400000L   /* +14 cold brand */
#define TR1_BRAND_POIS         0x00800000L   /* +14 poison brand */
#define TR1_BRAND_FLAME        0x01000000L   /* +22 fire brand */
#define TR1_BRAND_VENOM        0x02000000L   /* +22 poison brand */
#define TR1_RETURNING          0x04000000L   /* Returns when thrown */
#define TR1_VORPAL             0x08000000L   /* Gets lots of critical hits */
#define TR1_THROWING           0x10000000L   /* Can be thrown effectively */
#define TR1_PERFECT_BALANCE    0x20000000L   /* Perfectly balanced */
#define TR1_TWO_HANDED_REQ     0x40000000L   /* Usually needs two hands */
#define TR1_TWO_HANDED_DES     0x80000000L   /* Always needs two hands */


/*
 * Flags2:  Immunities, resistances, and protections
 */
#define TR2_IM_ACID            0x00000001L   /* Immunity to acid */
#define TR2_IM_ELEC            0x00000002L   /* Immunity to elec */
#define TR2_IM_FIRE            0x00000004L   /* Immunity to fire */
#define TR2_IM_COLD            0x00000008L   /* Immunity to cold */
#define TR2_RES_ACID           0x00000010L   /* Resist acid */
#define TR2_RES_ELEC           0x00000020L   /* Resist elec */
#define TR2_RES_FIRE           0x00000040L   /* Resist fire */
#define TR2_RES_COLD           0x00000080L   /* Resist cold */
#define TR2_RES_POIS           0x00000100L   /* Resist poison */
#define TR2_RES_LITE           0x00000200L   /* Resist light */
#define TR2_RES_DARK           0x00000400L   /* Resist darkness */
#define TR2_RES_FEAR           0x00000800L   /* Resist fear */
#define TR2_RES_BLIND          0x00001000L   /* Resist blind */
#define TR2_RES_CONFU          0x00002000L   /* Resist confusion */
#define TR2_RES_SOUND          0x00004000L   /* Resist sound */
#define TR2_RES_SHARD          0x00008000L   /* Resist shards */
#define TR2_RES_NEXUS          0x00010000L   /* Resist nexus */
#define TR2_RES_NETHR          0x00020000L   /* Resist nether */
#define TR2_RES_CHAOS          0x00040000L   /* Resist chaos */
#define TR2_RES_DISEN          0x00080000L   /* Resist disenchant */
#define TR2_RES_DRAIN          0x00100000L   /* Resist mana/charge drain */
#define TR2_XX21               0x00200000L   /*  */
#define TR2_XX22               0x00400000L   /*  */
#define TR2_XX23               0x00800000L   /*  */
#define TR2_XX24               0x01000000L   /*  */
#define TR2_XX25               0x02000000L   /*  */
#define TR2_XX26               0x04000000L   /*  */
#define TR2_XX27               0x08000000L   /*  */
#define TR2_IGNORE_ACID        0x10000000L   /* Item ignores Acid Damage */
#define TR2_IGNORE_ELEC        0x20000000L   /* Item ignores Elec Damage */
#define TR2_IGNORE_FIRE        0x40000000L   /* Item ignores Fire Damage */
#define TR2_IGNORE_COLD        0x80000000L   /* Item ignores Cold Damage */


/*
 * Flags3:  Miscellaneous object attributes, including the nasty ones
 */
#define TR3_SLOW_DIGEST        0x00000001L   /* Slow digest */
#define TR3_FEATHER            0x00000002L   /* Feather Falling */
#define TR3_LITE               0x00000004L   /* Permanent light */
#define TR3_REGEN              0x00000008L   /* Regeneration */
#define TR3_TELEPATHY          0x00000010L   /* Telepathy */
#define TR3_SEE_INVIS          0x00000020L   /* See Invis */
#define TR3_FREE_ACT           0x00000040L   /* Free action */
#define TR3_HOLD_LIFE          0x00000080L   /* Hold life */
#define TR3_BLESSED            0x00000100L   /* Blessed (good for priests) */
#define TR3_IMPACT             0x00000200L   /* Thrust back opponents */
#define TR3_XX10               0x00000400L   /*  */
#define TR3_XX11               0x00000800L   /*  */
#define TR3_IS_LIT             0x00001000L   /* Object is currently lit */
#define TR3_INSTA_ART          0x00002000L   /* Item makes an artifact */
#define TR3_EASY_KNOW          0x00004000L   /* Item is known if aware */
#define TR3_HIDE_TYPE          0x00008000L   /* Item hides description */
#define TR3_SHOW_MODS          0x00010000L   /* Item shows Tohit/Todam */
#define TR3_ATTR_MULTI         0x00020000L   /* Item is multi-hued */
#define TR3_XX18               0x00040000L   /*  */
#define TR3_NOFUEL             0x00080000L   /* Light source needs no fuel */
#define TR3_SOULSTEAL          0x00100000L   /* Weapon must be fed */
#define TR3_NOMAGIC            0x00200000L   /* Spellcasting blocked */
#define TR3_TELEPORT           0x00400000L   /* Random teleportation */
#define TR3_AGGRAVATE          0x00800000L   /* Aggravate monsters */
#define TR3_DRAIN_EXP          0x01000000L   /* Experience drain */
#define TR3_DRAIN_HP           0x02000000L   /* Reduce hitpoints */
#define TR3_XX26               0x04000000L   /* (nasty qualities should go here) */
#define TR3_XX27               0x08000000L   /*  */
#define TR3_CURSE_HIDDEN       0x10000000L   /* Bears a hidden curse */
#define TR3_LIGHT_CURSE        0x20000000L   /* Item has Light Curse */
#define TR3_HEAVY_CURSE        0x40000000L   /* Item has Heavy Curse */
#define TR3_PERMA_CURSE        0x80000000L   /* Item has Perma Curse */



/*
 * Flag set 2 -- mask for "ignore element" flags.
 */
#define TR2_IGNORE_MASK \
	(TR2_IGNORE_ACID | TR2_IGNORE_ELEC | TR2_IGNORE_FIRE | TR2_IGNORE_COLD )






/*
 * Allow easy access to object flags
 *
 * Note:  indexes must match the position of the corresponding flag.
 *
 * flags_pval starts at 0
 * flags1 starts at 32
 * flags2 starts at 64
 * flags3 starts at 96
 */

/* Flags_pval */
#define PVAL_STR             0
#define PVAL_INT             1
#define PVAL_WIS             2
#define PVAL_DEX             3
#define PVAL_CON             4
#define PVAL_CHR             5

#define PVAL_STEALTH         8
#define PVAL_AWARE           9
#define PVAL_INFRA          10
#define PVAL_TUNNEL         11
#define PVAL_SPEED          12
#define PVAL_INVIS          13
#define PVAL_DISARM         14
#define PVAL_DEVICE         15
#define PVAL_SAVE           16
#define PVAL_MANA           17
#define PVAL_LIGHT          18

#define PVAL_BLOWS          20
#define PVAL_SHOTS          21
#define PVAL_MIGHT          22


/* Flags1 */
#define SUST_STR            32
#define SUST_INT            33
#define SUST_WIS            34
#define SUST_DEX            35
#define SUST_CON            36
#define SUST_CHR            37

#define SLAY_ANIMAL         40
#define SLAY_EVIL           41
#define SLAY_UNDEAD         42
#define SLAY_DEMON          43
#define SLAY_ORC            44
#define SLAY_TROLL          45
#define SLAY_GIANT          46
#define SLAY_DRAGON         47
#define KILL_DRAGON         48

#define BRAND_ACID          51
#define BRAND_ELEC          52
#define BRAND_FIRE          53
#define BRAND_COLD          54
#define BRAND_POIS          55
#define BRAND_FLAME         56
#define BRAND_VENOM         57
#define RETURNING           58
#define VORPAL              59
#define THROWING            60
#define PERFECT_BALANCE     61
#define TWO_HANDED_REQ      62
#define TWO_HANDED_DES      63

/* Flags2 */
#define IM_ACID             64
#define IM_ELEC             65
#define IM_FIRE             66
#define IM_COLD             67
#define RES_ACID            68
#define RES_ELEC            69
#define RES_FIRE            70
#define RES_COLD            71
#define RES_POIS            72
#define RES_LITE            73
#define RES_DARK            74
#define RES_FEAR            75
#define RES_BLIND           76
#define RES_CONFU           77
#define RES_SOUND           78
#define RES_SHARD           79
#define RES_NEXUS           80
#define RES_NETHR           81
#define RES_CHAOS           82
#define RES_DISEN           83

#define IGNORE_ACID         92
#define IGNORE_ELEC         93
#define IGNORE_FIRE         94
#define IGNORE_COLD         95

/* Flags3 */
#define SLOW_DIGEST         96
#define FEATHER             97
#define LITE                98
#define REGEN               99
#define TELEPATHY          100
#define SEE_INVIS          101
#define FREE_ACT           102
#define HOLD_LIFE          103
#define BLESSED            104
#define IMPACT             105

#define INSTA_ART          109
#define EASY_KNOW          110
#define HIDE_TYPE          111
#define SHOW_MODS          112

#define NOFUEL             115
#define SOULSTEAL          116
#define NOMAGIC            117
#define TELEPORT           118
#define AGGRAVATE          119
#define DRAIN_EXP          120
#define DRAIN_HP           121

#define LIGHT_CURSE        125
#define HEAVY_CURSE        126
#define PERMA_CURSE        127


/* Space for a flags4 */


/* Miscellaneous qualities */
#define ADD_AC             160
#define IMPROVE_BASE_AC    161
#define ENHANCE_DICE       162
#define ADD_SKILL          163
#define ADD_DEADLINESS     164





/*
 * Hack -- special "xtra" object powers
 */
#define XTRA_SUSTAIN           0x0001   /* Sustain one stat */
#define XTRA_HIGH_RES          0x0002   /* High resist */
#define XTRA_LOW_RES           0x0004   /* Low resist */
#define XTRA_ANY_RES           0x0008   /* Any resist */
#define XTRA_POWER             0x0010   /* Special attribute */
#define XTRA_VORPAL            0x0020   /* May be vorpal */
#define XTRA_IMPACT            0x0040   /* May deal impact blows */
#define XXX1                   0x0080   /*  */
#define XTRA_LIGHT_QUALITY     0x0100   /* For ego-item light sources */
#define XTRA_MISSILE_POWER     0x0200   /* For ego-item missile launchers */
#define XTRA_ADD_DICE_SIDES    0x0400   /* Weapon may have better dice */
#define XTRA_CAN_BE_HEAVY      0x0800   /* Item can be especially heavy */
#define XTRA_XXX4              0x1000   /*  */
#define XTRA_XXX5              0x2000   /*  */
#define XTRA_NASTY_ACTIV       0x4000   /* Random nasty activation */
#define XTRA_NASTY_QUALITY     0x8000   /* Random nasty quality */


/*
 * Special object_kind flags - ID
 *
 * The ID-related flags are saved in the savefile.  They are not
 * saved between characters.
 */
#define SPECIAL_AWARE           0x01  /* Has basic awareness of kind */
#define SPECIAL_TRIED           0x02  /* Has "tried" one of the items */
#define SPECIAL_KNOWN_EFFECT    0x04  /* Item's effects are known */
#define SPECIAL_MESSAGE         0x08  /* Special object message displayed */
#define SPECIAL_EVER_SEEN       0x10  /* Object kind has been seen */
#define SPECIAL_XXX1            0x20  /*  */
#define SPECIAL_XXX2            0x40  /*  */
#define SPECIAL_XXX3            0x80  /*  */


/*
 * Special object_type flags - ID
 */
#define IDENT_SENSE             0x01  /* Item has been "sensed" */
#define IDENT_FIXED             0x02  /* Item has been "haggled" */
#define IDENT_EMPTY             0x04  /* Item charges are known */
#define IDENT_KNOWN             0x08  /* Item abilities are known */
#define IDENT_RUMOUR            0x10  /* Item background is known (not used) */
#define IDENT_MENTAL            0x20  /* Item details are fully known */
#define IDENT_CURSED            0x40  /* Item is temporarily cursed */
#define IDENT_WORN              0x80  /* Item has been worn */



/*** Monster flags ***/

/* Monster visibility */
#define    ML_LIMITED    1
#define    ML_FULL       2




#define MONSTER_BLOW_MAX 4


/*
 * Monster blow methods
 */
#define RBM_HIT           1
#define RBM_TOUCH         2
#define RBM_PUNCH         3
#define RBM_KICK          4
#define RBM_CLAW          5
#define RBM_BITE          6
#define RBM_STING         7
#define RBM_PECK          8
#define RBM_XXX1          9
#define RBM_BUTT         10
#define RBM_CRUSH        11
#define RBM_ENGULF       12
#define RBM_CRAWL        13
#define RBM_DROOL        14
#define RBM_SPIT         15
#define RBM_SLIME        16
#define RBM_GAZE         17
#define RBM_WAIL         18
#define RBM_SPORE        19
#define RBM_XXX4         20
#define RBM_BEG          21
#define RBM_INSULT       22
#define RBM_SNEER        23
#define RBM_TALK         24
#define RBM_XXX5         25


/*
 * Monster blow effects
 */
#define RBE_HURT       1
#define RBE_WOUND      2
#define RBE_BATTER     3
#define RBE_SHATTER    4

#define RBE_UN_BONUS   5
#define RBE_UN_POWER   6
#define RBE_LOSE_MANA  7
#define RBE_EAT_GOLD   8
#define RBE_EAT_ITEM   9
#define RBE_EAT_FOOD  10
#define RBE_EAT_LITE  11
#define RBE_HUNGER    12

#define RBE_POISON    13
#define RBE_ACID      14
#define RBE_ELEC      15
#define RBE_FIRE      16
#define RBE_COLD      17

#define RBE_BLIND     18
#define RBE_CONFUSE   19
#define RBE_TERRIFY   20
#define RBE_PARALYZE  21
#define RBE_HALLU     22
#define RBE_DISEASE   23

#define RBE_LOSE_STR  24
#define RBE_LOSE_INT  25
#define RBE_LOSE_WIS  26
#define RBE_LOSE_DEX  27
#define RBE_LOSE_CON  28
#define RBE_LOSE_CHR  29
#define RBE_LOSE_LUC  30
#define RBE_LOSE_ALL  31

#define RBE_EXP_10    32
#define RBE_EXP_20    33
#define RBE_EXP_40    34
#define RBE_EXP_80    35


/*
 * Special monster flags
 */
#define MFLAG_VIEW         0x0001  /* Monster is in line of sight */
#define MFLAG_XXX1         0x0002  /*  */
#define MFLAG_ACTV         0x0004  /* Monster is in active mode */
#define MFLAG_TEMP         0x0008  /* Monster is temporarily marked */
#define MFLAG_SHOW         0x0010  /* Monster is detected */
#define MFLAG_FULL         0x0020  /* Monster has full required visibility */
#define MFLAG_MARK         0x0040  /* Monster has some required visibility */
#define MFLAG_MIME         0x0080  /* Monster is a hidden mimic */

#define MFLAG_TOWN         0x0100  /* Monster is using "townsman" AI */
#define MFLAG_MADD         0x0200  /* Monster is maddened */
#define MFLAG_DOOM         0x0400  /* Monster is doomed */
#define MFLAG_WARY         0x0800  /* Monster is wary of stealing & traps */
#define MFLAG_TURN         0x1000  /* Monster will lose a turn */
#define MFLAG_BLBR         0x2000  /* Monster has the Black Breath */
#define MFLAG_XXX5         0x4000  /*  */
#define MFLAG_XXX6         0x8000  /*  */


/*
 * New monster race bit flags
 */
#define RF1_UNIQUE         0x00000001  /* Unique Monster */
#define RF1_QUESTOR        0x00000002  /* Quest Monster */
#define RF1_MALE           0x00000004  /* Male gender */
#define RF1_FEMALE         0x00000008  /* Female gender */
#define RF1_CHAR_CLEAR     0x00000010  /* Absorbs symbol */
#define RF1_CHAR_MIMIC     0x00000020  /* Monster can mimic a symbol */
#define RF1_ATTR_CLEAR     0x00000040  /* Absorbs color */
#define RF1_ATTR_MULTI     0x00000080  /* Changes color */
#define RF1_FORCE_DEPTH    0x00000100  /* Appear only on given depth or below */
#define RF1_FIXED_HPS      0x00000200  /* Start with fixed hitpoints */
#define RF1_FORCE_SLEEP    0x00000400  /* Start out sleeping */
#define RF1_FORCE_EXTRA    0x00000800  /* Start out something */
#define RF1_FRIEND         0x00001000  /* Arrive with a friend or two */
#define RF1_FRIENDS        0x00002000  /* Arrive with some friends */
#define RF1_ESCORT         0x00004000  /* Arrive with a small escort */
#define RF1_ESCORTS        0x00008000  /* Arrive with a large escort */
#define RF1_NEVER_BLOW     0x00010000  /* Never make physical blow */
#define RF1_NEVER_MOVE     0x00020000  /* Never make physical move */
#define RF1_RAND_25        0x00040000  /* Moves randomly (25%) */
#define RF1_RAND_50        0x00080000  /* Moves randomly (50%) */
#define RF1_ONLY_GOLD      0x00100000  /* Drop only gold */
#define RF1_ONLY_ITEM      0x00200000  /* Drop only items */
#define RF1_DROP_60        0x00400000  /* Drop an item/gold (60%) */
#define RF1_DROP_90        0x00800000  /* Drop an item/gold (90%) */
#define RF1_DROP_1D2       0x01000000  /* Drop 1d2 items/gold */
#define RF1_DROP_2D2       0x02000000  /* Drop 2d2 items/gold */
#define RF1_DROP_3D2       0x04000000  /* Drop 3d2 items/gold */
#define RF1_DROP_4D2       0x08000000  /* Drop 4d2 items/gold */
#define RF1_DROP_GOOD      0x10000000  /* Drop good items */
#define RF1_DROP_GREAT     0x20000000  /* Drop great items */
#define RF1_DROP_CHEST     0x40000000  /* Drop a chest */
#define RF1_DROP_XXX       0x80000000  /* Drop something */

/*
 * New monster race bit flags
 */
#define RF2_STUPID         0x00000001  /* Monster is stupid */
#define RF2_SMART          0x00000002  /* Monster is smart */
#define RF2_XXX1           0x00000004  /* (?) */
#define RF2_PLAYER_GHOST   0x00000008  /* Monster is a player ghost. -LM- */
#define RF2_INVISIBLE      0x00000010  /* Monster avoids vision */
#define RF2_COLD_BLOOD     0x00000020  /* Monster avoids infra */
#define RF2_EMPTY_MIND     0x00000040  /* Monster avoids telepathy.  NOT mindless. */
#define RF2_WEIRD_MIND     0x00000080  /* Monster avoids telepathy sometimes */
#define RF2_MULTIPLY       0x00000100  /* Monster reproduces */
#define RF2_REGENERATE     0x00000200  /* Monster regenerates especially quickly */
#define RF2_NOMISS         0x00000400  /* Never misses */
#define RF2_SAMESPD        0x00000800  /* Monster keeps pace with player */
#define RF2_EVASIVE        0x00001000  /* Monster often avoids blows */
#define RF2_FUNKY_DEATH    0x00002000  /* Something happens upon death */
#define RF2_CLOUD_SURROUND 0x00004000  /* Surrounded by gas/spores/darkness */
#define RF2_IS_LIT         0x00008000  /* Monster can be seen without normal light */
#define RF2_OPEN_DOOR      0x00010000  /* Monster can open doors */
#define RF2_BASH_DOOR      0x00020000  /* Monster can bash doors */
#define RF2_PASS_WALL      0x00040000  /* Monster can pass walls */
#define RF2_KILL_WALL      0x00080000  /* Monster can destroy walls */
#define RF2_XXX2           0x00100000  /* Was MOVE_BODY */
#define RF2_KILL_BODY      0x00200000  /* Monster can kill monsters */
#define RF2_TAKE_ITEM      0x00400000  /* Monster can pick up items */
#define RF2_KILL_ITEM      0x00800000  /* Monster can crush items */
#define RF2_FLYING         0x01000000  /* Monster can fly. */
#define RF2_LOW_MANA_RUN   0x02000000  /* Runs away/teleports when low on mana */
#define RF2_BRAIN_1        0x04000000  /* (?) */
#define RF2_POWERFUL       0x08000000  /* Breath loses less power with distance */
#define RF2_ARCHER         0x10000000  /* No 1_IN_X limits on missiles */
#define RF2_MORGUL_MAGIC   0x20000000  /* Some spells more necromantic */
#define RF2_UDUN_MAGIC     0x40000000  /* Some spells more hellish */
#define RF2_IMMUNE         0x80000000  /* Monster is immune when resistant */

/*
 * New monster race bit flags
 */
#define RF3_ORC            0x00000001  /* Orc */
#define RF3_TROLL          0x00000002  /* Troll */
#define RF3_GIANT          0x00000004  /* Giant */
#define RF3_DRAGON         0x00000008  /* Dragon */
#define RF3_DEMON          0x00000010  /* Demon */
#define RF3_UNDEAD         0x00000020  /* Undead */
#define RF3_EVIL           0x00000040  /* Evil */
#define RF3_ANIMAL         0x00000080  /* Animal */
#define RF3_RES_EDGED      0x00000100  /* Resists edged weapons */
#define RF3_RES_BLUNT      0x00000200  /* Resists blunt weapons */
#define RF3_IM_EDGED       0x00000400  /* Almost immune to edged weapons */
#define RF3_IM_BLUNT       0x00000800  /* Almost immune to blunt weapons */
#define RF3_HURT_LITE      0x00001000  /* Hurt by light */
#define RF3_HURT_ROCK      0x00002000  /* Hurt by rock remover */
#define RF3_HURT_FIRE      0x00004000  /* Hurt badly by fire */
#define RF3_HURT_COLD      0x00008000  /* Hurt badly by cold */
#define RF3_IM_ACID        0x00010000  /* Resist acid a lot */
#define RF3_IM_ELEC        0x00020000  /* Resist elec a lot */
#define RF3_IM_FIRE        0x00040000  /* Resist fire a lot */
#define RF3_IM_COLD        0x00080000  /* Resist cold a lot */
#define RF3_IM_POIS        0x00100000  /* Resist poison a lot */
#define RF3_RES_PLAS       0x00200000  /* Resist plasma */
#define RF3_RES_WATER      0x00400000  /* Resist water, move fast in water */
#define RF3_RES_NEXUS      0x00800000  /* Resist nexus */
#define RF3_RES_NETHR      0x01000000  /* Resist nether a lot */
#define RF3_RES_CHAOS      0x02000000  /* Resist chaos */
#define RF3_RES_DISEN      0x04000000  /* Resist disenchantment */
#define RF3_RES_TPORT      0x08000000  /* Resist teleportation */
#define RF3_NO_FEAR        0x10000000  /* Cannot be scared */
#define RF3_NO_STUN        0x20000000  /* Cannot be stunned */
#define RF3_NO_CONF        0x40000000  /* Cannot be confused */
#define RF3_NO_SLEEP       0x80000000  /* Cannot be slept (or slowed) */

/*
 * Monster racial flags - innate or physical ranged attacks
 */
#define RF4_SHRIEK         0x00000001  /* Shriek for help */
#define RF4_LASH           0x00000002  /* Use a melee attack at range 2 or 3 */
#define RF4_BOULDER        0x00000004  /* Throw a boulder */
#define RF4_SHOT           0x00000008  /* Fire sling shot */
#define RF4_ARROW          0x00000010  /* Fire arrows */
#define RF4_BOLT           0x00000020  /* Fire crossbow quarrels */
#define RF4_MISSL          0x00000040  /* Fire other physical missiles */
#define RF4_PMISSL         0x00000080  /* Fire poisoned missiles */
#define RF4_BRTH_ACID      0x00000100  /* Breathe Acid */
#define RF4_BRTH_ELEC      0x00000200  /* Breathe Elec */
#define RF4_BRTH_FIRE      0x00000400  /* Breathe Fire */
#define RF4_BRTH_COLD      0x00000800  /* Breathe Cold */
#define RF4_BRTH_POIS      0x00001000  /* Breathe Poison */
#define RF4_BRTH_PLAS      0x00002000  /* Breathe Plasma */
#define RF4_BRTH_LITE      0x00004000  /* Breathe Light */
#define RF4_BRTH_DARK      0x00008000  /* Breathe Dark */
#define RF4_BRTH_CONFU     0x00010000  /* Breathe Confusion */
#define RF4_BRTH_SOUND     0x00020000  /* Breathe Sound */
#define RF4_BRTH_SHARD     0x00040000  /* Breathe Shards */
#define RF4_BRTH_INER      0x00080000  /* Breathe Inertia */
#define RF4_BRTH_GRAV      0x00100000  /* Breathe Gravity */
#define RF4_BRTH_WIND      0x00200000  /* Breathe Wind */
#define RF4_BRTH_FORCE     0x00400000  /* Breathe Force */
#define RF4_BRTH_NEXUS     0x00800000  /* Breathe Nexus */
#define RF4_BRTH_NETHR     0x01000000  /* Breathe Nether */
#define RF4_BRTH_CHAOS     0x02000000  /* Breathe Chaos */
#define RF4_BRTH_DISEN     0x04000000  /* Breathe Disenchant */
#define RF4_BRTH_TIME      0x08000000  /* Breathe Time */
#define RF4_BRTH_MANA      0x10000000  /* Breathe Mana */
#define RF4_XXX1           0x20000000  /*  */
#define RF4_XXX2           0x40000000  /*  */
#define RF4_XXX3           0x80000000  /*  */

/*
 * Monster racial flags - defined-area projection spells
 */
#define RF5_BALL_ACID      0x00000001  /* Acid Ball -> Acid Storm */
#define RF5_BALL_ELEC      0x00000002  /* Elec Ball -> Elec Storm */
#define RF5_BALL_FIRE      0x00000004  /* Fire Ball -> Fire Storm */
#define RF5_BALL_COLD      0x00000008  /* Cold Ball -> Cold Storm */
#define RF5_BALL_POIS      0x00000010  /* Stinking Cloud -> Poison Storm */
#define RF5_BALL_LITE      0x00000020  /* Light Ball / Starburst */
#define RF5_BALL_DARK      0x00000040  /* Darkness Ball -> Dark Storm */
#define RF5_BALL_CONFU     0x00000080  /* Confusion Ball -> Conf Storm */
#define RF5_BALL_SOUND     0x00000100  /* Sound Ball -> Sound Storm */
#define RF5_BALL_SHARD     0x00000200  /* Shard Ball -> Shard Storm */
#define RF5_BALL_WIND      0x00000400  /* Wind Ball -> Cyclone */
#define RF5_BALL_STORM     0x00000800  /* Storm Ball -> Tempest */
#define RF5_BALL_NETHR     0x00001000  /* Nether Ball -> Nether Storm */
#define RF5_BALL_CHAOS     0x00002000  /* Chaos Ball -> Chaos Storm */
#define RF5_BALL_MANA      0x00004000  /* Mana Ball -> Mana Storm */
#define RF5_XXX1           0x00008000  /*  */
#define RF5_BOLT_ACID      0x00010000  /* Acid Bolt */
#define RF5_BOLT_ELEC      0x00020000  /* Elec Bolt */
#define RF5_BOLT_FIRE      0x00040000  /* Fire Bolt */
#define RF5_BOLT_COLD      0x00080000  /* Cold Bolt */
#define RF5_BOLT_POIS      0x00100000  /* Poison Bolt */
#define RF5_BOLT_PLAS      0x00200000  /* Plasma Bolt */
#define RF5_BOLT_ICE       0x00400000  /* Ice Bolt */
#define RF5_BOLT_WATER     0x00800000  /* Water Bolt */
#define RF5_BOLT_NETHR     0x01000000  /* Nether Bolt */
#define RF5_BOLT_MANA      0x02000000  /* Magic Missile -> Mana Bolt */
#define RF5_XXX3           0x04000000  /*  */
#define RF5_BEAM_ELEC      0x08000000  /* Electric spark */
#define RF5_BEAM_ICE       0x10000000  /* Ice Lance */
#define RF5_BEAM_NETHR     0x20000000  /* Spear of Nether */
#define RF5_ARC__HFIRE     0x40000000  /* Arc/Column of hellfire */
#define RF5_ARC__FORCE     0x80000000  /* Arc of force */

/*
 * Monster racial flags - help self, hinder character, and special magics
 */
#define RF6_HASTE          0x00000001  /* Speed self */
#define RF6_ADD_MANA       0x00000002  /* Regain Mana */
#define RF6_HEAL           0x00000004  /* Heal self */
#define RF6_CURE           0x00000008  /* Cure self */
#define RF6_BLINK          0x00000010  /* Teleport Short */
#define RF6_TPORT          0x00000020  /* Teleport Long */
#define RF6_XXX1           0x00000040  /* (effect-self) */
#define RF6_TELE_SELF_TO   0x00000080  /* (effect-self) */
#define RF6_TELE_TO        0x00000100  /* Move character to monster */
#define RF6_TELE_AWAY      0x00000200  /* Move character far away */
#define RF6_TELE_LEVEL     0x00000400  /* Move character vertically */
#define RF6_XXX3           0x00000800  /* (effect-character) */
#define RF6_DARKNESS       0x00001000  /* Create Darkness */
#define RF6_TRAPS          0x00002000  /* Create Traps */
#define RF6_FORGET         0x00004000  /* Cause amnesia */
#define RF6_DRAIN_MANA     0x00008000  /* Drain Mana */
#define RF6_XXX4           0x00010000  /* (effect-character) */
#define RF6_CURSE          0x00020000  /* Curse the character */
#define RF6_MIND_BLAST     0x00040000  /* Blast Mind --> Brain Smash */
#define RF6_XXX7           0x00080000  /* (effect-character) */
#define RF6_WOUND          0x00100000  /* Cause Wounds */
#define RF6_HELLDARK       0x00200000  /* Call hellish darkness */
#define RF6_HOLY_SMITE     0x00400000  /* Call down a holy orb */
#define RF6_XXX8           0x00800000  /* (effect-character) */
#define RF6_XX9            0x01000000  /* (effect-character) */
#define RF6_HUNGER         0x02000000  /* Make character Hungry */
#define RF6_XX11           0x04000000  /* (effect-character) */
#define RF6_SCARE          0x08000000  /* Frighten character */
#define RF6_BLIND          0x10000000  /* Blind character */
#define RF6_CONF           0x20000000  /* Confuse character */
#define RF6_SLOW           0x40000000  /* Slow character */
#define RF6_HOLD           0x80000000  /* Paralyze character */


/*
 * Monster racial flags - summons
 */
#define RF7_S_KIN          0x00000001  /* Summon Similar */
#define RF7_XXX1           0x00000002  /*  */
#define RF7_XXX2           0x00000004  /*  */
#define RF7_S_MONSTER      0x00000008  /* Summon Monster */
#define RF7_S_MONSTERS     0x00000010  /* Summon Monsters */
#define RF7_XXX3           0x00000020  /*  */
#define RF7_XXX4           0x00000040  /*  */
#define RF7_S_BEETLE       0x00000080  /* Summon Giant Beetle */
#define RF7_S_ANT          0x00000100  /* Summon Ants */
#define RF7_S_SPIDER       0x00000200  /* Summon Spiders */
#define RF7_S_HOUND        0x00000400  /* Summon Hounds */
#define RF7_S_ANIMAL       0x00000800  /* Summon Animals */
#define RF7_XXX6           0x00001000  /*  */
#define RF7_XXX7           0x00002000  /*  */
#define RF7_S_THIEF        0x00004000  /* Summon Thieves */
#define RF7_S_BERTBILLTOM  0x00008000  /* Summon Bert, Bill, and Tom */
#define RF7_S_ORC          0x00010000  /* Summon Orc (at a distance) */
#define RF7_S_ANGEL        0x00020000  /* Summon Angel */
#define RF7_XX10           0x00040000  /*  */
#define RF7_XX11           0x00080000  /*  */
#define RF7_S_DRAGON       0x00100000  /* Summon Dragon */
#define RF7_S_HI_DRAGON    0x00200000  /* Summon Ancient Dragons */
#define RF7_XX12           0x00400000  /*  */
#define RF7_XX13           0x00800000  /*  */
#define RF7_S_DEMON        0x01000000  /* Summon Demon(s) */
#define RF7_S_HI_DEMON     0x02000000  /* Summon Greater Demons */
#define RF7_XX14           0x04000000  /*  */
#define RF7_XX15           0x08000000  /*  */
#define RF7_S_UNDEAD       0x10000000  /* Summon Undead */
#define RF7_S_HI_UNDEAD    0x20000000  /* Summon Greater Undead */
#define RF7_S_WRAITH       0x40000000  /* Summon Unique Wraith */
#define RF7_S_UNIQUE       0x80000000  /* Summon Unique Monster */


/*
 * Some flags are obvious
 */
#define RF1_OBVIOUS_MASK \
	(RF1_UNIQUE | RF1_QUESTOR | RF1_MALE | RF1_FEMALE | \
	 RF1_FRIEND | RF1_FRIENDS | RF1_ESCORT | RF1_ESCORTS)

/*
 * "race" flags
 */
#define RF3_RACE_MASK \
	(RF3_ORC | RF3_TROLL | RF3_GIANT | RF3_DRAGON | \
	 RF3_DEMON | RF3_UNDEAD | RF3_EVIL | RF3_ANIMAL)



/*
 * Special monster lore flags.
 */
#define LORE_KNOWN_DEPTH    0x01





/*
 * Hack -- Bit masks to control what spells are considered
 */


/*
 * Attack spells.
 * Need special treatment in movement AI.
 */
#define RF4_ATTACK_MASK \
        (RF4_BOULDER | RF4_SHOT | RF4_ARROW | RF4_BOLT | RF4_MISSL | RF4_PMISSL)

#define RF5_ATTACK_MASK \
	(RF5_BALL_ACID | RF5_BALL_ELEC | RF5_BALL_FIRE | RF5_BALL_COLD | RF5_BALL_POIS | RF5_BALL_LITE | RF5_BALL_DARK | RF5_BALL_CONFU | RF5_BALL_SOUND | RF5_BALL_SHARD | RF5_BALL_STORM | RF5_BALL_NETHR | RF5_BALL_CHAOS | RF5_BALL_MANA | RF5_BOLT_ACID | RF5_BOLT_ELEC | RF5_BOLT_FIRE | RF5_BOLT_COLD | RF5_BOLT_POIS | RF5_BOLT_PLAS | RF5_BOLT_ICE | RF5_BOLT_WATER | RF5_BOLT_NETHR | RF5_BOLT_MANA | RF5_BEAM_ELEC | RF5_BEAM_ICE | RF5_BEAM_NETHR | RF5_ARC__FORCE | RF5_ARC__HFIRE)

#define RF6_ATTACK_MASK \
	(RF6_WOUND)

#define RF7_ATTACK_MASK \
	(0L)


/*
 * Breath attacks.
 * Need special treatment in movement AI.
 */
#define RF4_BREATH_MASK \
        (RF4_BRTH_ACID | RF4_BRTH_ELEC | RF4_BRTH_FIRE | RF4_BRTH_COLD | \
         RF4_BRTH_POIS | RF4_BRTH_PLAS | RF4_BRTH_LITE | RF4_BRTH_DARK | \
         RF4_BRTH_CONFU | RF4_BRTH_SOUND | RF4_BRTH_SHARD | RF4_BRTH_INER | \
         RF4_BRTH_GRAV | RF4_BRTH_FORCE | RF4_BRTH_NEXUS | RF4_BRTH_NETHR | \
         RF4_BRTH_CHAOS | RF4_BRTH_DISEN | RF4_BRTH_TIME | RF4_BRTH_WIND | \
         RF4_BRTH_MANA)

#define RF5_BREATH_MASK \
	(0L)

#define RF6_BREATH_MASK \
	(0L)

#define RF7_BREATH_MASK \
	(0L)

/*
 * Harassment (not direct damage) attacks.
 * Need special treatment in AI.
 */
#define RF4_HARASS_MASK \
        (RF4_SHRIEK)

#define RF5_HARASS_MASK \
	(0L)

#define RF6_HARASS_MASK \
	(RF6_DARKNESS | RF6_TRAPS | RF6_FORGET | RF6_HUNGER | RF6_DRAIN_MANA | \
         RF6_SCARE | RF6_BLIND | RF6_CONF | RF6_SLOW | RF6_HOLD)

#define RF7_HARASS_MASK \
	(0L)

/* Number of times harassment spells get special treatment */
#define BASE_HARASS 4
#define LOW_HARASS 2

/*
 * Hack -- "bolt" spells that may hurt fellow monsters
 * Need special treatment in AI.
 */
#define RF4_BOLT_MASK \
        (RF4_ARROW | RF4_BOLT | RF4_SHOT | RF4_MISSL | RF4_PMISSL | RF4_BOULDER)

#define RF5_BOLT_MASK \
	(RF5_BOLT_ACID | RF5_BOLT_ELEC | RF5_BOLT_FIRE | RF5_BOLT_COLD | \
	 RF5_BOLT_POIS | RF5_BOLT_NETHR | RF5_BOLT_WATER | RF5_BOLT_MANA | \
	 RF5_BOLT_PLAS | RF5_BOLT_ICE)

#define RF6_BOLT_MASK \
   0L


#define RF7_BOLT_MASK \
   0L

/*
 * Archery attacks
 * Need special treatment in AI.
 */
#define RF4_ARCHERY_MASK \
        (RF4_ARROW | RF4_BOLT | RF4_SHOT | RF4_MISSL | RF4_PMISSL | RF4_BOULDER)

#define RF5_ARCHERY_MASK \
	(0L)

#define RF6_ARCHERY_MASK \
	(0L)

#define RF7_ARCHERY_MASK \
	(0L)

/*
 * Spells that can be can cast without a character in sight
 * Need special treatment in AI.
 */
#define RF4_NO_PLAYER_MASK \
        (0L)

#define RF5_NO_PLAYER_MASK \
        (0L)

#define RF6_NO_PLAYER_MASK \
        (RF6_HEAL | RF6_ADD_MANA | RF6_TELE_SELF_TO | RF6_CURE)

#define RF7_NO_PLAYER_MASK \
        (0L)


/*
 * Spells that increase in range with level.
 */
#define RF4_ADD_RANGE \
	(RF4_BOULDER | RF4_SHOT | RF4_ARROW | RF4_BOLT | RF4_MISSL | RF4_PMISSL)






/* Spell Desire Table Columns */
#define D_BASE     0
#define D_SUMM     1
#define D_HURT     2
#define D_MANA     3
#define D_ESC      4
#define D_TACT     5
#define D_RES      6
#define D_RANGE    7


/*
 * Monsters will run up to 25 grids away
 */
#define FLEE_RANGE      MAX_SIGHT + 5

/*
 * Hack -- Panicked monsters will run far, far away
 */
#define PANIC_RANGE      100



/*** Option Definitions ***/


/*
 * Option indexes (offsets)
 *
 * These values are hard-coded by savefiles (and various pieces of code).
 */
#define OPT_BIRTH             100
#define OPT_MAX               110
#define OPT_PER_PAGE           20


/*
 * Option indexes (normal)
 *
 * These values are hard-coded by savefiles.
 */

	/* Game behavior */
#define OPT_rogue_like_commands             0
#define OPT_verify_destroy                  1

#define OPT_always_pickup                   3
#define OPT_query_floor                     4
#define OPT_never_haggle                    5
#define OPT_use_old_target                  6
#define OPT_run_ignore_stairs               7
#define OPT_run_ignore_doors                8
#define OPT_run_cut_corners                 9
#define OPT_xchars_to_file                 10
#define OPT_stack_force_notes              11
#define OPT_stack_force_costs              12
#define OPT_allow_quantity                 13
#define OPT_change_save_names              14


	/* Disturbance and warning */
#define OPT_disturb_move                   20

#define OPT_disturb_panel                  22
#define OPT_disturb_state                  23
#define OPT_disturb_minor                  24
#define OPT_alert_hitpoint                 25

#define OPT_ring_bell                      27
#define OPT_quick_messages                 28
#define OPT_compress_messages              29
#define OPT_flush_failure                  30
#define OPT_flush_disturb                  31
#define OPT_delay_failure                  32

#define OPT_colored_hit_msg                36
#define OPT_colored_hurt_char              37


	/* Visual Interface */

#define OPT_remember_seen_grids            41
#define OPT_torch_light                    42
#define OPT_sight_light                    43
#define OPT_wall_lighting                  44
#define OPT_floor_lighting                 45
#define OPT_highlight_player               46
#define OPT_fresh_after                    47
#define OPT_traps_display_on_top           48
#define OPT_depth_in_feet                  49
#define OPT_show_labels                    50
#define OPT_show_weights                   51
#define OPT_show_flavors                   52
#define OPT_use_metric                     53
#define OPT_always_show_list               54
#define OPT_message_to_window              55


	/* Blank space for another page of options here */


	/* Difficulty and cheating options (all are cleared for new characters) */
#define OPT_CHEAT_HEADER                   90
#define OPT_cheat_know                     93
#define OPT_beginner_play                  94


	/* Birth options (appear only on the character birth screen) */

#define OPT_birth_autoroll                 101
#define OPT_ironman_play                   102
#define OPT_birth_no_stores                103
#define OPT_birth_no_artifacts             104
#define OPT_birth_no_return_stair          105
#define OPT_birth_smart_cheat              106



/*
 * Information for "do_cmd_options()".
 *
 * There are five pages of options,
 * each with up to twenty options.
 */
#define OPT_PAGE_MAX				5
#define OPT_PAGE_PER				20


/*
 * Hack -- Option symbols
 */

	/* Game behavior */
#define rogue_like_commands         op_ptr->opt[OPT_rogue_like_commands]
#define verify_destroy              op_ptr->opt[OPT_verify_destroy]

#define always_pickup               op_ptr->opt[OPT_always_pickup]
#define query_floor                 op_ptr->opt[OPT_query_floor]
#define never_haggle                op_ptr->opt[OPT_never_haggle]
#define use_old_target              op_ptr->opt[OPT_use_old_target]
#define run_ignore_stairs           op_ptr->opt[OPT_run_ignore_stairs]
#define run_ignore_doors            op_ptr->opt[OPT_run_ignore_doors]
#define run_cut_corners             op_ptr->opt[OPT_run_cut_corners]
#define xchars_to_file              op_ptr->opt[OPT_xchars_to_file]
#define stack_force_notes           op_ptr->opt[OPT_stack_force_notes]
#define stack_force_costs           op_ptr->opt[OPT_stack_force_costs]
#define allow_quantity              op_ptr->opt[OPT_allow_quantity]
#define change_save_names           op_ptr->opt[OPT_change_save_names]

	/* Disturbance and Warning */
#define disturb_move                op_ptr->opt[OPT_disturb_move]

#define disturb_panel               op_ptr->opt[OPT_disturb_panel]
#define disturb_state               op_ptr->opt[OPT_disturb_state]
#define disturb_minor               op_ptr->opt[OPT_disturb_minor]
#define alert_hitpoint              op_ptr->opt[OPT_alert_hitpoint]

#define ring_bell                   op_ptr->opt[OPT_ring_bell]
#define quick_messages              op_ptr->opt[OPT_quick_messages]
#define compress_messages           op_ptr->opt[OPT_compress_messages]
#define flush_failure               op_ptr->opt[OPT_flush_failure]
#define flush_disturb               op_ptr->opt[OPT_flush_disturb]
#define delay_failure               op_ptr->opt[OPT_delay_failure]

#define colored_hit_msg             op_ptr->opt[OPT_colored_hit_msg]
#define colored_hurt_char           op_ptr->opt[OPT_colored_hurt_char]


	/* Visual Interface */

#define remember_seen_grids         op_ptr->opt[OPT_remember_seen_grids]
#define torch_light                 op_ptr->opt[OPT_torch_light]
#define sight_light                 op_ptr->opt[OPT_sight_light]
#define wall_lighting                  op_ptr->opt[OPT_wall_lighting]
#define floor_lighting                 op_ptr->opt[OPT_floor_lighting]
#define highlight_player            op_ptr->opt[OPT_highlight_player]
#define fresh_after                 op_ptr->opt[OPT_fresh_after]
#define traps_display_on_top        op_ptr->opt[OPT_traps_display_on_top]
#define center_player               op_ptr->opt[OPT_center_player]
#define depth_in_feet               op_ptr->opt[OPT_depth_in_feet]
#define show_labels                 op_ptr->opt[OPT_show_labels]
#define show_weights                op_ptr->opt[OPT_show_weights]
#define show_flavors                op_ptr->opt[OPT_show_flavors]
#define use_metric                  op_ptr->opt[OPT_use_metric]
#define always_show_list            op_ptr->opt[OPT_always_show_list]
#define message_to_window           op_ptr->opt[OPT_message_to_window]


	/* Difficulty options */


	/* Assistance/Cheating options */
#define cheat_know                  op_ptr->opt[OPT_cheat_know]
#define beginner_play               op_ptr->opt[OPT_beginner_play]


	/* Birth options */
#define birth_autoroll              op_ptr->opt[OPT_birth_autoroll]
#define ironman_play                op_ptr->opt[OPT_ironman_play]
#define birth_no_stores             op_ptr->opt[OPT_birth_no_stores]
#define birth_no_artifacts          op_ptr->opt[OPT_birth_no_artifacts]
#define birth_no_return_stair       op_ptr->opt[OPT_birth_no_return_stair]
#define birth_smart_cheat           op_ptr->opt[OPT_birth_smart_cheat]



/*
 * Definitions for various kinds of cheats, autoplay, and debugging.
 */
#define CHEAT_DEATH                 0x0001
#define CHEAT_WIZARD                0x0002
#define CHEAT_DEBUG                 0x0004
#define CHEAT_BORG                  0x0008
#define CHEAT_PEEK                  0x0100
#define CHEAT_HEAR                  0x0200
#define CHEAT_ROOM                  0x0400

#define cheat_death                 (p_ptr->noscore & (CHEAT_DEATH))
#define cheat_wizard                (p_ptr->noscore & (CHEAT_WIZARD))
#define cheat_debug                 (p_ptr->noscore & (CHEAT_DEBUG))
#define cheat_borg                  (p_ptr->noscore & (CHEAT_BORG))
#define cheat_peek                  (p_ptr->noscore & (CHEAT_PEEK))
#define cheat_hear                  (p_ptr->noscore & (CHEAT_HEAR))
#define cheat_room                  (p_ptr->noscore & (CHEAT_ROOM))




/*** Macro Definitions ***/

/*
 * Hack -- The main "screen"
 */
#define term_screen	(angband_term[0])




/*
 * Character macros
 */

/*
 * Attempts a saving throw with a difficulty of "roll".  -BR-
 */
#define check_save(R) \
	(rand_int(R) < p_ptr->skill_sav)

/*
 * Return the skill index of the better of two skills.  -JM-
 */
#define better_skill(S,T) \
	(get_skill(S,0,100)>get_skill(T,0,100))?(S):(T)




/*
 * Monster macros
 */

/*
 * Determine if a given monster is "non-living"
 *
 * Neither demons nor undead are alive.  Neither vortexes nor elementals
 * are alive.  Storms and events are not alive.  Creatures of earth that
 * are not alive use the symbol '#'; those that are use 'X'.
 *
 * An armour or weapon mimic is assumed to be "animated", and therefore
 * not alive.  All other mimics are "mimics", living creatures that look
 * like something non-living.
 */
#define monster_nonliving(M) \
	(((M)->flags3 & (RF3_DEMON))  || \
	 ((M)->flags3 & (RF3_UNDEAD)) || \
	 (strchr("Ev*g$+#|\\/][}{", (M)->d_char)))


/*
 * Determine if a given monster is "immaterial".
 *
 * If it passes through walls, it can qualify.  However, many monsters
 * (like various dragons) do not qualify and need to be special-cased out.
 * This is a bit of a hack -- we might use a flag at some point.
 *
 * Vortexes and storms also qualify.
 */
 #define monster_immaterial(M) \
	((((M)->flags2 & (RF2_PASS_WALL)) && \
	 (!strchr("adDEX.", (M)->d_char))) || \
     (strchr("v*", (M)->d_char)))


/*
 * Determine if the monster is fully visible.
 */
#define mon_fully_visible(M) \
	(((M)->ml >= ML_FULL) && !((M)->mflag & (MFLAG_MIME)))


/*
 * Determine if the monster is wary of stealing and traps.
 */
#define monster_wary(M) \
	((M)->mflag & (MFLAG_WARY))


/*
 * Make a monster wary.
 */
#define mon_make_wary(M) \
	((M)->mflag |= (MFLAG_WARY))


/*
 * Describe the death of a monster
 */
#define death_string(R) \
	(((R)->flags1 & (RF1_UNIQUE)) ? " is slain!" : \
	 (monster_nonliving((R))) ? " is destroyed." : " dies.")




/*
 * Object macros
 */


/*
 * Determine if a given inventory item is "aware"
 */
#define object_aware_p(T) \
	(k_info[(T)->k_idx].special & (SPECIAL_AWARE))

/*
 * Determine if a given inventory item is "tried"
 */
#define object_tried_p(T) \
	(k_info[(T)->k_idx].special & (SPECIAL_TRIED))


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware"
 */
#define object_known_p(T) \
	(((T)->ident & (IDENT_KNOWN)) || \
	 ((k_info[(T)->k_idx].flags3 & (TR3_EASY_KNOW)) && \
	  (k_info[(T)->k_idx].special & (SPECIAL_AWARE))))


/*
 * Artifacts use the "artifact_index" field
 */
#define artifact_p(T) \
	((T)->artifact_index ? TRUE : FALSE)

/*
 * Ego-Items use the "ego_item_index" field
 */
#define ego_item_p(T) \
	((T)->ego_item_index ? TRUE : FALSE)


/*
 * Items with a value of zero.
 */
#define broken_p(T) \
	((T)->b_cost <= 0L)

/*
 * Cursed items that "cling" and are inscribed "cursed".
 */
#define cursed_cling(T) \
	((T)->ident & (IDENT_CURSED))

/*
 * Cursed items (whether clinging or not).
 */
#define cursed_p(T) \
	((T)->flags3 & (TR3_LIGHT_CURSE))



/*
 * Object is a melee weapon
 */
#define is_melee_weapon(T) \
	(((T)->tval == TV_SWORD)   || \
	 ((T)->tval == TV_HAFTED)  || \
	 ((T)->tval == TV_POLEARM) || \
	 ((T)->tval == TV_DIGGING))

/*
 * Object is a missile weapon
 */
#define is_missile_weapon(T) \
	(((T)->tval == TV_SLING) || \
	 ((T)->tval == TV_BOW) || \
	 ((T)->tval == TV_CROSSBOW))

/*
 * Object is any weapon
 */
#define is_any_weapon(T) \
	(((T)->tval == TV_SWORD)   || \
	 ((T)->tval == TV_HAFTED)  || \
	 ((T)->tval == TV_POLEARM) || \
	 ((T)->tval == TV_DIGGING) || \
	 ((T)->tval == TV_SLING) || \
	 ((T)->tval == TV_BOW) || \
	 ((T)->tval == TV_CROSSBOW))

/*
 * Object is a missile
 */
#define is_missile(T) \
	(((T)->tval == TV_SHOT)   || \
	 ((T)->tval == TV_ARROW)  || \
	 ((T)->tval == TV_BOLT))


/*
 * Object is any armour
 */
#define is_any_armour(T) \
	(((T)->tval == TV_BOOTS)      || \
	 ((T)->tval == TV_GLOVES)     || \
	 ((T)->tval == TV_HELM)       || \
	 ((T)->tval == TV_CROWN)      || \
	 ((T)->tval == TV_SHIELD)     || \
	 ((T)->tval == TV_CLOAK)      || \
	 ((T)->tval == TV_SOFT_ARMOR) || \
	 ((T)->tval == TV_HARD_ARMOR) || \
	 ((T)->tval == TV_DRAG_ARMOR))

/*
 * Object is body armour
 */
#define is_body_armour(T) \
	(((T)->tval == TV_SOFT_ARMOR) || \
	 ((T)->tval == TV_HARD_ARMOR) || \
	 ((T)->tval == TV_DRAG_ARMOR))

/*
 * Object is wargear
 */
#define is_wargear(T) \
	(is_any_armour(T) || is_any_weapon(T) || is_missile(T))

/*
 * Object is wearable
 */
#define is_wearable(T) \
	(is_any_armour(T) || is_any_weapon(T) || is_missile(T) || \
	 ((T)->tval == TV_RING) || ((T)->tval == TV_AMULET) || \
	 ((T)->tval == TV_LITE))

/*
 * Object is a magical device
 */
#define is_magical_device(T) \
	(((T)->tval == TV_WAND)      || \
	 ((T)->tval == TV_STAFF)     || \
	 ((T)->tval == TV_ROD))

/*
 * Object is a magic book
 */
#define is_magic_book(T) \
	(((T)->tval == TV_MAGIC_BOOK)      || \
	 ((T)->tval == TV_PRAYER_BOOK)     || \
	 ((T)->tval == TV_NATURE_BOOK)     || \
	 ((T)->tval == TV_DARK_BOOK))

/*
 * Given an index "item", get an object.
 */
#define item_to_object(T, I) \
	if (I >= 0) T = &inventory[I]; \
	else        T = &o_list[0 - I]



/*
 * Return the "attr" for a given object.
 *
 * Use any special stored color, if available.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_attr(T) \
	((T)->marked >= COLORED_OBJ_MIN ? \
	 (T)->marked - COLORED_OBJ_MIN : (k_info[(T)->k_idx].flavor) ? \
	 (flavor_info[k_info[(T)->k_idx].flavor].x_attr) : \
	 (k_info[(T)->k_idx].x_attr))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (flavor_info[k_info[(T)->k_idx].flavor].x_char) : \
	 (k_info[(T)->k_idx].x_char))


/*
 * Visual and location macros
 */


/*
 * Convert an "attr"/"char" pair into a "pict" (P)
 */
#define PICT(A,C) \
	((((u16b)(A)) << 8) | ((byte)(C)))

/*
 * Convert a "pict" (P) into an "attr" (A)
 */
#define PICT_A(P) \
	((byte)((P) >> 8))

/*
 * Convert a "pict" (P) into an "char" (C)
 */
#define PICT_C(P) \
	((char)((byte)(P)))


/*
 * Convert a "location" (Y,X) into a "grid" (G)
 */
#define GRID(Y,X) \
	(256 * (Y) + (X))

/*
 * Convert a "grid" (G) into a "location" (Y)
 */
#define GRID_Y(G) \
	((int)((G) / 256U))

/*
 * Convert a "grid" (G) into a "location" (X)
 */
#define GRID_X(G) \
	((u16b)((G) % 256U))


/*
 * Determines if a map location is "meaningful"
 */
#define in_bounds(Y,X) \
	(((unsigned)(Y) < (unsigned)(dungeon_hgt)) && \
	 ((unsigned)(X) < (unsigned)(dungeon_wid)))

/*
 * Determines if a map location is fully inside the outer walls
 * This is more than twice as expensive as "in_bounds()", but
 * often we need to exclude the outer walls from calculations.
 */
#define in_bounds_fully(Y,X) \
	(((Y) > 0) && ((Y) < dungeon_hgt-1) && \
	 ((X) > 0) && ((X) < dungeon_wid-1))


/*
 * Determines if a map location is currently "on screen"
 * Note that "panel_contains(Y,X)" always implies "in_bounds(Y,X)".
 * Pre-storing this into a cave_info flag would be nice.  XXX XXX
 */
#define panel_contains(Y,X) \
	(((unsigned)((Y) - p_ptr->wy) < (unsigned)(map_rows)) && \
	 ((unsigned)((X) - p_ptr->wx) < (unsigned)(SCREEN_WID)))



/*
 * Terrain macros
 */

/*
 * Determine if grid allows line of sight through it.
 */
#define cave_los_bold(Y,X) \
	(cave_info[Y][X] & (CAVE_LOS))


/*
 * Determine if grid allows projections to pass through it.
 */
#define cave_project_bold(Y,X) \
	(f_info[cave_feat[Y][X]].flags & (TF_PROJECT))

/*
 * Determine if grid is clear, open, and "floor-like".
 */
#define cave_floor_bold(Y,X) \
	(f_info[cave_feat[Y][X]].flags & (TF_FLOOR))

/*
 * Determine if grid can hold objects.
 */
#define cave_allow_object_bold(Y,X) \
	(f_info[cave_feat[Y][X]].flags & (TF_OBJECT))

/*
 * Determine if a "legal" grid is able to be passed through by creatures
 * that cannot bore or pass through walls.  Also allows sound and various
 * other things.
 */
#define cave_passable_bold(Y,X) \
	(f_info[cave_feat[Y][X]].flags & (TF_PASSABLE))


/*
 * Determine if a "legal" grid is a "clean" floor grid
 * (used to place stairs)
 *
 * Line 1 -- require floors
 * Line 2 -- require lack of objects
 */
#define cave_clean_bold(Y,X) \
	((f_info[cave_feat[Y][X]].flags & (TF_FLOOR)) && \
	 (cave_o_idx[Y][X] == 0))

/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- require floors
 * Line 2 -- require lack of players/monsters
 */
#define cave_empty_bold(Y,X) \
	((f_info[cave_feat[Y][X]].flags & (TF_FLOOR)) && \
  	(cave_m_idx[Y][X] == 0))

/*
 * Determine if a "legal" grid is a "naked" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid objects
 * Line 3 -- forbid player/monsters
 */
#define cave_naked_bold(Y,X) \
	((f_info[cave_feat[Y][X]].flags & (TF_FLOOR)) && \
	 (cave_o_idx[Y][X] == 0) && \
	 (cave_m_idx[Y][X] == 0))

/*
 * Determine if a grid is a "shop"
 */
#define cave_shop_bold(Y,X) \
	 (f_info[cave_feat[Y][X]].flags & (TF_SHOP))

/*
 * Determine if a grid is a "wall"
 */
#define cave_wall_bold(Y,X) \
	 (f_info[cave_feat[Y][X]].flags & (TF_WALL))

/*
 * Determine if a grid is "permanent"
 */
#define cave_perma_bold(Y,X) \
	(f_info[cave_feat[Y][X]].flags & (TF_PERMANENT))

/*
 * Determine if a grid is a permanent wall.
 */
#define cave_permwall(Y,X) \
	((f_info[cave_feat[Y][X]].flags & (TF_PERMANENT)) && \
	 (f_info[cave_feat[Y][X]].flags & (TF_WALL)))


/*
 * Determine if a grid is rocky (can be tunneled or magically removed).
 */
#define cave_rock_bold(Y,X) \
   (f_info[cave_feat[Y][X]].flags & (TF_ROCK))

/*
 * Determine if a grid is granite.
 */
#define cave_granite_bold(Y,X) \
   (f_info[cave_feat[Y][X]].flags & (TF_GRANITE))


/*
 * Determine if a grid is a closed door.
 * Open or broken doors don't count.
 */
#define cave_closed_door(Y,X) \
   (f_info[cave_feat[Y][X]].flags & (TF_DOOR_CLOSED))


/*
 * Determine if a grid is any door.
 */
#define cave_any_door(Y,X) \
   (f_info[cave_feat[Y][X]].flags & (TF_DOOR_ANY))

/*
 * Determine if a grid contains a secret door
 */
#define cave_secret_door(Y,X) \
   ((cave_feat[Y][X] == FEAT_SECRET))

/*
 * Determine if a grid is marked as having traps in it.
 */
#define cave_trap(Y,X) \
 (cave_info[Y][X] & (CAVE_TRAP))

/*
 * Determine if a grid is an up stairs.
 */
#define cave_up_stairs(Y,X) \
   ((cave_feat[Y][X] == FEAT_LESS2) || \
    (cave_feat[Y][X] == FEAT_LESS))

/*
 * Determine if a grid is a down stairs.
 */
#define cave_down_stairs(Y,X) \
   ((cave_feat[Y][X] == FEAT_MORE2) || \
    (cave_feat[Y][X] == FEAT_MORE))

/*
 * Determine if a grid is any stairs
 */
#define cave_any_stairs(Y,X) \
   ((cave_feat[Y][X] == FEAT_LESS2) || \
    (cave_feat[Y][X] == FEAT_LESS) || \
    (cave_feat[Y][X] == FEAT_MORE2) || \
    (cave_feat[Y][X] == FEAT_MORE))



/*
 * Determine if a "legal" grid is within line of sight of the character
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(Y,X) \
	((cave_info[Y][X] & (CAVE_VIEW)) != 0)


/*
 * Determine if a "legal" grid can be seen directly by the character
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_can_see_bold(Y,X) \
	((cave_info[Y][X] & (CAVE_SEEN)) != 0)

/*
 * Determine if a "legal" grid is within line of fire of the character
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_can_fire_bold(Y,X) \
	((cave_info[Y][X] & (CAVE_FIRE)) != 0)



/*** Dungeon environment conditions (p_ptr->dungeon_flags) ***/

/*
 * Use character bitflags to control the way the current dungeon looks and
 * behaves.
 */
#define DUNGEON_NO_SPECIAL_LIGHTING     0x00000001  /* No special lighting */
/* xxx (many) */




/*** Color constants ***/


/*
 * Angband "attributes" (with symbols)
 */
#define TERM_DARK        0	/* 'd' */
#define TERM_WHITE       1	/* 'w' */
#define TERM_SLATE       2	/* 's' */
#define TERM_ORANGE      3	/* 'o' */
#define TERM_RED         4	/* 'r' */
#define TERM_GREEN       5	/* 'g' */
#define TERM_BLUE        6	/* 'b' */
#define TERM_UMBER       7	/* 'u' */
#define TERM_L_DARK      8	/* 'D' */
#define TERM_L_WHITE     9	/* 'W' */
#define TERM_L_PURPLE   10	/* 'P' */
#define TERM_YELLOW     11	/* 'y' */
#define TERM_L_RED      12	/* 'R' */
#define TERM_L_GREEN    13	/* 'G' */
#define TERM_L_BLUE     14	/* 'B' */
#define TERM_L_UMBER    15	/* 'U' */

#define TERM_PURPLE     16	/* 'p' */
#define TERM_VIOLET     17	/* 'v' */
#define TERM_TEAL       18	/* 't' */
#define TERM_MUD        19	/* 'm' */
#define TERM_L_YELLOW   20	/* 'Y' */
#define TERM_MAGENTA    21	/* 'M' */
#define TERM_L_TEAL     22	/* 'T' */
#define TERM_L_VIOLET   23	/* 'V' */
#define TERM_L_PINK     24	/* 'I' */
#define TERM_MUSTARD    25	/* 'i' */
#define TERM_BLUE_SLATE 26	/* 'z' */
#define TERM_DEEP_L_BLUE 27	/* 'Z' */



/*
 * Message indexes (used to generate sounds, and sometimes to color the
 * message text).
 *
 * If you change these, be sure to keep the file "/lib/pref/message.prf" up
 * to date.
 */
#define MSG_GENERIC          0
#define MSG_HIT              1
#define MSG_MISS             2
#define MSG_FLEE             3
#define MSG_DROP             4
#define MSG_KILL             5
#define MSG_LEVEL            6
#define MSG_DEATH            7
#define MSG_STUDY            8
#define MSG_TELEPORT         9
#define MSG_SHOOT           10
#define MSG_QUAFF           11
#define MSG_ZAP             12
#define MSG_WALK            13
#define MSG_TPOTHER         14
#define MSG_HITWALL         15
#define MSG_EAT             16
#define MSG_STORE1          17
#define MSG_STORE2          18
#define MSG_STORE3          19
#define MSG_STORE4          20
#define MSG_DIG             21
#define MSG_OPENDOOR        22
#define MSG_SHUTDOOR        23
#define MSG_TPLEVEL         24
#define MSG_BELL            25
#define MSG_NOTHING_TO_OPEN 26
#define MSG_LOCKPICK_FAIL   27
#define MSG_STAIRS          28
#define MSG_HITPOINT_WARN   29
#define MSG_HIT_SOFT        30
#define MSG_HIT_MEDIUM      31
#define MSG_HIT_HARD        32
#define MSG_HIT_DEADLY      33
#define MSG_SUMMON          34

#define MSG_MAX             35



/* Colored messages with no fanciness */
#define MSG_DARK           200
#define MSG_WHITE          201
#define MSG_SLATE          202
#define MSG_ORANGE         203
#define MSG_RED            204
#define MSG_GREEN          205
#define MSG_BLUE           206
#define MSG_UMBER          207
#define MSG_L_DARK         208
#define MSG_L_WHITE        209
#define MSG_L_PURPLE       210
#define MSG_YELLOW         211
#define MSG_L_RED          212
#define MSG_L_GREEN        213
#define MSG_L_BLUE         214
#define MSG_L_UMBER        215



/*** Sound constants ***/


/*
 * Mega-Hack -- some primitive sound support (see "main-win.c")
 *
 * Some "sound" constants for "Term_xtra(TERM_XTRA_SOUND, val)"
 */
#define SOUND_HIT        1
#define SOUND_MISS       2
#define SOUND_FLEE       3
#define SOUND_DROP       4
#define SOUND_KILL       5
#define SOUND_LEVEL      6
#define SOUND_DEATH      7
#define SOUND_STUDY      8
#define SOUND_TELEPORT   9
#define SOUND_SHOOT     10
#define SOUND_QUAFF     11
#define SOUND_ZAP       12
#define SOUND_WALK      13
#define SOUND_TPOTHER   14
#define SOUND_HITWALL   15
#define SOUND_EAT       16
#define SOUND_STORE1    17
#define SOUND_STORE2    18
#define SOUND_STORE3    19
#define SOUND_STORE4    20
#define SOUND_DIG       21
#define SOUND_OPENDOOR  22
#define SOUND_SHUTDOOR  23
#define SOUND_TPLEVEL   24

/*
 * Mega-Hack -- maximum known sounds
 *
 * Should be the same as MSG_MAX for compatibility reasons.
 */
#define SOUND_MAX MSG_MAX


/*
 * Available graphics modes
 */
#define GRAPHICS_NONE           0  /* Text, no fanciness */
#define GRAPHICS_ORIGINAL       1  /* Old graphics (not used) */
#define GRAPHICS_ADAM_BOLT      2  /* 16x16 Adam Bolt graphics */
#define GRAPHICS_DAVID_GERVAIS  3  /* 32x32 David Gervais graphics */
#define GRAPHICS_PSEUDO         4  /* Text with pseudo-graphical chars */


/*
 * List of commands that will be auto-repeated
 *
 * ToDo: This string should be user-configurable.
 */
#define AUTO_REPEAT_COMMANDS "TBDoc+"


/*
 * Maximum number of macro trigger names
 */
#define MAX_MACRO_TRIGGER 200
#define MAX_MACRO_MOD 12


/*** Hack ***/

/*
 * HACK - define if the source contains the cleanup_angband() function.
 */
#define HAS_CLEANUP


/*
 * Given an array, determine how many elements are in the array.
 */
#define N_ELEMENTS(a) (int)(sizeof(a) / sizeof((a)[0]))

/*
 * Quest description modes.
 */
#define QMODE_HALF_1 1
#define QMODE_HALF_2 2
#define QMODE_SHORT  3
#define QMODE_FULL   4

