/* File: h-define.h */

#ifndef INCLUDED_H_DEFINE_H
#define INCLUDED_H_DEFINE_H

/*
 * Define some simple constants
 */


/*
 * Hack -- Define NULL
 */
#ifndef NULL
# ifdef __STDC__
#  define NULL ((void*)0)
# else
#  define NULL ((char*)0)
# endif /* __STDC__ */
#endif /* NULL */



/*
 * The constants "TRUE" and "FALSE"
 */

#undef TRUE
#define TRUE	1

#undef FALSE
#define FALSE	0




/**** Simple "Macros" ****/

/*
 * Force a character to lowercase/uppercase
 */
#define FORCELOWER(A)  ((isupper((unsigned char)(A))) ? tolower((unsigned char)(A)) : (A))
#define FORCEUPPER(A)  ((islower((unsigned char)(A))) ? toupper((unsigned char)(A)) : (A))


/*
 * Non-typed minimum value macro
 *
 * Do not use any of these with values that can vary between one call of
 * "a" or "b" and another.  Pre-calculate "a" and "b" if in any doubt.
 */
#undef MIN
#define MIN(a,b)	(((a) > (b)) ? (b)  : (a))

/*
 * Non-typed maximum value macro
 */
#undef MAX
#define MAX(a,b)	(((a) < (b)) ? (b)  : (a))

/*
 * Non-typed absolute value macro
 */
#undef ABS
#define ABS(a)		(((a) < 0)   ? (-(a)) : (a))

/*
 * Non-typed sign extractor macro
 */
#undef SGN
#define SGN(a)		(((a) < 0)   ? (-1) : ((a) != 0))


/*
 * Hack -- allow use of "ASCII" for "indexes", "digits", and "Control-
 * Characters".
 *
 * Note that all "index" values must be "lowercase letters", while
 * all "digits" must be "digits".  Control characters can be made
 * from any legal characters.  XXX XXX XXX
 */
#  define A2I(X)	((X) - 'a')
#  define I2A(X)	((X) + 'a')
#  define D2I(X)	((X) - '0')
#  define I2D(X)	((X) + '0')
#  define KTRL(X)	((X) & 0x1F)
#  define UN_KTRL(X)	((X) + 64)
#  define ESCAPE	'\033'



#endif /* INCLUDED_H_DEFINE_H */
