
function [dx, dy, theta] = curvedpath(sensor1, sensor2, wheelbase)

radii = zeros(length(sensor1),1);
theta = zeros(length(sensor1),1);
dx = zeros(length(sensor1),1);
dy = zeros(length(sensor1),1);

for i = 1:length(sensor1),
    if sensor1(i) == sensor2(i)
        dy(i) = sensor1(i);
    else
        radii(i) = (0.5 * wheelbase * (1 + sensor1(i)/sensor2(i)))/(1 - sensor1(i)/sensor2(i));
        theta(i) = sensor1(i)/(radii(i) - 0.5 * wheelbase);
        dy(i) = radii(i)*sin(theta(i));
        dx(i) = radii(i) - radii(i)*cos(theta(i));
    end;
    
end;