function map = makemap(datalog, xsize, ysize, resolution) % x,ysize in inches, resolution in dpi

[d1, d2, dir1, dir2, bu1, bu2] = parsedatalogmore(datalog);
[dxd, dyd, thetad] = curvedpath(d1,d2,wb);
[dxdir, dydir, thetadir] = curvedpath(dir1, -dir2, wb);   % pass the negative because they're spinning in opposite directions when turning
[dxb, dyb, thetab] = curvedpath(-bu1,-bu2,wb);             % both negative cus we're backing up

dxa = [dxdir';dxd';dxb'];
dxa = dxa(:);                           % create an array of all the dx's
dya = [dydir';dyd';dyb'];
dya = dya(:);                           % create an array of all the dy's
dha = [thetadir';thetad';thetab'];
dha = dha(:);                           % create an array of all the heading changes

cspace = 0.5 + zeros(xsize*resolution,ysize*resolution,200,2); % the configuration space.  the third dim is heading in hundreths of pi, the 4th is 1 prob filled, 2 prob empty

totaldistance = 0;
nominalheading = 0;

x = xsize*resolution/2;
y = ysize*resolution/2;

