
function [xxx, yyy, bpx, bpy] = plotbumps(datums, wb, by, bw, sx, sy, bumpnum);
[d1, d2, dir1, dir2, bu1, bu2] = parsedatalogmore(datums);
[dxd, dyd, thetad] = curvedpath(d1,d2,wb);
[dxdir, dydir, thetadir] = curvedpath(dir1, -dir2, wb);   % pass the negative because they're spinning in opposite directions when turning
[dxb, dyb, thetab] = curvedpath(-bu1,-bu2,wb);             % both negative cus we're backing up

xxx = [0];    % take 0,0 to be the starting point
yyy = [0];
bpx = [];
bpy = [];
heading = 7*pi/8;
px = 0;
py = 0;
for i = 1:bumpnum,

    px = px + dxdir(i)*cos(heading) + dydir(i)*sin(heading);
    py = py + dydir(i)*cos(heading) - dxdir(i)*sin(heading);
    heading = heading + thetadir(i);

    px = px + dxd(i)*cos(heading) + dyd(i)*sin(heading);
    py = py + dyd(i)*cos(heading) - dxd(i)*sin(heading);
    xxx = [xxx px];
    yyy = [yyy py];
    heading = heading + thetad(i);

    tt = px + (by/0.0675)*sin(heading);
    tt2 = tt + (bw/0.0675)*sin(heading+pi/2);
    tt3 = tt + (bw/0.0675)*sin(heading-pi/2);
    bpx = [bpx tt tt2 tt3];
    tt = py + (by/0.0675)*cos(heading);
    tt2 = tt + (bw/0.0675)*cos(heading+pi/2);
    tt3 = tt + (bw/0.0675)*cos(heading-pi/2);
    bpy = [bpy tt tt2 tt3];

    px = px + dxb(i)*cos(heading) + dyb(i)*sin(heading);
    py = py + dyb(i)*cos(heading) - dxb(i)*sin(heading);
    heading = heading + thetab(i);

end;

mapx = [ 0 0 -12.5 -23 -23 0]/0.0675 - sx/0.0675;
mapy = [ 0 12 12 4.75 0 0]/0.0675 - sy/0.0675;
plot(xxx,yyy, 'r', bpx, bpy, 'ro', mapx, mapy, 'g');
axis([-200 200 -150 50]);
