%mx and my are the x and y coordinates of a closed polygon, the map.  the
%first and last point should be the same
%px and py are the x and y of a point to check within tolerance
%tf is 1 for true, 0 for false

% the basic idea is that if a point is inside a polygon, the sum of the
% angles between the vectors formed by that point and the vertices of the
% polygon should be 2pi.  

function tf = pointinside(mx, my, px, py, tolerance)

dv = mx - px + j*(my - py);
dw = phase(dv);
dv = acos(cos(abs(dw(1:(length(dw)-1)) - dw(2:length(dw))))); % force the angle to be between 0 and pi

ss = sum(dv);

if abs(2*pi - ss) <= tolerance
    tf = 1;
else
    tf = 0;
end;